/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app.ext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IndustryFactory;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitLayerType;
import com.kingdee.eas.basedata.org.OrgPropertyCollection;
import com.kingdee.eas.basedata.org.OrgPropertyFactory;
import com.kingdee.eas.basedata.org.OrgPropertyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.RegistTypeCollection;
import com.kingdee.eas.basedata.org.RegistTypeFactory;
import com.kingdee.eas.basedata.org.RegistTypeInfo;
import com.kingdee.eas.basedata.org.app.di.BizOrgDIBase;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.OrgUnitOptFacadeFactory;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.ExportUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class AdminImport
extends BizOrgDIBase {
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        String number = this.getFieldValue(hsData, "FNumber");
        String name_l1 = this.getFieldValue(hsData, "FName_l1");
        String name_l2 = this.getFieldValue(hsData, "FName_l2");
        String name_l3 = this.getFieldValue(hsData, "FName_l3");
        String simpleName = this.getFieldValue(hsData, "FSimpleName");
        String desc_l1 = this.getFieldValue(hsData, "FDescription_l1");
        String desc_l2 = this.getFieldValue(hsData, "FDescription_l2");
        String desc_l3 = this.getFieldValue(hsData, "FDescription_l3");
        String parent = this.getFieldValue(hsData, "FParent_number");
        String layerType = this.getFieldValue(hsData, "FUnitLayerType_name_l2");
        String orgProperty = this.getFieldValue(hsData, "FOrgProperty_name_l2");
        String isJuridicalCompany = this.getFieldValue(hsData, "FIsJuridicalCompany");
        String juridicalPerson = this.getFieldValue(hsData, "FJuridicalPerson_number");
        String setDate = this.getFieldValue(hsData, "FSetupDate");
        String endDate = this.getFieldValue(hsData, "FEndupDate");
        String registType = this.getFieldValue(hsData, "FRegistType_name_l2");
        String EFFDT = this.getFieldValue(hsData, "FEFFDT");
        Locale l1 = new Locale("L1");
        Locale l2 = new Locale("L2");
        Locale l3 = new Locale("L3");
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        this.checkRequeiredField(ctx, "FNumber", number);
        if (mode != 128) {
            this.checkRequeiredField(ctx, "FEFFDT", EFFDT);
            this.checkRequeiredField(ctx, "FName_l2", name_l2);
            this.checkRequeiredField(ctx, "FParent_number", parent);
        }
        AdminOrgUnitInfo unitInfo = this.getAdminOrgUnitInfo(ctx, number);
        unitInfo.setIsAdminOrgUnit(true);
        if (mode != 128 || !StringUtils.isEmpty((String)name_l1)) {
            unitInfo.setName(name_l1, l1);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)name_l2)) {
            unitInfo.setName(name_l2, l2);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)name_l3)) {
            unitInfo.setName(name_l3, l3);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)number)) {
            unitInfo.setNumber(number);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)simpleName)) {
            unitInfo.setSimpleName(simpleName);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)desc_l1)) {
            unitInfo.setDescription(desc_l1, l1);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)desc_l2)) {
            unitInfo.setDescription(desc_l2, l2);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)desc_l3)) {
            unitInfo.setDescription(desc_l3, l3);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)parent)) {
            AdminOrgUnitInfo parentInfo = (AdminOrgUnitInfo)this.getBizOrgUnitInfo(ctx, OrgType.Admin, parent);
            unitInfo.setParent(parentInfo);
            if (unitInfo.getCU() == null) {
                unitInfo.setCU(parentInfo.getCU());
            }
        }
        if (mode != 128 || !StringUtils.isEmpty((String)layerType)) {
            unitInfo.setUnitLayerType(this.getLayerTypeInfo(ctx, layerType));
        }
        if (mode != 128 || !StringUtils.isEmpty((String)orgProperty)) {
            unitInfo.setOrgProperty(this.getOrgPropertyInfo(ctx, orgProperty));
        }
        if (mode != 128 || !StringUtils.isEmpty((String)registType)) {
            unitInfo.setRegistType(this.getRegistTypeInfo(ctx, registType));
        }
        if (mode != 128 || !StringUtils.isEmpty((String)isJuridicalCompany)) {
            if ("1".equalsIgnoreCase(isJuridicalCompany) || "Y".equalsIgnoreCase(isJuridicalCompany) || "true".equalsIgnoreCase(isJuridicalCompany) || "yes".equalsIgnoreCase(isJuridicalCompany)) {
                unitInfo.setIsJuridicalCompany(true);
            } else {
                unitInfo.setIsJuridicalCompany(false);
            }
        }
        if (!(mode == 128 && StringUtils.isEmpty((String)juridicalPerson) || StringUtils.isEmpty((String)juridicalPerson))) {
            PersonInfo juridicalPersonInfo = (PersonInfo)this.getCoreBaseInfo((ICoreBase)PersonFactory.getLocalInstance((Context)ctx), juridicalPerson);
            if (juridicalPersonInfo == null) {
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(juridicalPerson);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"JURIDICAL_PERSON", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            unitInfo.setJuridicalPerson(juridicalPersonInfo);
        }
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        if (!(mode == 128 && StringUtils.isEmpty((String)setDate) || StringUtils.isEmpty((String)setDate))) {
            unitInfo.setSetupDate(new Timestamp(dtformat.parse(setDate).getTime()));
        }
        if (!(mode == 128 && StringUtils.isEmpty((String)endDate) || StringUtils.isEmpty((String)endDate))) {
            unitInfo.setEndupDate(new Timestamp(dtformat.parse(endDate).getTime()));
        }
        if (!StringUtils.isEmpty((String)EFFDT)) {
            unitInfo.setEFFDT(dtformat.parse(EFFDT));
        } else if (unitInfo.getEFFDT() == null) {
            unitInfo.setEFFDT(DateTimeUtils.truncateDate((Date)new Date()));
        }
        this.setOtherPartAdminInfo(ctx, hsData, unitInfo);
        unitInfo.put("notNeedGenerateObjectNumber", (Object)true);
        return unitInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)coreBaseInfo;
        try {
            if (unitInfo.containsKey("notDealOrgDelegate") && ((Boolean)unitInfo.get("notDealOrgDelegate")).booleanValue()) {
                OrgUnitOptFacadeFactory.getLocalInstance(ctx).updateAdminOrg(unitInfo);
            } else {
                OrgUnitOptFacadeFactory.getLocalInstance(ctx).addNewAdminOrg(unitInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private OrgUnitLayerTypeInfo getLayerTypeInfo(Context ctx, String layerType) throws Exception {
        if (StringUtils.isEmpty((String)layerType)) {
            return null;
        }
        boolean isBOSUuid = true;
        try {
            BOSUuid.read((String)layerType);
        }
        catch (Exception e) {
            isBOSUuid = false;
        }
        IOrgUnitLayerType iOrgLayerType = OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = null;
        if (isBOSUuid) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)layerType));
            if (iOrgLayerType.exists(filterInfo)) {
                BOSUuid uuid = BOSUuid.read((String)layerType);
                OrgUnitLayerTypeInfo layerTypeInfo = new OrgUnitLayerTypeInfo();
                layerTypeInfo.setId(uuid);
                return layerTypeInfo;
            }
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)layerType));
        if (iOrgLayerType.exists(filterInfo)) {
            OrgUnitLayerTypeInfo layerTypeInfo = iOrgLayerType.getOrgUnitLayerTypeInfo("select id where name = '" + layerType + "'");
            return layerTypeInfo;
        }
        throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ORG_LAYER_TYPE_NOT_CORRECT", (Locale)ctx.getLocale()));
    }

    private OrgPropertyInfo getOrgPropertyInfo(Context ctx, String name) throws BOSException {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        OrgPropertyCollection col = OrgPropertyFactory.getLocalInstance((Context)ctx).getOrgPropertyCollection("select id where name ='" + name + "'");
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    private RegistTypeInfo getRegistTypeInfo(Context ctx, String name) throws BOSException {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        RegistTypeCollection col = RegistTypeFactory.getLocalInstance((Context)ctx).getRegistTypeCollection("select id where name ='" + name + "'");
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    private void setOtherPartAdminInfo(Context ctx, Hashtable hsData, AdminOrgUnitInfo partAdminInfo) throws Exception {
        String address = this.getFieldValue(hsData, "FAddressID");
        String telephone = this.getFieldValue(hsData, "FPhoneNumber");
        String zipCode = this.getFieldValue(hsData, "FZipCode");
        String fax = this.getFieldValue(hsData, "FFax");
        String isVirtual = this.getFieldValue(hsData, "FIsVirtual");
        String baseDuty_l1 = this.getFieldValue(hsData, "FBaseDuty_L1");
        String baseDuty_l2 = this.getFieldValue(hsData, "FBaseDuty_L2");
        String baseDuty_l3 = this.getFieldValue(hsData, "FBaseDuty_L3");
        String industry = this.getFieldValue(hsData, "FIndustry");
        String territory = this.getFieldValue(hsData, "FTerritory");
        String taxNum = this.getFieldValue(hsData, "FTaxNumber");
        String capital = this.getFieldValue(hsData, "FRegisteredCapital");
        String orgCode = this.getFieldValue(hsData, "FOrgCode");
        String isChurchyard = this.getFieldValue(hsData, "FIsChurchyard");
        String index = this.getFieldValue(hsData, "FIndex");
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (orgCode != null && orgCode.length() > 80) {
            orgCode = orgCode.substring(0, 80);
        }
        if (!(mode == 128 && StringUtils.isEmpty((String)index) || StringUtils.isEmpty((String)index))) {
            partAdminInfo.setIndex(Integer.valueOf(index).intValue());
        }
        if (mode != 128 || !StringUtils.isEmpty((String)telephone)) {
            partAdminInfo.setPhoneNumber(telephone);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)fax)) {
            partAdminInfo.setFax(fax);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)zipCode)) {
            partAdminInfo.setZipCode(zipCode);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)isVirtual)) {
            if ("1".equalsIgnoreCase(isVirtual) || "Y".equalsIgnoreCase(isVirtual)) {
                partAdminInfo.setIsVirtual(true);
            } else {
                partAdminInfo.setIsVirtual(false);
            }
        }
        if (mode != 128 || !StringUtils.isEmpty((String)baseDuty_l1)) {
            partAdminInfo.setBaseDuty(baseDuty_l1, new Locale("L1"));
        }
        if (mode != 128 || !StringUtils.isEmpty((String)baseDuty_l2)) {
            partAdminInfo.setBaseDuty(baseDuty_l2, new Locale("L2"));
        }
        if (mode != 128 || !StringUtils.isEmpty((String)baseDuty_l3)) {
            partAdminInfo.setBaseDuty(baseDuty_l3, new Locale("L3"));
        }
        if (mode != 128 || !StringUtils.isEmpty((String)territory)) {
            partAdminInfo.setTerritory(territory);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)taxNum)) {
            partAdminInfo.setTaxNumber(taxNum);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)orgCode)) {
            partAdminInfo.setOrgCode(orgCode);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)isChurchyard)) {
            if ("1".equalsIgnoreCase(isChurchyard) || "Y".equalsIgnoreCase(isChurchyard)) {
                partAdminInfo.setIsChurchyard(true);
            } else {
                partAdminInfo.setIsChurchyard(false);
            }
        }
        if (!(mode == 128 && StringUtils.isEmpty((String)capital) || StringUtils.isEmpty((String)capital))) {
            partAdminInfo.setRegisteredCapital(new BigDecimal(capital));
        }
        if (!(mode == 128 && StringUtils.isEmpty((String)industry) || StringUtils.isEmpty((String)industry))) {
            IndustryInfo industryInfo = (IndustryInfo)this.getCoreBaseInfo((ICoreBase)IndustryFactory.getLocalInstance((Context)ctx), industry);
            if (industryInfo == null) {
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(industry);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"INDUSTRY", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            partAdminInfo.setIndustry(industryInfo);
        }
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, String number) throws EASBizException, BOSException, TaskExternalException {
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminInfo = null;
        AdminOrgUnitCollection adminColl = null;
        if (mode != 8) {
            if (mode == 16) {
                adminColl = iAdminOrgUnit.getAdminOrgUnitCollection("select id where number ='" + number + "'");
            } else if (mode == 128) {
                adminColl = iAdminOrgUnit.getAdminOrgUnitCollection("select * where number ='" + number + "'");
            }
        }
        if (adminColl == null || adminColl.size() <= 0) {
            adminInfo = new AdminOrgUnitInfo();
        } else {
            if (adminColl.size() > 1) {
                throw new TaskExternalException("number(" + number + ") is duplicate!");
            }
            if (mode == 8) {
                throw new TaskExternalException(EASResource.getString((String)(this.RESOURCE_FILE_NAME + ".codeExisted")));
            }
            adminInfo = adminColl.get(0);
            adminInfo.put("notDealOrgDelegate", (Object)true);
        }
        adminInfo.setNumber(number);
        return adminInfo;
    }

    public Hashtable<String, Object> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        String localString = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toLowerCase();
        HashMap<String, String> exportMap = new HashMap<String, String>();
        exportMap.put("FEFFDT", "EFFDT,Date");
        exportMap.put("FNumber", "number,String");
        exportMap.put("FName" + localString, "name,String");
        exportMap.put("FSimpleName", "simpleName,String");
        exportMap.put("FDescription" + localString, "description,String");
        exportMap.put("FParent_number", "parent.number,String");
        exportMap.put("FUnitLayerType_name" + localString, "unitLayerType.name,String");
        exportMap.put("FUnitLayerType_number", "unitLayerType.number,String");
        exportMap.put("FOrgProperty_name" + localString, "orgProperty.name,String");
        exportMap.put("FOrgProperty_number", "orgProperty.number,String");
        exportMap.put("FIsJuridicalCompany", "isJuridicalCompany,boolean");
        exportMap.put("FJuridicalPerson_number", "juridicalPerson.number,String");
        exportMap.put("FRegistType_name" + localString, "registType.name,String");
        exportMap.put("FRegistType_number", "registType.number,String");
        exportMap.put("FSetupDate", "setupDate,Date");
        exportMap.put("FEndupDate", "endupDate,Date");
        Hashtable result = null;
        try {
            result = ExportUtil.exportTransmit((IRowSet)rs, exportMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.org.app.AdminOrgExportQuery";
    }

    public static String deleteAdminOrg(Context ctx, AdminOrgUnitInfo adminInfo) throws BOSException {
        Object[] objs = new Object[]{adminInfo.getId().toString()};
        String deleteSql = "delete from t_org_admin where fid =?";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])objs);
        deleteSql = "delete from t_org_adminhis where fhistoryrelateid =?";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])objs);
        deleteSql = "delete from t_org_oupartadmin where funitid=?";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])objs);
        deleteSql = "delete from t_org_structure where funitid=? and ftreeid='00000000-0000-0000-0000-0000000000034F2827FD'";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])objs);
        return adminInfo.getId().toString();
    }
}

