/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app.ext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.DomainFactory;
import com.kingdee.eas.basedata.hraux.DomainInfo;
import com.kingdee.eas.basedata.hraux.ProductLineFactory;
import com.kingdee.eas.basedata.hraux.ProductLineInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.PositionOptFacadeFactory;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.ExportUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.axis.utils.StringUtils;

public class PositionImport
extends AbstractDataTransmission {
    private static final String resStr = "com.kingdee.eas.hr.org.JobGradeResource.";
    protected String RESOURCE_FILE_NAME = "com.kingdee.eas.basedata.org.ImportResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PositionFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PositionInfo info = null;
        try {
            info = this.createNewData(ctx, hsData);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        PositionInfo info = (PositionInfo)coreBaseInfo;
        info.put("notNeedGenerateObjectNumber", (Object)true);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        try {
            if (mode == 128) {
                PositionOptFacadeFactory.getLocalInstance(ctx).updatePosition((IObjectPK)new ObjectUuidPK(info.getId()), info);
            } else if (mode == 16) {
                PositionOptFacadeFactory.getLocalInstance(ctx).importUpdate(info);
            } else {
                PositionOptFacadeFactory.getLocalInstance(ctx).addNewPosition(info);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private PositionInfo createNewData(Context ctx, Hashtable hsData) throws Exception {
        JobInfo jobInfo;
        String number = this.getFieldValue(hsData, "FNumber");
        String name_l1 = this.getFieldValue(hsData, "FName_l1");
        String name_l2 = this.getFieldValue(hsData, "FName_l2");
        String name_l3 = this.getFieldValue(hsData, "FName_l3");
        String simpleName = this.getFieldValue(hsData, "FSimpleName");
        String desc_l1 = this.getFieldValue(hsData, "FDescription_l1");
        String desc_l2 = this.getFieldValue(hsData, "FDescription_l2");
        String desc_l3 = this.getFieldValue(hsData, "FDescription_l3");
        String EFFDT = this.getFieldValue(hsData, "FEFFDT");
        String parentNumber = this.getFieldValue(hsData, "FParent_number");
        String adminNumber = this.getFieldValue(hsData, "FAdminOrgUnit_number");
        String isRespPosition = this.getFieldValue(hsData, "FIsRespPosition");
        String positionPlanCount = this.getFieldValue(hsData, "FPositionPlanCount");
        String jobNumber = this.getFieldValue(hsData, "FJob_number");
        String jobLevelName = this.getFieldValue(hsData, "FJobLevel_name_l2");
        String lowJobGradeNumber = this.getFieldValue(hsData, "FLowJobGrade_number");
        String highJobGradeNumber = this.getFieldValue(hsData, "FHighJobGrade_number");
        String domainName = this.getFieldValue(hsData, "FDomain_name_l2");
        String productLineName = this.getFieldValue(hsData, "FProductLine_name_l2");
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        this.checkRequeiredField(ctx, "FNumber", number);
        if (mode != 128) {
            this.checkRequeiredField(ctx, "FEFFDT", EFFDT);
            this.checkRequeiredField(ctx, "FName_l2", name_l2);
            this.checkRequeiredField(ctx, "FAdminOrgUnit_number", adminNumber);
            this.checkRequeiredField(ctx, "FParent_number", parentNumber);
        }
        Locale l1 = new Locale("L1");
        Locale l2 = new Locale("L2");
        Locale l3 = new Locale("L3");
        PositionInfo info = this.getPositionInfo(ctx, number);
        if (mode != 128 || !StringUtils.isEmpty((String)EFFDT)) {
            DateFormat dtformat = BOSLocaleUtil.getDateFormat();
            info.setEFFDT(dtformat.parse(EFFDT));
        }
        if (info.getEFFDT() == null && StringUtils.isEmpty((String)EFFDT)) {
            info.setEFFDT(DateTimeUtils.truncateDate((Date)new Date()));
        }
        if (mode != 128 || !StringUtils.isEmpty((String)name_l1)) {
            info.setName(name_l1, l1);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)name_l2)) {
            info.setName(name_l2, l2);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)name_l3)) {
            info.setName(name_l3, l3);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)simpleName)) {
            info.setSimpleName(simpleName);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)desc_l1)) {
            info.setDescription(desc_l1, l1);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)desc_l2)) {
            info.setDescription(desc_l2, l2);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)desc_l3)) {
            info.setDescription(desc_l3, l3);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)isRespPosition)) {
            info.setIsRespPosition(this.getBooleanFromAlias(isRespPosition).booleanValue());
        }
        if (!(mode == 128 && StringUtils.isEmpty((String)positionPlanCount) || StringUtils.isEmpty((String)positionPlanCount))) {
            info.setPositionPlanCount(Integer.valueOf(positionPlanCount).intValue());
        }
        if (mode != 128 || !StringUtils.isEmpty((String)adminNumber)) {
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)this.getObjectInfoByNumber(ctx, (ICoreBase)iAdmin, adminNumber.trim());
            if (adminInfo == null) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_Admin_NOT_FOUND"));
            }
            info.setAdminOrgUnit(adminInfo);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)parentNumber)) {
            PositionInfo parentInfo = (PositionInfo)this.getObjectInfoByNumber(ctx, (ICoreBase)PositionFactory.getLocalInstance((Context)ctx), parentNumber);
            if (parentInfo == null) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_Position_NOT_FOUND"));
            }
            info.setParent(parentInfo);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)jobNumber)) {
            jobInfo = this.getJobInfoByNumber(ctx, jobNumber);
            info.setJob(jobInfo);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)jobLevelName)) {
            JobLevelInfo jobLevelInfo = (JobLevelInfo)this.getObjectInfoByName(ctx, (ICoreBase)JobLevelFactory.getLocalInstance(ctx), jobLevelName);
            info.setJobLevel(jobLevelInfo);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)lowJobGradeNumber)) {
            JobGradeInfo lowJobGradeInfo = (JobGradeInfo)this.getObjectInfoByNumber(ctx, (ICoreBase)JobGradeFactory.getLocalInstance(ctx), lowJobGradeNumber);
            info.setLowJobGrade(lowJobGradeInfo);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)highJobGradeNumber)) {
            JobGradeInfo highJobGradeInfo = (JobGradeInfo)this.getObjectInfoByNumber(ctx, (ICoreBase)JobGradeFactory.getLocalInstance(ctx), highJobGradeNumber);
            info.setHighJobGrade(highJobGradeInfo);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)domainName)) {
            DomainInfo domainInfo = (DomainInfo)this.getObjectInfoByName(ctx, (ICoreBase)DomainFactory.getLocalInstance((Context)ctx), domainName);
            info.setDomain(domainInfo);
        }
        if (mode != 128 || !StringUtils.isEmpty((String)productLineName)) {
            ProductLineInfo productLineInfo = (ProductLineInfo)this.getObjectInfoByName(ctx, (ICoreBase)ProductLineFactory.getLocalInstance((Context)ctx), productLineName);
            info.setProductLine(productLineInfo);
        }
        if (mode == 8 && info.getJob() != null) {
            jobInfo = info.getJob();
            if (info.getJobLevel() == null) {
                info.setJobLevel(jobInfo.getJobLevel());
            }
            if (info.getLowJobGrade() == null) {
                info.setLowJobGrade(jobInfo.getLowJobGrade());
            }
            if (info.getHighJobGrade() == null) {
                info.setHighJobGrade(jobInfo.getHighJobGrade());
            }
        }
        return info;
    }

    private PositionInfo getPositionInfo(Context ctx, String number) throws EASBizException, BOSException, TaskExternalException {
        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
        PositionCollection posColl = null;
        PositionInfo info = null;
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            posColl = iPosition.getPositionCollection("select id where number ='" + number + "'");
        } else if (mode == 128) {
            posColl = iPosition.getPositionCollection("select * where number ='" + number + "'");
        }
        if (posColl == null || posColl.size() <= 0) {
            if (mode == 128) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_Number_ERRPR"));
            }
            info = new PositionInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        } else {
            if (posColl.size() > 1) {
                throw new TaskExternalException("number(" + number + ") is duplicate!");
            }
            if (posColl.size() == 1) {
                if (mode == 8) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_POSITION_EXIST"));
                }
                info = posColl.get(0);
            }
        }
        if (info != null) {
            info.setNumber(number);
        }
        return info;
    }

    protected String getFieldValue(Hashtable hsData, String key) {
        if (hsData.get(key) != null && ((DataToken)hsData.get((Object)key)).data != null) {
            return ((String)((DataToken)hsData.get((Object)key)).data).trim();
        }
        return "";
    }

    private Boolean getBooleanFromAlias(String isPrimary) {
        if (isPrimary.equalsIgnoreCase("Y") || isPrimary.equalsIgnoreCase(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.YES")) || isPrimary.equalsIgnoreCase("true") || isPrimary.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private CoreBaseInfo getObjectInfoByName(Context ctx, ICoreBase coreBase, String name) throws BOSException {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append("select id where name = '");
        filterSql.append(name);
        filterSql.append("'");
        CoreBaseCollection coll = coreBase.getCollection(filterSql.toString());
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private CoreBaseInfo getObjectInfoByNumber(Context ctx, ICoreBase coreBase, String number) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append("select id where number = '");
        filterSql.append(number);
        filterSql.append("'");
        CoreBaseCollection coll = coreBase.getCollection(filterSql.toString());
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private JobInfo getJobInfoByNumber(Context ctx, String number) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append("select id,lowJobGrade.id,highJobGrade.id,jobLevel.id where number = '");
        filterSql.append(number);
        filterSql.append("'");
        JobCollection coll = JobFactory.getLocalInstance((Context)ctx).getJobCollection(filterSql.toString());
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.org.app.PositionExportQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return new FilterInfo();
    }

    public Hashtable<String, Object> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        String localString = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toLowerCase();
        HashMap<String, String> exportMap = new HashMap<String, String>();
        exportMap.put("FEFFDT", "effectDate,Date");
        exportMap.put("FNumber", "number,String");
        exportMap.put("FName" + localString, "name,String");
        exportMap.put("FSimpleName", "simpleName,String");
        exportMap.put("FDescription" + localString, "description,String");
        exportMap.put("FParent_number", "parent.number,String");
        exportMap.put("FAdminOrgUnit_number", "admin.number,String");
        exportMap.put("FIsRespPosition", "isRespPosition,String");
        exportMap.put("FPositionPlanCount", "positionPlanCount,int");
        exportMap.put("FJob_number", "job.number,String");
        exportMap.put("FJobLevel_name" + localString, "jobLevel.name,String");
        exportMap.put("FJobLevel_number", "jobLevel.number,String");
        exportMap.put("FLowJobGrade_number", "lowJobGrade.number,String");
        exportMap.put("FHighJobGrade_number", "highJobGrade.number,String");
        exportMap.put("FDomain_name" + localString, "domain.name,String");
        exportMap.put("FDomain_number", "domain.number,String");
        exportMap.put("FProductLine_name" + localString, "productLine.name,String");
        exportMap.put("FProductLine_number", "productLine.number,String");
        Hashtable result = null;
        try {
            result = ExportUtil.exportTransmit((IRowSet)rs, exportMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void checkRequeiredField(Context ctx, String field, String value) throws Exception {
        if (value == null || value.trim().length() == 0) {
            StringBuffer message = new StringBuffer();
            Locale currentLocale = ctx.getLocale();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"FIELD", (Locale)currentLocale));
            message.append(field);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"NOT_NULL", (Locale)currentLocale));
            throw new Exception(message.toString());
        }
    }
}

