/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.hr.org.IOrgHRCommon;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.IPersonPlanScheme;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.SchemeStatus;

public class GetHroPositionRelaInfoProcessor
extends AbstractBusinessProcessor {
    public GetHroPositionRelaInfoProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        PositionInfo position = (PositionInfo)batchResults.getObjCollection().getObject(0);
        IOrgHRCommon iOrgHRCommon = OrgHRCommonFactory.getLocalInstance(this.ctx);
        HROrgUnitInfo hro = iOrgHRCommon.getPositionOrgHRO(position.getId().toString());
        if (hro == null || this.ctx.get((Object)hro.getId().toString()) != null) {
            return;
        }
        IPersonPlanScheme iPPScheme = PersonPlanSchemeFactory.getLocalInstance(this.ctx);
        PersonPlanSchemeInfo schemeInfo = iPPScheme.getDefaultScheme(hro.getId().toString());
        if (schemeInfo != null && schemeInfo.getStatus() == SchemeStatus.EXECUTE && schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            IPersonPlan iPPlan = PersonPlanFactory.getLocalInstance(this.ctx);
            int count = iPPlan.getCurrPlanCountByPosition(position.getId().toString(), schemeInfo.getId().toString());
            if (count < 0) {
                count = 0;
            }
            if (count > 0) {
                position.setPositionPlanCount(count);
                position.put("PlanCountFromScheme", (Object)Boolean.TRUE);
            }
        }
        boolean isPositionJobMust = HRParamUtil.getParamOfHR((Context)this.ctx, (String)"IS_JOB_POSITION_MUST", (String)hro.getId().toString());
        position.put("IS_JOB_POSITION_MUST", (Object)isPositionJobMust);
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return null;
    }
}

