/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.HRJobSystemClassifyFactory;
import com.kingdee.eas.hr.org.HRJobSystemClassifyInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.ws.ca.utils.StringUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class JobSystemUtil {
    public static HRJobSystemClassifyInfo getJobSystemInfoByClassify(Context ctx, String hrJobSystemClassifyId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)hrJobSystemClassifyId)) {
            return null;
        }
        SelectorItemCollection sic = JobSystemUtil.getHRJobSystemClassifySelector();
        HRJobSystemClassifyInfo info = HRJobSystemClassifyFactory.getLocalInstance(ctx).getHRJobSystemClassifyInfo((IObjectPK)new ObjectUuidPK(hrJobSystemClassifyId), sic);
        return info;
    }

    private static SelectorItemCollection getHRJobSystemClassifySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("hrJobFamily.id"));
        sic.add(new SelectorItemInfo("hrJobFamily.name"));
        sic.add(new SelectorItemInfo("hrJobFamily.number"));
        sic.add(new SelectorItemInfo("hrJobCategory.id"));
        sic.add(new SelectorItemInfo("hrJobCategory.name"));
        sic.add(new SelectorItemInfo("hrJobCategory.number"));
        sic.add(new SelectorItemInfo("hrJobSubCategory.id"));
        sic.add(new SelectorItemInfo("hrJobSubCategory.name"));
        sic.add(new SelectorItemInfo("hrJobSubCategory.number"));
        return sic;
    }

    public static String getHRJobSystemClassifyByOrg(Context ctx, String hrOrgId) throws BOSException {
        String filterId = "";
        try {
            String getJobFamilySql = "SELECT hrJobSystemClassify.FID AS id FROM T_HR_HRJobSystemClassify hrJobSystemClassify LEFT JOIN T_HR_HRJobFamily hrJobFamily ON hrJobSystemClassify.FHRJobFamilyID = hrJobFamily.FID WHERE hrJobSystemClassify.FLEVEL = 1 AND hrJobSystemClassify.FISLEAF = 1 AND hrJobFamily.FSTATE = 1 AND hrJobFamily.FID IN ( SELECT FBASEINFOID FROM T_HR_HRJobFamilyRelationHR WHERE FSTATE = 100 AND FHrOrgUseId = '" + hrOrgId + "' )";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)getJobFamilySql);
            while (executeQuery.next()) {
                filterId = filterId + ",'" + executeQuery.getString("id") + "'";
            }
            String getHRJobCategorySql = "SELECT hrJobSystemClassify.FID AS id  FROM T_HR_HRJobSystemClassify hrJobSystemClassify  LEFT JOIN T_HR_HRJobCategory hrJobCategory ON hrJobSystemClassify.FHRJobCategoryID =hrJobCategory.FID  WHERE hrJobSystemClassify.FLEVEL = 2  AND hrJobSystemClassify.FISLEAF = 1 AND hrJobCategory.FSTATE = 1  AND hrJobCategory.FID IN ( SELECT FBASEINFOID FROM T_HR_HRJobCategoryRelationHR WHERE FSTATE = 100 AND FHrOrgUseId = '" + hrOrgId + "' )";
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)getHRJobCategorySql);
            while (executeQuery.next()) {
                filterId = filterId + ",'" + executeQuery.getString("id") + "'";
            }
            String getHRSubJobCategorySql = "SELECT hrJobSystemClassify.FID AS id  FROM T_HR_HRJobSystemClassify hrJobSystemClassify  LEFT JOIN T_HR_HRJobSubCategory hrJobSubCategory ON hrJobSystemClassify.FHRJobSubCategoryID =hrJobSubCategory.FID  WHERE hrJobSystemClassify.FLEVEL = 3  AND hrJobSystemClassify.FISLEAF = 1 AND hrJobSubCategory.FSTATE = 1  AND hrJobSubCategory.FID IN ( SELECT FBASEINFOID FROM T_HR_HRJobSubCategoryRelaHR WHERE FSTATE = 100 AND FHrOrgUseId = '" + hrOrgId + "' )";
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)getHRSubJobCategorySql);
            while (executeQuery.next()) {
                filterId = filterId + ",'" + executeQuery.getString("id") + "'";
            }
            if (!filterId.equals("")) {
                filterId = filterId.substring(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return filterId;
    }

    public static Set<String> getJobGradeModuleAvailableIdSet(Context ctx, String hrOrgUnitId) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        try {
            String sql = "select fbaseinfoid from T_HR_JobGradeModuleRelationHR where FState=100 and fhrorguseid =  '" + hrOrgUnitId + "'";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                idSet.add(iRowSet.getString("fbaseinfoid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return idSet;
    }

    public static Set<String> getJobLevelProjectAvailableIdSet(Context ctx, String hrOrgUnitId) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        try {
            String sql = "select fbaseinfoid from T_HR_JobLevelProjectRelationHR where FState=100 and fhrorguseid =  '" + hrOrgUnitId + "'";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                idSet.add(iRowSet.getString("fbaseinfoid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return idSet;
    }

    public static String getStringBySet(Set<String> idSet) {
        StringBuffer sb = new StringBuffer();
        if (idSet == null || idSet.size() == 0) {
            return "('')";
        }
        sb.append("(");
        Iterator<String> iter = idSet.iterator();
        int index = 0;
        while (iter.hasNext()) {
            if (index > 0) {
                sb.append(",");
            }
            sb.append("'").append(iter.next()).append("'");
            ++index;
        }
        sb.append(")");
        return sb.toString();
    }
}

