/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class OrgBatchAdjustUtil {
    public static PersonCollection getPersonCollByOrgPos(Context ctx, String adminId, String positionId, Date appointDate) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        EmpPosOrgRelationCollection eColl = OrgBatchAdjustUtil.getEmpPosOrgRelByOrgPos(ctx, positionId, adminId, appointDate, false);
        for (int i = 0; i < eColl.size(); ++i) {
            EmpPosOrgRelationInfo eInfo = eColl.get(i);
            idSet.add(eInfo.getPerson().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PersonCollection pColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
        return pColl;
    }

    public static EmpPosOrgRelationCollection getEmpPosOrgRelByOrgPos(Context ctx, String adminId, String positionId, Date appointDate, Boolean isHasSub) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)adminId)) {
            if (isHasSub.booleanValue()) {
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminId));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)("%" + adminOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)adminId));
            }
        }
        if (!StringUtils.isEmpty((String)positionId)) {
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isLatestInAday", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("laborRelation.laborRelationState.isInCount", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)AssignTypeEnum.MAIN));
        FilterInfo filterDate = HistoryVersionUtil.getPointDateFilterInfo((Date)appointDate);
        filter.mergeFilter(filterDate, "and");
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        return empposorgRelationColl;
    }

    public static EmpPosOrgRelationCollection getEmpPosOrgRelByOrgPosSub(Context ctx, String adminId, String positionId, Date appointDate, Boolean isHasSub) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)adminId)) {
            if (isHasSub.booleanValue()) {
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminId));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)("%" + adminOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)adminId));
            }
        }
        if (!StringUtils.isEmpty((String)positionId)) {
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isLatestInAday", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("laborRelation.laborRelationState.isInCount", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)AssignTypeEnum.MAIN));
        FilterInfo filterDate = HistoryVersionUtil.getPointDateFilterInfo((Date)appointDate);
        filter.mergeFilter(filterDate, "and");
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        return empposorgRelationColl;
    }

    public static EmpPosOrgRelationCollection getPartTimeEmpPosOrgRelByOrgPosSub(Context ctx, String adminId, String positionId, Date appointDate, Boolean isHasSub) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)adminId)) {
            if (isHasSub.booleanValue()) {
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminId));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)("%" + adminOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)adminId));
            }
        }
        if (!StringUtils.isEmpty((String)positionId)) {
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)AssignTypeEnum.PARTTIME));
        FilterInfo filterDate = HistoryVersionUtil.getPointDateFilterInfo((Date)appointDate);
        filter.mergeFilter(filterDate, "and");
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        return empposorgRelationColl;
    }

    public static EmpPosOrgRelationCollection getPartTimeEmpPosOrgRelByOrgPos(Context ctx, String adminId, String positionId, Date appointDate, Boolean isHasSub) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)adminId)) {
            if (isHasSub.booleanValue()) {
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminId));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)("%" + adminOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)adminId));
            }
        }
        if (!StringUtils.isEmpty((String)positionId)) {
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)AssignTypeEnum.PARTTIME));
        FilterInfo filterDate = HistoryVersionUtil.getPointDateFilterInfo((Date)appointDate);
        filter.mergeFilter(filterDate, "and");
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        return empposorgRelationColl;
    }

    public static EmpPosOrgRelationCollection getEmpPosOrgRelByOrgPosIdSet(Context ctx, Set<String> orgIdSet, Set<String> posIdSet, Date appointDate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (orgIdSet != null && orgIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", orgIdSet, CompareType.INCLUDE));
        }
        if (posIdSet != null && posIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("position.id", posIdSet, CompareType.INCLUDE));
        }
        FilterInfo filterDate = HistoryVersionUtil.getPointDateFilterInfo((Date)appointDate);
        filter.mergeFilter(filterDate, "and");
        filter.getFilterItems().add(new FilterItemInfo("isLatestInAday", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)AssignTypeEnum.MAIN));
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        return empposorgRelationColl;
    }

    public static Set<String> getOrgSubPersonIdSet(Context ctx, String orgId, String posId) throws BOSException, EASBizException {
        HashSet<String> pIdSet = new HashSet<String>();
        EmpPosOrgRelationCollection eColl = OrgBatchAdjustUtil.getEmpPosOrgRelByOrgPos(ctx, orgId, posId, new Date(), false);
        for (int j = 0; j < eColl.size(); ++j) {
            EmpPosOrgRelationInfo eInfo = eColl.get(j);
            pIdSet.add(eInfo.getPerson().getId().toString());
        }
        return pIdSet;
    }

    public static Set<String> getOrgSubPositionSet(Context ctx, String orgId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        HashSet<String> posIdSet = new HashSet<String>();
        AdminOrgUnitInfo orgInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT pos.fid as posId FROM  t_org_position pos").append(" left join t_org_admin org  on pos.FADMINORGUNITID =org.fid").append(" where pos.FDELETEDSTATUS =1 and org.FISSEALUP =0").append(" and (org.FLONGNUMBER ='" + orgInfo.getLongNumber() + "' or org.FLONGNUMBER LIKE '" + orgInfo.getLongNumber() + "!%')");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                posIdSet.add(rowSet.getString("posId"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return posIdSet;
    }

    public static PositionCollection getOrgSubPositionColl(Context ctx, String orgId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        Set<String> posIdSet = OrgBatchAdjustUtil.getOrgSubPositionSet(ctx, orgId);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.company.*"));
        sic.add(new SelectorItemInfo("parent.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", posIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PositionCollection posColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(view);
        return posColl;
    }

    public static AdminOrgUnitCollection getSubOrgColl(Context ctx, String orgId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        AdminOrgUnitInfo orgInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("unitLayerType.*"));
        sic.add(new SelectorItemInfo("unitLayerType.adminAffiliationType.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)orgInfo.getLongNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
        filter.setMaskString(" (#0 or #1) AND #2");
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longNumber"));
        view.setSorter(sorter);
        AdminOrgUnitCollection orgColl = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(view);
        return orgColl;
    }

    public static String idsSetToIdSql(Set<String> idsSet) {
        String result = "";
        Iterator<String> it = idsSet.iterator();
        while (it.hasNext()) {
            result = result + ",'" + it.next() + "'";
        }
        if (result.length() > 0) {
            return result.substring(1);
        }
        return "''";
    }
}

