/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.openapi.app.IPrivacyMapping;
import com.kingdee.bos.openapi.app.PrivacyMappingFactory;
import com.kingdee.bos.privacy.PrivacyPropertyManager;
import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class PrivacyAsyncJobHandler
implements IJobHandler,
ICoreJobHandler {
    private static final Logger logger = Logger.getLogger(PrivacyAsyncJobHandler.class);
    private static final long serialVersionUID = 9166642775209554203L;
    private String privacyMappingId;
    private boolean reverse;

    public PrivacyAsyncJobHandler(String privacyMappingId, boolean reverse) {
        this.privacyMappingId = privacyMappingId;
        this.reverse = reverse;
    }

    public Object execute(Job job) throws Exception {
        Context ctx = job.getContext();
        try {
            PrivacyPropertyManager.disable();
            IPrivacyMapping privacyMapping = PrivacyMappingFactory.getLocalInstance(ctx);
            privacyMapping.syncHistory(this.privacyMappingId);
        }
        catch (Exception e) {
            try {
                String sql = " update T_Privacy_Mapping set fstate=?,FLastUpdateTime=? where fid=? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{this.reverse ? 3 : 6, new Timestamp(System.currentTimeMillis()), this.privacyMappingId});
            }
            catch (Throwable a) {
                logger.error((Object)a.getMessage(), a);
            }
            throw e;
        }
        finally {
            PrivacyPropertyManager.enable();
        }
        return null;
    }
}

