/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.core.limit;

import com.google.common.util.concurrent.RateLimiter;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.openapi.app.core.limit.AbstractLimitInterceptor;
import com.kingdee.bos.openapi.common.bo.ResultInfo;
import com.kingdee.bos.openapi.util.OpenApiConfig;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RateLimitInterceptor
extends AbstractLimitInterceptor {
    private Logger logger = Logger.getLogger(RateLimitInterceptor.class);
    private final RateLimiter rateLimiter;

    public RateLimitInterceptor(double limiterQPS) {
        super(limiterQPS);
        this.rateLimiter = RateLimiter.create((double)limiterQPS);
    }

    public void setRate(double limiterQPS) {
        this.rateLimiter.setRate(limiterQPS);
    }

    @Override
    protected ResultInfo preFilter() throws BOSException {
        int limitWaitTime = Integer.parseInt(OpenApiConfig.getProperty("limiterWaitTime", "60").trim());
        if (!this.rateLimiter.tryAcquire((long)limitWaitTime, TimeUnit.SECONDS)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"\u9650\u6d41\u4e2d......");
            }
            return ResultInfo.STATUS_RATE_LIMIT;
        }
        return ResultInfo.STATUS_SUCCESS;
    }
}

