/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.mq.comsumer;

import com.kingdee.bos.openapi.app.mq.QueueManager;
import com.kingdee.bos.openapi.app.mq.comsumer.IMqConsumer;
import com.kingdee.bos.openapi.app.mq.comsumer.MessageConsumer;
import com.kingdee.bos.openapi.common.mq.ConnectionEntity;
import com.kingdee.bos.openapi.common.mq.IERPConsumerQueue;
import com.kingdee.bos.openapi.common.mq.RabbitMqConnectionFactory;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RabbitMqConsumer
extends DefaultConsumer
implements IMqConsumer {
    private static Logger logger = Logger.getLogger(RabbitMqConsumer.class);
    private MessageConsumer consumer = null;
    private ConnectionEntity connEntity = null;
    private IERPConsumerQueue consumerQueue = null;
    private String queue = null;

    public RabbitMqConsumer(Channel channel) {
        super(channel);
    }

    @Override
    public MessageConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public ConnectionEntity getConnEntity() {
        return this.connEntity;
    }

    public void setConnEntity(ConnectionEntity connEntity) {
        this.connEntity = connEntity;
    }

    @Override
    public IERPConsumerQueue getConsumerQueue() {
        return this.consumerQueue;
    }

    public void setConsumerQueue(IERPConsumerQueue consumerQueue) {
        this.consumerQueue = consumerQueue;
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    @Override
    public void setQueue(String queue) {
        this.queue = queue;
    }

    public RabbitMqConsumer(ConnectionEntity connEntity, MessageConsumer consumer, IERPConsumerQueue consumerQueue) throws IOException {
        super(RabbitMqConnectionFactory.getConnection(connEntity).createChannel());
        this.consumer = consumer;
        this.connEntity = connEntity;
        this.consumerQueue = consumerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        byte[] result = null;
        try {
            result = this._handleDeliver(consumerTag, envelope, properties, body);
        }
        catch (Exception e) {
            logger.error((Object)"openapi error", (Throwable)e);
            result = "xxxx".getBytes();
        }
        finally {
            AMQP.BasicProperties replyProps = new AMQP.BasicProperties.Builder().correlationId(properties.getCorrelationId()).build();
            this.getChannel().basicPublish("", properties.getReplyTo(), replyProps, result);
            this.getChannel().basicAck(envelope.getDeliveryTag(), false);
            QueueManager.checkReduceConsumer(this);
        }
    }

    @Override
    public void start() {
        Channel channel = this.getChannel();
        try {
            channel.queueDeclare(this.queue, true, false, false, null);
            channel.basicQos(1);
            channel.basicConsume(this.queue, this.consumerQueue.isAutoAck(), (Consumer)this);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't init consumer for queue " + this.queue, e);
        }
    }

    private byte[] _handleDeliver(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws Exception {
        try {
            this.consumer.init(body);
        }
        catch (Exception e) {
            logger.error((Object)"openapi error,fail to init", (Throwable)e);
            throw new Exception("", e);
        }
        byte[] result = this.consumer.process();
        return result;
    }

    @Override
    public void close() throws Exception {
        Channel channel = this.getChannel();
        channel.close();
    }
}

