/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.abnormal.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbnormalAttTaskSpcialTimeCollection;
import com.kingdee.eas.hr.ats.AbnormalAttTaskSpcialTimeInfo;
import com.kingdee.eas.hr.ats.AbnormalAttTaskStatCtrCollection;
import com.kingdee.eas.hr.ats.AbnormalAttTaskStatCtrInfo;
import com.kingdee.eas.hr.ats.AbnormalAttendanceCollection;
import com.kingdee.eas.hr.ats.AbnormalAttendanceFactory;
import com.kingdee.eas.hr.ats.AbnormalAttendanceInfo;
import com.kingdee.eas.hr.ats.AbnormalAttendanceTaskInfo;
import com.kingdee.eas.hr.ats.AtsAbnormalDataStatus;
import com.kingdee.eas.hr.ats.AtsAbnormalOprationStatusEnum;
import com.kingdee.eas.hr.ats.AttendanceStatusEnum;
import com.kingdee.eas.hr.ats.IAbnormalAttendance;
import com.kingdee.eas.hr.ats.abnormal.AbnormalUtils;
import com.kingdee.eas.hr.ats.abnormal.task.AbstractAbnormalTaskService;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class AbnormalTaskServiceImpl
extends AbstractAbnormalTaskService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.abnormal.task.SynAbnormalServiceImpl");
    private UserInfo currentUser;

    @Override
    public void init(Context ctx, Map<String, Object> params, AbnormalAttendanceCollection abormals, Map<String, AbnormalAttendanceTaskInfo> tasks) {
        super.init(ctx, params, abormals, tasks);
        this.currentUser = (UserInfo)ctx.get((Object)"UserInfo");
    }

    @Override
    public void groupAbnormal() {
        if (this.abormals == null || this.abormals.size() == 0) {
            return;
        }
        if (this.tasks == null || this.tasks.size() == 0) {
            for (int index = 0; index < this.abormals.size(); ++index) {
                this.lessTaskAbnormalInfos.add(this.abormals.get(index));
            }
            return;
        }
        Date date = new Date();
        Timestamp timestamp = AtsDateUtils.dateToTimestamp(date);
        AbnormalAttendanceInfo info = null;
        for (int index = 0; index < this.abormals.size(); ++index) {
            info = this.abormals.get(index);
            info.setLastUpdateUser(this.currentUser);
            info.setLastUpdateTime(timestamp);
            AbnormalAttendanceTaskInfo taskInfo = (AbnormalAttendanceTaskInfo)this.tasks.get(info.getRuleScheme().getId().toString());
            if (taskInfo == null) {
                this.lessTaskAbnormalInfos.add(info);
                continue;
            }
            if (this.checkIsSpcialTime(taskInfo, info.getAttendanceDate())) {
                this.spcialTimeAbnormalInfos.add(info);
                continue;
            }
            if (info.getSendToDoTime() == null) {
                this.newSendAbnormalInfos.add(info);
                continue;
            }
            this.operationGroup(info, taskInfo, date);
        }
    }

    private void operationGroup(AbnormalAttendanceInfo info, AbnormalAttendanceTaskInfo taskInfo, Date date) {
        AbnormalAttTaskStatCtrCollection statCtrs = taskInfo.getStatCtrs();
        if (statCtrs == null || statCtrs.size() == 0) {
            this.lostScrAbnormalInfos.add(info);
        }
        AbnormalAttTaskStatCtrInfo statCtrInfo = null;
        AtsAbnormalOprationStatusEnum opStatus = null;
        Date nextDay = null;
        AtsAbnormalOprationStatusEnum infoStatus = info.getOperationStatus();
        if (statCtrs != null && statCtrs.size() > 0) {
            for (int index = 0; index < statCtrs.size(); ++index) {
                statCtrInfo = statCtrs.get(index);
                opStatus = statCtrInfo.getOpStatus();
                int dayValue = statCtrInfo.getDayValue();
                nextDay = AtsDateUtils.getNextDay(info.getSendToDoTime(), dayValue);
                if (null == opStatus || !opStatus.getValue().equalsIgnoreCase(infoStatus.getValue()) || nextDay.getTime() >= date.getTime()) continue;
                this.closedAbnormalInfos.add(info);
                return;
            }
        }
        this.lostScrAbnormalInfos.add(info);
    }

    private boolean checkIsSpcialTime(AbnormalAttendanceTaskInfo taskInfo, Date date) {
        AbnormalAttTaskSpcialTimeCollection spcialTimes = taskInfo.getSpcialTimes();
        if (!taskInfo.isSpcialTimeNotSendTask()) {
            return false;
        }
        if (spcialTimes == null || spcialTimes.size() == 0) {
            return false;
        }
        AbnormalAttTaskSpcialTimeInfo spcialTimeInfo = null;
        Timestamp startTime = null;
        Timestamp endTime = null;
        for (int index = 0; index < spcialTimes.size(); ++index) {
            spcialTimeInfo = spcialTimes.get(index);
            startTime = spcialTimeInfo.getStartTime();
            endTime = spcialTimeInfo.getEndTime();
            if (startTime == null || endTime == null || startTime.getTime() > date.getTime() || endTime.getTime() < date.getTime()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void otherOperationStatusGroup() {
    }

    @Override
    public void dealLessTaskAbnormal() {
    }

    @Override
    public void dealNewSendAbnormal() {
        if (this.newSendAbnormalInfos == null || this.newSendAbnormalInfos.size() == 0) {
            return;
        }
        try {
            Date date = new Date();
            Timestamp timestamp = AtsDateUtils.dateToTimestamp(date);
            AbnormalAttendanceInfo info = null;
            IAbnormalAttendance localInstance = AbnormalAttendanceFactory.getLocalInstance(this.ctx);
            CoreBaseCollection news = new CoreBaseCollection();
            CoreBaseCollection inserts = new CoreBaseCollection();
            for (int index = 0; index < this.newSendAbnormalInfos.size(); ++index) {
                try {
                    info = (AbnormalAttendanceInfo)this.newSendAbnormalInfos.get(index);
                    info.setNumber(AbnormalUtils.createNumber(info));
                    System.out.println("dealNewSendAbnormal send,UserId and date and ID is:" + info.getProposer().getId() + " " + AtsDateUtils.dateShortToString(info.getAttendanceDate()) + " " + info.getId().toString());
                    localInstance.submit((CoreBaseInfo)info);
                    info.setSendToDoUser(this.currentUser);
                    info.setSendToDoTime(timestamp);
                    news.add((CoreBaseInfo)info);
                    continue;
                }
                catch (Exception e) {
                    inserts.add(info);
                    System.out.println("dealNewSendAbnormal error,UserId and date is:" + info.getProposer().getId() + " " + AtsDateUtils.dateShortToString(info.getAttendanceDate()));
                }
            }
            localInstance.updateBatchData(news);
            this.changeAbnormalId(this.ctx, inserts, localInstance);
        }
        catch (Exception e) {
            System.out.println("dealNewSendAbnormal error");
            e.printStackTrace();
            logger.error((Object)e);
        }
    }

    private void changeAbnormalId(Context ctx, CoreBaseCollection abnormals, IAbnormalAttendance localInstance) throws EASBizException, BOSException {
        if (abnormals.size() > 0) {
            Date date = new Date();
            Timestamp timestamp = new Timestamp(date.getTime());
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
            for (int index = 0; index < abnormals.size(); ++index) {
                Object[] objects = new Object[]{timestamp, abnormals.get(index).getId().toString()};
                sqlParams.add(objects);
            }
            String sql = "update T_HR_ATS_AbnormalAttendance set FDataStatus = " + AtsAbnormalDataStatus.updateId.getValue() + ", FBillState = " + HRBillStateEnum.SUBMITED.getValue() + ",FLastUpdateTime = ?  where fid = ?";
            DbUtile.executeBatch(ctx, sql, sqlParams);
        }
    }

    @Override
    public void dealCloseAbnormal() {
        if (this.closedAbnormalInfos == null || this.closedAbnormalInfos.size() == 0) {
            return;
        }
        try {
            Date date = new Date();
            Timestamp timestamp = AtsDateUtils.dateToTimestamp(date);
            IAbnormalAttendance localInstance = AbnormalAttendanceFactory.getLocalInstance(this.ctx);
            CoreBaseCollection closed = new CoreBaseCollection();
            for (int index = 0; index < this.closedAbnormalInfos.size(); ++index) {
                AbnormalAttendanceInfo info = (AbnormalAttendanceInfo)this.closedAbnormalInfos.get(index);
                info.setStatus(AttendanceStatusEnum.theArchive);
                info.setLastUpdateTime(timestamp);
                info.setLastUpdateUser(this.currentUser);
                AbnormalUtils.abortAbnormal(this.ctx, info, localInstance);
                closed.add((CoreBaseInfo)info);
            }
            localInstance.updateBatchData(closed);
            CoreBaseCollection inserts = new CoreBaseCollection();
            for (int index = 0; index < this.closedAbnormalInfos.size(); ++index) {
                AbnormalAttendanceInfo info = (AbnormalAttendanceInfo)((AbnormalAttendanceInfo)this.closedAbnormalInfos.get(index)).clone();
                info.setStatus(AttendanceStatusEnum.pending);
                info.setId(null);
                info.setLastUpdateTime(timestamp);
                info.setLastUpdateUser(this.currentUser);
                info.setSendToDoUser(null);
                info.setSendToDoTime(null);
                info.setCreator(this.currentUser);
                info.setCreateTime(timestamp);
                info.setOperationStatus(AtsAbnormalOprationStatusEnum.confirm);
                info.setBillState(HRBillStateEnum.SUBMITED);
                inserts.add((CoreBaseInfo)info);
            }
            localInstance.addnewBatchData(inserts);
            CoreBaseCollection ups = new CoreBaseCollection();
            CoreBaseCollection upss = new CoreBaseCollection();
            for (int index = 0; index < inserts.size(); ++index) {
                AbnormalAttendanceInfo info = null;
                try {
                    info = (AbnormalAttendanceInfo)inserts.get(index);
                    info.setNumber(AbnormalUtils.createNumber(info));
                    System.out.println("dealCloseAbnormal send,UserId and date and ID is:" + info.getProposer().getId() + " " + AtsDateUtils.dateShortToString(info.getAttendanceDate()) + " " + info.getId().toString());
                    localInstance.submit((CoreBaseInfo)info);
                    info.setSendToDoUser(this.currentUser);
                    info.setSendToDoTime(timestamp);
                    ups.add((CoreBaseInfo)info);
                    continue;
                }
                catch (Exception e) {
                    if (info != null) {
                        System.out.println("dealCloseAbnormal error,UserId and date is:" + info.getProposer().getId() + " " + AtsDateUtils.dateShortToString(info.getAttendanceDate()));
                        upss.add((CoreBaseInfo)info);
                    }
                    e.printStackTrace();
                }
            }
            localInstance.updateBatchData(ups);
            this.changeAbnormalId(this.ctx, upss, localInstance);
        }
        catch (Exception e) {
            System.out.println("dealCloseAbnormals error");
            e.printStackTrace();
            logger.error((Object)e);
        }
    }

    @Override
    public void dealOtherAbnormal() {
    }

    @Override
    public void dealLostScrAbnormal() {
    }

    @Override
    public void dealSpcialTimeAbnormal() {
    }
}

