/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.base.ssc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportInfo;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsAcrossStoreRptUtils;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.shareservice.ActivitySolutionInfo;
import com.kingdee.shr.shareservice.strategy.impl.AbstractBaseActivitySolutionOperation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AtsBillSolutionOperation
extends AbstractBaseActivitySolutionOperation {
    public Map<String, Object> getOrgAndPerson(Context ctx, String billId, Map params) throws BOSException, EASBizException {
        CoreBaseInfo billInfo = AtsEntityUtile.getData(ctx, billId);
        Map orgAndPerson = AtsCollectionUtile.newMap("personId", "");
        if (billInfo instanceof AtsAcrossStoreSopportInfo) {
            AtsAcrossStoreSopportInfo crossBill = (AtsAcrossStoreSopportInfo)billInfo;
            String userId = CoreBaseUtile.getId(crossBill.getCreator());
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo("select person.id,name where id='" + userId + "'");
            orgAndPerson.put("personId", CoreBaseUtile.getId(user.getPerson()));
            orgAndPerson.put("personName", user.getName());
            HROrgUnitInfo hrOrgUnit = crossBill.getHrOrgUnit();
            orgAndPerson.put("hrOrgUnit", hrOrgUnit == null ? null : HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrgUnit.getId())));
            AdminOrgUnitInfo adminOrg = crossBill.getAdminOrg();
            orgAndPerson.put("adminOrgUnit", adminOrg == null ? null : AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrg.getId())));
        }
        if (StringUtils.isBlank((CharSequence)((String)orgAndPerson.get("personId")))) {
            PersonInfo personInfo = SHRBillUtil.getCurrPersonInfoNew(ctx);
            orgAndPerson.put("personId", personInfo.getString("id"));
            orgAndPerson.put("personName", personInfo.getName());
            orgAndPerson.put("hrOrgUnit", ContextUtil.getCurrentHRUnit((Context)ctx));
            orgAndPerson.put("adminOrgUnit", ContextUtil.getCurrentAdminUnit((Context)ctx));
        }
        return orgAndPerson;
    }

    public void beforeCreateJob(Context ctx, ActivitySolutionInfo activitySolutionInfo, String billId, Map params) throws BOSException, EASBizException {
    }

    public void afterCreateJob(Context ctx, ActivitySolutionInfo activitySolutionInfo, String billId, Set<String> jobIdSet, Map afterCreateParam) throws BOSException, EASBizException {
        Map params = (Map)afterCreateParam.get("params");
        Set users = (Set)params.get("currentDistributeUser");
        if (AtsCollectionUtile.isEmpty(users) || AtsCollectionUtile.isEmpty(jobIdSet)) {
            return;
        }
        if (!params.containsKey("hasPushedUsers")) {
            params.put("hasPushedUsers", new HashSet());
        }
        Map jobParam = (Map)afterCreateParam.get("paramMap");
        Set hasPushedUsers = (Set)params.get("hasPushedUsers");
        HashMap<String, Object> pushParam = new HashMap<String, Object>(params);
        pushParam.remove("currentDistributeUser");
        pushParam.remove("hasPushedUsers");
        pushParam.put("fromSSC", true);
        pushParam.put("jobFromWF", params.get("workflow"));
        pushParam.put("jobId", jobIdSet.iterator().next());
        pushParam.put("billID", billId);
        for (String user : users) {
            if (!hasPushedUsers.add(user)) continue;
            AtsAcrossStoreRptUtils.pushCollaboratMsg(ctx, user, String.valueOf(jobParam.get("subject")), pushParam);
        }
    }

    public Map<String, Object> getCommonParams(Context ctx, String billId, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> createdMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)billId)) {
            ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, billId);
            EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"creator.number", "proposer.name", "createTime"});
            AtsViewUtile.getViewByFilter("id", (Object)billId, evi);
            CoreBaseInfo billInfo = iCoreBase.getValue(evi.toString());
            createdMap.put("creator.number", CoreBaseUtile.getfield(billInfo, "creator.number"));
            createdMap.put("personId.name", CoreBaseUtile.getfield(billInfo, "proposer.name"));
            createdMap.put("MultiApprove.createTime", billInfo.getTimestamp("createTime"));
        }
        return createdMap;
    }
}

