/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.biz.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.app.AtsLeaveBillControllerBean;
import com.kingdee.eas.hr.ats.dataLog.control.LogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.factory.DataLogControlFactory;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenHolidayLimitManager;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.takeWorkLimit.impl.GenerateTakeWorkLimit;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmInfo;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtsAutoDealUtil {
    private static Logger logger = Logger.getLogger(AtsAutoDealUtil.class);
    public static final String COMPENSATION_DAY_ID = "+ZM5jTmrS0KHCjDSYGcFLf0tUpg=";

    public static void transferReCal(Context ctx, PersonBURelaConfirmInfo personBURelaConfirmInfo) throws EASBizException, BOSException {
        AtsAutoDealUtil.transferReCal(ctx, personBURelaConfirmInfo.getChangeDate(), personBURelaConfirmInfo.getPerson().getId().toString());
        AtsAutoDealUtil.transferTakeLimitReCal(ctx, personBURelaConfirmInfo.getChangeDate(), personBURelaConfirmInfo.getPerson().getId().toString());
        AtsAutoDealUtil.resetLeaveBill(ctx, personBURelaConfirmInfo.getChangeDate(), personBURelaConfirmInfo.getPerson().getId().toString(), personBURelaConfirmInfo.getNewHrOrgUnit().getId().toString());
    }

    public static void transferReCal(Context ctx, Object changeDateObj, String personId) throws EASBizException, BOSException {
        Date changeDate = Date.getDate(changeDateObj);
        try {
            if (StringUtils.isEmpty((String)personId) || changeDate == null) {
                return;
            }
            String updateLimit = AtsAutoDealUtil.hasLimit(ctx, changeDate, personId);
            AtsAutoDealUtil.leaveReCal(ctx, changeDate.newPreDay(), personId, Boolean.valueOf(ConfigAts.getPropertyFromConfig("del_delimit_when_bizChange")));
            String deleteSql = "delete from T_HR_ATS_HOLIDAYLIMIT t1 where FProposerid=? and fCycleBeginDate <=? and fCycleEndDate>=? and exists(select 1 from T_HR_ATS_HolidayPolicy t2 where t1.FHolidayPolicyID=t2.fid and t2.FHolidayTypeID <> ?)";
            DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{personId, changeDate, changeDate, COMPENSATION_DAY_ID});
            if (!StringUtils.isEmpty((String)updateLimit)) {
                HashMap<Object, Object> param = new HashMap<Object, Object>();
                param.put("proposers", personId);
                param.put("existedDealType", "1");
                param.put("calBaseDate", changeDate);
                param.put("holidayType", updateLimit);
                param.put("transaction", "transaction");
                param.put("cycleDate", changeDate.toDateStr());
                new GenHolidayLimitManager().generateNewHolidayLimit(ctx, param);
            }
        }
        catch (Exception e) {
            logger.error((Object)"catch a exception.", (Throwable)e);
        }
    }

    public static void transferTakeLimitReCal(Context ctx, Object changeDateObj, String personId) throws EASBizException, BOSException {
        logger.error((Object)MessageFormat.format("transferTakeLimitReCal begin changeDateObj={0},personId={1}", changeDateObj, personId));
        Date changeDate = Date.getDate(changeDateObj);
        try {
            if (StringUtils.isEmpty((String)personId) || changeDate == null) {
                return;
            }
            AtsAutoDealUtil.calTransferBeforeTakeLimit(ctx, personId, changeDate.newPreDay());
            AtsAutoDealUtil.calTransferAfterTakeLimit(ctx, personId, changeDate);
        }
        catch (Exception e) {
            logger.error((Object)"catch a exception.", (Throwable)e);
        }
    }

    private static void calTransferBeforeTakeLimit(Context ctx, String personId, Date changeDate) throws Exception {
        String updateSql = "update T_HR_ATS_HOLIDAYLIMIT t1 set fdelayDate=? where FProposerid=? and feffectdate<=? and fdelayDate>? and exists(select 1 from T_HR_ATS_HolidayPolicy t2 where t1.FHolidayPolicyID=t2.fid and t2.FHolidayTypeID = ?)";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{changeDate, personId, changeDate, changeDate, COMPENSATION_DAY_ID});
        AtsHolidayFileHisCollection fileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposer.id='" + personId + "' order by effdt desc");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("proposers", personId);
        param.put("existedDealType", "1");
        param.put("calBaseDate", changeDate.toDateStr());
        param.put("bizChangeDate", changeDate.toDateStr());
        param.put("transaction", "transaction");
        param.put("cycleDate", changeDate.toDateStr());
        if (fileHisCollection.size() > 0) {
            AtsHolidayFileHisInfo info = fileHisCollection.get(0);
            HolidayPolicySetInfo policySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo((IObjectPK)new ObjectUuidPK(info.getHolidayPolicySet().getId()));
            param.put("policySet", policySetInfo);
            GenerateTakeWorkLimit genTWLimitService = new GenerateTakeWorkLimit(ctx);
            genTWLimitService.prepareInitClearData();
            genTWLimitService.preparePageData(ctx, param);
            genTWLimitService.genLimit(ctx, ctx, param);
            genTWLimitService.prepareInitClearData();
        }
    }

    private static void calTransferAfterTakeLimit(Context ctx, String personId, Date changeDate) throws Exception {
        AtsHolidayFileHisCollection fileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposer.id='" + personId + "' order by effdt desc");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("proposers", personId);
        param.put("existedDealType", "1");
        param.put("calBaseDate", changeDate.toDateStr());
        param.put("transaction", "transaction");
        param.put("cycleDate", changeDate.toDateStr());
        if (fileHisCollection.size() > 0) {
            AtsHolidayFileHisInfo info = fileHisCollection.get(0);
            HolidayPolicySetInfo policySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo((IObjectPK)new ObjectUuidPK(info.getHolidayPolicySet().getId()));
            param.put("policySet", policySetInfo);
            GenerateTakeWorkLimit genTWLimitService = new GenerateTakeWorkLimit(ctx);
            genTWLimitService.prepareInitClearData();
            genTWLimitService.preparePageData(ctx, param);
            genTWLimitService.genLimit(ctx, ctx, param);
            genTWLimitService.prepareInitClearData();
        }
    }

    public static boolean needTransferReCal(Context ctx, Date changeDate, String personId) throws BOSException {
        boolean needCal = false;
        String selectSql = "select FHolidayPolicySetID from T_HR_ATS_AtsHolidayFileHis where FProposerid=? and feffdt<=? and fleffdt>=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{personId, changeDate, changeDate.newPreDay()});
        try {
            rowSet.next();
            String policy = rowSet.getString("FHolidayPolicySetID");
            rowSet.next();
            needCal = !StringUtils.equals((String)policy, (String)rowSet.getString("FHolidayPolicySetID")) && !rowSet.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return needCal;
    }

    public static void leaveReCal(Context ctx, PersonBURelaConfirmInfo personBURelaConfirmInfo) throws EASBizException, BOSException {
        Date changeDate = Date.getTime(personBURelaConfirmInfo.getChangeDate()).newPreDay();
        AtsAutoDealUtil.leaveReCal(ctx, changeDate, personBURelaConfirmInfo.getPerson().getId().toString(), true);
    }

    public static Map<String, Object> leaveReCal(Context ctx, Object changeDateObj, String personId, boolean deleteAfterLimit) throws BOSException {
        Date changeDate = Date.getDate(changeDateObj);
        if (StringUtils.isEmpty((String)personId) || changeDate == null) {
            return null;
        }
        String updateLimit = AtsAutoDealUtil.hasLimit(ctx, changeDateObj, personId);
        if (deleteAfterLimit) {
            DbUtil.execute((Context)ctx, (String)"delete T_HR_ATS_HOLIDAYLIMIT where FProposerid=? and fCycleBeginDate>?", (Object[])new Object[]{personId, changeDate});
        }
        AtsAutoDealUtil.updateCycleDate(ctx, personId, changeDate);
        Map<String, Object> result = null;
        if (!StringUtils.isEmpty((String)updateLimit)) {
            HashMap<Object, Object> param = new HashMap<Object, Object>();
            param.put("proposers", personId);
            param.put("existedDealType", "1");
            param.put("holidayType", updateLimit);
            param.put("bizChangeDate", changeDate);
            param.put("transaction", "transaction");
            param.put("cycleDate", changeDate.toDateStr());
            result = new GenHolidayLimitManager().generateUpdateHolidayLimit(ctx, param);
            param.remove("bizChangeDate");
        }
        AtsAutoDealUtil.updateTakeWorkLimit(ctx, personId, changeDate);
        return result;
    }

    private static void updateTakeWorkLimit(Context ctx, String personId, Date changeDate) {
        try {
            logger.error((Object)MessageFormat.format("come in compensation day method.personId={0},changeDateObj={1}", personId, changeDate));
            HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer.id='" + personId + "' and holidayPolicy.holidayType.id ='" + COMPENSATION_DAY_ID + "'   ");
            if (AtsCollectionUtile.isEmpty((IObjectCollection)holidayLimitCollection)) {
                return;
            }
            logger.error((Object)MessageFormat.format("holidayLimitCollection.size={0}", holidayLimitCollection.size()));
            CoreBaseCollection oldLimitColl = new CoreBaseCollection();
            for (int i = 0; i < holidayLimitCollection.size(); ++i) {
                oldLimitColl.add((CoreBaseInfo)holidayLimitCollection.get(i));
            }
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
            DataLogUtil.addLogObserverToCenter(ctx, logControlCenter, oldLimitColl, OperTypeEnum.holidayLimit, OperActionEnum.leftUndoByOsf, false);
            CoreBaseCollection updateHolidayLimitCollection = new CoreBaseCollection();
            for (int i = 0; i < holidayLimitCollection.size(); ++i) {
                HolidayLimitInfo holidayLimitInfo = holidayLimitCollection.get(i);
                if (holidayLimitInfo == null) continue;
                boolean isUpdate = false;
                if (holidayLimitInfo.getCycleBeginDate() != null && holidayLimitInfo.getCycleEndDate() != null && holidayLimitInfo.getCycleBeginDate().before(changeDate) && holidayLimitInfo.getCycleEndDate().after(changeDate)) {
                    holidayLimitInfo.setLeftCycleEndDate(holidayLimitInfo.getCycleEndDate());
                    holidayLimitInfo.setCycleEndDate(changeDate);
                    isUpdate = true;
                }
                if (holidayLimitInfo.getEffectDate() != null && holidayLimitInfo.getDelayDate() != null && holidayLimitInfo.getEffectDate().before(changeDate) && holidayLimitInfo.getDelayDate().after(changeDate)) {
                    holidayLimitInfo.setLeftDelayDate(holidayLimitInfo.getLeftDelayDate());
                    holidayLimitInfo.setDelayDate(changeDate);
                    isUpdate = true;
                }
                if (!isUpdate) continue;
                holidayLimitInfo.setIsLeftConvert(true);
                updateHolidayLimitCollection.add((CoreBaseInfo)holidayLimitInfo);
            }
            logger.error((Object)MessageFormat.format("updateHolidayLimitCollection.size={0}", updateHolidayLimitCollection.size()));
            Result result = HolidayLimitFactory.getLocalInstance(ctx).update(updateHolidayLimitCollection);
            logger.error((Object)MessageFormat.format("update status={0}", result != null ? result.getResult() : 0));
            DataLogUtil.addLogObserverToCenter(ctx, logControlCenter, updateHolidayLimitCollection, OperTypeEnum.holidayLimit, OperActionEnum.leftUndoByOsf, true);
        }
        catch (Exception e) {
            logger.error((Object)"catch a exception.", (Throwable)e);
        }
    }

    private static void updateCycleDate(Context ctx, String personId, Date changeDate) throws BOSException {
        String updateSql = "UPDATE T_HR_ATS_HOLIDAYLIMIT T1 SET FLEFTDELAYDATE=FDELAYDATE WHERE FPROPOSERID=? AND FEFFECTDATE<=? AND FDELAYDATE>?  AND EXISTS(SELECT 1 FROM T_HR_ATS_HOLIDAYPOLICY T2 WHERE T1.FHOLIDAYPOLICYID=T2.FID AND T2.FHOLIDAYTYPEID <> ?)";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{personId, changeDate, changeDate, COMPENSATION_DAY_ID});
        updateSql = " UPDATE T_HR_ATS_HOLIDAYLIMIT T1 SET FDELAYDATE=? ,FISLEFTCONVERT=? WHERE FPROPOSERID=? AND FEFFECTDATE<=? AND FDELAYDATE>?   AND EXISTS(SELECT 1 FROM T_HR_ATS_HOLIDAYPOLICY T2 WHERE T1.FHOLIDAYPOLICYID=T2.FID AND T2.FHOLIDAYTYPEID <> ?)";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{changeDate, 1, personId, changeDate, changeDate, COMPENSATION_DAY_ID});
    }

    public static String hasLimit(Context ctx, Object changeDateObj, String personId) throws BOSException {
        Date changeDate = Date.getDate(changeDateObj);
        StringBuffer limit = new StringBuffer();
        try {
            StringBuffer querySql = new StringBuffer();
            querySql.append(" select policy.FHolidayTypeID holidayTypeId");
            querySql.append(" FROM T_HR_ATS_HOLIDAYLIMIT HOLIMIT ");
            querySql.append(" JOIN T_HR_ATS_HolidayPolicy policy ON HOLIMIT.fholidaypolicyid = policy.fid");
            querySql.append(" where HOLIMIT.FPROPOSERID = ? and HOLIMIT.fCycleBeginDate <=? and HOLIMIT.fcycleEndDate>=? and policy.FHolidayTypeID <> ?");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])new Object[]{personId, changeDate, changeDate, COMPENSATION_DAY_ID});
            while (rowSet.next()) {
                limit.append(rowSet.getString("holidayTypeId")).append(",");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (limit.length() > 0) {
            limit.setLength(limit.length() - 1);
        }
        return limit.toString();
    }

    public static void leaveDelSchedule(Context ctx, PersonBURelaConfirmInfo personBURelaConfirmInfo) throws BOSException, EASBizException {
        String personId = personBURelaConfirmInfo.getPerson().getId().toString();
        AttendanceFileInfo fileInfo = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileInfo("select *,attencePolicy.* from where proposer.id = '" + personId + "'");
        String changeDate = AtsDateUtils.dateShortToString(fileInfo.getLEFFDT());
        String delSql = "delete T_HR_ATS_ScheduleShift where FattendDate > {ts '" + changeDate + "'} and Fproposerid = '" + personId + "'";
        String delItemSql = "delete T_HR_ATS_ScheduleShiftItem where FgroupID in (select fid from T_HR_ATS_ScheduleShift where FattendDate > {ts '" + changeDate + "'} and Fproposerid = '" + personId + "')";
        DbUtil.execute((Context)ctx, (String)delItemSql);
        DbUtil.execute((Context)ctx, (String)delSql);
    }

    public static void leaveDelResult(Context ctx, PersonBURelaConfirmInfo personBURelaConfirmInfo) throws BOSException, EASBizException {
        String personId = personBURelaConfirmInfo.getPerson().getId().toString();
        AttendanceFileInfo fileInfo = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileInfo("select *,attencePolicy.* from where proposer.id = '" + personId + "'");
        String changeDate = AtsDateUtils.dateShortToString(fileInfo.getLEFFDT());
        String delSql = "delete T_HR_ATS_AttendanceResult where FattenceDate > {ts '" + changeDate + "'} and Fproposerid = '" + personId + "' ";
        DbUtil.execute((Context)ctx, (String)delSql);
    }

    public static void resetLeaveBill(Context ctx, Object changeDate, String personId, String hrOrgId) {
        try {
            String date = HRTimeWebUtils.dateLongToString(Date.getDate(changeDate));
            AtsLeaveBillEntryCollection collection = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection("where person='" + personId + "' and bill.HROrgUnit ='" + hrOrgId + "' and beginTime >= '" + date + "'");
            if (collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    AtsLeaveBillEntryInfo info = collection.get(i);
                    AtsLeaveBillControllerBean bean = new AtsLeaveBillControllerBean();
                    String billId = info.getBill().getId().toString();
                    AtsLeaveBillInfo leaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(billId));
                    if (leaveBillInfo.getBillState() == HRBillStateEnum.AUDITED) {
                        bean.rollBackHolidayLimit(ctx, BOSUuid.read((String)billId), 6);
                        bean.deductHolidayLimit(ctx, BOSUuid.read((String)billId), 4);
                        continue;
                    }
                    if (leaveBillInfo.getBillState() != HRBillStateEnum.SUBMITED && leaveBillInfo.getBillState() != HRBillStateEnum.AUDITING) continue;
                    bean.rollBackHolidayLimit(ctx, BOSUuid.read((String)billId), 6);
                    bean.deductHolidayLimit(ctx, BOSUuid.read((String)billId), 6);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

