/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.datadump.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.datadump.service.impl.CommonDataDumpImpl;
import com.kingdee.eas.hr.ats.datadump.util.DataDumpLog;
import com.kingdee.eas.hr.ats.datadump.util.DataDumpUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="MainEntryDataDumpImpl")
@Scope(value="prototype")
public class MainEntryDataDumpImpl
extends CommonDataDumpImpl {
    @Autowired
    private DataDumpLog logger;

    @Override
    public List<String> getDataDumpSql(Context ctx) {
        this.logger.info(this.dataDumpConfigInfo.getName() + " getDataDumpSql");
        ArrayList<String> sqlList = new ArrayList<String>();
        String tableName = this.dataDumpConfigInfo.getTableName();
        String joinSql = this.dataDumpConfigInfo.getJoinSql();
        String filterField = this.dataDumpConfigInfo.getFilterField();
        Set<String> insertColumns = DataDumpUtil.getColumnMapByTableName(ctx, tableName).keySet();
        HashSet<String> insertEntryColumns = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)this.dataDumpConfigInfo.getEntryTableName())) {
            insertEntryColumns = DataDumpUtil.getColumnMapByTableName(ctx, this.dataDumpConfigInfo.getEntryTableName()).keySet();
        }
        String entryTableName = this.dataDumpConfigInfo.getEntryTableName();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "_" + dumpYear;
                String beginDate = dumpYear + "-01-01";
                String endDate = Integer.valueOf(dumpYear) + 1 + "-01-01";
                String whereSql = "where " + filterField + " >= {ts '" + beginDate + "'} and " + filterField + " < {ts '" + endDate + "'}";
                String insertSql = DataDumpUtil.genInsertDumpSQL(ctx, dumpYearTableName, insertColumns, tableName, joinSql, whereSql);
                sqlList.add(insertSql);
                String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry_" + dumpYear;
                String mainEntryJoinCondition = this.dataDumpConfigInfo.getEntryFilterField().toUpperCase().replaceFirst(this.dataDumpConfigInfo.getTableName().toUpperCase(), dumpYearTableName);
                String entryWhereExistsSql = " WHERE EXISTS (SELECT 1 FROM " + dumpYearTableName + " WHERE " + mainEntryJoinCondition + " ) ";
                String insertEntrySql = DataDumpUtil.genInsertDumpSQL(ctx, dumpEntryYearTableName, insertEntryColumns, this.dataDumpConfigInfo.getEntryTableName(), null, entryWhereExistsSql);
                sqlList.add(insertEntrySql);
            }
        } else {
            String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName();
            String insertSql = DataDumpUtil.genInsertDumpSQL(ctx, dumpYearTableName, insertColumns, tableName, joinSql, null);
            sqlList.add(insertSql);
            String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry";
            String mainEntryJoinCondition = this.dataDumpConfigInfo.getEntryFilterField().toUpperCase().replaceFirst(this.dataDumpConfigInfo.getTableName().toUpperCase(), dumpYearTableName);
            String entryWhereExistsSql = " WHERE EXISTS (SELECT 1 FROM " + dumpYearTableName + " WHERE " + mainEntryJoinCondition + " ) ";
            String insertEntrySql = DataDumpUtil.genInsertDumpSQL(ctx, dumpEntryYearTableName, insertEntryColumns, this.dataDumpConfigInfo.getEntryTableName(), null, entryWhereExistsSql);
            sqlList.add(insertEntrySql);
        }
        return sqlList;
    }

    @Override
    public List<String> getDeleteSql(Context ctx) {
        this.logger.info(this.dataDumpConfigInfo.getName() + " deleteCurTableData");
        ArrayList<String> sqlList = new ArrayList<String>();
        String tableName = this.dataDumpConfigInfo.getTableName();
        String filterField = this.dataDumpConfigInfo.getFilterField();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String beginDate = dumpYear + "-01-01";
                String endDate = Integer.valueOf(dumpYear) + 1 + "-01-01";
                String whereSql = "where " + filterField + " >= {ts '" + beginDate + "'} and " + filterField + " < {ts '" + endDate + "'}";
                String deletetSql = "delete from " + tableName + " " + whereSql;
                sqlList.add(deletetSql);
                String entryTableName = this.dataDumpConfigInfo.getEntryTableName();
                if (!StringUtils.isNotEmpty((CharSequence)entryTableName) || !StringUtils.isNotEmpty((CharSequence)this.dataDumpConfigInfo.getEntryFilterField())) continue;
                String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry_" + dumpYear;
                String entryWhereSql = " WHERE EXISTS (SELECT 1 FROM  " + dumpEntryYearTableName + " WHERE " + entryTableName + ".FID = " + dumpEntryYearTableName + ".FID)";
                String deleteEntrySql = "delete from " + entryTableName + " " + entryWhereSql;
                sqlList.add(deleteEntrySql);
            }
        } else {
            String deletetSql = "delete from " + tableName;
            sqlList.add(deletetSql);
            String entryTableName = this.dataDumpConfigInfo.getEntryTableName();
            if (StringUtils.isNotEmpty((CharSequence)entryTableName) && StringUtils.isNotEmpty((CharSequence)this.dataDumpConfigInfo.getEntryFilterField())) {
                String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry";
                String entryWhereSql = " WHERE EXISTS (SELECT 1 FROM  " + dumpEntryYearTableName + " WHERE " + entryTableName + ".FID = " + dumpEntryYearTableName + ".FID)";
                String deleteEntrySql = "delete from " + entryTableName + " " + entryWhereSql;
                sqlList.add(deleteEntrySql);
            }
        }
        return sqlList;
    }

    @Override
    public List<String> getAntiDataDumpSql(Context ctx) {
        this.logger.info(this.dataDumpConfigInfo.getName() + " getDataDumpSql");
        ArrayList<String> sqlList = new ArrayList<String>();
        String tableName = this.dataDumpConfigInfo.getTableName();
        Set<String> insertColumns = DataDumpUtil.getColumnMapByTableName(ctx, tableName).keySet();
        HashSet<String> insertEntryColumns = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)this.dataDumpConfigInfo.getEntryTableName())) {
            insertEntryColumns = DataDumpUtil.getColumnMapByTableName(ctx, this.dataDumpConfigInfo.getEntryTableName()).keySet();
        }
        String entryTableName = this.dataDumpConfigInfo.getEntryTableName();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getAntiDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "_" + dumpYear;
                String insertSql = DataDumpUtil.genInsertDumpSQL(ctx, tableName, insertColumns, dumpYearTableName, null, null);
                sqlList.add(insertSql);
                String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry_" + dumpYear;
                String insertEntrySql = DataDumpUtil.genInsertDumpSQL(ctx, entryTableName, insertEntryColumns, dumpEntryYearTableName, null, null);
                sqlList.add(insertEntrySql);
            }
        } else {
            String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName();
            String insertSql = DataDumpUtil.genInsertDumpSQL(ctx, tableName, insertColumns, dumpYearTableName, null, null);
            sqlList.add(insertSql);
            String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry";
            String insertEntrySql = DataDumpUtil.genInsertDumpSQL(ctx, entryTableName, insertEntryColumns, dumpEntryYearTableName, null, null);
            sqlList.add(insertEntrySql);
        }
        return sqlList;
    }

    @Override
    public List<String> getAntiDeleteSql(Context ctx) {
        this.logger.info(this.dataDumpConfigInfo.getName() + " deleteCurTableData");
        ArrayList<String> sqlList = new ArrayList<String>();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getAntiDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "_" + dumpYear;
                String deletetSql = "delete from " + dumpYearTableName;
                sqlList.add(deletetSql);
                String entryTableName = this.dataDumpConfigInfo.getEntryTableName();
                if (!StringUtils.isNotEmpty((CharSequence)entryTableName) || !StringUtils.isNotEmpty((CharSequence)this.dataDumpConfigInfo.getEntryFilterField())) continue;
                String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry_" + dumpYear;
                String deleteEntrySql = "delete from " + dumpEntryYearTableName;
                sqlList.add(deleteEntrySql);
            }
        } else {
            String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName();
            String deletetSql = "delete from " + dumpYearTableName;
            sqlList.add(deletetSql);
            String entryTableName = this.dataDumpConfigInfo.getEntryTableName();
            if (StringUtils.isNotEmpty((CharSequence)entryTableName) && StringUtils.isNotEmpty((CharSequence)this.dataDumpConfigInfo.getEntryFilterField())) {
                String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry";
                String deleteEntrySql = "delete from " + dumpEntryYearTableName;
                sqlList.add(deleteEntrySql);
            }
        }
        return sqlList;
    }
}

