/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.decimalPlace.strategy.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationCommon;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

public class DecimalPlaceOperationLimit
extends DecimalPlaceOperationCommon
implements IDecimalPlaceStrategy {
    protected IDecimalPlaceStrategy strategy = new DecimalPlaceOperationSystem();

    @Override
    public BigDecimal precisionConvert(Context ctx, Map<String, Object> param) {
        BigDecimal standardLimit = (BigDecimal)param.get("standardLimit");
        try {
            RoundingMode roundingMode;
            HolidayPolicyInfo holidayPolicyInfo = (HolidayPolicyInfo)param.get("holidayPolicyInfo");
            RoundingMode roundingMode2 = roundingMode = (RoundingMode)((Object)param.get("roundingMode")) == null ? RoundingMode.HALF_UP : (RoundingMode)((Object)param.get("roundingMode"));
            if (null != holidayPolicyInfo && null != standardLimit) {
                if (holidayPolicyInfo.isEnableMinAmt()) {
                    BigDecimal minAmt = holidayPolicyInfo.getMinAmt();
                    Double M = minAmt.stripTrailingZeros().doubleValue();
                    int scale = DecimalPlaceUtil.getNumberDecimalDigits(M);
                    int minAmtMtd = holidayPolicyInfo.getMinAmtValueMtd().getValue();
                    int ZNum = (int)(standardLimit.doubleValue() / M);
                    BigDecimal M1 = this.strategy.precisionConvert(ctx, new BigDecimal(M), RoundingMode.HALF_UP);
                    double XSNum = standardLimit.divideAndRemainder(M1)[1].doubleValue();
                    if (minAmtMtd == 1) {
                        standardLimit = BigDecimal.valueOf(((double)ZNum + Math.floor(XSNum / M)) * M);
                    } else if (minAmtMtd == 2) {
                        standardLimit = BigDecimal.valueOf(((double)ZNum + Math.ceil(XSNum / M)) * M);
                    } else if (minAmtMtd == 3) {
                        standardLimit = BigDecimal.valueOf((double)((long)ZNum + Math.round(XSNum / M)) * M);
                    }
                    standardLimit = BigDecimal.valueOf(Math.floor(standardLimit.doubleValue() / M) * M).setScale(scale, roundingMode);
                } else {
                    Integer decimalPlaces = (Integer)param.get("decimalPlaces");
                    standardLimit = null != decimalPlaces && decimalPlaces >= 0 ? standardLimit.setScale((int)decimalPlaces, roundingMode) : this.precisionConvert(ctx, standardLimit, roundingMode);
                }
            }
        }
        catch (Exception e) {
            standardLimit = this.precisionConvert(ctx, standardLimit, RoundingMode.HALF_UP);
            e.printStackTrace();
        }
        return standardLimit;
    }
}

