/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.decimalPlace.strategy.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AttencePolicyEntryInfo;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationCommon;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

public class DecimalPlaceOperationOffsite
extends DecimalPlaceOperationCommon
implements IDecimalPlaceStrategy {
    protected IDecimalPlaceStrategy strategy = new DecimalPlaceOperationSystem();

    @Override
    public BigDecimal precisionConvert(Context ctx, Map<String, Object> param) {
        BigDecimal billLength = (BigDecimal)param.get("billLength");
        try {
            RoundingMode roundingMode;
            AttencePolicyEntryInfo policyEntry = (AttencePolicyEntryInfo)param.get("policyEntry");
            RoundingMode roundingMode2 = roundingMode = param.get("roundingMode") == null ? RoundingMode.HALF_UP : (RoundingMode)((Object)param.get("roundingMode"));
            if (null != policyEntry && null != billLength) {
                if (policyEntry.isUnitLengthControl()) {
                    BigDecimal minAmt = policyEntry.getUnitLength();
                    Double M = minAmt.stripTrailingZeros().doubleValue();
                    int scale = DecimalPlaceUtil.getNumberDecimalDigits(M);
                    int minAmtMtd = policyEntry.getTakeValueMethod().getValue();
                    int ZNum = (int)(billLength.doubleValue() / M);
                    BigDecimal M1 = this.strategy.precisionConvert(ctx, new BigDecimal(M), RoundingMode.HALF_UP);
                    double XSNum = billLength.divideAndRemainder(M1)[1].doubleValue();
                    if (minAmtMtd == 1) {
                        billLength = BigDecimal.valueOf(((double)ZNum + Math.floor(XSNum / M)) * M);
                    } else if (minAmtMtd == 2) {
                        billLength = BigDecimal.valueOf(((double)ZNum + Math.ceil(XSNum / M)) * M);
                    } else if (minAmtMtd == 3) {
                        billLength = BigDecimal.valueOf((double)((long)ZNum + Math.round(XSNum / M)) * M);
                    }
                    billLength = BigDecimal.valueOf(Math.floor(billLength.doubleValue() / M) * M).setScale(scale, roundingMode);
                } else {
                    Integer decimalPlaces = (Integer)param.get("decimalPlaces");
                    billLength = null != decimalPlaces && decimalPlaces >= 0 ? billLength.setScale((int)decimalPlaces, roundingMode) : this.precisionConvert(ctx, billLength, roundingMode);
                }
            }
        }
        catch (Exception e) {
            billLength = this.precisionConvert(ctx, billLength, RoundingMode.HALF_UP);
            e.printStackTrace();
        }
        return billLength;
    }
}

