/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.OverTimeCreateTag;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AtsOverTimeBillEntryDataFunc {
    public Object getCurrentOverTimeEntryData(Map paramMap) throws ParseException, BOSException, SQLException {
        Context ctx = Tools.getInstance().getCtx();
        String personId = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID");
        String currDateStr = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE");
        return this.getOverTimeEntryData(ctx, personId, currDateStr, currDateStr);
    }

    public Object getOverTimeEntryData(Context ctx, String personIds, String strBeginDate, String strEndDate) throws BOSException, SQLException {
        Object[] params;
        Timestamp beginDate = AtsDateUtils.stringToTimestamp(strBeginDate + " 00:00:00");
        Timestamp endDate = AtsDateUtils.stringToTimestamp(strEndDate + " 23:59:59");
        HashMap resultMap = new HashMap();
        if (StringUtils.isEmpty((CharSequence)personIds)) {
            return resultMap;
        }
        String personsWhere = "(";
        for (String personId : personIds.split(",")) {
            personsWhere = personsWhere + "'" + personId + "',";
        }
        personsWhere = personsWhere + "'')";
        String mlFlag = MLUtile.getMlFlag(ctx);
        String sql = "select bill.fnumber as bill_number,bill.fapplyDate,entry.fbillId,entry.fotDate,entry.FStartTime,entry.FEndTime,entry.FApplyOTTime,entry.FRestTime,entry.FRealOTTime,entry.FRealStartTime,entry.FRealEndTime,entry.FDescription,entry.fpersonid,holidaylimit.fid as holidaylimit_id,holidaylimit.fname" + mlFlag + " as holidaylimit_name ,holidaylimit.fnumber as holidaylimit_number,otType.fid as otType_id,otType.fname" + mlFlag + " as otType_name,otType.fnumber as otType_number,otReason.fid as otReason_id,otReason.fname" + mlFlag + " as otReason_name ,otReason.fnumber as otReason_number,otCompens.fid as otCompens_id,otCompens.fname" + mlFlag + " as otCompens_name,otCompens.fnumber as otCompens_number,FCalculateState,FCreateTag from t_hr_ats_overTimeBill bill  inner join t_hr_ats_overTimebillentry entry on bill.fid = entry.fbillid left join T_HR_ATS_HolidayLimit holidaylimit on entry.FHolidayLimit = holidaylimit.fid left join T_HR_ATS_OverTimeType otType  on entry.FOTTypeID = otType.fid left join T_HR_ATS_OverTimeReason otReason on entry.fotReasonId = otReason.fid left join T_HR_ATS_OverTimeCompens otCompens on entry.fotCompensid = otCompens.fid where entry.fpersonId in" + personsWhere + " and bill.fbillState = ? and entry.fotDate between ? and ?";
        IRowSet iRow = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])(params = new Object[]{3, beginDate, endDate}));
        if (iRow != null) {
            while (iRow.next()) {
                HashSet<HashMap<String, Object>> set;
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                String dateKey = AtsDateUtils.dateLongToString(iRow.getDate("fotDate"));
                String personId = iRow.getString("fpersonid");
                tempMap.put("applyDate", AtsDateUtils.dateShortToString(iRow.getDate("fapplyDate")));
                tempMap.put("billId", iRow.getString("fbillId"));
                tempMap.put("billId.number", iRow.getString("bill_number"));
                tempMap.put("otDate", dateKey);
                tempMap.put("startTime", AtsDateUtils.timestampToString(iRow.getTimestamp("FStartTime")));
                tempMap.put("endTime", AtsDateUtils.timestampToString(iRow.getTimestamp("fendTime")));
                BigDecimal applyOTTime = iRow.getBigDecimal("frealOTTime");
                tempMap.put("applyOTTime", applyOTTime == null ? "" : Double.valueOf(applyOTTime.doubleValue()));
                tempMap.put("restTime", iRow.getInt("FRestTime"));
                BigDecimal realOTTime = iRow.getBigDecimal("frealOTTime");
                tempMap.put("realOTTime", realOTTime == null ? "" : Double.valueOf(realOTTime.doubleValue()));
                tempMap.put("realStartTime", AtsDateUtils.timestampToString(iRow.getTimestamp("frealStartTime")));
                tempMap.put("realEndTime", AtsDateUtils.timestampToString(iRow.getTimestamp("frealEndTime")));
                tempMap.put("description", iRow.getString("FDescription"));
                tempMap.put("holidaylimit.id", iRow.getString("holidaylimit_id"));
                tempMap.put("holidaylimit.name", iRow.getString("holidaylimit_name"));
                tempMap.put("holidaylimit.number", iRow.getString("holidaylimit_number"));
                tempMap.put("otType.id", iRow.getString("otType_id"));
                tempMap.put("otType.name", iRow.getString("otType_name"));
                tempMap.put("otType.number", iRow.getString("otType_number"));
                tempMap.put("otReason.id", iRow.getString("otReason_id"));
                tempMap.put("otReason.name", iRow.getString("otReason_name"));
                tempMap.put("otReason.number", iRow.getString("otReason_number"));
                tempMap.put("otCompens.id", iRow.getString("otCompens_id"));
                tempMap.put("otCompens.name", iRow.getString("otCompens_name"));
                tempMap.put("otCompens.number", iRow.getString("otCompens_number"));
                tempMap.put("calculateState", iRow.getInt("FCalculateState"));
                OverTimeCreateTag createTag = OverTimeCreateTag.getEnum(iRow.getInt("FCalculateState"));
                tempMap.put("createTag.value", createTag == null ? "" : Integer.valueOf(createTag.getValue()));
                tempMap.put("createTag.alias", createTag == null ? "" : createTag.getAlias());
                HashMap dataMap = (HashMap)resultMap.get(personId);
                if (dataMap != null) {
                    if (dataMap.containsKey(dateKey)) {
                        ((HashSet)dataMap.get(dateKey)).add(tempMap);
                        continue;
                    }
                    set = new HashSet<HashMap<String, Object>>();
                    set.add(tempMap);
                    dataMap.put(dateKey, set);
                    continue;
                }
                dataMap = new HashMap();
                set = new HashSet();
                set.add(tempMap);
                dataMap.put(dateKey, set);
                resultMap.put(personId, dataMap);
            }
        }
        return resultMap;
    }
}

