/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.function;

import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;

public class OTCalculate
implements Serializable {
    private static final long serialVersionUID = -127573948569935430L;

    public double calculateFixOverTime(String onScheduleTime, String offScheduleTime, String onTimeDynamicResult, String offTimeDynamicResult, BigDecimal segmentInRest, AttencePolicyInfo attencePolicyInfo, int decimalPlace) {
        int oTStart = attencePolicyInfo.getOtStart();
        AtsOverTimeBillEntryInfo entryInfo = null;
        Timestamp startDate = AtsDateUtils.stringToTimestamp(onScheduleTime);
        Timestamp endDate = AtsDateUtils.stringToTimestamp(offScheduleTime);
        double oTValue = 0.0;
        if (StringUtils.isNotBlank((String)onTimeDynamicResult) && StringUtils.isNotBlank((String)offTimeDynamicResult)) {
            entryInfo = new AtsOverTimeBillEntryInfo();
            Timestamp onTimeCardTamp = AtsDateUtils.stringToTimestamp(onTimeDynamicResult);
            Timestamp offTimeCardTamp = AtsDateUtils.stringToTimestamp(offTimeDynamicResult);
            Timestamp realStartDate = null;
            Timestamp realEndDate = null;
            realStartDate = this.getBiggerTimestamp(startDate, onTimeCardTamp);
            realEndDate = this.getSamllerTimestamp(endDate, offTimeCardTamp);
            if (realStartDate != null && realEndDate != null) {
                oTValue = AtsDateUtils.getTwoTimeDiffMinutes(realStartDate, realEndDate);
                if ((oTValue -= segmentInRest.doubleValue()) < 0.0 || oTValue < (double)oTStart) {
                    oTValue = 0.0;
                }
                oTValue = AtsDateUtils.divide(oTValue, 60.0, decimalPlace);
            }
            entryInfo.setStartTime(startDate);
            entryInfo.setEndTime(endDate);
            entryInfo.setRealStartTime(realStartDate);
            entryInfo.setRealEndTime(realEndDate);
            entryInfo.setRealOTTime(BigDecimal.valueOf(oTValue));
            entryInfo.setRestTime(segmentInRest.intValue());
            entryInfo.setApplyOTTime(BigDecimal.valueOf(oTValue));
        }
        return oTValue;
    }

    public double getPreAndAftOTBillLength(String startTime, String endTime, AttencePolicyInfo attencePolicyInfo, int decimalPlace) {
        int oTStart = attencePolicyInfo.getOtStart();
        if (StringUtils.isNotBlank((String)startTime) && StringUtils.isNotBlank((String)endTime)) {
            Timestamp endTimestamp;
            Timestamp startTimestamp = AtsDateUtils.stringToTimestamp(startTime);
            double oTValue = AtsDateUtils.getTwoTimeDiffMinutes(startTimestamp, endTimestamp = AtsDateUtils.stringToTimestamp(endTime));
            if (oTValue < 0.0 || oTValue < (double)oTStart) {
                oTValue = 0.0;
            }
            oTValue = AtsDateUtils.divide(oTValue, 60.0, decimalPlace);
            return oTValue;
        }
        return 0.0;
    }

    public Timestamp getBiggerTimestamp(Timestamp time1, Timestamp time2) {
        Timestamp time = null;
        if (null != time1 && null != time2) {
            time = time1.getTime() > time2.getTime() ? time1 : time2;
        }
        return time;
    }

    public Timestamp getSamllerTimestamp(Timestamp time1, Timestamp time2) {
        Timestamp time = null;
        if (null != time1 && null != time2) {
            time = time1.getTime() > time2.getTime() ? time2 : time1;
        }
        return time;
    }
}

