/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.HolidayLimitBillTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitChangeType;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.app.AtsLeaveBillControllerBean;
import com.kingdee.eas.hr.ats.holidayLimit.IBaseOperateHolidayLimit;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public abstract class AbstractBaseRockBackLimit
implements IBaseOperateHolidayLimit {
    private AtsLeaveBillInfo atsLeaveBillInfo;

    public AtsLeaveBillInfo getAtsLeaveBillInfo() {
        return this.atsLeaveBillInfo;
    }

    public void setAtsLeaveBillInfo(AtsLeaveBillInfo atsLeaveBillInfo) {
        this.atsLeaveBillInfo = atsLeaveBillInfo;
    }

    public AbstractBaseRockBackLimit(Context ctx, String billId) throws EASBizException, BOSException {
        String sql = "where id ='" + billId + "'";
        this.atsLeaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(sql);
    }

    public AbstractBaseRockBackLimit(Context ctx, AtsLeaveBillInfo leaveBillInfo) throws EASBizException, BOSException {
        this.atsLeaveBillInfo = leaveBillInfo;
    }

    @Override
    public void operateHolidayLimitProcess(Context ctx) throws BOSException, EASBizException {
        this.beforeRockBackLimit(ctx, this.atsLeaveBillInfo, null);
        this.baseRockBackLimit(ctx, this.atsLeaveBillInfo);
        this.afterRockBackLimit(ctx, this.atsLeaveBillInfo);
    }

    public abstract void baseRockBackLimit(Context var1, AtsLeaveBillInfo var2) throws BOSException, EASBizException;

    public void afterRockBackLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo) throws BOSException {
        String billId = atsLeaveBillInfo.getId().toString();
        this.deleteAtsLeaveBillDetail(ctx, billId);
    }

    private void deleteAtsLeaveBillDetail(Context ctx, String leaveBillId) {
        String sql = "delete  from T_HR_ATS_LeaveBillDetail  where  fleavebillid ='" + leaveBillId + "'";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void beforeRockBackLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo, HRBillStateEnum hRBillStateEnum) throws BOSException {
    }

    public HolidayLimitDetailInfo insertDataInfoToHolildayLimitDetail(Context ctx, Map<String, Object> mapBalance, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo billEntryInfo, HolidayLimitChangeType holidayLimitChangeType) {
        HolidayLimitDetailInfo detailInfo = new HolidayLimitDetailInfo();
        String personId = (String)mapBalance.get("personId");
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx, personId);
        detailInfo.setProposer(personPositionInfo.getPerson());
        detailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
        detailInfo.setPosition(personPositionInfo.getPrimaryPosition());
        HROrgUnitInfo hrInfo = null;
        hrInfo = personPositionInfo.getHrOrgUnit();
        detailInfo.setHrOrgUnit(hrInfo);
        Calendar cal = Calendar.getInstance();
        detailInfo.setYear(cal.get(1));
        detailInfo.setChangeDate(AtsDateUtils.dateToTimestamp(new Date()));
        detailInfo.setCreateTime(AtsDateUtils.dateToTimestamp(new Date()));
        detailInfo.setChangeType(holidayLimitChangeType);
        detailInfo.setBillType(HolidayLimitBillTypeEnum.leaveBill);
        detailInfo.setLeaveBill(billInfo);
        detailInfo.setLeaveBillNumber(billInfo.getNumber());
        detailInfo.setLeaveBillEntry(billEntryInfo);
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        if (holidayLimitId != null) {
            HolidayLimitInfo holidayLimitInfo = new HolidayLimitInfo();
            holidayLimitInfo.setId(BOSUuid.read((String)holidayLimitId));
            detailInfo.setHolidayLimit(holidayLimitInfo);
        }
        detailInfo.setChangeValue((BigDecimal)mapBalance.get("changeValue"));
        detailInfo.setChangeUnit((HolidayTypeUnitEnum)((Object)mapBalance.get("holidayPolicyUnit")));
        try {
            if (billInfo.getId() == null) {
                AtsLeaveBillControllerBean AtsLeaveBillControllerBean2 = new AtsLeaveBillControllerBean();
                AtsLeaveBillControllerBean2.save(ctx, (CoreBaseInfo)billInfo);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return detailInfo;
    }
}

