/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.HolidayLimitDetailCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailFactory;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.dataLog.control.LogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.factory.DataLogControlFactory;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.holidayLimit.CoreBaseRockBackLimit;
import com.kingdee.eas.hr.ats.result.AttendCalculateJob;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AtsLeaveBillRockBackLimit
extends CoreBaseRockBackLimit {
    public AtsLeaveBillRockBackLimit(Context ctx, String billId, int changeType) throws EASBizException, BOSException {
        super(ctx, billId, changeType);
    }

    @Override
    public void beforeRockBackLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo, HRBillStateEnum hRBillStateEnum) throws BOSException {
        super.beforeRockBackLimit(ctx, atsLeaveBillInfo, HRBillStateEnum.SAVED);
    }

    @Override
    public void afterRockBackLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo) throws BOSException {
        this.updateAtsLeaveBillState(ctx, atsLeaveBillInfo.getId().toString());
        if (4 == this.getChangeType()) {
            super.afterRockBackLimit(ctx, atsLeaveBillInfo);
            this.againstApproveBill(ctx, atsLeaveBillInfo.getId().toString());
            this.triggerAttendanceCal(ctx, atsLeaveBillInfo);
        }
    }

    public void triggerAttendanceCal(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo) {
        AttendCalculateJob attendCalculateJob = new AttendCalculateJob();
        try {
            String billNumber = atsLeaveBillInfo.getNumber();
            String Bill = atsLeaveBillInfo.getId().toString();
            attendCalculateJob.createLeaveBillTriggerAgainstAttendCalJob(ctx, null, null, Bill, null, billNumber);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    public void againstApproveBill(Context ctx, String billId) {
        try {
            String deleteSql = "delete from T_BAS_MultiApprove where fbillId = '" + billId + "'";
            DbUtil.execute((Context)ctx, (String)deleteSql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void updateAtsLeaveBillState(Context ctx, String billId) {
        try {
            String sql = "update  T_HR_ATS_LeaveBill   set fbillState = 0  where fid = '" + billId + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void rockBackLimit(Context ctx, AtsLeaveBillEntryInfo atsLeaveBillEntryInfo, Map<String, Object> parmMap) throws EASBizException, BOSException {
        this.doRockBackLimit(ctx, atsLeaveBillEntryInfo);
        this.afterRockBack(ctx, atsLeaveBillEntryInfo, parmMap);
    }

    public void doRockBackLimit(Context ctx, AtsLeaveBillEntryInfo atsLeaveBillEntryInfo) throws BOSException, EASBizException {
        CoreBaseCollection oldLimitColl = null;
        String billId = atsLeaveBillEntryInfo.getBill().getId().toString();
        String entryBillId = atsLeaveBillEntryInfo.getId().toString();
        String proposerId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        int changeType = this.getChangeType();
        HolidayLimitDetailCollection holidayLimitDetailCol = this.getHolidayLimitDetailCollectionByBillEntryId(ctx, billId, entryBillId, proposerId, changeType);
        List<HolidayLimitDetailInfo> limitDetailList = this.holidayLimitDetailColtoList(holidayLimitDetailCol);
        Map<String, HolidayLimitInfo> holidayLimitMap = this.getHolidaylimitInfoMap(ctx, holidayLimitDetailCol);
        CoreBaseCollection limitCol = new CoreBaseCollection();
        HashSet<String> holidayLimitInfoSet = new HashSet<String>();
        HashSet<String> holidayLimitDetailSet = new HashSet<String>();
        if (limitDetailList != null && !limitDetailList.isEmpty()) {
            oldLimitColl = this.RockBackDeductLimit(ctx, limitDetailList, holidayLimitMap, limitCol, holidayLimitInfoSet, holidayLimitDetailSet, changeType);
        }
        String policyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
        AtsLeaveBillInfo atsLeaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillCollection("where id = '" + atsLeaveBillEntryInfo.getBill().getId().toString() + "'").get(0);
        String hrOrgUnitId = atsLeaveBillInfo.getHrOrgUnit().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, policyId);
        if (!limitCol.isEmpty()) {
            limitCol.sort("cyclebegindate");
            limitCol.sort("delaydate");
            this.RockBackOverDraftLimit(ctx, limitCol, holidayLimitInfoSet, holidayPolicyInfo, proposerId, billId, entryBillId, changeType, hrOrgUnitId);
        }
        if (!limitCol.isEmpty()) {
            HolidayLimitFactory.getLocalInstance(ctx).update(limitCol);
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
            DataLogUtil.addLogObserverToCenter(ctx, atsLeaveBillInfo, atsLeaveBillEntryInfo, logControlCenter, oldLimitColl, false);
            DataLogUtil.addLogObserverToCenter(ctx, atsLeaveBillInfo, atsLeaveBillEntryInfo, logControlCenter, limitCol, true);
        }
        if (!holidayLimitDetailSet.isEmpty()) {
            String hql = "where id in (" + AtsUtil.convertSetToString(holidayLimitDetailSet) + ")";
            HolidayLimitDetailFactory.getLocalInstance(ctx).delete(hql);
        }
    }

    public List<HolidayLimitDetailInfo> holidayLimitDetailColtoList(HolidayLimitDetailCollection holidayLimitDetailCol) {
        ArrayList<HolidayLimitDetailInfo> limitDetailList = new ArrayList<HolidayLimitDetailInfo>();
        if (holidayLimitDetailCol != null) {
            int size = holidayLimitDetailCol.size();
            for (int i = 0; i < size; ++i) {
                limitDetailList.add(holidayLimitDetailCol.get(i));
            }
        }
        return limitDetailList;
    }

    public HolidayLimitDetailCollection getHolidayLimitDetailCollectionByBillEntryId(Context ctx, String billId, String entryBillId, String proposerId, int changeType) throws BOSException {
        String oql = "where LeaveBillEntry = '" + entryBillId + "' and changeType = " + changeType + " and proposer ='" + proposerId + "'";
        HolidayLimitDetailCollection holidayLimitDetailCol = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(oql);
        return holidayLimitDetailCol;
    }

    public void afterRockBack(Context ctx, AtsLeaveBillEntryInfo atsLeaveBillEntryInfo, Map<String, Object> parmMap) throws EASBizException, BOSException {
        String oldLeaveLength = atsLeaveBillEntryInfo.getLeaveLength().doubleValue() + "";
        String leaveBillEntryId = atsLeaveBillEntryInfo.getId().toString();
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        String person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId)).getName();
        String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
        HolidayPolicyInfo policyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
        String holidayType = policyInfo.getName();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String now = sdf.format(new Date());
        double nowLeaveLength = (Double)parmMap.get("realLen");
        BigDecimal leaveLength = BigDecimal.valueOf(nowLeaveLength);
        atsLeaveBillEntryInfo.setLeaveLength(leaveLength);
        atsLeaveBillEntryInfo.setRealLeaveLength(leaveLength);
        atsLeaveBillEntryInfo.setRealUnit(policyInfo.getUnit());
        atsLeaveBillEntryInfo.setReasonForRecalculate(this.getReasonForRecalculate(ctx, atsLeaveBillEntryInfo.getReasonForRecalculate()));
        AtsLeaveBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(leaveBillEntryId), atsLeaveBillEntryInfo);
        String billInfoId = atsLeaveBillEntryInfo.getBill().getId().toString();
        AtsLeaveBillInfo billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(billInfoId));
    }

    private String getEntryReason(AtsLeaveBillEntryInfo atsLeaveBillEntryInfo, String oldLeaveLength, double nowLeaveLength, String person, String holidayType, String now) {
        String reason = atsLeaveBillEntryInfo.getReason() == null ? "" : atsLeaveBillEntryInfo.getReason();
        String result = reason + "//" + now + "\u7531\u4e8e\u6392\u73ed\u4fee\u6539\uff0c" + person + "[" + holidayType + "]\u8bf7\u5047\u91cd\u7b97\uff0c\u8bf7\u5047\u65f6\u957f\u7531" + oldLeaveLength + "\u53d8\u66f4\u4e3a" + nowLeaveLength + "\u3002";
        return result.length() <= 200 ? result : reason;
    }

    private String getReasonForRecalculate(Context ctx, String preReasonForRecalculate) {
        String res;
        if (null == preReasonForRecalculate) {
            preReasonForRecalculate = "";
        }
        return (res = MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.ModifyShift, ctx, AtsDateUtils.dateLongToString(new Date())) + ";" + preReasonForRecalculate).length() > 200 ? res.substring(0, res.substring(0, res.length() - 1).indexOf(";") + 1) : res;
    }
}

