/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.CancelHolidayLimit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.holidayLimit.CancelHolidayLimit.CoreCancelBillOperateLimit;
import com.kingdee.eas.hr.ats.holidayLimit.CancelHolidayLimit.util.CelLeaveBillEditHolidayTypeUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class CancelBillOperateLimitEntrance {
    public static void operateLimitAndLeaveBill(Context ctx, CancelLeaveBillInfo cancelLeaveBillInfo, int changeType) {
        boolean flag = CancelBillOperateLimitEntrance.isEditHolidayType(ctx, cancelLeaveBillInfo);
        if (flag) {
            CoreCancelBillOperateLimit.CancelEditHolidayTypeDeductHolidayLimit(ctx, cancelLeaveBillInfo, changeType);
        }
    }

    public static void approvalNotLimitAndLeaveBill(Context ctx, CancelLeaveBillInfo cancelLeaveBillInfo, int changeType) {
        boolean flag = CancelBillOperateLimitEntrance.isApprovalEditHolidayType(ctx, cancelLeaveBillInfo);
        if (flag) {
            CoreCancelBillOperateLimit.antiApprovalDeductHolidayLimit(ctx, cancelLeaveBillInfo, changeType);
        }
    }

    public static CancelLeaveBillInfo setBillNumAndUpBillId(Context ctx, CancelLeaveBillInfo cancelLeaveBillInfo) {
        CancelLeaveBillEntryCollection collection = null;
        IRowSet rowSet = null;
        try {
            collection = cancelLeaveBillInfo.getEntries();
            if (null != collection && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    CancelLeaveBillEntryInfo info = collection.get(i);
                    String leaveEntryId = info.getLeaveEntryBill().getId().toString();
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT entry.FID as FID, entry.FUPCANCELBILLID as FUPCANCELBILLID ,entry.FSORFNUM as FSORFNUM FROM T_HR_ATS_CANLEAVEBILLENTRY entry,T_HR_ATS_CANLEAVEBILL bill where entry.FBillId = bill.FID and bill.FbillState=3 and FLEAVEENTRYBILLID ='").append(leaveEntryId).append("' and FSORFNUM =(SELECT max(FSORFNUM) FROM T_HR_ATS_CANLEAVEBILLENTRY where FLEAVEENTRYBILLID ='").append(leaveEntryId).append("' )");
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    if (null != rowSet && rowSet.size() > 0) {
                        rowSet.next();
                        int sorfNum = rowSet.getInt("FSORFNUM");
                        String id = rowSet.getString("FID");
                        info.setSorfNum(sorfNum + 1);
                        info.setUpCancelBillId(id);
                        continue;
                    }
                    info.setSorfNum(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cancelLeaveBillInfo;
    }

    public static IRowSet getUpCancelLeaveBillInfo(Context ctx, String leaveEntryId, int sorfNum) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT entry.FID as FID, entry.FUPCANCELBILLID as FUPCANCELBILLID ,entry.FSORFNUM as FSORFNUM,entry.FACTHOLIDAYTYPE as FACTHOLIDAYTYPE,entry.FREALLEALENGTH as FREALLEALENGTH,entry.FREALLEABEGINTIME as FREALLEABEGINTIME,entry.FREALLEAENDTIME as FREALLEAENDTIME FROM T_HR_ATS_CANLEAVEBILLENTRY entry,T_HR_ATS_CANLEAVEBILL bill where entry.FBillId = bill.FID and bill.FbillState=3 and FLEAVEENTRYBILLID ='").append(leaveEntryId);
        if (sorfNum == 0) {
            sql.append("' and FSORFNUM =(SELECT max(FSORFNUM) FROM T_HR_ATS_CANLEAVEBILLENTRY where FLEAVEENTRYBILLID ='").append(leaveEntryId);
            sql.append("' )");
        } else {
            sql.append("' and FSORFNUM = ").append(sorfNum - 1);
        }
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (null != rowSet && rowSet.size() > 1) {
                return rowSet;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getActHolidayType(Context ctx, CancelLeaveBillEntryInfo cancelLeaveBillEntryInfo) {
        String leaveEntryId = cancelLeaveBillEntryInfo.getLeaveEntryBill().getId().toString();
        String holidayType = "";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT entry.FACTHOLIDAYTYPE as FACTHOLIDAYTYPE FROM T_HR_ATS_CANLEAVEBILLENTRY entry,T_HR_ATS_CANLEAVEBILL bill where entry.FBillId = bill.FID and bill.FbillState=3 and FLEAVEENTRYBILLID ='").append(leaveEntryId);
        sql.append("' and FSORFNUM =(SELECT max(FSORFNUM) FROM T_HR_ATS_CANLEAVEBILLENTRY where FLEAVEENTRYBILLID ='").append(leaveEntryId);
        sql.append("' )");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (null != rowSet && rowSet.size() > 0) {
                holidayType = rowSet.getString("FACTHOLIDAYTYPE");
            } else {
                AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leaveEntryId));
                String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
                HolidayPolicyInfo oriHolidayPolicyInfo = AtsWebUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
                holidayType = oriHolidayPolicyInfo.getHolidayType().getId().toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return holidayType;
    }

    public static boolean isApprovalEditHolidayType(Context ctx, CancelLeaveBillInfo cancelLeaveBillInfo) {
        CancelLeaveBillEntryInfo cancelLeaveBillEntryInfo = null;
        boolean flag = false;
        try {
            IRowSet rowSet;
            cancelLeaveBillEntryInfo = cancelLeaveBillInfo.getEntries().get(0);
            int sorfNum = cancelLeaveBillEntryInfo.getSorfNum();
            String atcHolidayType = cancelLeaveBillEntryInfo.getActHolidayType() == null ? "" : cancelLeaveBillEntryInfo.getActHolidayType();
            String leaveBillEntryId = cancelLeaveBillEntryInfo.getLeaveEntryBill().getId().toString();
            if (sorfNum == 1) {
                String sourceHolidayType;
                AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leaveBillEntryId));
                String string = sourceHolidayType = atsLeaveBillEntryInfo.getSourceHolidayType() == null ? "" : atsLeaveBillEntryInfo.getSourceHolidayType().getId().toString();
                if (!(atcHolidayType.isEmpty() || sourceHolidayType.isEmpty() || atcHolidayType.equals(sourceHolidayType))) {
                    flag = true;
                }
            } else if (sorfNum > 1 && null != (rowSet = CancelBillOperateLimitEntrance.getUpCancelLeaveBillInfo(ctx, leaveBillEntryId, sorfNum)) && rowSet.size() > 0) {
                String upHolidayType;
                String string = upHolidayType = rowSet.getString("FACTHOLIDAYTYPE") == null ? "" : rowSet.getString("FACTHOLIDAYTYPE");
                if (upHolidayType.isEmpty()) {
                    flag = true;
                } else if (!upHolidayType.equals(atcHolidayType)) {
                    flag = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean isEditHolidayType(Context ctx, CancelLeaveBillInfo cancelLeaveBillInfo) {
        boolean flag = false;
        CancelLeaveBillEntryInfo cancelLeaveBillEntryInfo = null;
        try {
            CancelLeaveBillEntryCollection cancelLeaveBillEntryCollection = cancelLeaveBillInfo.getEntries();
            cancelLeaveBillEntryInfo = cancelLeaveBillEntryCollection.get(0);
            if (cancelLeaveBillEntryInfo.getActHolidayType() == null && cancelLeaveBillEntryInfo.get("actHolidayTypef7") == null) {
                String cancelBillId = cancelLeaveBillEntryInfo.getId().toString();
                CancelLeaveBillEntryInfo entryInfo = CancelLeaveBillEntryFactory.getLocalInstance(ctx).getCancelLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(cancelBillId));
                cancelLeaveBillEntryInfo.setActHolidayType(entryInfo.getActHolidayType());
                cancelLeaveBillEntryInfo.setLeaveEntryBill(entryInfo.getLeaveEntryBill());
            }
            String editHolidayId = cancelLeaveBillEntryInfo.get("actHolidayTypef7") == null ? cancelLeaveBillEntryInfo.getActHolidayType() : (String)cancelLeaveBillEntryInfo.get("actHolidayTypef7");
            IRowSet rowSet = CancelBillOperateLimitEntrance.getUpCancelLeaveBillInfo(ctx, cancelLeaveBillEntryInfo.getLeaveEntryBill().getId().toString(), 0);
            if (!editHolidayId.isEmpty()) {
                if (null != rowSet && rowSet.size() > 0) {
                    String upHolidayType;
                    rowSet.next();
                    String string = upHolidayType = rowSet.getString("FACTHOLIDAYTYPE") == null ? "" : rowSet.getString("FACTHOLIDAYTYPE");
                    if (upHolidayType.isEmpty()) {
                        flag = true;
                    } else if (!upHolidayType.equals(editHolidayId)) {
                        flag = true;
                    }
                } else {
                    String leavebillEntryId = cancelLeaveBillEntryInfo.getLeaveEntryBill().getId().toString();
                    AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leavebillEntryId));
                    String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
                    HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo((IObjectPK)new ObjectUuidPK(holidayPolicyId));
                    String holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
                    if (!holidayTypeId.equals(editHolidayId)) {
                        flag = true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static AtsLeaveBillInfo setBillSourceUnitRequest(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo) {
        AtsLeaveBillEntryCollection atsLeaveBillEntryController = atsLeaveBillInfo.getEntries();
        for (int i = 0; i < atsLeaveBillEntryController.size(); ++i) {
            AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = atsLeaveBillEntryController.get(i);
            String leaveEntryId = atsLeaveBillEntryInfo.getId() == null ? "" : atsLeaveBillEntryInfo.getId().toString();
            try {
                if (!leaveEntryId.isEmpty()) {
                    atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leaveEntryId));
                }
                String policyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
                HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo((IObjectPK)new ObjectUuidPK(policyId));
                atsLeaveBillEntryInfo.setSourceUnit(holidayPolicyInfo.getUnit());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return atsLeaveBillInfo;
    }

    public static CancelLeaveBillInfo getUpCancelLeaveBillInfo(Context ctx, CancelLeaveBillInfo cancelLeaveBillInfo) {
        CancelLeaveBillEntryInfo cancelLeaveBillEntryInfo = null;
        try {
            String upHolidayType;
            IRowSet rowSet;
            cancelLeaveBillEntryInfo = cancelLeaveBillInfo.getEntries().get(0);
            int sorfNum = cancelLeaveBillEntryInfo.getSorfNum();
            String leaveBillEntryId = cancelLeaveBillEntryInfo.getLeaveEntryBill().getId().toString();
            AtsLeaveBillEntryInfo leaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leaveBillEntryId));
            String personId = leaveBillEntryInfo.getPerson().getId().toString();
            String leaveBeginTime = HRTimeWebUtils.dateShortToString(leaveBillEntryInfo.getBeginTime());
            String leaveEndTime = HRTimeWebUtils.dateShortToString(leaveBillEntryInfo.getEndTime());
            String errorString = "";
            Map<Object, Object> upRes = new HashMap();
            BigDecimal length = cancelLeaveBillEntryInfo.getRealLeaLength();
            if (sorfNum == 1) {
                AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leaveBillEntryId));
                String sourceHolidayType = atsLeaveBillEntryInfo.getSourceHolidayType() == null ? "" : atsLeaveBillEntryInfo.getSourceHolidayType().getId().toString();
                upRes = CelLeaveBillEditHolidayTypeUtil.getHolidayPolicyInfo(ctx, personId, sourceHolidayType, leaveBeginTime, leaveEndTime);
                errorString = (String)upRes.get("errorString");
                if (errorString.isEmpty()) {
                    HolidayPolicyInfo upHolidayPolicyInfo = (HolidayPolicyInfo)upRes.get("holidayPolicyInfo");
                    HolidayPolicyInfo orHolidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo((IObjectPK)new ObjectUuidPK(atsLeaveBillEntryInfo.getPolicy().getId().toString()));
                    cancelLeaveBillInfo = CancelBillOperateLimitEntrance.setRealLength(ctx, personId, orHolidayPolicyInfo, upHolidayPolicyInfo, length, cancelLeaveBillInfo);
                }
            } else if (sorfNum > 1 && null != (rowSet = CancelBillOperateLimitEntrance.getUpCancelLeaveBillInfo(ctx, leaveBillEntryId, sorfNum)) && rowSet.size() > 0 && (errorString = (String)(upRes = CelLeaveBillEditHolidayTypeUtil.getHolidayPolicyInfo(ctx, personId, upHolidayType = rowSet.getString("FACTHOLIDAYTYPE") == null ? "" : rowSet.getString("FACTHOLIDAYTYPE"), leaveBeginTime, leaveEndTime)).get("errorString")).isEmpty()) {
                HolidayPolicyInfo upHolidayPolicyInfo = (HolidayPolicyInfo)upRes.get("holidayPolicyInfo");
                Map<Object, Object> orRes = new HashMap();
                orRes = CelLeaveBillEditHolidayTypeUtil.getHolidayPolicyInfo(ctx, personId, cancelLeaveBillEntryInfo.getActHolidayType(), leaveBeginTime, leaveEndTime);
                cancelLeaveBillInfo = CancelBillOperateLimitEntrance.setRealLength(ctx, personId, (HolidayPolicyInfo)orRes.get("holidayPolicyInfo"), upHolidayPolicyInfo, length, cancelLeaveBillInfo);
                cancelLeaveBillEntryInfo.setActHolidayType(upHolidayType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cancelLeaveBillInfo;
    }

    public static CancelLeaveBillInfo getUpLeaveBillEntryInfo(Context ctx, CancelLeaveBillInfo cancelLeaveBillInfo) {
        CancelLeaveBillEntryInfo cancelLeaveBillEntryInfo = null;
        try {
            cancelLeaveBillEntryInfo = cancelLeaveBillInfo.getEntries().get(0);
            int sorfNum = cancelLeaveBillEntryInfo.getSorfNum();
            String leaveBillEntryId = cancelLeaveBillEntryInfo.getLeaveEntryBill().getId().toString();
            if (sorfNum == 1) {
                AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leaveBillEntryId));
                atsLeaveBillEntryInfo.setRealBeginTime(atsLeaveBillEntryInfo.getBeginTime());
                atsLeaveBillEntryInfo.setRealEndTime(atsLeaveBillEntryInfo.getEndTime());
                cancelLeaveBillEntryInfo.setLeaveEntryBill(atsLeaveBillEntryInfo);
            } else if (sorfNum > 1) {
                IRowSet rowSet = CancelBillOperateLimitEntrance.getUpCancelLeaveBillInfo(ctx, leaveBillEntryId, sorfNum);
                AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leaveBillEntryId));
                if (null != rowSet && rowSet.size() > 0) {
                    atsLeaveBillEntryInfo.setRealBeginTime(rowSet.getTimestamp("FREALLEABEGINTIME"));
                    atsLeaveBillEntryInfo.setRealEndTime(rowSet.getTimestamp("FREALLEAENDTIME"));
                    cancelLeaveBillEntryInfo.setLeaveEntryBill(atsLeaveBillEntryInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cancelLeaveBillInfo;
    }

    public static CancelLeaveBillInfo setRealLength(Context ctx, String personId, HolidayPolicyInfo orHolidayPolicyInfo, HolidayPolicyInfo holidayPolicyInfo, BigDecimal length, CancelLeaveBillInfo cancelLeaveBillInfo) {
        if (orHolidayPolicyInfo.getUnit() != holidayPolicyInfo.getUnit()) {
            CancelLeaveBillEntryInfo cancelLeaveBillEntryInfo = cancelLeaveBillInfo.getEntries().get(0);
            try {
                AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(cancelLeaveBillEntryInfo.getLeaveEntryBill().getId().toString()));
                BigDecimal standradHour = CoreCancelBillOperateLimit.getStandardHour(ctx, personId, atsLeaveBillEntryInfo, holidayPolicyInfo);
                if (orHolidayPolicyInfo.getUnit() == HolidayTypeUnitEnum.day) {
                    cancelLeaveBillEntryInfo.setRealLeaLength(standradHour.multiply(length));
                } else {
                    cancelLeaveBillEntryInfo.setRealLeaLength(length.divide(standradHour, 4, 4));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cancelLeaveBillInfo;
    }
}

