/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.generate.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAttenceCycleResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AttendanceLogEntryInfo;
import com.kingdee.eas.hr.ats.ChangeTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayLimitStatus;
import com.kingdee.eas.hr.ats.HolidayPeriodUniteEnum;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.HolidayRuleInfo;
import com.kingdee.eas.hr.ats.HolidayTypeInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.decimalPlace.DecimalPlaceContext;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationLimit;
import com.kingdee.eas.hr.ats.holidayLimit.generate.rule.GenHolidayLimitModel;
import com.kingdee.eas.hr.ats.holidayLimit.generate.rule.GenHolidayLimitRule;
import com.kingdee.eas.hr.ats.holidayLimit.generate.rule.impl.GenHolidayLimitRuleImpl;
import com.kingdee.eas.hr.ats.holidayLimit.generate.service.impl.ReCalHolidayLimitServiceImpl;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.AtsParentalLeaveUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.GenHolidayLimitUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.holidayLimit.generate.vo.NextGenerationInfo;
import com.kingdee.eas.hr.ats.lightapp.util.AtsLeaveBillLimit;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.DataSaver;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class GenHolidayLimitCommon {
    private Logger logger = Logger.getLogger(GenHolidayLimitCommon.class);
    protected Context ctx;
    protected Map<Object, Object> globalMap = new HashMap<Object, Object>();
    protected Map<Object, Object> param = new HashMap<Object, Object>();
    protected Map<String, AttendanceLogEntryInfo> logEntryMap = new ConcurrentHashMap<String, AttendanceLogEntryInfo>();
    protected GenHolidayLimitRule holidayLimitRule = null;
    protected IDecimalPlaceStrategy strategy = new DecimalPlaceOperationLimit();

    public void initData(Context ctx, Map<Object, Object> param, Map<Object, Object> globalMap) {
        this.ctx = ctx;
        this.param = param;
        this.globalMap = globalMap;
        this.holidayLimitRule = new GenHolidayLimitRuleImpl(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> generateHolidayLimit(Context ctx) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> resultMap = null;
        Boolean isTrial = this.param.get("isTrial") == null ? false : (Boolean)this.param.get("isTrial");
        try {
            Map<String, HolidayLimitInfo> oldLimitMap = this.cloneExistsLimitMap();
            resultMap = this.doGenHolidayLimit(ctx);
            if (!isTrial.booleanValue()) {
                Integer[] success = this.saveData(resultMap);
                if (resultMap != null) {
                    resultMap.put("oldHolidayLimitMap", oldLimitMap);
                    result.put("errorMsgList", resultMap.get("errorMsgList"));
                    result.put("UPDATECOUNT", success[0]);
                    result.put("INSERTCOUNT", success[1]);
                }
                this.reCalHolidayLimit(ctx, resultMap);
                this.recordLog(ctx, resultMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (isTrial.booleanValue() || null != this.param.get("bizChangeDate") || null != this.param.get("leftUndo")) {
                result.putAll(resultMap);
            }
            this.clearData();
        }
        return result;
    }

    public Map<String, Object> doGenHolidayLimit(Context ctx) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> failedList = new ArrayList<String>();
        HashMap<String, Object> resultLimitMap = new HashMap<String, Object>();
        Map personPositionMap = (Map)this.globalMap.get("personPositionMap");
        Map holidayTypeMap = (Map)this.globalMap.get("holidayTypeMap");
        Map personHoilTypeMap = (Map)this.param.get("PERSONHOLIDAYTYPES");
        Map personFamilyMap = (Map)this.globalMap.get("existedPersonFamilyMap");
        String cycleDate = StringUtils.cnulls((Object)this.param.get("cycleDate"));
        String personIds = String.valueOf(this.param.get("personIds"));
        String[] personIdArr = personIds.split(",");
        for (int i = 0; i < personIdArr.length; ++i) {
            String personId = personIdArr[i];
            this.logger.error((Object)MessageFormat.format("-------current personId={0}", personId));
            PersonPositionInfo personPositionInfo = (PersonPositionInfo)personPositionMap.get(personId);
            String personName = "";
            if (null != personPositionInfo && personPositionInfo.getId() != null) {
                personName = personPositionInfo.getPerson().getName();
            }
            try {
                String errorMsg = this.validData(personId, cycleDate);
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    failedList.add(errorMsg);
                    continue;
                }
                List hoildayTypes = (List)personHoilTypeMap.get(personId);
                if (hoildayTypes.isEmpty()) continue;
                for (int typej = 0; typej < hoildayTypes.size(); ++typej) {
                    String holidayTypeId = (String)hoildayTypes.get(typej);
                    HolidayTypeInfo holidayTypeInfo = (HolidayTypeInfo)holidayTypeMap.get(holidayTypeId);
                    if ("4F7rXAuSEFjgUzsFEqwuZ/0tUpg=".equals(holidayTypeId)) {
                        if (personFamilyMap == null || AtsCollectionUtile.isEmpty((Collection)personFamilyMap.get(personId))) continue;
                        List nextGenerationInfoList = (List)personFamilyMap.get(personId);
                        for (NextGenerationInfo nextGenerationInfo : nextGenerationInfoList) {
                            if (nextGenerationInfo == null || nextGenerationInfo.getBirthdayDate() == null || nextGenerationInfo.getId() == null) {
                                this.logger.error((Object)MessageFormat.format("data exception.personId={0},nextGenerationInfo={1}", personId, nextGenerationInfo));
                                continue;
                            }
                            if (this.isExistsHolidayLimit(holidayTypeInfo, cycleDate, personId, nextGenerationInfo) && null != this.param.get("GENTYPE") && this.param.get("GENTYPE").equals("GENTYPE_NEW")) continue;
                            errorMsg = this.validDetailData(holidayTypeInfo, personId, nextGenerationInfo);
                            if (!StringUtils.isEmpty((String)errorMsg)) {
                                failedList.add(errorMsg);
                                continue;
                            }
                            this.genHolidayLimitData(resultLimitMap, holidayTypeInfo, personId, failedList, nextGenerationInfo);
                        }
                        AtsParentalLeaveUtil.proPersonelDeleteChildBiz(ctx, personId, nextGenerationInfoList);
                        Map holidayRuleMap = (Map)this.globalMap.get("holidayRuleMap");
                        Map atsHolidayFileHisMap = (Map)this.globalMap.get("atsHolidayFileHisMap");
                        Map holidayPolicyMap = (Map)this.globalMap.get("holidayPolicyMap");
                        AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)atsHolidayFileHisMap.get(personId + "_" + cycleDate);
                        HolidayPolicyCollection holidayPolicyColl = (HolidayPolicyCollection)((Object)holidayPolicyMap.get(atsHolidayFileHisInfo.getHolidayPolicySet().getId().toString()));
                        HolidayPolicyInfo holidayPolicyInfo = GenHolidayLimitUtil.getHolidayPolicyByHolidayType(holidayPolicyColl, holidayTypeInfo.getId().toString());
                        HolidayRuleInfo holidayRuleInfo = (HolidayRuleInfo)holidayRuleMap.get(holidayPolicyInfo.getHolidayRule().getId().toString());
                        if (holidayRuleInfo.getDistributionRules().getValue() != 1 || !"4F7rXAuSEFjgUzsFEqwuZ/0tUpg=".equals(holidayPolicyInfo.getHolidayType().getId().toString())) continue;
                        AtsParentalLeaveUtil.childPersonIsAccumal(ctx, resultLimitMap, holidayRuleInfo, personId);
                        continue;
                    }
                    try {
                        if (this.isExistsHolidayLimit(holidayTypeInfo, cycleDate, personId) && null != this.param.get("GENTYPE") && this.param.get("GENTYPE").equals("GENTYPE_NEW")) continue;
                        errorMsg = this.validDetailData(holidayTypeInfo, personId, null);
                        if (!StringUtils.isEmpty((String)errorMsg)) {
                            failedList.add(errorMsg);
                            continue;
                        }
                        this.genHolidayLimitData(resultLimitMap, holidayTypeInfo, personId, failedList, null);
                        continue;
                    }
                    catch (Exception e) {
                        failedList.add(MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail23, ctx, personName, holidayTypeInfo.getName(), e.getMessage()));
                        e.printStackTrace();
                    }
                }
                continue;
            }
            catch (Exception e) {
                failedList.add(MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail24, ctx, personName, e.getMessage()));
                e.printStackTrace();
            }
        }
        resultMap.putAll(resultLimitMap);
        resultMap.put("errorMsgList", failedList);
        return resultMap;
    }

    public boolean isExistsHolidayLimit(HolidayTypeInfo holidayTypeInfo, String cycleDate, String personId) {
        return this.isExistsHolidayLimit(holidayTypeInfo, cycleDate, personId, null);
    }

    private boolean isExistsHolidayLimit(HolidayTypeInfo holidayTypeInfo, String cycleDate, String personId, NextGenerationInfo nextGenerationInfo) {
        Map existedHolidayLimitMap = (Map)this.globalMap.get("existedHolidayLimitMap");
        if (nextGenerationInfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nextGenerationInfo.getId())) {
            existedHolidayLimitMap = (Map)this.globalMap.get("existedParentalLeaveHolidayLimitMap");
        }
        Map atsHolidayFileHisMap = (Map)this.globalMap.get("atsHolidayFileHisMap");
        AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)atsHolidayFileHisMap.get(personId + "_" + cycleDate);
        HolidayLimitInfo hLimitInfo = (HolidayLimitInfo)existedHolidayLimitMap.get(personId + holidayTypeInfo.getId().toString() + atsHolidayFileHisInfo.getHrOrgUnit().getId().toString());
        if (nextGenerationInfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nextGenerationInfo.getId())) {
            hLimitInfo = (HolidayLimitInfo)existedHolidayLimitMap.get(personId + holidayTypeInfo.getId().toString() + atsHolidayFileHisInfo.getHrOrgUnit().getId().toString() + nextGenerationInfo.getId());
        }
        return null != hLimitInfo && hLimitInfo.getId() != null;
    }

    public String validData(String personId, String cycleDate) {
        Map personPositionMap = (Map)this.globalMap.get("personPositionMap");
        Map empLaborRelationMap = (Map)this.globalMap.get("empLaborRelationMap");
        Map atsHolidayFileHisMap = (Map)this.globalMap.get("atsHolidayFileHisMap");
        PersonPositionInfo personPositionInfo = (PersonPositionInfo)personPositionMap.get(personId);
        EmpLaborRelationInfo laborInfo = (EmpLaborRelationInfo)empLaborRelationMap.get(personId);
        AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)atsHolidayFileHisMap.get(personId + "_" + cycleDate);
        String personName = personPositionInfo.getPerson().getName().toString();
        if (atsHolidayFileHisInfo == null || atsHolidayFileHisInfo.getId() == null) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail1, this.ctx, personName, cycleDate);
        }
        if (laborInfo == null || laborInfo.getId() == null) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail18, this.ctx, personName);
        }
        HolidayPolicySetInfo holidayPolicySetInfo = atsHolidayFileHisInfo.getHolidayPolicySet();
        if (holidayPolicySetInfo == null || holidayPolicySetInfo.getId() == null) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail7, this.ctx, personName);
        }
        if (BaseItemStateEnum.DISABLE == holidayPolicySetInfo.getState()) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail2, this.ctx, personName);
        }
        if (BaseItemStateEnum.NEW == holidayPolicySetInfo.getState()) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail3, this.ctx, personName);
        }
        return null;
    }

    public String validDetailData(HolidayTypeInfo holidayType, String personId, NextGenerationInfo nextGenerationInfo) {
        String existedDealType;
        Map personPositionMap = (Map)this.globalMap.get("personPositionMap");
        Map atsHolidayFileHisMap = (Map)this.globalMap.get("atsHolidayFileHisMap");
        Map holidayPolicyMap = (Map)this.globalMap.get("holidayPolicyMap");
        Map holidayRuleMap = (Map)this.globalMap.get("holidayRuleMap");
        Map existedHolidayLimitMap = (Map)this.globalMap.get("existedHolidayLimitMap");
        if (nextGenerationInfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nextGenerationInfo.getId())) {
            existedHolidayLimitMap = (Map)this.globalMap.get("existedParentalLeaveHolidayLimitMap");
        }
        Map empLaborRelationMap = (Map)this.globalMap.get("empLaborRelationMap");
        Map personOtherMap = (Map)this.globalMap.get("personOtherMap");
        String cycleDate = StringUtils.cnulls((Object)this.param.get("cycleDate"));
        Date scycleDate = HRTimeWebUtils.stringToShortDate(cycleDate);
        AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)atsHolidayFileHisMap.get(personId + "_" + cycleDate);
        HolidayPolicyInfo holidayPolicyInfo = GenHolidayLimitUtil.getHolidayPolicyByHolidayType((HolidayPolicyCollection)((Object)holidayPolicyMap.get(atsHolidayFileHisInfo.getHolidayPolicySet().getId().toString())), holidayType.getId().toString());
        EmpLaborRelationInfo laborInfo = (EmpLaborRelationInfo)empLaborRelationMap.get(personId);
        PersonPositionInfo personPositionInfo = (PersonPositionInfo)personPositionMap.get(personId);
        PersonOtherInfoInfo personOtherInfo = (PersonOtherInfoInfo)personOtherMap.get(personId);
        String personName = personPositionInfo.getPerson().getName().toString();
        if (holidayPolicyInfo == null || holidayPolicyInfo.getId() == null) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail8, this.ctx, personName, holidayType.getName());
        }
        if (!holidayPolicyInfo.isIsCtrlLimit()) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail5, this.ctx, personName, holidayType.getName());
        }
        if (holidayPolicyInfo.getHolidayRule() == null || holidayPolicyInfo.getHolidayRule().getId() == null) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail4, this.ctx, personName, holidayType.getName());
        }
        StringBuilder key = new StringBuilder(personId + holidayType.getId().toString() + atsHolidayFileHisInfo.getHrOrgUnit().getId().toString());
        if (nextGenerationInfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nextGenerationInfo.getId())) {
            key.append(nextGenerationInfo.getId());
        }
        HolidayLimitInfo hLimitInfo = (HolidayLimitInfo)existedHolidayLimitMap.get(key.toString());
        HolidayRuleInfo holidayRuleInfo = (HolidayRuleInfo)holidayRuleMap.get(holidayPolicyInfo.getHolidayRule().getId().toString());
        if (hLimitInfo != null && hLimitInfo.getId() != null && "0".equals(existedDealType = StringUtils.cnulls((Object)this.param.get("existedDealType")))) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.IgnoreUpdateHolidayPolicy, this.ctx, personName, holidayType.getName());
        }
        if (holidayRuleInfo.getCycleType().getValue() == 2 && scycleDate.compareTo(AtsDateUtils.stringToShortDate(holidayRuleInfo.getCycleTypeCustomValue())) == -1) {
            return MLUtile.getRes((ResourceEnum)AtsAttenceCycleResEnum.GenerateLimitFail13, this.ctx, personName, holidayType.getName());
        }
        return null;
    }

    public void genHolidayLimitData(Map<String, Object> resultMap, HolidayTypeInfo holidayTypeInfo, String personId, List<String> failedList, NextGenerationInfo nextGenerationInfo) throws Exception {
        CoreBaseCollection newLimit;
        HolidayLimitInfo hLimitInfo;
        Map personPositionMap = (Map)this.globalMap.get("personPositionMap");
        Map atsHolidayFileHisMap = (Map)this.globalMap.get("atsHolidayFileHisMap");
        Map holidayPolicyMap = (Map)this.globalMap.get("holidayPolicyMap");
        Map holidayRuleMap = (Map)this.globalMap.get("holidayRuleMap");
        Map existedHolidayLimitMap = (Map)this.globalMap.get("existedHolidayLimitMap");
        if (nextGenerationInfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nextGenerationInfo.getId())) {
            existedHolidayLimitMap = (Map)this.globalMap.get("existedParentalLeaveHolidayLimitMap");
        }
        Map empLaborRelationMap = (Map)this.globalMap.get("empLaborRelationMap");
        Map personOtherMap = (Map)this.globalMap.get("personOtherMap");
        Map atsHolidayFileHisHROMap = (Map)this.globalMap.get("atsHolidayFileHisColl");
        Map empPosOrgRelationMap = (Map)this.globalMap.get("empOrgRelationMap");
        String cycleDate = StringUtils.cnulls((Object)this.param.get("cycleDate"));
        Date scycleDate = HRTimeWebUtils.stringToShortDate(StringUtils.cnulls((Object)this.param.get("cycleDate")));
        AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)atsHolidayFileHisMap.get(personId + "_" + cycleDate);
        HolidayPolicyCollection holidayPolicyColl = (HolidayPolicyCollection)((Object)holidayPolicyMap.get(atsHolidayFileHisInfo.getHolidayPolicySet().getId().toString()));
        HolidayPolicyInfo holidayPolicyInfo = GenHolidayLimitUtil.getHolidayPolicyByHolidayType(holidayPolicyColl, holidayTypeInfo.getId().toString());
        EmpLaborRelationInfo laborInfo = (EmpLaborRelationInfo)empLaborRelationMap.get(personId);
        PersonPositionInfo personPositionInfo = (PersonPositionInfo)personPositionMap.get(personId);
        PersonOtherInfoInfo personOtherInfo = (PersonOtherInfoInfo)personOtherMap.get(personId);
        EmpPosOrgRelationInfo empPosOrgReLaInfo = (EmpPosOrgRelationInfo)empPosOrgRelationMap.get(personId);
        HolidayRuleInfo holidayRuleInfo = (HolidayRuleInfo)holidayRuleMap.get(holidayPolicyInfo.getHolidayRule().getId().toString());
        String personName = personPositionInfo.getPerson().getName();
        String periodAccordType = Integer.toString(holidayRuleInfo.getCycleType().getValue());
        GenHolidayLimitModel holidayLimitModel = this.holidayLimitRule.getLimitModel(this.ctx, personPositionInfo, scycleDate, periodAccordType, holidayTypeInfo, holidayPolicyColl, null, holidayRuleInfo, laborInfo, personOtherInfo, nextGenerationInfo);
        if (holidayLimitModel == null) {
            failedList.add(MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail26, this.ctx, personName, holidayTypeInfo.getName()));
            return;
        }
        if (nextGenerationInfo != null && nextGenerationInfo.getBirthdayDate().after(holidayLimitModel.getCycleEndDate())) {
            return;
        }
        StringBuilder key = new StringBuilder(personId + holidayTypeInfo.getId().toString() + atsHolidayFileHisInfo.getHrOrgUnit().getId().toString());
        if (nextGenerationInfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nextGenerationInfo.getId())) {
            key.append(nextGenerationInfo.getId());
        }
        if (null != (hLimitInfo = (HolidayLimitInfo)existedHolidayLimitMap.get(key.toString()))) {
            Date cycleBeginDate = holidayLimitModel.getCycleBeginDate();
            Date cycleEndDate = holidayLimitModel.getCycleEndDate();
            if (empPosOrgReLaInfo != null && empPosOrgReLaInfo.getId() != null && this.isCommonYear(holidayLimitModel.getCycleBeginDate(), laborInfo.getEnterDate(), holidayPolicyInfo.getPeriodLengthUnit())) {
                cycleBeginDate = laborInfo.getEnterDate();
            }
            if (null != cycleBeginDate && null != cycleEndDate) {
                String errorMsg;
                String orgDate = GenHolidayLimitUtil.isOrgChange(this.ctx, personId, HRTimeWebUtils.dateLongToString(cycleBeginDate), HRTimeWebUtils.dateLongToString(cycleEndDate));
                Date bizChangeDate = (Date)this.param.get("bizChangeDate");
                if ((Date)this.param.get("bizChangeDate") != null || orgDate != null) {
                    Date date = bizChangeDate = (Date)this.param.get("bizChangeDate") == null ? HRTimeWebUtils.stringToShortDate(orgDate) : (Date)this.param.get("bizChangeDate");
                }
                if (bizChangeDate == null && !StringUtils.isEmpty((String)(errorMsg = GenHolidayLimitUtil.isHolidayLimitIntersectbyExists(this.ctx, personId, holidayPolicyInfo.getId().toString(), personName, holidayTypeInfo.getName(), cycleBeginDate, cycleEndDate, hLimitInfo.getHrOrgUnit().getId().toString(), nextGenerationInfo)))) {
                    failedList.add(errorMsg);
                    return;
                }
            }
        } else {
            hLimitInfo = new HolidayLimitInfo();
            this.logger.error((Object)("person\u3010" + personName + "(" + personId + ")\u3011,limit type \u3010" + holidayTypeInfo.getName() + "\u3011,not exist cur attcycle limit,add new limit"));
        }
        BigDecimal standardLimit = this.calStandardLimit(holidayTypeInfo, failedList, atsHolidayFileHisHROMap, cycleDate, holidayPolicyInfo, laborInfo, personPositionInfo, personOtherInfo, holidayRuleInfo, periodAccordType, holidayLimitModel, nextGenerationInfo);
        if (standardLimit.compareTo(BigDecimal.valueOf(-1.0E9)) == 0) {
            failedList.add(MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail25, this.ctx, personName, holidayTypeInfo.getName()));
            return;
        }
        String errorMsg = GenHolidayLimitUtil.checkAndSetHolidayLimitDate(this.ctx, holidayLimitModel, personPositionInfo, holidayRuleInfo, holidayTypeInfo, hLimitInfo, laborInfo, personOtherInfo, nextGenerationInfo);
        if (!StringUtils.isEmpty((String)errorMsg)) {
            failedList.add(errorMsg);
            return;
        }
        this.assembleHolidayLimitData(atsHolidayFileHisInfo, empPosOrgReLaInfo, laborInfo, holidayLimitModel, standardLimit, hLimitInfo, holidayPolicyInfo, nextGenerationInfo);
        if (nextGenerationInfo != null && nextGenerationInfo.getBirthdayDate() != null && hLimitInfo.getId() == null && standardLimit != null && standardLimit.compareTo(BigDecimal.ZERO) == 0 && !holidayLimitModel.isMatchHolidayRuleCal()) {
            this.logger.error((Object)"----There is no matching quota rule, causing the standard parental leave quota to be generated as 0 and no quota record to be generated");
            return;
        }
        if (nextGenerationInfo != null && nextGenerationInfo.getBirthdayDate() != null) {
            this.logger.error((Object)MessageFormat.format("Parental leave calBeginTime={0},calEndTime={1}", holidayLimitModel.getCalChildDateCtnBegin(), holidayLimitModel.getCalChildDateCtnEnd()));
            hLimitInfo.put("calBeginTime", holidayLimitModel.getCalChildDateCtnBegin());
            hLimitInfo.put("calEndTime", holidayLimitModel.getCalChildDateCtnEnd());
        }
        String SAVEMODE = "UPDATELIMIT";
        if (null == hLimitInfo.getId() || StringUtils.isEmpty((String)hLimitInfo.getId().toString())) {
            SAVEMODE = "NEWLIMIT";
        }
        if (resultMap.get(SAVEMODE) != null) {
            newLimit = (CoreBaseCollection)resultMap.get(SAVEMODE);
            newLimit.add((CoreBaseInfo)hLimitInfo);
        } else {
            newLimit = new CoreBaseCollection();
            newLimit.add((CoreBaseInfo)hLimitInfo);
            resultMap.put(SAVEMODE, newLimit);
        }
    }

    private void assembleHolidayLimitData(AtsHolidayFileHisInfo atsHolidayFileHisInfo, EmpPosOrgRelationInfo empPosOrgReLaInfo, EmpLaborRelationInfo laborInfo, GenHolidayLimitModel holidayLimitModel, BigDecimal standardLimit, HolidayLimitInfo hLimitInfo, HolidayPolicyInfo holidayPolicyInfo, NextGenerationInfo nextGenerationInfo) throws BOSException {
        hLimitInfo.setHolidayPolicy(holidayLimitModel.getHolidayPolicyInfo());
        hLimitInfo.setHolidayUnit(holidayLimitModel.getHolidayPolicyInfo().getUnit());
        hLimitInfo.setEnableCycle(holidayLimitModel.getHolidayPolicyInfo().isEnablePeriod());
        hLimitInfo.setYear(holidayLimitModel.getYear());
        hLimitInfo.setCycleDate(holidayLimitModel.getCycleDate());
        if (empPosOrgReLaInfo != null && empPosOrgReLaInfo.getId() != null && this.isCommonYear(holidayLimitModel.getCycleBeginDate(), laborInfo.getEnterDate(), holidayPolicyInfo.getPeriodLengthUnit())) {
            if (laborInfo != null && laborInfo.getEnterDate() != null && holidayLimitModel.getCycleBeginDate() != null && laborInfo.getEnterDate().getTime() > holidayLimitModel.getCycleBeginDate().getTime()) {
                hLimitInfo.setCycleBeginDate(laborInfo.getEnterDate());
            } else {
                hLimitInfo.setCycleBeginDate(holidayLimitModel.getCycleBeginDate());
            }
            hLimitInfo.setEffectDate(holidayLimitModel.getEffectDate());
        } else {
            hLimitInfo.setCycleBeginDate(holidayLimitModel.getCycleBeginDate());
            hLimitInfo.setEffectDate(holidayLimitModel.getEffectDate());
        }
        hLimitInfo.setDelayDate(holidayLimitModel.getDelayDate());
        hLimitInfo.setCycleEndDate(holidayLimitModel.getCycleEndDate());
        if (this.param.get("bizChangeDate") != null || holidayLimitModel.isChangeHrOrgUnitOld()) {
            Date delayDate = (Date)this.param.get("bizChangeDate") == null ? holidayLimitModel.getCycleEndDate() : (Date)this.param.get("bizChangeDate");
            delayDate = delayDate.before(holidayLimitModel.getCycleEndDate()) ? delayDate : holidayLimitModel.getCycleEndDate();
            hLimitInfo.setDelayDate(delayDate);
            hLimitInfo.setLeftCycleEndDate(hLimitInfo.getCycleEndDate());
            hLimitInfo.setCycleEndDate(delayDate);
            if (hLimitInfo.getLeftConvertLimit() == null || null != hLimitInfo.getStandardLimit() && standardLimit.compareTo(hLimitInfo.getStandardLimit()) != 0) {
                hLimitInfo.setLeftConvertLimit(hLimitInfo.getStandardLimit());
            }
        }
        hLimitInfo.setStatus(HolidayLimitStatus.audited);
        hLimitInfo.setStandardLimit(standardLimit);
        if (hLimitInfo.getAddOrSubLimit() != null) {
            hLimitInfo.setRealLimit(standardLimit.add(hLimitInfo.getAddOrSubLimit()));
        } else {
            hLimitInfo.setRealLimit(standardLimit);
        }
        if (null == hLimitInfo.getId() || StringUtils.isEmpty((String)hLimitInfo.getId().toString())) {
            hLimitInfo.setAddOrSubLimit(BigDecimal.valueOf(0.0));
            hLimitInfo.setUsedLimit(BigDecimal.valueOf(0.0));
            hLimitInfo.setFreezeLimit(BigDecimal.valueOf(0.0));
            hLimitInfo.setPreOverdraftLimit(BigDecimal.valueOf(0.0));
            hLimitInfo.setRemainLimit(standardLimit);
            hLimitInfo.setProposer(laborInfo.getPerson());
            hLimitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
            hLimitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
            hLimitInfo.setPosition(atsHolidayFileHisInfo.getPosition());
        } else {
            hLimitInfo.setProposer(laborInfo.getPerson());
            hLimitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
            hLimitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
            hLimitInfo.setPosition(atsHolidayFileHisInfo.getPosition());
            hLimitInfo.setRemainLimit(hLimitInfo.getRealLimit().subtract(hLimitInfo.getUsedLimit()).subtract(hLimitInfo.getFreezeLimit()).subtract(hLimitInfo.getPreOverdraftLimit()));
        }
        if (nextGenerationInfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nextGenerationInfo.getId())) {
            hLimitInfo.setChildId(nextGenerationInfo.getId());
        }
    }

    private BigDecimal calStandardLimit(HolidayTypeInfo holidayTypeInfo, List<String> failedList, Map<String, AtsHolidayFileHisCollection> atsHolidayFileHisHROMap, String cycleDate, HolidayPolicyInfo holidayPolicyInfo, EmpLaborRelationInfo laborInfo, PersonPositionInfo personPositionInfo, PersonOtherInfoInfo personOtherInfo, HolidayRuleInfo holidayRuleInfo, String periodAccordType, GenHolidayLimitModel holidayLimitModel, NextGenerationInfo nextGenerationInfo) throws EASBizException, BOSException, SQLException {
        ((GenHolidayLimitRuleImpl)this.holidayLimitRule).setFileHisCollectionMap(atsHolidayFileHisHROMap);
        holidayLimitModel.setLeftEndDate(personPositionInfo.getLeftDate());
        if (this.param.get("bizChangeDate") != null) {
            holidayLimitModel.setLeftEndDate((Date)this.param.get("bizChangeDate"));
        }
        if (this.param.get("calBaseDate") != null) {
            holidayLimitModel.setCycleBeginDate((Date)this.param.get("calBaseDate"));
            holidayLimitModel.setLeftEndDate(holidayLimitModel.getCycleEndDate());
        }
        this.holidayLimitRule.calHolidayLimitByRule(this.ctx, holidayLimitModel, personPositionInfo, HRTimeWebUtils.stringToShortDate(cycleDate), periodAccordType, holidayPolicyInfo, holidayRuleInfo, laborInfo, personOtherInfo, nextGenerationInfo);
        BigDecimal standardLimit = holidayLimitModel.getStandardLimit();
        if (standardLimit.compareTo(BigDecimal.valueOf(-1.0E9)) == 0) {
            return standardLimit;
        }
        if (this.param.get("bizChangeDate") == null) {
            standardLimit = this.holidayLimitRule.isGrantStandarLimit(this.ctx, standardLimit, holidayLimitModel.getHolidayPolicyInfo(), holidayLimitModel, personPositionInfo, holidayRuleInfo, laborInfo, personOtherInfo);
        }
        this.logger.error((Object)MessageFormat.format("-------split stage after.standardLimit={0}", standardLimit));
        HashMap<String, Object> param_amt = new HashMap<String, Object>();
        param_amt.put("standardLimit", standardLimit);
        param_amt.put("holidayPolicyInfo", holidayPolicyInfo);
        standardLimit = new DecimalPlaceContext(this.strategy).precisionConvert(this.ctx, param_amt);
        return standardLimit;
    }

    public Integer[] saveData(Map<String, Object> resultMap) {
        long startTime = System.currentTimeMillis();
        Integer[] result = new Integer[]{0, 0};
        if (null == resultMap) {
            return result;
        }
        try {
            Object newLimit;
            Object updateLimit = resultMap.get("UPDATELIMIT");
            if (updateLimit != null) {
                CoreBaseCollection updateLimitColl = (CoreBaseCollection)updateLimit;
                DataSaver dataSaver = new DataSaver();
                dataSaver.setCtx(this.ctx).save(updateLimitColl);
                result[0] = updateLimitColl.size();
                AtsLeaveBillLimit limit = new AtsLeaveBillLimit();
                limit.recordHolidayLimit(this.ctx, updateLimitColl, ChangeTypeEnum.update, null);
            }
            if ((newLimit = resultMap.get("NEWLIMIT")) != null) {
                CoreBaseCollection newLimitColl = (CoreBaseCollection)newLimit;
                DataSaver dataSaver = new DataSaver();
                dataSaver.setCtx(this.ctx).save(newLimitColl);
                result[1] = newLimitColl.size();
                AtsLeaveBillLimit limit = new AtsLeaveBillLimit();
                CoreBaseCollection newLimitColl1 = new CoreBaseCollection();
                for (int i = 0; i < newLimitColl.size(); ++i) {
                    HolidayLimitInfo info = (HolidayLimitInfo)newLimitColl.get(i);
                    BOSUuid id = info.getId() == null ? BOSUuid.create((String)"A804F41D") : info.getId();
                    info.setId(id);
                    newLimitColl1.add((CoreBaseInfo)info);
                }
                limit.recordHolidayLimit(this.ctx, newLimitColl1, ChangeTypeEnum.update, null);
            }
            this.logger.error((Object)("generate limit,add count \uff1a" + result[1] + ",update count\uff1a" + result[0] + ",save cost\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        }
        catch (Exception e) {
            this.logger.error((Object)("save limit data  error resultMap size" + resultMap.size()));
            e.printStackTrace();
        }
        return result;
    }

    public String validGenHolidayLimitModelData(GenHolidayLimitModel holidayLimitModel, String personName) {
        int errorType = holidayLimitModel.getErrorType();
        if (errorType == 1) {
            return MLUtile.getRes((ResourceEnum)AtsAttenceCycleResEnum.GenerateLimitFail10, this.ctx, personName);
        }
        if (errorType == 2) {
            return MLUtile.getRes((ResourceEnum)AtsAttenceCycleResEnum.GenerateLimitFail8, this.ctx, personName);
        }
        if (errorType == 3) {
            return MLUtile.getRes((ResourceEnum)AtsAttenceCycleResEnum.GenerateLimitFail11, this.ctx, personName);
        }
        if (errorType == 4) {
            return MLUtile.getRes((ResourceEnum)AtsAttenceCycleResEnum.GenerateLimitFail9, this.ctx, personName);
        }
        return null;
    }

    public void reCalHolidayLimit(Context ctx, Map<String, Object> resultMap) {
        if (null != resultMap && resultMap.size() > 0) {
            long startTime = System.currentTimeMillis();
            CoreBaseCollection existedColls = null;
            if (null != resultMap.get("UPDATELIMIT")) {
                existedColls = (CoreBaseCollection)resultMap.get("UPDATELIMIT");
            }
            if (null == existedColls) {
                existedColls = new CoreBaseCollection();
            }
            CoreBaseCollection insertColls = null;
            if (null != resultMap.get("NEWLIMIT")) {
                insertColls = (CoreBaseCollection)resultMap.get("NEWLIMIT");
            }
            if (null == insertColls) {
                insertColls = new CoreBaseCollection();
            }
            insertColls.addCollection(existedColls);
            ReCalHolidayLimitServiceImpl reCalLimitService = new ReCalHolidayLimitServiceImpl();
            this.globalMap.putAll(this.param);
            reCalLimitService.initData(ctx, this.globalMap);
            reCalLimitService.initDeal(ctx, insertColls);
            this.logger.error((Object)("reCal one batch person's limit that used or fromzon end ,cost\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        }
    }

    public void recordLog(Context ctx, Map<String, Object> resultMap) {
        long startTime = System.currentTimeMillis();
        if (null != this.param) {
            resultMap.put("accessSrc", this.param.get("accessSrc"));
        }
        DataLogUtil.recordLimitLog(ctx, resultMap);
        this.logger.error((Object)("Recordlog one batch person's limit ,cost\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
    }

    public Map<String, HolidayLimitInfo> cloneExistsLimitMap() {
        HashMap<String, HolidayLimitInfo> oldLimitMap = new HashMap<String, HolidayLimitInfo>();
        Map existedHolidayLimitMap = (Map)this.globalMap.get("existedHolidayLimitMap");
        if (null != existedHolidayLimitMap) {
            for (HolidayLimitInfo limitInfo : existedHolidayLimitMap.values()) {
                oldLimitMap.put(limitInfo.getId().toString(), (HolidayLimitInfo)limitInfo.clone());
            }
        }
        return oldLimitMap;
    }

    public boolean isCommonYear(Date date, Date compareDate, HolidayPeriodUniteEnum holidayPeriodUniteEnum) {
        if (holidayPeriodUniteEnum == HolidayPeriodUniteEnum.month) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int month = cal.get(2);
            cal = Calendar.getInstance();
            cal.setTime(compareDate);
            int compareMonth = cal.get(2);
            return month == compareMonth;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        cal = Calendar.getInstance();
        cal.setTime(compareDate);
        int compareYear = cal.get(1);
        return year == compareYear;
    }

    public void clearData() {
        this.globalMap.clear();
        this.param.clear();
        this.logEntryMap.clear();
        this.holidayLimitRule = null;
    }
}

