/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.generate.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.CycleTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayRuleInfo;
import com.kingdee.eas.hr.ats.IHolidayLimit;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenHolidayLimitManager;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.GenHolidayLimitSQL;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.holidayLimit.generate.vo.NextGenerationInfo;
import com.kingdee.eas.hr.ats.util.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsFitFn;
import com.kingdee.eas.hr.ats.util.common.AtsMapFn;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonFamilyCollection;
import com.kingdee.eas.hr.emp.PersonFamilyFactory;
import com.kingdee.eas.hr.emp.PersonFamilyInfo;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AtsParentalLeaveUtil {
    private static Logger logger = Logger.getLogger(AtsParentalLeaveUtil.class);
    public static final String PERSONAL_LEAVE_ID = "4F7rXAuSEFjgUzsFEqwuZ/0tUpg=";

    public static Map<String, List<NextGenerationInfo>> getPersonNextGeneration(Context ctx, Set<String> personIdSet) {
        logger.error((Object)MessageFormat.format("query person next generation.personIdSet={0}", personIdSet));
        if (AtsCollectionUtile.isEmpty(personIdSet)) {
            return new HashMap<String, List<NextGenerationInfo>>();
        }
        List<List<String>> personGroupList = AtsCollectionUtile.group(personIdSet, 100);
        ArrayList<NextGenerationInfo> allNextGenerationInfo = new ArrayList<NextGenerationInfo>();
        for (List<String> subPersonList : personGroupList) {
            List<NextGenerationInfo> nextGenerationInfoList = AtsParentalLeaveUtil.getNextGenerateListByPersonId(ctx, subPersonList);
            if (AtsCollectionUtile.isEmpty(nextGenerationInfoList)) continue;
            allNextGenerationInfo.addAll(nextGenerationInfoList);
        }
        Map<String, List<NextGenerationInfo>> resultMap = AtsCollectionUtile.groupBy(allNextGenerationInfo, new AtsMapFn<NextGenerationInfo, String>(){

            @Override
            public String map(NextGenerationInfo nextGenerationInfo) {
                return nextGenerationInfo == null ? null : nextGenerationInfo.getPersonId();
            }
        });
        logger.error((Object)MessageFormat.format("result is {0}", resultMap));
        return resultMap;
    }

    private static List<NextGenerationInfo> getNextGenerateListByPersonId(Context ctx, List<String> personIdList) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("id"));
        selectorColl.add(new SelectorItemInfo("name"));
        selectorColl.add(new SelectorItemInfo("birthday"));
        selectorColl.add(new SelectorItemInfo("person.number"));
        selectorColl.add(new SelectorItemInfo("person.id"));
        fi.getFilterItems().add(new FilterItemInfo("person.id", new HashSet<String>(personIdList), CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("relation.relationType", (Object)2, CompareType.EQUALS));
        evi.setFilter(fi);
        try {
            PersonFamilyCollection personFamilyCollection = PersonFamilyFactory.getLocalInstance((Context)ctx).getPersonFamilyCollection(evi);
            if (AtsCollectionUtile.isEmpty((IObjectCollection)personFamilyCollection)) {
                return new ArrayList<NextGenerationInfo>();
            }
            ArrayList<NextGenerationInfo> nextGenerationInfoList = new ArrayList<NextGenerationInfo>();
            for (int i = 0; i < personFamilyCollection.size(); ++i) {
                PersonFamilyInfo personFamilyInfo = personFamilyCollection.get(i);
                if (personFamilyInfo == null || personFamilyInfo.getBirthday() == null || personFamilyInfo.getId() == null || personFamilyInfo.getPerson() == null || personFamilyInfo.getPerson().getId() == null) continue;
                NextGenerationInfo generationInfo = new NextGenerationInfo();
                generationInfo.setId(personFamilyInfo.getId().toString());
                generationInfo.setBirthdayDate(personFamilyInfo.getBirthday());
                generationInfo.setPersonId(personFamilyInfo.getPerson().getId().toString());
                nextGenerationInfoList.add(generationInfo);
            }
            return nextGenerationInfoList;
        }
        catch (Exception e) {
            logger.error((Object)"catch a exception", (Throwable)e);
            return new ArrayList<NextGenerationInfo>();
        }
    }

    public static void updateAddLimitWithParentalLeave(Context ctx, Map<Object, Object> param, Map<String, List<String>> personTypeMap) throws Exception {
        if (StringUtils.isBlank((CharSequence)((String)param.get("holidayType"))) && StringUtils.isBlank((CharSequence)((String)param.get("holidayTypeName")))) {
            Map<Object, Object> paramClone = AtsCommonUtile.deepClone(param);
            paramClone.put("holidayType", PERSONAL_LEAVE_ID);
            paramClone.put("proposers", AtsCollectionUtile.join(personTypeMap.keySet()));
            String parentalHolidayLimitSql = GenHolidayLimitSQL.getGenerateAllHolidayLimitSql(ctx, paramClone);
            Map<String, List<String>> patentalpPpersonTypeMap = new GenHolidayLimitManager().getPersonMap(ctx, parentalHolidayLimitSql);
            for (Map.Entry<String, List<String>> entry : personTypeMap.entrySet()) {
                if (!patentalpPpersonTypeMap.containsKey(entry.getKey()) || AtsCollectionUtile.isEmpty((Collection)patentalpPpersonTypeMap.get(entry.getKey()))) continue;
                HashSet holidayTypeSet = new HashSet();
                holidayTypeSet.addAll(entry.getValue());
                holidayTypeSet.addAll(patentalpPpersonTypeMap.get(entry.getKey()));
                entry.setValue(new ArrayList(holidayTypeSet));
            }
        }
    }

    public static void proPersonelDeleteChildBiz(Context ctx, String personId, List<NextGenerationInfo> nextGenerationInfoList) throws BOSException, EASBizException {
        logger.error((Object)MessageFormat.format("proPersonelDeleteChildBiz exe.personId={0},nextGenerationInfoList={1}", personId, nextGenerationInfoList));
        List<String> curChildIdList = AtsCollectionUtile.map(nextGenerationInfoList, new AtsMapFn<NextGenerationInfo, String>(){

            @Override
            public String map(NextGenerationInfo nextGenerationInfo) {
                if (nextGenerationInfo == null) {
                    return null;
                }
                return nextGenerationInfo.getId();
            }
        });
        logger.error((Object)MessageFormat.format("---------------curChildIdList={0}", curChildIdList));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("id"));
        selectorColl.add(new SelectorItemInfo("proposer.id"));
        selectorColl.add(new SelectorItemInfo("standardLimit"));
        selectorColl.add(new SelectorItemInfo("realLimit"));
        selectorColl.add(new SelectorItemInfo("addOrSubLimit"));
        selectorColl.add(new SelectorItemInfo("usedLimit"));
        selectorColl.add(new SelectorItemInfo("freezeLimit"));
        selectorColl.add(new SelectorItemInfo("remainLimit"));
        selectorColl.add(new SelectorItemInfo("preOverdraftLimit"));
        selectorColl.add(new SelectorItemInfo("hrOrgUnit.id"));
        selectorColl.add(new SelectorItemInfo("holidayPolicy.holidayType.id"));
        selectorColl.add(new SelectorItemInfo("childId"));
        evi.setSelector(selectorColl);
        fi.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)personId, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("holidayPolicy.holidayType.id", (Object)PERSONAL_LEAVE_ID, CompareType.EQUALS));
        evi.setFilter(fi);
        IHolidayLimit iHolidayLimit = HolidayLimitFactory.getLocalInstance(ctx);
        HolidayLimitCollection personParentalLeaveLimitCol = iHolidayLimit.getHolidayLimitCollection(evi);
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)personParentalLeaveLimitCol)) {
            List<String> allChildrenList = AtsCollectionUtile.filter(AtsCollectionUtile.map(personParentalLeaveLimitCol, new AtsMapFn<HolidayLimitInfo, String>(){

                @Override
                public String map(HolidayLimitInfo holidayLimitInfo) {
                    if (holidayLimitInfo == null) {
                        return null;
                    }
                    return holidayLimitInfo.getChildId();
                }
            }), new AtsFitFn<String>(){

                @Override
                public boolean fit(String childId) {
                    return !StringUtils.isBlank((CharSequence)childId);
                }
            });
            logger.error((Object)MessageFormat.format("---------------allChildrenList={0}", allChildrenList));
            allChildrenList.removeAll(curChildIdList);
            if (AtsCollectionUtile.isEmpty(allChildrenList)) {
                return;
            }
            ArrayList<String> delHolidayLimitIdList = new ArrayList<String>();
            HolidayLimitCollection updateHolidayLimitCollection = new HolidayLimitCollection();
            for (int i = 0; i < personParentalLeaveLimitCol.size(); ++i) {
                HolidayLimitInfo holidayLimitInfo = personParentalLeaveLimitCol.get(i);
                if (holidayLimitInfo == null || StringUtils.isBlank((CharSequence)holidayLimitInfo.getChildId()) || !allChildrenList.contains(holidayLimitInfo.getChildId())) continue;
                if (BigDecimal.ZERO.compareTo(holidayLimitInfo.getUsedLimit()) == 0) {
                    delHolidayLimitIdList.add(holidayLimitInfo.getId().toString());
                    continue;
                }
                BigDecimal standardLimit = BigDecimal.ZERO;
                BigDecimal addOrSubLimit = holidayLimitInfo.getAddOrSubLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getAddOrSubLimit();
                BigDecimal freezeLimit = holidayLimitInfo.getFreezeLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getFreezeLimit();
                BigDecimal preOverdraftLimit = holidayLimitInfo.getPreOverdraftLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getPreOverdraftLimit();
                BigDecimal usedLimit = holidayLimitInfo.getUsedLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getUsedLimit();
                holidayLimitInfo.setStandardLimit(standardLimit);
                holidayLimitInfo.setRealLimit(standardLimit.add(addOrSubLimit));
                holidayLimitInfo.setRemainLimit(standardLimit.add(addOrSubLimit).subtract(freezeLimit.add(preOverdraftLimit.add(usedLimit))));
                holidayLimitInfo.setNote(MLUtile.getRes(AtsCommonResEnum.PersonChildDel, ctx));
                updateHolidayLimitCollection.add(holidayLimitInfo);
            }
            if (!AtsCollectionUtile.isEmpty(delHolidayLimitIdList)) {
                logger.error((Object)MessageFormat.format("del limit.delHolidayLimitIdList={0}", delHolidayLimitIdList));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(delHolidayLimitIdList), CompareType.INCLUDE));
                iHolidayLimit.delete(filter);
            }
            if (!AtsCollectionUtile.isEmpty((IObjectCollection)updateHolidayLimitCollection)) {
                SelectorItemCollection updateSelectorColl = new SelectorItemCollection();
                updateSelectorColl.add(new SelectorItemInfo("standardLimit"));
                updateSelectorColl.add(new SelectorItemInfo("realLimit"));
                updateSelectorColl.add(new SelectorItemInfo("remainLimit"));
                updateSelectorColl.add(new SelectorItemInfo("note"));
                for (int i = 0; i < updateHolidayLimitCollection.size(); ++i) {
                    iHolidayLimit.updatePartial(updateHolidayLimitCollection.get(i), updateSelectorColl);
                }
            }
        }
    }

    public static void childPersonIsAccumal(Context ctx, Map<String, Object> resultLimitMap, HolidayRuleInfo holidayRuleInfo, String personId) {
        HolidayLimitInfo info;
        int i;
        String updateMode = "UPDATELIMIT";
        String saveMode = "NEWLIMIT";
        HolidayLimitCollection holidayLimitColl = new HolidayLimitCollection();
        CoreBaseCollection collection = new CoreBaseCollection();
        if (resultLimitMap.get(updateMode) != null && null != (collection = (CoreBaseCollection)resultLimitMap.get(updateMode)) && collection.size() > 0) {
            for (i = 0; i < collection.size(); ++i) {
                info = (HolidayLimitInfo)collection.get(i);
                if (!info.getProposer().getId().toString().equals(personId)) continue;
                holidayLimitColl.add((HolidayLimitInfo)collection.get(i));
            }
        }
        if (resultLimitMap.get(saveMode) != null && null != (collection = (CoreBaseCollection)resultLimitMap.get(saveMode)) && collection.size() > 0) {
            for (i = 0; i < collection.size(); ++i) {
                info = (HolidayLimitInfo)collection.get(i);
                if (!info.getProposer().getId().toString().equals(personId)) continue;
                holidayLimitColl.add((HolidayLimitInfo)collection.get(i));
            }
        }
        if (null != holidayLimitColl && holidayLimitColl.size() > 0) {
            holidayLimitColl.sort("cycleBeginDate");
            HolidayLimitInfo holidayLimitInfo = null;
            holidayLimitInfo = holidayLimitColl.get(0);
            String cyclebeginTime = HRTimeWebUtils.dateShortToString(holidayLimitInfo.getCycleBeginDate());
            String cycleendTime = HRTimeWebUtils.dateShortToString(holidayLimitInfo.getCycleEndDate());
            String policyId = holidayLimitInfo.getHolidayPolicy().getId().toString();
            HolidayLimitCollection holidayLimitCollection = null;
            try {
                holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection("where proposer.id='" + personId + "' and holidayPolicy.id='" + policyId + "' and CycleBeginDate <'" + cycleendTime + "' and CycleEndDate >'" + cyclebeginTime + "' order by effectDate asc");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (null != holidayLimitCollection && holidayLimitCollection.size() > 0) {
                HolidayLimitInfo holidayLimitInfo2 = holidayLimitCollection.get(0);
                String beginTime = HRTimeWebUtils.dateShortToString(holidayLimitInfo2.getCycleBeginDate());
                String endTime = HRTimeWebUtils.dateShortToString(holidayLimitInfo2.getCycleEndDate());
                String id = holidayLimitInfo2.getId().toString();
                if (!(cyclebeginTime.equals(beginTime) || cycleendTime.equals(endTime) || holidayLimitInfo.getId() != null && holidayLimitInfo.getId().toString().equals(id))) {
                    holidayLimitInfo2.put("calBeginTime", holidayLimitInfo2.getCycleBeginDate());
                    holidayLimitInfo2.put("calEndTime", holidayLimitInfo2.getCycleEndDate());
                    holidayLimitColl.add(holidayLimitInfo2);
                }
            }
            if (holidayRuleInfo.getCycleType() == CycleTypeEnum.year) {
                holidayLimitColl.sort("standardLimit");
                HolidayLimitCollection holidayLimitCollectionNew = new HolidayLimitCollection();
                for (int i2 = holidayLimitColl.size() - 1; i2 >= 0; --i2) {
                    holidayLimitCollectionNew.add(holidayLimitColl.get(i2));
                }
                holidayLimitColl = holidayLimitCollectionNew;
            } else {
                holidayLimitColl.sort("calBeginTime");
            }
            Map<Object, Object> map = new HashMap();
            CoreBaseCollection newHolidayLimitColl = new CoreBaseCollection();
            CoreBaseCollection updateLimitColl = new CoreBaseCollection();
            if (holidayLimitColl.size() > 0) {
                holidayLimitInfo = holidayLimitColl.get(0);
                if (holidayLimitColl.size() > 1) {
                    for (int i3 = 0; i3 < holidayLimitColl.size(); ++i3) {
                        HolidayLimitInfo nextHolidayLimitInfo = holidayLimitColl.get(i3 + 1);
                        if (i3 != holidayLimitColl.size() - 1) {
                            map = AtsParentalLeaveUtil.childPersonIsAccumalUtil(holidayLimitInfo, nextHolidayLimitInfo, holidayRuleInfo);
                            holidayLimitInfo = (HolidayLimitInfo)map.get("holidayLimitInfo");
                        }
                        if (holidayLimitInfo.getId() != null) {
                            updateLimitColl.add((CoreBaseInfo)holidayLimitInfo);
                        } else {
                            newHolidayLimitColl.add((CoreBaseInfo)holidayLimitInfo);
                        }
                        holidayLimitInfo = (HolidayLimitInfo)map.get("nextHolidayLimitInfo");
                    }
                } else if (holidayLimitInfo.getId() != null) {
                    updateLimitColl.add((CoreBaseInfo)holidayLimitInfo);
                } else {
                    newHolidayLimitColl.add((CoreBaseInfo)holidayLimitInfo);
                }
            }
            AtsParentalLeaveUtil.setPersonLimit(resultLimitMap, updateLimitColl, newHolidayLimitColl, personId);
        }
    }

    private static void setPersonLimit(Map<String, Object> resultLimitMap, CoreBaseCollection updateLimitColl, CoreBaseCollection newHolidayLimitColl, String personId) {
        HolidayLimitInfo info;
        int i;
        String updateMode = "UPDATELIMIT";
        String saveMode = "NEWLIMIT";
        CoreBaseCollection collection = new CoreBaseCollection();
        if (resultLimitMap.get(updateMode) != null) {
            collection = (CoreBaseCollection)resultLimitMap.get(updateMode);
            if (null != collection && collection.size() > 0) {
                for (i = 0; i < collection.size(); ++i) {
                    info = (HolidayLimitInfo)collection.get(i);
                    if (!info.getProposer().getId().toString().equals(personId)) continue;
                    collection.remove(collection.get(i));
                    --i;
                }
            }
            if (null != updateLimitColl && updateLimitColl.size() > 0) {
                for (i = 0; i < updateLimitColl.size(); ++i) {
                    collection.add(updateLimitColl.get(i));
                }
            }
        }
        if (resultLimitMap.get(saveMode) != null) {
            collection = (CoreBaseCollection)resultLimitMap.get(saveMode);
            if (null != collection && collection.size() > 0) {
                for (i = 0; i < collection.size(); ++i) {
                    info = (HolidayLimitInfo)collection.get(i);
                    if (!info.getProposer().getId().toString().equals(personId)) continue;
                    collection.remove(collection.get(i));
                    --i;
                }
            }
            if (null != newHolidayLimitColl && newHolidayLimitColl.size() > 0) {
                for (i = 0; i < newHolidayLimitColl.size(); ++i) {
                    collection.add(newHolidayLimitColl.get(i));
                }
            }
        }
    }

    private static Map<String, HolidayLimitInfo> childPersonIsAccumalUtil(HolidayLimitInfo holidayLimitInfo, HolidayLimitInfo nextHolidayLimitInfo, HolidayRuleInfo holidayRuleInfo) {
        HashMap<String, HolidayLimitInfo> map = new HashMap<String, HolidayLimitInfo>();
        Date cyclebeginTime = (Date)holidayLimitInfo.get("calBeginTime");
        Date cycleEndTime = (Date)holidayLimitInfo.get("calEndTime");
        Date nextCyclebeginTime = (Date)nextHolidayLimitInfo.get("calBeginTime");
        Date nextCycleEndTime = (Date)nextHolidayLimitInfo.get("calEndTime");
        if (nextCycleEndTime.getTime() >= cyclebeginTime.getTime() && cycleEndTime.getTime() >= nextCyclebeginTime.getTime()) {
            Date dateTime = nextCycleEndTime;
            BigDecimal standLimit = nextHolidayLimitInfo.getStandardLimit();
            if (holidayRuleInfo.getValueType().getValue() == 1) {
                int value = holidayRuleInfo.getConvertType().getValue();
                if (value == 1) {
                    int endDays = 0;
                    if (dateTime.getTime() - cycleEndTime.getTime() > 0L) {
                        endDays = (int)((dateTime.getTime() - cycleEndTime.getTime()) / 86400000L);
                    }
                    int startDays = 0;
                    if (cyclebeginTime.getTime() - nextCyclebeginTime.getTime() > 0L) {
                        startDays = (int)((cyclebeginTime.getTime() - nextCyclebeginTime.getTime()) / 86400000L);
                    }
                    BigDecimal day = new BigDecimal(startDays + endDays).divide(new BigDecimal(365), 4, 6);
                    BigDecimal newStandLimit = standLimit.multiply(day);
                    nextHolidayLimitInfo.setStandardLimit(newStandLimit);
                    nextHolidayLimitInfo.setRealLimit(newStandLimit.add(nextHolidayLimitInfo.getAddOrSubLimit()));
                    BigDecimal remainLimit = newStandLimit.add(nextHolidayLimitInfo.getAddOrSubLimit()).subtract(nextHolidayLimitInfo.getUsedLimit().add(nextHolidayLimitInfo.getFreezeLimit().add(nextHolidayLimitInfo.getAddOrSubLimit())));
                    nextHolidayLimitInfo.setRemainLimit(remainLimit);
                } else {
                    int endMonth = HRTimeWebUtils.getMonthsBetweenTwoDate(dateTime, cycleEndTime);
                    if (dateTime.getTime() - cycleEndTime.getTime() > 0L) {
                        endMonth = HRTimeWebUtils.getMonthsBetweenTwoDate(dateTime, cycleEndTime);
                    }
                    int startMonth = 0;
                    if (cyclebeginTime.getTime() - nextCyclebeginTime.getTime() > 0L) {
                        startMonth = AtsParentalLeaveUtil.getMonthSpace(HRTimeWebUtils.dateShortToString(nextCyclebeginTime), HRTimeWebUtils.dateShortToString(cyclebeginTime));
                    }
                    BigDecimal monthSpace = new BigDecimal(startMonth + endMonth).divide(new BigDecimal(12), 4, 6);
                    BigDecimal newStandLimit = standLimit.multiply(monthSpace);
                    nextHolidayLimitInfo.setStandardLimit(newStandLimit);
                    nextHolidayLimitInfo.setRealLimit(newStandLimit.add(nextHolidayLimitInfo.getAddOrSubLimit()));
                    BigDecimal remainLimit = newStandLimit.add(nextHolidayLimitInfo.getAddOrSubLimit()).subtract(nextHolidayLimitInfo.getUsedLimit().add(nextHolidayLimitInfo.getFreezeLimit().add(nextHolidayLimitInfo.getAddOrSubLimit())));
                    nextHolidayLimitInfo.setRemainLimit(remainLimit);
                }
            }
        }
        map.put("holidayLimitInfo", holidayLimitInfo);
        map.put("nextHolidayLimitInfo", nextHolidayLimitInfo);
        return map;
    }

    public static int getMonthSpace(String date1, String date2) {
        int result = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            if (sdf.parse(date1).getTime() == sdf.parse(date2).getTime()) {
                return 0;
            }
            c1.setTime(sdf.parse(date1));
            c2.setTime(sdf.parse(date2));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int i = c2.get(1) - c1.get(1);
        int month = 0;
        if (i < 0) {
            month = -i * 12;
        } else if (i > 0) {
            month = i * 12;
        }
        result = c2.get(2) - c1.get(2) + month;
        result = result >= 0 ? result + 1 : result - 1;
        return Math.abs(result);
    }
}

