/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.generate.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsAttenceCycleResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.CycleTypeEnum;
import com.kingdee.eas.hr.ats.DelayDateUnitEnum;
import com.kingdee.eas.hr.ats.HolidayEffecDateTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayRlStdTypeEnum;
import com.kingdee.eas.hr.ats.HolidayRuleInfo;
import com.kingdee.eas.hr.ats.HolidayTypeInfo;
import com.kingdee.eas.hr.ats.IHolidayLimit;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.holidayLimit.generate.rule.GenHolidayLimitModel;
import com.kingdee.eas.hr.ats.holidayLimit.generate.vo.NextGenerationInfo;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsBaseUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.emp.PersonFamilyCollection;
import com.kingdee.eas.hr.emp.PersonFamilyFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class GenHolidayLimitUtil {
    private static Logger logger = Logger.getLogger(GenHolidayLimitUtil.class);

    public static String checkAndSetHolidayLimitDate(Context ctx, GenHolidayLimitModel holidayLimitModel, PersonPositionInfo personPositionInfo, HolidayRuleInfo holidayRuleInfo, HolidayTypeInfo holidayTypeInfo, HolidayLimitInfo hLimitInfo, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo other, NextGenerationInfo nextGenerationInfo) throws EASBizException, BOSException {
        String personName = personPositionInfo.getPerson().getName();
        int errorType = holidayLimitModel.getErrorType();
        if (errorType == 1) {
            return MLUtile.getRes((ResourceEnum)AtsAttenceCycleResEnum.GenerateLimitFail10, ctx, personName);
        }
        if (errorType == 2) {
            return MLUtile.getRes((ResourceEnum)AtsAttenceCycleResEnum.GenerateLimitFail8, ctx, personName);
        }
        if (errorType == 3) {
            return MLUtile.getRes((ResourceEnum)AtsAttenceCycleResEnum.GenerateLimitFail11, ctx, personName);
        }
        if (errorType == 4) {
            return MLUtile.getRes((ResourceEnum)AtsAttenceCycleResEnum.GenerateLimitFail9, ctx, personName);
        }
        java.util.Date delayDate = GenHolidayLimitUtil.getDelayDateByDelayDate(holidayRuleInfo, personPositionInfo, holidayLimitModel.getCycleEndDate());
        holidayLimitModel.setDelayDate(delayDate);
        java.util.Date cycleDateTemp = holidayLimitModel.getCycleDate();
        java.util.Date beginDate = holidayLimitModel.getCycleBeginDate();
        java.util.Date endDate = holidayLimitModel.getCycleEndDate();
        boolean check = false;
        java.util.Date effectDate = GenHolidayLimitUtil.getCycleBeginDateByHolidayEffecDateType(ctx, holidayRuleInfo, personPositionInfo, beginDate, endDate, laborInfo, other, nextGenerationInfo);
        if (effectDate == null) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail20, ctx, personName);
        }
        if (!holidayLimitModel.isChangeHrOrgUnit()) {
            holidayLimitModel.setEffectDate(effectDate);
        }
        if (!check && beginDate.getTime() > cycleDateTemp.getTime()) {
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail19, ctx, personName);
        }
        if (!check && effectDate.getTime() > delayDate.getTime()) {
            IHolidayLimit holidayLimit = HolidayLimitFactory.getRemoteInstance();
            if (hLimitInfo.getId() != null) {
                holidayLimit.delete(" where id ='" + hLimitInfo.getId().toString() + "'");
            }
            return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail22, ctx, personName);
        }
        if (!check && laborInfo.getEnterDate() == null) {
            check = true;
        } else if (!check) {
            int cycleBeginYear = beginDate.getYear();
            if (null != holidayRuleInfo.getCycleType() && (holidayRuleInfo.getCycleType().getValue() == CycleTypeEnum.custom.getValue() || holidayRuleInfo.getCycleType().getValue() == CycleTypeEnum.childBirthDate.getValue())) {
                ++cycleBeginYear;
            }
            if (laborInfo.getEnterDate().getYear() > cycleBeginYear) {
                return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitFail21, ctx, personName);
            }
        }
        return null;
    }

    public static java.util.Date getCycleBeginDateByHolidayEffecDateType(Context jobctx, HolidayRuleInfo holidayRuleInfo, PersonPositionInfo ppi, java.util.Date beginDate, java.util.Date endDate, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo personOtherInfoInfo, NextGenerationInfo nextGenerationInfo) {
        if (laborInfo == null) {
            return null;
        }
        java.util.Date effectDate = null;
        java.util.Date tempDate = null;
        HolidayEffecDateTypeEnum holidayEffecDateTypeEnum = holidayRuleInfo.getHolidayEffecDateType();
        if (holidayEffecDateTypeEnum == HolidayEffecDateTypeEnum.entryDate) {
            if (laborInfo != null && laborInfo.getEnterDate() == null) {
                return null;
            }
            if (laborInfo != null) {
                tempDate = laborInfo.getEnterDate();
            }
            if (laborInfo != null && (laborInfo.getEnterDate().getTime() > beginDate.getTime() && laborInfo.getEnterDate().getTime() < endDate.getTime() || laborInfo.getEnterDate().getTime() > endDate.getTime())) {
                effectDate = laborInfo.getEnterDate();
                return effectDate;
            }
        } else if (holidayEffecDateTypeEnum == HolidayEffecDateTypeEnum.probationFull) {
            if (laborInfo != null && laborInfo.getPlanFormalDate() == null && laborInfo.getActualFormalDate() == null && laborInfo.getEnterDate() == null) {
                return null;
            }
            if (laborInfo != null) {
                tempDate = laborInfo.getActualFormalDate();
                if (laborInfo.getActualFormalDate() == null) {
                    tempDate = laborInfo.getPlanFormalDate() != null ? laborInfo.getPlanFormalDate() : laborInfo.getEnterDate();
                }
                java.util.Date compareDate = laborInfo.getActualFormalDate();
                if (laborInfo.getActualFormalDate() == null) {
                    compareDate = laborInfo.getPlanFormalDate() != null ? laborInfo.getPlanFormalDate() : laborInfo.getEnterDate();
                }
                if (compareDate.getTime() > beginDate.getTime() && compareDate.getTime() < endDate.getTime() || compareDate.getTime() > endDate.getTime()) {
                    effectDate = laborInfo.getActualFormalDate();
                    if (laborInfo.getActualFormalDate() == null) {
                        effectDate = laborInfo.getPlanFormalDate() != null ? laborInfo.getPlanFormalDate() : laborInfo.getEnterDate();
                    }
                    return effectDate;
                }
            }
        } else if (holidayEffecDateTypeEnum == HolidayEffecDateTypeEnum.entryFullYear) {
            java.util.Date enterDateAfterYear;
            if (laborInfo != null && laborInfo.getEnterDate() == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            if (laborInfo != null) {
                cal.setTime(laborInfo.getEnterDate());
            }
            cal.set(1, cal.get(1) + 1);
            tempDate = enterDateAfterYear = cal.getTime();
        } else if (holidayEffecDateTypeEnum == HolidayEffecDateTypeEnum.custom) {
            java.util.Date enterDateAfterYear;
            int customValue = 0;
            if (holidayRuleInfo.getCustomValue() != null) {
                customValue = holidayRuleInfo.getCustomValue().intValue();
            }
            if (laborInfo.getEnterDate() == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(laborInfo.getEnterDate());
            cal.add(2, customValue);
            tempDate = enterDateAfterYear = cal.getTime();
        } else if (holidayEffecDateTypeEnum == HolidayEffecDateTypeEnum.childBirDate) {
            if (nextGenerationInfo != null && nextGenerationInfo.getBirthdayDate() != null) {
                java.util.Date enterDateAfterYear;
                Calendar cal = Calendar.getInstance();
                cal.setTime(nextGenerationInfo.getBirthdayDate());
                tempDate = enterDateAfterYear = cal.getTime();
            } else {
                try {
                    java.util.Date enterDateAfterYear;
                    PersonFamilyCollection personFamilyCollection = PersonFamilyFactory.getLocalInstance((Context)jobctx).getPersonFamilyCollection("where person.id ='" + personOtherInfoInfo.getPerson().getId().toString() + "' and relation.relationType =2");
                    if (personFamilyCollection == null || personFamilyCollection.size() <= 0) {
                        logger.error((Object)"------------------param exception.");
                        return null;
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(personFamilyCollection.get(0).getBirthday());
                    tempDate = enterDateAfterYear = cal.getTime();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        } else if (holidayEffecDateTypeEnum == HolidayEffecDateTypeEnum.marriageRegDate) {
            if (personOtherInfoInfo != null) {
                String id = personOtherInfoInfo.getId().toString();
                try {
                    personOtherInfoInfo = PersonOtherInfoFactory.getLocalInstance((Context)jobctx).getPersonOtherInfoInfo((IObjectPK)new ObjectUuidPK(id));
                    if (personOtherInfoInfo.getWedDate() != null) {
                        java.util.Date enterDateAfterYear;
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(personOtherInfoInfo.getWedDate());
                        tempDate = enterDateAfterYear = cal.getTime();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                logger.error((Object)"------------------param exception.");
                return null;
            }
        }
        if (tempDate != null && beginDate != null && tempDate.getTime() > beginDate.getTime()) {
            effectDate = tempDate;
            return effectDate;
        }
        return beginDate;
    }

    public static java.util.Date getDelayDateByDelayDate(HolidayRuleInfo holidayRuleInfo, PersonPositionInfo ppi, java.util.Date date) {
        DelayDateUnitEnum unit = holidayRuleInfo.getDelayDateUnit();
        BigDecimal amount = holidayRuleInfo.getDelayDate();
        if (date.getTime() >= new java.util.Date(8099, 11, 31).getTime()) {
            return date;
        }
        if (unit != null && amount != null) {
            if (unit == DelayDateUnitEnum.year) {
                return AtsDateUtils.dateAdd(date, 1, amount.intValue(), false);
            }
            if (unit == DelayDateUnitEnum.month) {
                return AtsDateUtils.dateAdd(date, 2, amount.intValue(), false);
            }
            if (unit == DelayDateUnitEnum.day) {
                return AtsDateUtils.dateAdd(date, 3, amount.intValue(), false);
            }
        }
        return date;
    }

    public static boolean checkIsValidHolidayLimit(Map<Object, Object> param, PersonPositionInfo personPositionInfo, HolidayRuleInfo holidayRuleInfo, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo otherInfo) {
        String existedDealType = StringUtils.cnulls((Object)param.get("existedDealType"));
        String isTran = StringUtils.cnulls((Object)param.get("transaction"));
        int convertType = 5;
        if (holidayRuleInfo.getConvertType() != null) {
            convertType = holidayRuleInfo.getConvertType().getValue();
        }
        boolean check = false;
        if ("1".equals(existedDealType) || !isTran.equals("") && convertType == 4) {
            check = true;
            if (!isTran.equals("") && 4 == convertType && !GenHolidayLimitUtil.checkIsJodNoConvert(personPositionInfo, holidayRuleInfo, laborInfo, otherInfo)) {
                check = false;
            }
        }
        return check;
    }

    private static boolean checkIsJodNoConvert(PersonPositionInfo ppi, HolidayRuleInfo holidayRuleInfo, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo otherInfo) {
        boolean flag = false;
        if (holidayRuleInfo.getHolidayRlStdType() != null) {
            HolidayRlStdTypeEnum rlStdType = holidayRuleInfo.getHolidayRlStdType();
            java.util.Date jobStartDate = null;
            if (otherInfo != null) {
                jobStartDate = otherInfo.getJobStartDate();
            }
            java.util.Date serveStartDate = null;
            if (ppi.getJoinGroupDate() != null) {
                serveStartDate = ppi.getJoinGroupDate();
            } else if (laborInfo != null) {
                serveStartDate = laborInfo.getEnterDate();
            }
            if (rlStdType.equals((Object)HolidayRlStdTypeEnum.workingAge)) {
                if (jobStartDate != null) {
                    flag = GenHolidayLimitUtil.checkIsCommonDay(jobStartDate);
                }
            } else if (rlStdType.equals((Object)HolidayRlStdTypeEnum.servingAge)) {
                if (serveStartDate != null) {
                    flag = GenHolidayLimitUtil.checkIsCommonDay(serveStartDate);
                }
            } else if (serveStartDate != null && jobStartDate != null) {
                flag = GenHolidayLimitUtil.checkIsCommonDay(serveStartDate) || GenHolidayLimitUtil.checkIsCommonDay(jobStartDate);
            }
        }
        return flag;
    }

    private static boolean checkIsCommonDay(java.util.Date jobStartDate) {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            date = dateFormat.parse(dateFormat.format(date));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(1, 2000);
            calendar.set(2, calendar.get(2));
            calendar.set(7, calendar.get(7));
            date = calendar.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        try {
            Calendar calendar1 = Calendar.getInstance();
            dateFormat = new SimpleDateFormat("yyyyMMdd");
            jobStartDate = dateFormat.parse(dateFormat.format(jobStartDate));
            calendar1.setTime(jobStartDate);
            calendar1.set(1, 2000);
            calendar1.set(2, calendar1.get(2));
            calendar1.set(7, calendar1.get(7));
            jobStartDate = calendar1.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return jobStartDate.getTime() == date.getTime();
    }

    public static HolidayPolicyInfo getHolidayPolicyByHolidayType(HolidayPolicyCollection holidayPolicyCollection, String holidayType) {
        HolidayPolicyInfo holidayPolicyInfo = null;
        if (holidayPolicyCollection != null) {
            int size = holidayPolicyCollection.size();
            for (int i = 0; i < size; ++i) {
                HolidayPolicyInfo tempPolicyInfo = holidayPolicyCollection.get(i);
                if (!holidayType.equals(tempPolicyInfo.getHolidayType().getId().toString())) continue;
                holidayPolicyInfo = tempPolicyInfo;
                break;
            }
        }
        return holidayPolicyInfo;
    }

    public static String genBosId(Context ctx, String bosType) {
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select newbosid('" + bosType + "')"));
            if (rowSet != null && rowSet.next()) {
                return rowSet.getString(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static IRowSet executeQueryToExcelPaging(String querySql, int rows, int page, int totalCount, Context ctx) throws Exception {
        String afterPagingSql = "";
        int dbType = AtsBaseUtils.getDbType(ctx);
        try {
            PagingHelper pageHelper = new PagingHelper();
            int length = rows;
            if (page * rows > totalCount) {
                length = totalCount - (page - 1) * rows;
            }
            afterPagingSql = pageHelper.getPagingSqlNoOptmize(dbType, querySql, (page - 1) * rows, length);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return GenHolidayLimitUtil.executeQuery(afterPagingSql, ctx);
    }

    public static IRowSet executeQuery(String sql, Context ctx) throws Exception {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rowSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getTotalCount(IRowSet rowSet) throws Exception {
        int totalCount = 0;
        while (rowSet.next()) {
            try {
                totalCount = rowSet.getInt(1);
            }
            catch (SQLException e) {
                throw e;
                return totalCount;
            }
        }
    }

    public static Object convertData(String value, String dataType) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && StringUtils.isEmpty((String)value)) {
            return value;
        }
        if (value.indexOf(",") > -1 || value.indexOf("\uff0c") > -1) {
            String[] str = value.split(",");
            if (str.length == 1) {
                str = value.split("\uff0c");
            }
            HashSet set = new HashSet();
            Collections.addAll(set, str);
            return set;
        }
        if ("String".equalsIgnoreCase(dataType) || "StringEnum".equalsIgnoreCase(dataType)) {
            return value;
        }
        if ("Date".equalsIgnoreCase(dataType)) {
            java.util.Date dateValue = null;
            try {
                dateValue = DateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return dateValue;
        }
        if ("Boolean".equalsIgnoreCase(dataType)) {
            return Integer.parseInt(value);
        }
        if ("Integer".equalsIgnoreCase(dataType) || "IntEnum".equalsIgnoreCase(dataType)) {
            return Integer.parseInt(value);
        }
        if ("BigDecimal".equalsIgnoreCase(dataType)) {
            return new BigDecimal(value);
        }
        return value;
    }

    public static BigDecimal getChangeLimitByUnit(BigDecimal standardLimit, HolidayPolicyInfo holidayPolicyInfo) {
        if (holidayPolicyInfo.isEnableMinAmt()) {
            double M = holidayPolicyInfo.getMinAmt().doubleValue();
            int minAmtMtd = holidayPolicyInfo.getMinAmtValueMtd().getValue();
            int ZNum = (int)(standardLimit.doubleValue() / M);
            double XSNum = standardLimit.doubleValue() % M;
            if (minAmtMtd == 1) {
                standardLimit = BigDecimal.valueOf(((double)ZNum + Math.floor(XSNum / M)) * M);
            } else if (minAmtMtd == 2) {
                standardLimit = BigDecimal.valueOf(((double)ZNum + Math.ceil(XSNum / M)) * M);
            } else if (minAmtMtd == 3) {
                standardLimit = BigDecimal.valueOf((double)((long)ZNum + Math.round(XSNum / M)) * M);
            }
            standardLimit = BigDecimal.valueOf(Math.floor(standardLimit.doubleValue() / M) * M);
        }
        return standardLimit;
    }

    public static String isHolidayLimitIntersect(Context ctx, String personId, String holidayPolicyId, String personName, String holidayTypeName, java.util.Date cycleBeginDate, java.util.Date cycleEndDate, String hrOrgUnitId) {
        if (null == holidayTypeName) {
            holidayTypeName = "";
        }
        if (null != cycleBeginDate && null != cycleEndDate) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID, FCYCLEBEGINDATE,FCYCLEENDDATE FROM T_HR_ATS_HOLIDAYLIMIT WHERE FPROPOSERID=? AND FHOLIDAYPOLICYID = ? AND FHRORGUNITID = ? AND FCYCLEBEGINDATE <= ? AND FCYCLEENDDATE >= ?", (Object[])new Object[]{personId, holidayPolicyId, hrOrgUnitId, new Timestamp(cycleEndDate.getTime()), new Timestamp(cycleBeginDate.getTime())});
                if (rs.next()) {
                    Date sysBeginDate = rs.getDate("FCYCLEBEGINDATE");
                    Date sysEndDate = rs.getDate("FCYCLEENDDATE");
                    return MLUtile.getRes((ResourceEnum)AtsFileResEnum.GenerateExistsPersonInSystemFail, ctx, personName, holidayTypeName, AtsDateUtils.dateShortToString(sysBeginDate) + "~" + AtsDateUtils.dateShortToString(sysEndDate), AtsDateUtils.dateShortToString(cycleBeginDate) + "~" + AtsDateUtils.dateShortToString(cycleEndDate));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String isHolidayLimitIntersectbyExists(Context ctx, String personId, String holidayPolicyId, String personName, String holidayTypeName, java.util.Date cycleBeginDate, java.util.Date cycleEndDate, String hrOrgUnitId, NextGenerationInfo nextGenerationInfo) {
        if (null == holidayTypeName) {
            holidayTypeName = "";
        }
        if (null != cycleBeginDate && null != cycleEndDate) {
            try {
                StringBuilder sql = new StringBuilder("SELECT FID, FCYCLEBEGINDATE,FCYCLEENDDATE FROM T_HR_ATS_HOLIDAYLIMIT WHERE FPROPOSERID=? AND FHOLIDAYPOLICYID = ? AND FHRORGUNITID = ? AND FCYCLEBEGINDATE <= ? AND FCYCLEENDDATE >= ?");
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(personId);
                params.add(holidayPolicyId);
                params.add(hrOrgUnitId);
                params.add(new Timestamp(cycleEndDate.getTime()));
                params.add(new Timestamp(cycleBeginDate.getTime()));
                if (nextGenerationInfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nextGenerationInfo.getId())) {
                    sql.append(" and FChildId=?");
                    params.add(nextGenerationInfo.getId());
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray(new Object[0]));
                while (rs.next()) {
                    Date sysBeginDate = rs.getDate("FCYCLEBEGINDATE");
                    Date sysEndDate = rs.getDate("FCYCLEENDDATE");
                    if (cycleBeginDate.compareTo(sysBeginDate) == 0 && cycleEndDate.compareTo(sysEndDate) == 0) continue;
                    return MLUtile.getRes((ResourceEnum)AtsFileResEnum.GenerateExistsPersonInSystemFail, ctx, personName, holidayTypeName, AtsDateUtils.dateShortToString(sysBeginDate) + "~" + AtsDateUtils.dateShortToString(sysEndDate), AtsDateUtils.dateShortToString(cycleBeginDate) + "~" + AtsDateUtils.dateShortToString(cycleEndDate));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String isOrgChange(Context ctx, String personId, String beginTime, String endTime) {
        try {
            AtsHolidayFileHisCollection fileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection(" where proposer.id='" + personId + "' and attendFileState=1 and  Effdt <= {ts '" + endTime + "'} and Leffdt >= {ts '" + beginTime + "'} order by effdt desc");
            if (fileHisCollection.size() >= 2 && !fileHisCollection.get(0).getHrOrgUnit().getId().toString().equals(fileHisCollection.get(1).getHrOrgUnit().getId().toString())) {
                return HRTimeWebUtils.dateShortToString(fileHisCollection.get(0).getEFFDT());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }
}

