/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.generate.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsDateCommonResEnum;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HRTimeWebUtils {
    public static String timestampToString(Timestamp timestamp) {
        String tsStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            tsStr = sdf.format(timestamp);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return tsStr;
    }

    public static String timestampToString2(Timestamp timestamp) {
        String tsStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            tsStr = sdf.format(timestamp);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return tsStr;
    }

    public static Timestamp string2Timestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat c = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            Date d = c.parse(tsStr);
            ts = new Timestamp(d.getTime());
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return ts;
    }

    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return ts;
    }

    public static Timestamp stringShortToTimestamp(String tsStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setLenient(false);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = new Timestamp(format.parse(tsStr).getTime());
        }
        catch (ParseException e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return ts;
    }

    public static Date stringToLongDate(String str) {
        Date date = new Date();
        if (str.indexOf("/") != -1) {
            str = str.replaceAll("/", "-");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return date;
    }

    public static Date stringToShortDate(String str) {
        Date date = new Date();
        if (str.indexOf("/") != -1) {
            str = str.replaceAll("/", "-");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return date;
    }

    public static String dateLongToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return dateStr;
    }

    public static String dateToString(Date date, String parameter) {
        String dateStr = "";
        if (StringUtils.isEmpty((CharSequence)parameter)) {
            parameter = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(parameter);
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return dateStr;
    }

    public static String dateShortToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return dateStr;
    }

    public static Timestamp dateToTimestamp(Date date) {
        Timestamp ts = new Timestamp(date.getTime());
        return ts;
    }

    public static Date timestampToDate(Timestamp temTimestamp) {
        Date date = new Date();
        try {
            date = temTimestamp;
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return date;
    }

    public static Map<String, String> getFirstDayLastDay(int year, int month) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        if (year >= 1900 && year <= 9999) {
            cal.set(1, year);
        }
        cal.set(2, month);
        cal.set(5, 1);
        cal.add(5, -1);
        Date lastDate = cal.getTime();
        cal.set(5, 1);
        Date firstDate = cal.getTime();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("firstDate", sf.format(firstDate));
        map.put("lastDate", sf.format(lastDate));
        return map;
    }

    public static long getDaysBetweenTwoDate(Date date2, Date date1) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        long days = 0L;
        try {
            long diff = date2.getTime() - date1.getTime();
            days = diff < 0L ? 0L : diff / 86400000L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return days;
    }

    public static int getMonthsBetweenTwoDate(Date date2, Date date1) {
        int month = (date2.getYear() - date1.getYear()) * 12 + date2.getMonth() - date1.getMonth() + 1;
        return month;
    }

    public static int getQuarterBetweenTwoDate(Date date2, Date date1) {
        int quarter = (date2.getYear() - date1.getYear()) * 4 + date2.getMonth() / 3 - date1.getMonth() / 3 + 1;
        return quarter;
    }

    public static String getBeforeDay(String someDay) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd").parse(someDay);
        }
        catch (ParseException e) {
            AtsCommonUtile.logFirstStack(e);
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - 1);
        String dayBefore = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayBefore;
    }

    public static Date getAfterOneDayTime(String curTime) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(curTime);
        }
        catch (ParseException e) {
            AtsCommonUtile.logFirstStack(e);
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + 1);
        return c.getTime();
    }

    public static Date getAfterOneHourTime(Date curTime, int val) {
        Calendar c = Calendar.getInstance();
        c.setTime(curTime);
        c.add(11, val);
        return c.getTime();
    }

    public static String getAfterDay(String someDay) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd").parse(someDay);
        }
        catch (ParseException e) {
            AtsCommonUtile.logFirstStack(e);
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + 1);
        String dayAfter = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayAfter;
    }

    public static String getAfterDay(String someDay, int n) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd").parse(someDay);
        }
        catch (ParseException e) {
            AtsCommonUtile.logFirstStack(e);
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + n);
        String dayAfter = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayAfter;
    }

    public static Date getAfterDay(Date someDay, int n) {
        Calendar c = Calendar.getInstance();
        c.setTime(someDay);
        int day = c.get(5);
        c.set(5, day + n);
        return c.getTime();
    }

    public static Date getNextYearDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        c.set(1, year + 1);
        return c.getTime();
    }

    public static String getDateOfWeek(String sDate) {
        try {
            String formater = "yyyy-MM-dd";
            SimpleDateFormat format = new SimpleDateFormat(formater);
            Date date = format.parse(sDate);
            format.applyPattern("E");
            return format.format(date);
        }
        catch (Exception ex) {
            System.out.println("HRTimeWebUtils  getDateOfWeek  " + ex.getMessage());
            return "";
        }
    }

    public static int getDateOfWeekForNum(Context ctx, String sDate) {
        try {
            int weekEn = 0;
            String formater = "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat(formater);
            Date date = sdf.parse(sDate);
            sdf.applyPattern("E");
            String week = sdf.format(date);
            if (MLUtile.getRes(AtsDateCommonResEnum.Monday, ctx).equals(week)) {
                weekEn = 1;
            } else if (MLUtile.getRes(AtsDateCommonResEnum.Tuesday, ctx).equals(week)) {
                weekEn = 2;
            } else if (MLUtile.getRes(AtsDateCommonResEnum.Wednesday, ctx).equals(week)) {
                weekEn = 3;
            } else if (MLUtile.getRes(AtsDateCommonResEnum.Thursday, ctx).equals(week)) {
                weekEn = 4;
            } else if (MLUtile.getRes(AtsDateCommonResEnum.Friday, ctx).equals(week)) {
                weekEn = 5;
            } else if (MLUtile.getRes(AtsDateCommonResEnum.Saturday, ctx).equals(week)) {
                weekEn = 6;
            } else if (MLUtile.getRes(AtsDateCommonResEnum.Sunday, ctx).equals(week)) {
                weekEn = 0;
            }
            return weekEn;
        }
        catch (Exception ex) {
            System.out.println("HRTimeWebUtils  getDateOfWeek  " + ex.getMessage());
            return 0;
        }
    }

    public static String getFullDateWeekTime(String sDate) {
        try {
            String formater = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat format = new SimpleDateFormat(formater);
            Date date = format.parse(sDate);
            format.applyPattern("yyyy-MM-dd E HH:mm:ss");
            return format.format(date);
        }
        catch (Exception ex) {
            System.out.println("HRTimeWebUtils  getFullDateWeekTime " + ex.getMessage());
            return "";
        }
    }

    public static String getCurentShortStringDate() {
        try {
            Date cudate = new Date();
            String formater = "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat(formater);
            String dateTemp = sdf.format(cudate);
            return dateTemp;
        }
        catch (Exception ex) {
            System.out.println("HRTimeWebUtils  getCurentShortStringDate " + ex.getMessage());
            return "";
        }
    }

    public static String getCurentLongStringDate() {
        try {
            Date cudate = new Date();
            String formater = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat sdf = new SimpleDateFormat(formater);
            String dateTemp = sdf.format(cudate);
            return dateTemp;
        }
        catch (Exception ex) {
            System.out.println("HRTimeWebUtils  getCurentLongStringDate " + ex.getMessage());
            return "";
        }
    }

    public static String getTimeCoincidence(Date beginTime1, Date endTime1, Date beginTime2, Date endTime2) {
        String coincidenceTime;
        long e2;
        long b1 = beginTime1 != null ? beginTime1.getTime() : 0L;
        long e1 = endTime1 != null ? endTime1.getTime() : 0L;
        long b2 = beginTime2 != null ? beginTime2.getTime() : 0L;
        long l = e2 = endTime2 != null ? endTime2.getTime() : 0L;
        if (b1 <= b2 && e1 >= e2) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference(endTime2, beginTime2);
        } else if (b1 >= b2 && e1 <= e2) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference(endTime1, beginTime1);
        } else if (b1 >= b2 && b1 < e2 && e2 <= e1) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference(endTime2, beginTime1);
        } else if (b1 <= b2 && e1 <= e2 && e1 > b2) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference(endTime1, beginTime2);
        } else if (e1 <= b2 || b1 >= e2) {
            coincidenceTime = "0";
        } else {
            coincidenceTime = "-1";
            System.out.println("Unexpected date combination,Could not calculate coincidence.");
        }
        return coincidenceTime;
    }

    public static String getTimeCoincidence2(Date beginTime1, Date endTime1, Date beginTime2, Date endTime2) {
        String coincidenceTime;
        long e2;
        long b1 = beginTime1 != null ? beginTime1.getTime() : 0L;
        long e1 = endTime1 != null ? endTime1.getTime() : 0L;
        long b2 = beginTime2 != null ? beginTime2.getTime() : 0L;
        long l = e2 = endTime2 != null ? endTime2.getTime() : 0L;
        if (b1 <= b2 && e1 >= e2) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference2(endTime2, beginTime2);
        } else if (b1 >= b2 && e1 <= e2) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference2(endTime1, beginTime1);
        } else if (b1 >= b2 && b1 < e2 && e2 <= e1) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference2(endTime2, beginTime1);
        } else if (b1 <= b2 && e1 <= e2 && e1 > b2) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference2(endTime1, beginTime2);
        } else if (e1 <= b2 || b1 >= e2) {
            coincidenceTime = "0";
        } else {
            coincidenceTime = "-1";
            System.out.println("Unexpected date combination,Could not calculate coincidence.");
        }
        return coincidenceTime;
    }

    public static String getTimeDifference(Date date1, Date date2) {
        StringBuffer df = new StringBuffer();
        if (date1 == null || date2 == null) {
            return df.toString();
        }
        try {
            double num = (double)(date1.getTime() - date2.getTime()) / 60000.0;
            num = BigDecimal.valueOf(num).setScale(2, 4).doubleValue();
            if (num > 0.0) {
                df.append(num);
            } else if (num == 0.0) {
                df.append(0);
            } else {
                df.append(-1);
            }
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return df.toString();
    }

    public static String getTimeDifference2(Date date1, Date date2) {
        StringBuffer df = new StringBuffer();
        if (date1 == null || date2 == null) {
            return df.toString();
        }
        try {
            long num = (date1.getTime() - date2.getTime()) / 60000L;
            if (num > 0L) {
                df.append(num);
            } else if (num == 0L) {
                df.append(0);
            } else {
                df.append(-1);
            }
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return df.toString();
    }

    public static long getTimeCoincidence(long b1, long e1, long b2, long e2) {
        long coincidenceTime = 0L;
        if (b1 <= b2 && e1 >= e2) {
            System.out.println("1 include 2");
            coincidenceTime = HRTimeWebUtils.getTimeDifference(e2, b2);
        } else if (b1 >= b2 && e1 <= e2) {
            System.out.println("2 inclued 1");
            coincidenceTime = HRTimeWebUtils.getTimeDifference(e1, b1);
        } else if (b1 >= b2 && b1 <= e2 && e2 <= e1) {
            System.out.println("intersect 1");
            coincidenceTime = HRTimeWebUtils.getTimeDifference(e2, b1);
        } else if (b1 <= b2 && e1 <= e2 && e1 > b2) {
            System.out.println("intersect 2");
            coincidenceTime = HRTimeWebUtils.getTimeDifference(e1, b2);
        } else if (e1 <= b2 || b1 >= e2) {
            coincidenceTime = 0L;
        } else {
            coincidenceTime = 0L;
            System.out.println("illegal date combine\uff01");
        }
        System.out.println("intersect count [" + coincidenceTime + "]min\u3002");
        return coincidenceTime;
    }

    public static long getTimeDifference(long time1, long time2) {
        return time1 - time2;
    }

    public static void main(String[] args) {
        Calendar cal = Calendar.getInstance();
        System.out.println(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
    }

    public static Timestamp stringToTimestamp(String tsStr, boolean errorToNull) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        if (errorToNull) {
            ts = null;
        }
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return ts;
    }

    public static Timestamp stringShortToTimestamp(String tsStr, boolean errorToNull) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setLenient(false);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        if (errorToNull) {
            ts = null;
        }
        try {
            ts = new Timestamp(format.parse(tsStr).getTime());
        }
        catch (ParseException e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return ts;
    }

    public static Date stringToLongDate(String str, boolean errorToNull) {
        Date date = new Date();
        if (errorToNull) {
            date = null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return date;
    }

    public static Date stringToShortDate(String str, boolean errorToNull) {
        Date date = new Date();
        if (errorToNull) {
            date = null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return date;
    }

    public static List getLeaveDateColl(Date beginTime, Date endTime) throws EASBizException, BOSException {
        ArrayList<Date> dateList = new ArrayList<Date>();
        beginTime = HRTimeWebUtils.stringToShortDate(HRTimeWebUtils.dateLongToString(beginTime));
        endTime = HRTimeWebUtils.stringToShortDate(HRTimeWebUtils.dateLongToString(endTime));
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(beginTime);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endTime);
        int temp = (int)((endTime.getTime() - beginTime.getTime()) / 86400000L + 1L);
        for (int i = 0; i < temp; ++i) {
            int year = beginCal.get(1);
            int month = beginCal.get(2);
            int day = beginCal.get(5);
            Date tempDate = new Date(year - 1900, month, day);
            dateList.add(tempDate);
            beginCal.add(5, 1);
        }
        return dateList;
    }

    public static Date getMonthFirstDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        Date firstDate = cal.getTime();
        return firstDate;
    }

    public static Date getMonthLastDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        Date lastDate = cal.getTime();
        return lastDate;
    }

    public static Date addMonth(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, months);
        Date lastDate = cal.getTime();
        return lastDate;
    }

    public static String getStringFromObject(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            return HRTimeWebUtils.dateLongToString((Date)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    public static Date getLongDateFromObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return HRTimeWebUtils.stringToLongDate(value.toString());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return null;
    }

    public static Date getShortDateFromObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return HRTimeWebUtils.stringToShortDate(value.toString());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return null;
    }

    public static List getLeaveBeforeAndAfterDateColl(Date beginTime, Date endTime) throws EASBizException, BOSException {
        ArrayList<Date> dateList = new ArrayList<Date>();
        beginTime = AtsDateUtils.getPreDay(beginTime);
        endTime = AtsDateUtils.getNextDay(endTime);
        beginTime = HRTimeWebUtils.stringToShortDate(HRTimeWebUtils.dateLongToString(beginTime));
        endTime = HRTimeWebUtils.stringToShortDate(HRTimeWebUtils.dateLongToString(endTime));
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(beginTime);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endTime);
        int temp = (int)((endTime.getTime() - beginTime.getTime()) / 86400000L + 1L);
        for (int i = 0; i < temp; ++i) {
            int year = beginCal.get(1);
            int month = beginCal.get(2);
            int day = beginCal.get(5);
            Date tempDate = new Date(year - 1900, month, day);
            dateList.add(tempDate);
            beginCal.add(5, 1);
        }
        return dateList;
    }

    public static Date getLastMonthFirstDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getLastMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static boolean compareTime(String timeStr, String timeStr1) {
        int timeMin1;
        int timeHour1;
        Time time1;
        int timeMin;
        int timeHour = Integer.parseInt(timeStr.split(":")[0]);
        Time time = new Time(timeHour, timeMin = Integer.parseInt(timeStr.split(":")[1]), 0);
        int i = time.compareTo(time1 = new Time(timeHour1 = Integer.parseInt(timeStr1.split(":")[0]), timeMin1 = Integer.parseInt(timeStr1.split(":")[1]), 0));
        return i >= 0;
    }

    public static List<String> getMonthBetween(String minDate, String maxDate) throws ParseException {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(sdf.parse(minDate));
        min.set(min.get(1), min.get(2), 1);
        max.setTime(sdf.parse(maxDate));
        max.set(max.get(1), max.get(2), 2);
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        return result;
    }

    public static Date addYear(Date date, int years) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        Date lastDate = cal.getTime();
        return lastDate;
    }
}

