/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.dayDayAttendance.cloud;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class XTServiceConfig {
    private static Logger logger = Logger.getLogger(XTServiceConfig.class);
    private static final String CONFIGFILE = "XTServiceConfig.xml";
    private static final String CONFIGITEM_XTINFO = "XTInfo";
    private static final String CONFIGITEM_DBINFO = "DbInfo";
    private static final String CONFIGITEM_PUBACCT = "PubAcct";
    protected static XTServiceConfig instance = new XTServiceConfig();
    private static XMLConfiguration configuration;
    private static Object lock;
    private static String xtMcloudUrl;
    private static String xtPushServerUrl;

    protected XTServiceConfig() {
        this.load();
    }

    public static XTServiceConfig getInstance() {
        return instance;
    }

    public XMLConfiguration getConfiguration() {
        this.reload();
        return configuration;
    }

    public ConfigurationItem getConfigurationItem(String configKey) {
        this.reload();
        return configuration.getConfigItem(configKey);
    }

    public ConfigurationItem getConfigurationItemByPath(String configPath) {
        this.reload();
        return configuration.getConfigItemByPath(configPath);
    }

    public Map<String, String> getXTInfoProperties() {
        this.reload();
        try {
            return this.getConfigurationItemByPath(CONFIGITEM_XTINFO).getProperties();
        }
        catch (Exception e) {
            logger.info((Object)"cann't find the properties:XTInfo");
            throw new RuntimeException("cann't find the properties:XTInfo");
        }
    }

    public String getContentType() {
        return this.getXTInfoProperties().get("xt.pubacct.connect.content.type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXTServerUrl() {
        if (!StringUtils.isEmpty((String)xtPushServerUrl)) {
            return xtPushServerUrl;
        }
        Object object = lock;
        synchronized (object) {
            if (!StringUtils.isEmpty((String)xtPushServerUrl)) {
                return xtPushServerUrl;
            }
            xtPushServerUrl = this.getXTInfoProperties().get("xt.pubacct.connect.server.url");
            if (StringUtils.isEmpty((String)xtPushServerUrl)) {
                xtPushServerUrl = "http://xunt.me/pubacc/pubsend";
            }
        }
        return xtPushServerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXTMcloudUrl() {
        if (!StringUtils.isEmpty((String)xtMcloudUrl)) {
            return xtMcloudUrl;
        }
        Object object = lock;
        synchronized (object) {
            if (!StringUtils.isEmpty((String)xtMcloudUrl)) {
                return xtMcloudUrl;
            }
            xtMcloudUrl = this.getXTInfoProperties().get("xt.mcloud.url");
            if (StringUtils.isEmpty((String)xtMcloudUrl)) {
                xtMcloudUrl = "http://mcloud.kingdee.com";
            }
        }
        return xtMcloudUrl;
    }

    public String getEidByDbCode(String dbCode) {
        this.reload();
        String eid = null;
        try {
            ConfigurationItem ct = this.getConfigurationItemByPath(CONFIGITEM_DBINFO);
            List cl = ct.getAllChildren();
            for (int i = 0; i < cl.size(); ++i) {
                ConfigurationItem item = (ConfigurationItem)cl.get(i);
                if (!dbCode.equals(item.getProperty("dbCode"))) continue;
                eid = item.getName();
                break;
            }
        }
        catch (Exception e) {
            logger.info((Object)"cann't find the properties:DbMap");
            throw new RuntimeException("cann't find the properties:DbMap");
        }
        return eid;
    }

    public Map<String, String> getDbInfoProperties(String eid) {
        this.reload();
        try {
            return this.getConfigurationItemByPath("DbInfo/" + eid).getProperties();
        }
        catch (Exception e) {
            logger.info((Object)"cann't find the properties:XTInfo");
            throw new RuntimeException("cann't find the properties:XTInfo");
        }
    }

    public String getDbInfoProperty(String eid, String key, String defaultValue) {
        this.reload();
        return this.getConfigurationItemByPath("DbInfo/" + eid).getProperty(key, defaultValue);
    }

    public int getDbType(String eid) {
        return Integer.parseInt(this.getDbInfoProperties(eid).get("dbType"));
    }

    public String getDbCode(String eid) {
        return this.getDbInfoProperties(eid).get("dbCode");
    }

    public String getSlnName(String eid) {
        return this.getDbInfoProperties(eid).get("slnName");
    }

    public String getLocale(String eid) {
        return this.getDbInfoProperties(eid).get("locale");
    }

    private ConfigurationItem getPubAcctProperties(String eid, String pubAcctName) {
        logger.info((Object)("getPubAcctProperties==pubAcctName" + pubAcctName));
        logger.info((Object)("getPubAcctProperties==eid" + eid));
        return this.getConfigurationItemByPath("PubAcct/" + eid + "/" + pubAcctName);
    }

    public String getPubAcctProperty(String eid, String pubAcctName, String key, String defaultValue) {
        logger.info((Object)("getPubAcctProperty==eid" + eid));
        logger.info((Object)("getPubAcctProperty==pubAcctName" + pubAcctName));
        logger.info((Object)("getPubAcctProperty==key" + key));
        return this.getPubAcctProperties(eid, pubAcctName).getProperty(key, defaultValue);
    }

    public String getPubCode(String eid, String pubAcctName) {
        return this.getPubAcctProperties(eid, pubAcctName).getProperty("code");
    }

    public String getPubKey(String eid, String pubAcctName) {
        return this.getPubAcctProperties(eid, pubAcctName).getProperty("pubKey");
    }

    public boolean getPubEnabled(String eid, String pubAcctName) {
        return Boolean.parseBoolean(this.getPubAcctProperties(eid, pubAcctName).getProperty("enabled"));
    }

    public String getPubTempFileDir(String eid, String pubAcctName) {
        return this.getPubAcctProperties(eid, pubAcctName).getProperty("xt.pubacct.local.server.dir");
    }

    public String getPubClean(String eid, String pubAcctName) {
        return this.getPubAcctProperties(eid, pubAcctName).getProperty("clean");
    }

    public String getPubkeyBypubaccid(String eid, String pubaccid) {
        String pubKey = null;
        logger.info((Object)("getPubkeyBypubaccid==eid" + eid));
        ConfigurationItem ct = this.getConfigurationItemByPath("PubAcct/" + eid);
        if (ct != null) {
            List cl = ct.getAllChildren();
            for (int i = 0; i < cl.size(); ++i) {
                ConfigurationItem item = (ConfigurationItem)cl.get(i);
                if (!pubaccid.equals(item.getProperty("code"))) continue;
                pubKey = item.getProperty("pubKey");
                break;
            }
        } else {
            logger.error((Object)("XTServiceConfig getPubkeyBypubaccid error:can not get pubKey of " + eid));
        }
        return pubKey;
    }

    public String getAppSecret(String appId) {
        return this.getConfigurationItemByPath("AppSecret").getProperty(appId);
    }

    private void load() {
        String propertiesPath = System.getProperty("eas.properties.dir");
        String fileName = propertiesPath + File.separator + CONFIGFILE;
        File configFile = new File(SHRCheck.checkFilePath((String)fileName));
        if (!configFile.exists()) {
            throw new RuntimeException("cann't find the config file!");
        }
        configuration = XMLConfiguration.getInstance((File)configFile);
    }

    protected void reload() {
    }

    static {
        lock = new Object();
        xtMcloudUrl = null;
        xtPushServerUrl = null;
    }
}

