/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.ChangeTypeEnum;
import com.kingdee.eas.hr.ats.HolidayFlowDetailCollection;
import com.kingdee.eas.hr.ats.HolidayFlowDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitBillTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitChangeType;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.LimitTypeEnum;
import com.kingdee.eas.hr.ats.app.AtsLeaveBillControllerBean;
import com.kingdee.eas.hr.ats.app.HolidayLimitDetailControllerBean;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillLimitServer;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.common.DataSaver;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class AtsLeaveBillLimit {
    private IDecimalPlaceStrategy decimalPlacesSystem = new DecimalPlaceOperationSystem();

    public AtsLeaveBillLimit() {
        if (null == this.decimalPlacesSystem) {
            this.decimalPlacesSystem = new DecimalPlaceOperationSystem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int operatorFreezeAndRemainLimitAndPreOverdraftLimit(Context ctx, HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws BOSException, EASBizException {
        AtsLeaveBillLimitServer atsLeaveBillLimitServer = new AtsLeaveBillLimitServer();
        AtsLeaveBillInfo billInfo = (AtsLeaveBillInfo)model;
        String hrOrgUnitId = billInfo.getHrOrgUnit().getId().toString();
        for (int k = 0; k < billInfo.getEntries().size(); ++k) {
            AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = billInfo.getEntries().get(k);
            BigDecimal leaveLength = atsLeaveBillEntryInfo.getLeaveLength();
            BigDecimal billLeaveLength = atsLeaveBillEntryInfo.getLeaveLength();
            String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
            Timestamp startTime = atsLeaveBillEntryInfo.getBeginTime();
            Timestamp endTime = atsLeaveBillEntryInfo.getEndTime();
            String holidayLimitDetailId = this.existsHolidayLimitDetail(ctx, atsLeaveBillEntryInfo);
            if (StringUtils.isNotEmpty((CharSequence)holidayLimitDetailId)) continue;
            String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
            HolidayPolicyInfo holidayPolicyInfo = AtsWebUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
            String holidayTypeId = null;
            if (holidayPolicyInfo != null) {
                holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
            }
            Map holidayLimitCollresMap = new HashMap();
            List<Object> holidayLimitCollresMapList = new ArrayList();
            try {
                boolean isElasticCalLen = atsLeaveBillEntryInfo.isIsElasticCalLen();
                holidayLimitCollresMapList = AtsServerUtils.getfiterHolidayLimitCollByLeavebillTimeNew(ctx, null, startTime, endTime, hrOrgUnitId, personId, holidayTypeId, holidayPolicyInfo, isElasticCalLen, leaveLength, 0.0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int resMapListIndex = 0; resMapListIndex < holidayLimitCollresMapList.size(); ++resMapListIndex) {
                int i;
                holidayLimitCollresMap = (Map)holidayLimitCollresMapList.get(resMapListIndex);
                HolidayLimitCollection holidayLimitCollection = null;
                holidayLimitCollection = (HolidayLimitCollection)((Object)holidayLimitCollresMap.get("holidayLimitCollectionSplit"));
                leaveLength = BigDecimal.valueOf((Double)holidayLimitCollresMap.get("leaveLengthWhole"));
                if (billLeaveLength.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (leaveLength.compareTo(billLeaveLength) > 0) {
                    leaveLength = billLeaveLength;
                    billLeaveLength = new BigDecimal(0);
                } else {
                    billLeaveLength = billLeaveLength.subtract(leaveLength);
                }
                if (holidayLimitCollection == null) {
                    HashMap<String, Object> mapBalance = new HashMap<String, Object>();
                    mapBalance.put("freezeLimit", leaveLength);
                    mapBalance.put("changeValue", leaveLength);
                    mapBalance.put("personId", personId);
                    mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                    this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo, HolidayLimitChangeType.freeze);
                    return 0;
                }
                holidayLimitCollection.sort("cyclebegindate");
                holidayLimitCollection.sort("delaydate");
                ctx.put((Object)(atsLeaveBillEntryInfo.getId().toString() + "_OperType"), (Object)"leaveBill");
                ctx.put((Object)(atsLeaveBillEntryInfo.getId().toString() + "_OperAction"), (Object)"submit");
                HashSet<String> holidayLimitIDSet = new HashSet<String>();
                for (i = 0; i < holidayLimitCollection.size(); ++i) {
                    holidayLimitIDSet.add(holidayLimitCollection.get(i).getId().toString());
                }
                try {
                    AtsLeaveBillLimitServer.acquireLock(ctx, holidayLimitIDSet);
                    for (i = 0; i < holidayLimitCollection.size(); ++i) {
                        HashMap<String, Object> mapBalance;
                        String holidayLimitId;
                        BigDecimal leaveLengthTemp;
                        if (leaveLength.compareTo(BigDecimal.ZERO) == -1) continue;
                        if (i == holidayLimitCollection.size() - 1) {
                            leaveLengthTemp = leaveLength;
                            holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                            mapBalance = new HashMap<String, Object>();
                            mapBalance.put("freezeLimit", leaveLengthTemp);
                            mapBalance.put("holidayLimitId", holidayLimitId);
                            mapBalance.put("changeValue", leaveLengthTemp);
                            mapBalance.put("personId", personId);
                            mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                            mapBalance.put("holidayTypeId", holidayTypeId);
                            mapBalance.put("hrOrgUnitId", billInfo.getHrOrgUnit().getId().toString());
                            mapBalance.put("billInfo", billInfo);
                            mapBalance.put("atsLeaveBillEntryInfo", atsLeaveBillEntryInfo);
                            atsLeaveBillLimitServer.updateFreezeRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                            this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo, HolidayLimitChangeType.freeze);
                            this.operatorPreOverdraftLimit(ctx, mapBalance);
                            leaveLength = leaveLength.subtract(leaveLengthTemp);
                            continue;
                        }
                        if (leaveLength.compareTo(holidayLimitCollection.get(i).getRemainLimit()) == 1) {
                            if (holidayLimitCollection.get(i).getRemainLimit().compareTo(BigDecimal.ZERO) != 1) continue;
                            leaveLengthTemp = holidayLimitCollection.get(i).getRemainLimit();
                            holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                            mapBalance = new HashMap();
                            mapBalance.put("freezeLimit", leaveLengthTemp);
                            mapBalance.put("holidayLimitId", holidayLimitId);
                            mapBalance.put("changeValue", leaveLengthTemp);
                            mapBalance.put("personId", personId);
                            mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                            mapBalance.put("holidayTypeId", holidayTypeId);
                            mapBalance.put("hrOrgUnitId", billInfo.getHrOrgUnit().getId().toString());
                            mapBalance.put("billInfo", billInfo);
                            mapBalance.put("atsLeaveBillEntryInfo", atsLeaveBillEntryInfo);
                            atsLeaveBillLimitServer.updateFreezeRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                            this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo, HolidayLimitChangeType.freeze);
                            this.operatorPreOverdraftLimit(ctx, mapBalance);
                            leaveLength = leaveLength.subtract(leaveLengthTemp);
                            continue;
                        }
                        leaveLengthTemp = leaveLength;
                        holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                        mapBalance = new HashMap();
                        mapBalance.put("freezeLimit", leaveLengthTemp);
                        mapBalance.put("holidayLimitId", holidayLimitId);
                        mapBalance.put("holidayTypeId", holidayTypeId);
                        mapBalance.put("hrOrgUnitId", billInfo.getHrOrgUnit().getId().toString());
                        mapBalance.put("changeValue", leaveLengthTemp);
                        mapBalance.put("personId", personId);
                        mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                        mapBalance.put("billInfo", billInfo);
                        mapBalance.put("atsLeaveBillEntryInfo", atsLeaveBillEntryInfo);
                        atsLeaveBillLimitServer.updateFreezeRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                        this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo, HolidayLimitChangeType.freeze);
                        this.operatorPreOverdraftLimit(ctx, mapBalance);
                        leaveLength = leaveLength.subtract(leaveLengthTemp);
                    }
                    continue;
                }
                finally {
                    for (String id : holidayLimitIDSet) {
                        Mutex.unlock((Context)ctx, (String)id);
                    }
                    ctx.remove((Object)(billInfo.getId().toString() + "_OperType"));
                    ctx.remove((Object)(billInfo.getId().toString() + "_OperAction"));
                }
            }
        }
        if (billInfo.getId() == null) {
            AtsLeaveBillControllerBean AtsLeaveBillControllerBean2 = new AtsLeaveBillControllerBean();
            AtsLeaveBillControllerBean2.save(ctx, (CoreBaseInfo)billInfo);
        }
        return 0;
    }

    public String existsHolidayLimitDetail(Context ctx, AtsLeaveBillEntryInfo billEntryInfo) throws BOSException {
        String holidayLimitDetailId = "";
        StringBuffer sqlQuery = new StringBuffer();
        if (billEntryInfo != null && billEntryInfo.getId() != null) {
            String personId = billEntryInfo.getPerson().getId().toString();
            sqlQuery.append("select Fid from  T_HR_ATS_HolidayLimitDetail ");
            sqlQuery.append(" where fLeaveBillEntryID = '");
            sqlQuery.append(billEntryInfo.getId().toString());
            sqlQuery.append("'");
            sqlQuery.append(" and FchangeType = '6'");
            sqlQuery.append(" and FPROPOSERId = '");
            sqlQuery.append(personId);
            sqlQuery.append("'");
            IRowSet row = null;
            row = DbUtil.executeQuery((Context)ctx, (String)sqlQuery.toString());
            try {
                while (row.next()) {
                    holidayLimitDetailId = row.getString("Fid");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return holidayLimitDetailId;
    }

    public int insertDataInfoToHolildayLimitDetail(Context ctx, Map<String, Object> mapBalance, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo atsLeaveBillEntryInfo, HolidayLimitChangeType holidayLimitChangeType) {
        int res = 0;
        HolidayLimitDetailControllerBean holidayLimitDetailControllerBean = new HolidayLimitDetailControllerBean();
        CoreBaseCollection colls = new CoreBaseCollection();
        HolidayLimitDetailInfo detailInfo = new HolidayLimitDetailInfo();
        String personId = (String)mapBalance.get("personId");
        PersonPositionInfo personPositionInfo = SHRBillUtil.getAdminOrgUnit(personId, ctx);
        detailInfo.setProposer(personPositionInfo.getPerson());
        detailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
        detailInfo.setPosition(personPositionInfo.getPrimaryPosition());
        PersonPositionInfo position = SHRBillUtil.getAdminOrgUnitAndHrOrgUnit(personId, ctx);
        HROrgUnitInfo hrInfo = null;
        hrInfo = position.getHrOrgUnit();
        detailInfo.setHrOrgUnit(hrInfo);
        Calendar cal = Calendar.getInstance();
        detailInfo.setYear(cal.get(1));
        detailInfo.setChangeDate(HRTimeWebUtils.dateToTimestamp(new Date()));
        detailInfo.setCreateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
        detailInfo.setChangeType(holidayLimitChangeType);
        detailInfo.setBillType(HolidayLimitBillTypeEnum.leaveBill);
        detailInfo.setLeaveBill(billInfo);
        detailInfo.setLeaveBillNumber(billInfo.getNumber());
        detailInfo.setLeaveBillEntry(atsLeaveBillEntryInfo);
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        if (holidayLimitId != null) {
            HolidayLimitInfo holidayLimitInfo = new HolidayLimitInfo();
            holidayLimitInfo.setId(BOSUuid.read((String)holidayLimitId));
            detailInfo.setHolidayLimit(holidayLimitInfo);
        }
        detailInfo.setChangeValue((BigDecimal)mapBalance.get("changeValue"));
        detailInfo.setChangeUnit((HolidayTypeUnitEnum)((Object)mapBalance.get("holidayPolicyUnit")));
        colls.add((CoreBaseInfo)detailInfo);
        try {
            holidayLimitDetailControllerBean.addnewBatchData(ctx, colls);
            res = 1;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return res;
    }

    public void operatorPreOverdraftLimit(Context ctx, Map mapBalance) throws BOSException, EASBizException {
        HashMap<String, Object> nextmapBalance;
        BigDecimal preOverdraftLimit;
        BigDecimal temp;
        AtsLeaveBillLimitServer atsLeaveBillLimitServer = new AtsLeaveBillLimitServer();
        AtsLeaveBillInfo atsLeaveBillInfo = (AtsLeaveBillInfo)mapBalance.get("billInfo");
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = (AtsLeaveBillEntryInfo)mapBalance.get("atsLeaveBillEntryInfo");
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        BigDecimal changeValue = (BigDecimal)mapBalance.get("changeValue");
        String hrOrgUnitId = (String)mapBalance.get("hrOrgUnitId");
        String holidayTypeId = (String)mapBalance.get("holidayTypeId");
        HolidayLimitInfo holidayLimitInfo = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitInfo(" where id='" + holidayLimitId + "'");
        String personId = holidayLimitInfo.getProposer().getId().toString();
        HolidayLimitCollection holidayLimitCollectionAll = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and holidayPolicy.holidayType='" + holidayTypeId + "' and hrOrgUnit.id='" + hrOrgUnitId + "'");
        holidayLimitCollectionAll.sort("cyclebegindate");
        holidayLimitCollectionAll.sort("delaydate");
        HolidayLimitInfo nextholidayLimitInfo = null;
        for (int i = 0; i < holidayLimitCollectionAll.size(); ++i) {
            if (!holidayLimitInfo.getId().equals((Object)holidayLimitCollectionAll.get(i).getId()) || i >= holidayLimitCollectionAll.size() - 1) continue;
            nextholidayLimitInfo = holidayLimitCollectionAll.get(i + 1);
        }
        String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
        HolidayPolicyInfo holidayPolicyInfoo = AtsWebUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
        if (holidayPolicyInfoo != null) {
            holidayTypeId = holidayPolicyInfoo.getHolidayType().getId().toString();
        }
        HolidayPolicyInfo holidayPolicyInfo = AtsWebUtils.getHolidayPolicyInfoByPersonIdAndHolidayType(ctx, personId, holidayTypeId);
        if (nextholidayLimitInfo == null && holidayPolicyInfo != null && holidayPolicyInfo.isIsOver() && holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) != 1) {
            temp = BigDecimal.valueOf(-1L);
            preOverdraftLimit = holidayLimitInfo.getRemainLimit().multiply(temp);
            if (preOverdraftLimit.compareTo(changeValue) == 1) {
                preOverdraftLimit = changeValue;
            }
            nextmapBalance = new HashMap<String, Object>();
            nextmapBalance.put("holidayLimitId", holidayLimitId);
            nextmapBalance.put("changeValue", preOverdraftLimit);
            nextmapBalance.put("personId", personId);
            nextmapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
            this.insertDataInfoToHolildayLimitDetail(ctx, nextmapBalance, atsLeaveBillInfo, atsLeaveBillEntryInfo, HolidayLimitChangeType.overdraft);
        }
        if (nextholidayLimitInfo != null && holidayPolicyInfo != null && holidayPolicyInfo.isIsOver() && holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) != 1) {
            temp = BigDecimal.valueOf(-1L);
            preOverdraftLimit = holidayLimitInfo.getRemainLimit().multiply(temp);
            if (preOverdraftLimit.compareTo(changeValue) == 1) {
                preOverdraftLimit = changeValue;
            }
            nextmapBalance = new HashMap();
            String nextholidayLimitId = nextholidayLimitInfo.getId().toString();
            nextmapBalance.put("preOverdraftLimit", preOverdraftLimit);
            nextmapBalance.put("holidayLimitId", nextholidayLimitId);
            nextmapBalance.put("changeValue", preOverdraftLimit);
            nextmapBalance.put("personId", personId);
            nextmapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
            if (holidayPolicyInfo.isIsOverAutoSub()) {
                atsLeaveBillLimitServer.updateOverDraftRemainLimitNew(ctx, nextmapBalance, atsLeaveBillInfo, atsLeaveBillEntryInfo);
            }
            this.insertDataInfoToHolildayLimitDetail(ctx, nextmapBalance, atsLeaveBillInfo, atsLeaveBillEntryInfo, HolidayLimitChangeType.overdraft);
        }
    }

    public void recordHolidayLimit(Context ctx, CoreBaseCollection collection, ChangeTypeEnum changeType, String billNumber) throws BOSException, EASBizException {
        HolidayFlowDetailCollection coll = new HolidayFlowDetailCollection();
        for (int i = 0; i < collection.size(); ++i) {
            HolidayLimitInfo info = (HolidayLimitInfo)collection.get(i);
            BigDecimal standLimit = info.getStandardLimit();
            BigDecimal addOrReduceLimit = info.getAddOrSubLimit();
            BigDecimal freezeLimit = info.getFreezeLimit();
            BigDecimal remainLimit = info.getRemainLimit();
            String id = info.getId() == null ? null : info.getId().toString();
            BigDecimal realStandLimit = new BigDecimal(0);
            BigDecimal realAddOrReduceLimit = new BigDecimal(0);
            BigDecimal realFreezeLimit = new BigDecimal(0);
            BigDecimal realRemainLimit = new BigDecimal(0);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                HolidayLimitCollection hColl = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection("where id = '" + id + "'");
                HolidayLimitInfo holidayLimitInfo = hColl != null && hColl.size() > 0 ? hColl.get(0) : info;
                realStandLimit = holidayLimitInfo.getStandardLimit();
                realAddOrReduceLimit = holidayLimitInfo.getAddOrSubLimit();
                realFreezeLimit = holidayLimitInfo.getFreezeLimit();
                realRemainLimit = holidayLimitInfo.getRemainLimit();
            }
            if (standLimit.compareTo(realStandLimit) > 0) {
                this.setHolidayFlowDetailColl(ctx, coll, LimitTypeEnum.standLimit, HolidayLimitChangeType.add, realStandLimit, standLimit.subtract(realStandLimit), standLimit, changeType, billNumber, info);
            } else if (standLimit.compareTo(realStandLimit) < 0) {
                this.setHolidayFlowDetailColl(ctx, coll, LimitTypeEnum.standLimit, HolidayLimitChangeType.sub, realStandLimit, standLimit.subtract(realStandLimit), standLimit, changeType, billNumber, info);
            }
            if (addOrReduceLimit.compareTo(realAddOrReduceLimit) > 0) {
                this.setHolidayFlowDetailColl(ctx, coll, LimitTypeEnum.addOrReduceLimit, HolidayLimitChangeType.add, realAddOrReduceLimit, addOrReduceLimit.subtract(realAddOrReduceLimit), addOrReduceLimit, changeType, billNumber, info);
            } else if (addOrReduceLimit.compareTo(realAddOrReduceLimit) < 0) {
                this.setHolidayFlowDetailColl(ctx, coll, LimitTypeEnum.addOrReduceLimit, HolidayLimitChangeType.sub, realAddOrReduceLimit, addOrReduceLimit.subtract(realAddOrReduceLimit), addOrReduceLimit, changeType, billNumber, info);
            }
            if (freezeLimit.compareTo(realFreezeLimit) > 0) {
                this.setHolidayFlowDetailColl(ctx, coll, LimitTypeEnum.freezeLimit, HolidayLimitChangeType.freeze, realFreezeLimit, freezeLimit.subtract(realFreezeLimit), freezeLimit, changeType, billNumber, info);
            } else if (freezeLimit.compareTo(realFreezeLimit) < 0) {
                this.setHolidayFlowDetailColl(ctx, coll, LimitTypeEnum.freezeLimit, HolidayLimitChangeType.reverse, realFreezeLimit, freezeLimit.subtract(realFreezeLimit), freezeLimit, changeType, billNumber, info);
            }
            if (remainLimit.compareTo(realRemainLimit) > 0) {
                this.setHolidayFlowDetailColl(ctx, coll, LimitTypeEnum.remainLimit, HolidayLimitChangeType.reverse, realRemainLimit, remainLimit.subtract(realRemainLimit), remainLimit, changeType, billNumber, info);
                continue;
            }
            if (remainLimit.compareTo(realRemainLimit) >= 0) continue;
            this.setHolidayFlowDetailColl(ctx, coll, LimitTypeEnum.remainLimit, HolidayLimitChangeType.deduction, realRemainLimit, remainLimit.subtract(realRemainLimit), remainLimit, changeType, billNumber, info);
        }
        DataSaver dataSaver = new DataSaver(ctx);
        dataSaver.save(coll);
    }

    public void setHolidayFlowDetailColl(Context ctx, HolidayFlowDetailCollection coll, LimitTypeEnum limitType, HolidayLimitChangeType changeType, BigDecimal sourceValue, BigDecimal changeValue, BigDecimal remainValue, ChangeTypeEnum type, String billNumber, HolidayLimitInfo info) {
        HolidayFlowDetailInfo holidayFlowDetailInfo = new HolidayFlowDetailInfo();
        holidayFlowDetailInfo.setType(type);
        holidayFlowDetailInfo.setLimitType(limitType);
        holidayFlowDetailInfo.setChangeType(changeType);
        holidayFlowDetailInfo.setSourceValue(sourceValue);
        holidayFlowDetailInfo.setChangeValue(changeValue);
        holidayFlowDetailInfo.setRemainValue(remainValue);
        holidayFlowDetailInfo.setBillNumber(billNumber);
        holidayFlowDetailInfo.setHolidayLimit(info);
        holidayFlowDetailInfo.setCreateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
        holidayFlowDetailInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        coll.add(holidayFlowDetailInfo);
    }
}

