/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AbstractAttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AtsAttenceCycleResEnum;
import com.kingdee.eas.hr.ats.AtsCanTripBillResEnum;
import com.kingdee.eas.hr.ats.AtsFillSignCardResEnum;
import com.kingdee.eas.hr.ats.AtsOverTimeBillResEnum;
import com.kingdee.eas.hr.ats.AtsTripBillResEnum;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodCollection;
import com.kingdee.eas.hr.ats.AttendancePeriodFactory;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.IAttendanceFile;
import com.kingdee.eas.hr.ats.WorkCalendarInfo;
import com.kingdee.eas.hr.ats.WorkCalendarItemCollection;
import com.kingdee.eas.hr.ats.WorkCalendarItemFactory;
import com.kingdee.eas.hr.ats.WorkCalendarItemInfo;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AttencePolicyFillHelper {
    public static final Logger logger = Logger.getLogger(AttencePolicyFillHelper.class);

    public static AttencePolicyInfo getAttencePolicyInfo(Context ctx, String personId, AttendanceFileInfo attendanceFile) {
        AttencePolicyInfo attencePolicyInfo;
        block9: {
            HashMap<String, AttencePolicyInfo> attencePolicyInfoMap = new HashMap<String, AttencePolicyInfo>();
            IAttendanceFile iAttendanceFile = null;
            attencePolicyInfo = null;
            try {
                iAttendanceFile = AttendanceFileFactory.getLocalInstance(ctx);
                if (attendanceFile == null) {
                    AttendanceFileCollection attendanceFileColl = null;
                    try {
                        attendanceFileColl = iAttendanceFile.getAttendanceFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    attendanceFile = attendanceFileColl != null && attendanceFileColl.size() > 0 ? attendanceFileColl.get(0) : null;
                }
                logger.info((Object)("personId......" + personId));
                logger.info((Object)("attendanceFile.size()......" + (attendanceFile == null ? 0 : attendanceFile.size())));
                if (attendanceFile == null || attendanceFile.getAttencePolicy() == null) break block9;
                String attencePolicyId = attendanceFile.getAttencePolicy().getId().toString();
                if (attencePolicyInfoMap.get(attencePolicyId) == null) {
                    try {
                        attencePolicyInfo = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyInfo((IObjectPK)new ObjectUuidPK(attencePolicyId));
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    attencePolicyInfoMap.put(attencePolicyId, attencePolicyInfo);
                    break block9;
                }
                attencePolicyInfo = (AttencePolicyInfo)attencePolicyInfoMap.get(attencePolicyId);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return attencePolicyInfo;
    }

    public static String validateByTimeControl(Context ctx, BigDecimal amount, FillAmountUnitEnum unit, Date applyDate, int flag, AttencePolicyInfo attencePolicyInfo, Date attendDate) {
        long time;
        String billErrorMsg = "";
        long l = time = attendDate != null ? attendDate.getTime() : -1L;
        if (flag == 1) {
            billErrorMsg = MLUtile.getRes(AtsTripBillResEnum.OverBillFillTime, ctx) + "!";
        }
        if (flag == 2) {
            billErrorMsg = MLUtile.getRes(AtsFillSignCardResEnum.OverFillAmount, ctx);
        }
        if (flag == 3) {
            billErrorMsg = MLUtile.getRes(AtsOverTimeBillResEnum.OverFillAmount, ctx);
        }
        String errorMsg = "";
        if (amount != null && unit != null) {
            Calendar cal = Calendar.getInstance();
            if (applyDate != null) {
                cal.setTime(applyDate);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (unit == FillAmountUnitEnum.year) {
                cal.set(1, cal.get(1) - amount.intValue());
            } else if (unit == FillAmountUnitEnum.month) {
                cal.set(2, cal.get(2) - amount.intValue());
            } else if (unit == FillAmountUnitEnum.day) {
                cal.set(5, cal.get(5) - amount.intValue());
            } else if (unit == FillAmountUnitEnum.daywork && attencePolicyInfo != null) {
                WorkCalendarInfo workCalendarInfo = attencePolicyInfo.getWorkCalendar();
                int workDayCount = 0;
                try {
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("dayType", (Object)0));
                    filterInfo.getFilterItems().add(new FilterItemInfo("calendarGroup", (Object)workCalendarInfo.getId()));
                    filterInfo.getFilterItems().add(new FilterItemInfo("DATE", (Object)sdf.parse(sdf.format(attendDate)), CompareType.GREATER_EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("DATE", (Object)applyDate, CompareType.LESS));
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(filterInfo);
                    workDayCount = WorkCalendarItemFactory.getLocalInstance(ctx).getCount(evi);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (workDayCount <= amount.intValue()) {
                    return errorMsg;
                }
            }
            Date date = AttencePolicyFillHelper.formatCalendar(cal);
            if (date != null && time < date.getTime()) {
                errorMsg = billErrorMsg;
            }
        }
        return errorMsg;
    }

    public static String validateByCycleControle(Context ctx, String personId, AttencePolicyInfo attencePolicyInfo, long time, Date applyDate, int cycleType, BigDecimal afterDay, int flag) {
        String errorString = "";
        String billString = "";
        FillAmountUnitEnum fillAmountUnitEnum = null;
        if (flag == 1) {
            billString = MLUtile.getRes(AtsTripBillResEnum.OverBillFillTime, ctx) + "!";
            fillAmountUnitEnum = attencePolicyInfo.getFillTripAfterDayUnit();
        } else if (flag == 2) {
            billString = MLUtile.getRes(AtsFillSignCardResEnum.OverFillAmount, ctx);
            fillAmountUnitEnum = attencePolicyInfo.getFillSignCardAfterDayUnit();
        } else if (flag == 3) {
            billString = MLUtile.getRes(AtsOverTimeBillResEnum.OverFillAmount, ctx);
            fillAmountUnitEnum = attencePolicyInfo.getFillOtAfterDayUnit();
        } else if (flag == 4) {
            billString = MLUtile.getRes(AtsCanTripBillResEnum.OverCanBillFillTime, ctx) + "!";
            fillAmountUnitEnum = attencePolicyInfo.getFillCanTripByCycleAUnit();
        }
        Calendar cal = Calendar.getInstance();
        if (applyDate != null) {
            cal.setTime(applyDate);
        }
        if (1 == cycleType) {
            int dayOfMonth = cal.get(5);
            if (dayOfMonth <= afterDay.intValue()) {
                cal.set(2, cal.get(2) - 1);
                Date preMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                if (time < preMonthFirstDay.getTime()) {
                    errorString = billString;
                }
            } else {
                Calendar curCal = Calendar.getInstance();
                Date curMonthFirstDay = HRTimeWebUtils.stringToShortDate(curCal.get(1) + "-" + (curCal.get(2) + 1) + "-01");
                if (time < curMonthFirstDay.getTime()) {
                    errorString = billString;
                }
            }
        } else if (2 == cycleType) {
            if (fillAmountUnitEnum != FillAmountUnitEnum.mouthEndDay) {
                String attendanceCycleId = "";
                if (attencePolicyInfo != null && attencePolicyInfo.getAttenceCycle() != null) {
                    AttendancePeriodInfo curPeriod;
                    attendanceCycleId = attencePolicyInfo.getAttenceCycle().getId().toString();
                    AttendancePeriodCollection attendancePeriodCollection = null;
                    try {
                        attendancePeriodCollection = AttendancePeriodFactory.getLocalInstance(ctx).getAttendancePeriodCollection(" where group.id = '" + attendanceCycleId + "' order by endDate DESC");
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    if (attendancePeriodCollection == null || attendancePeriodCollection.size() == 0) {
                        errorString = MLUtile.getRes(AtsAttenceCycleResEnum.LeakToCompleteAudit, ctx) + "!";
                        return errorString;
                    }
                    AbstractAttendancePeriodInfo prePeriod = null;
                    int preIndex = 0;
                    for (int j = 0; j < attendancePeriodCollection.size(); ++j) {
                        AttendancePeriodInfo attendancePeriodInfo = attendancePeriodCollection.get(j);
                        if (attendancePeriodInfo.getEndDate().getTime() > cal.getTime().getTime()) continue;
                        prePeriod = attendancePeriodInfo;
                        preIndex = j;
                        break;
                    }
                    AttendancePeriodInfo attendancePeriodInfo = curPeriod = preIndex - 1 >= 0 ? attendancePeriodCollection.get(preIndex - 1) : null;
                    if (prePeriod != null) {
                        Date currDate;
                        Date curPeriodStartDate;
                        Date startDate = prePeriod.getStartDate();
                        Date endDate = prePeriod.getEndDate();
                        Date addAfterDate = AtsDateUtils.dateAdd(endDate, 3, afterDay.intValue(), false);
                        Date date = curPeriodStartDate = curPeriod != null ? curPeriod.getStartDate() : null;
                        if (curPeriod != null && addAfterDate.getTime() > curPeriod.getEndDate().getTime()) {
                            addAfterDate = curPeriod.getEndDate();
                        }
                        if ((currDate = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5))).getTime() > addAfterDate.getTime()) {
                            if (curPeriodStartDate != null && time < curPeriodStartDate.getTime()) {
                                errorString = billString;
                            }
                        } else if (time < startDate.getTime()) {
                            errorString = billString;
                        }
                    }
                } else {
                    int dayOfMonth = cal.get(5);
                    if (dayOfMonth <= afterDay.intValue()) {
                        cal.set(2, cal.get(2) - 1);
                        Date preMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                        if (time < preMonthFirstDay.getTime()) {
                            errorString = billString;
                        }
                    } else {
                        Date curMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                        if (time < curMonthFirstDay.getTime()) {
                            errorString = billString;
                        }
                    }
                }
            } else if (attencePolicyInfo != null && attencePolicyInfo.getAttenceCycle() != null) {
                Boolean valid = true;
                try {
                    valid = AttencePolicyFillUtil.validMonthlyStatementDateByPerson(ctx, personId, afterDay.intValue(), AtsDateUtils.dateShortToString(new Date(time)), applyDate);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                if (!valid.booleanValue()) {
                    errorString = billString;
                }
            } else {
                int dayOfMonth = cal.get(5);
                if (dayOfMonth <= afterDay.intValue()) {
                    cal.set(2, cal.get(2) - 1);
                    Date preMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                    if (time < preMonthFirstDay.getTime()) {
                        errorString = billString;
                    }
                } else {
                    Date curMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                    if (time < curMonthFirstDay.getTime()) {
                        errorString = billString;
                    }
                }
            }
        }
        logger.info((Object)("validateByCycleControle......" + errorString));
        return errorString;
    }

    public static String validateByCycleControle(Context ctx, String personId, AttencePolicyInfo attencePolicyInfo, long time, int cycleType, BigDecimal afterDay, int flag) {
        return AttencePolicyFillHelper.validateByCycleControle(ctx, personId, attencePolicyInfo, time, null, cycleType, afterDay, flag);
    }

    public static Date formatCalendar(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(year + "-" + (month + 1) + "-" + day);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String dateObejectToLongString(Object object) throws BOSException, EASBizException {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Date) {
            return HRTimeWebUtils.dateLongToString((Date)object);
        }
        if (object instanceof Timestamp) {
            return HRTimeWebUtils.timestampToString((Timestamp)object);
        }
        return "";
    }

    public static int getRealDayCountFromWorkWorkCalendar(Context ctx, String workCalendarId, AttencePolicyInfo attencePolicyInfo, Date applyDate, int amount) {
        int daysBetweenTwoDate = amount;
        if (StringUtils.isNotBlank((CharSequence)workCalendarId)) {
            String applyDateString = HRTimeWebUtils.dateShortToString(applyDate);
            String oql = "select  date where calendarGroup='" + workCalendarId + "' and dayType='" + 0 + "'  and  date < { ts '" + applyDateString + "'} ORDER BY date desc";
            WorkCalendarItemCollection coll = null;
            try {
                coll = WorkCalendarItemFactory.getLocalInstance(ctx).getWorkCalendarItemCollection(oql);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll != null && amount > 0) {
                WorkCalendarItemInfo workCalendarItemInfo = coll.get(amount - 1);
                daysBetweenTwoDate = (int)AttencePolicyFillHelper.getDaysBetweenTwoDate(applyDate, workCalendarItemInfo.getDate());
            }
        }
        return daysBetweenTwoDate;
    }

    public static long getDaysBetweenTwoDate(Date date2, Date date1) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        long days = 0L;
        try {
            long diff = date2.getTime() - date1.getTime();
            days = diff < 0L ? 0L : diff / 86400000L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return days;
    }
}

