/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class SHRBillUtil {
    private static Logger logger = Logger.getLogger(SHRBillUtil.class);

    public static PersonInfo getCurrPersonInfoNew(Context ctx) {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo personInfo = user == null ? null : user.getPerson();
        return personInfo;
    }

    public static HROrgUnitInfo getCurrentHRUnitByAttFile(Context ctx, String personId) {
        HROrgUnitInfo hrOrgInfo = null;
        try {
            AttendanceFileCollection coll = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection("select hrOrgUnit.*,*  where proposer.id = '" + personId + "'");
            if (coll.size() > 0) {
                hrOrgInfo = coll.get(0).getHrOrgUnit();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return hrOrgInfo;
    }

    public static PersonInfo getPersonDetailInfo(String personID, Context ctx) {
        PersonInfo personInfo = null;
        if (personID == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("employeeType.id"));
        sic.add(new SelectorItemInfo("employeeType.name"));
        sic.add(new SelectorItemInfo("employeeType.number"));
        sic.add(new SelectorItemInfo("employeeClassify.id"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        try {
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personID), sic);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return personInfo;
    }

    public static PersonPositionInfo getAdminOrgUnit(String personID, Context ctx) {
        if (personID == null) {
            return null;
        }
        PersonPositionInfo personPositionInfo = null;
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("jobGrade.id,");
        oqlb.append("tryoutMonth,");
        oqlb.append("jobGrade.name,");
        oqlb.append("jobLevel.id,");
        oqlb.append("jobLevel.name,");
        oqlb.append("person.number,");
        oqlb.append("person.name,");
        oqlb.append("person.employeeType.name,");
        oqlb.append("personDep.id,");
        oqlb.append("personDep.name,");
        oqlb.append("personDep.number,");
        oqlb.append("personDep.longnumber,");
        oqlb.append("personDep.displayName,");
        oqlb.append("primaryPosition.id,");
        oqlb.append("primaryPosition.name,");
        oqlb.append("primaryPosition.number,");
        oqlb.append("primaryPosition.job.id,");
        oqlb.append("primaryPosition.job.name");
        oqlb.append(" where person.id='");
        oqlb.append(personID);
        oqlb.append("'");
        PersonPositionCollection c = null;
        try {
            c = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oqlb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"SHRBillUtil.getAdminOrgUnit err", (Throwable)e);
        }
        if (c != null && c.size() > 0) {
            personPositionInfo = c.get(0);
        }
        return personPositionInfo;
    }

    public static PersonPositionInfo getAdminOrgUnitAndHrOrgUnit(String personID, Context ctx) {
        if (personID == null) {
            return null;
        }
        PersonPositionInfo personPositionInfo = null;
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("jobGrade.id,");
        oqlb.append("tryoutMonth,");
        oqlb.append("jobGrade.name,");
        oqlb.append("jobLevel.id,");
        oqlb.append("jobLevel.name,");
        oqlb.append("person.name,");
        oqlb.append("person.employeeType.name,");
        oqlb.append("hrOrgUnit.id,");
        oqlb.append("hrOrgUnit.name,");
        oqlb.append("hrOrgUnit.number,");
        oqlb.append("personDep.id,");
        oqlb.append("personDep.name,");
        oqlb.append("personDep.number,");
        oqlb.append("personDep.displayName,");
        oqlb.append("primaryPosition.id,");
        oqlb.append("primaryPosition.name,");
        oqlb.append("primaryPosition.number,");
        oqlb.append("primaryPosition.job.id,");
        oqlb.append("primaryPosition.job.name");
        oqlb.append(" where person.id='");
        oqlb.append(personID);
        oqlb.append("'");
        PersonPositionCollection c = null;
        try {
            c = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oqlb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"SHRBillUtil.getAdminOrgUnitAndHrOrgUnit err", (Throwable)e);
        }
        if (c != null && c.size() > 0) {
            personPositionInfo = c.get(0);
        }
        return personPositionInfo;
    }

    public static EmpLaborRelationInfo getEmpLaborRelationInfo(String personId, Context ctx) {
        if (personId == null) {
            return null;
        }
        EmpLaborRelationInfo laborInfo = null;
        try {
            EmpLaborRelationCollection laborColl = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationCollection(" where person = '" + personId + "' order by createTime desc ");
            if (laborColl != null && laborColl.size() > 0) {
                laborInfo = laborColl.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return laborInfo;
    }

    public static PersonOtherInfoInfo getPersonOtherInfo(String personId, Context ctx) {
        if (personId == null) {
            return null;
        }
        PersonOtherInfoInfo otherInfo = null;
        try {
            PersonOtherInfoCollection otherInfoColl = PersonOtherInfoFactory.getLocalInstance((Context)ctx).getPersonOtherInfoCollection(" where person = '" + personId + "' ");
            if (otherInfoColl != null && otherInfoColl.size() > 0) {
                otherInfo = otherInfoColl.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return otherInfo;
    }
}

