/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsHolidayFileCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TimeUtil {
    public static boolean paramIsExist(Context ctx, String paramNum) throws BOSException, EASBizException {
        IParam iParam = ParamFactory.getLocalInstance((Context)ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("number", (Object)paramNum, CompareType.EQUALS));
        return iParam.exists(i);
    }

    public static String dateShortToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static String dateLongToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static String getDtAPMStr(Context ctx, Date date) {
        String dt = TimeUtil.dateShortToString(date);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        int h = calendar.get(11);
        dt = h <= 12 ? dt + MLUtile.getRes(AtsCommonResEnum.Am, ctx) : dt + MLUtile.getRes(AtsCommonResEnum.Pm, ctx);
        return dt;
    }

    public static Timestamp getBeginTimeStampNew(Context ctx, String timeOffDate, String personId) throws EASBizException, BOSException, UuidException, SQLException {
        String amBeginTime = " 09:00:00";
        String pmBeginTime = " 14:00:00";
        Map<String, Object> map = TimeUtil.getSetIsCtrlHalfDayOffNew(ctx, personId);
        if ("true".equalsIgnoreCase(map.get("isHalfDayOff").toString())) {
            String amb = map.get("amBeginTime").toString().length() == 5 ? map.get("amBeginTime").toString() + ":00" : map.get("amBeginTime").toString();
            String pmb = map.get("pmBeginTime").toString().length() == 5 ? map.get("pmBeginTime").toString() + ":00" : map.get("pmBeginTime").toString();
            amBeginTime = " " + amb;
            pmBeginTime = " " + pmb;
        }
        if (timeOffDate == null) {
            return null;
        }
        timeOffDate = timeOffDate.replaceAll("AM", amBeginTime).replaceAll("PM", pmBeginTime);
        return Timestamp.valueOf(timeOffDate);
    }

    public static Map<String, Object> getSetIsCtrlHalfDayOffNew(Context ctx, String personId) throws EASBizException, BOSException, UuidException, SQLException, EASBizException {
        PersonInfo personInfo = SHRBillUtil.getCurrPersonInfoNew(ctx);
        AtsHolidayFileCollection holidayFileColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        if (holidayFileColl.size() == 0) {
            throw new AtsFileBizException(AtsFileBizException.NOTEXISTEFFECTFILE);
        }
        if (holidayFileColl.get(0).getHolidayPolicySet() == null) {
            throw new AtsFileBizException(AtsFileBizException.NOTEXISTEFFECTPOLICYINHFILE);
        }
        HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" where id='" + holidayFileColl.get(0).getHolidayPolicySet().getId().toString() + "' ");
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("isHalfDayOff", holidayPolicySetInfo.isIsHalfDayOff());
        res.put("amBeginTime", holidayPolicySetInfo.getAmStartWorkTime());
        res.put("amEndTime", holidayPolicySetInfo.getAmEndWorkTime());
        res.put("pmBeginTime", holidayPolicySetInfo.getPmStartWorkTime());
        res.put("pmEndTime", holidayPolicySetInfo.getPmEndWorkTime());
        return res;
    }

    public static Timestamp getEndTimeStampNew(Context ctx, String timeOffDate, String personId) throws EASBizException, BOSException, UuidException, SQLException {
        if (timeOffDate == null) {
            return null;
        }
        String amEndTime = " 12:00:00";
        String pmEndTime = " 18:00:00";
        Map<String, Object> map = TimeUtil.getSetIsCtrlHalfDayOffNew(ctx, personId);
        if ("true".equalsIgnoreCase(map.get("isHalfDayOff").toString())) {
            String ame = map.get("amEndTime").toString().length() == 5 ? map.get("amEndTime").toString() + ":00" : map.get("amEndTime").toString();
            String pme = map.get("pmEndTime").toString().length() == 5 ? map.get("pmEndTime").toString() + ":00" : map.get("pmEndTime").toString();
            amEndTime = " " + ame;
            pmEndTime = " " + pme;
        }
        timeOffDate = timeOffDate.replaceAll("AM", amEndTime).replaceAll("PM", pmEndTime);
        return Timestamp.valueOf(timeOffDate);
    }

    public static String getHRUnitId(Context ctx) throws BOSException, SQLException {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        return hrInfo.getId() == null ? null : hrInfo.getId().toString();
    }
}

