/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.metasBuilder;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.util.backport.TreeSet;
import com.kingdee.eas.hr.ats.metasBuilder.ExceptMetasBuilder;
import com.kingdee.eas.hr.ats.metasBuilder.MetasBuilder;
import com.kingdee.eas.hr.ats.metasBuilder.MetasType;
import com.kingdee.eas.hr.ats.metasBuilder.ResMetasBuilder;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;

public class MetasFactory {
    JSONObject projectPosition = new JSONObject(7);

    public MetasFactory() {
        Properties codeChechConfig = new Properties();
        try {
            String path = SHRSyssettingUtil.getShrPropertiesPathByFileName((String)"codeCheckConfig.properties");
            codeChechConfig = SHRSyssettingUtil.getPropertiesFileByPath((String)SHRCheck.checkFilePath((String)path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String codePaths = codeChechConfig.getProperty("codePaths");
        for (String project : codePaths.split(";")) {
            int flagInd = project.indexOf(":");
            this.projectPosition.put(project.substring(0, flagInd), (Object)project.substring(flagInd + 1).replaceAll("\\\\", "/"));
        }
        this.projectPosition.put("javaPublishPath", (Object)codeChechConfig.getProperty("javaPublishPath"));
        this.projectPosition.put("MetasPublishPath", (Object)codeChechConfig.getProperty("MetasPublishPath"));
        this.projectPosition.put("packageName", (Object)codeChechConfig.getProperty("packageName"));
    }

    public void createException(JSONObject metaInfo, List<JSONObject> metaItemsInfo) {
        if (metaInfo == null || metaItemsInfo == null || metaItemsInfo.size() == 0) {
            return;
        }
        ExceptMetasBuilder exceptMetasBuilder = new ExceptMetasBuilder();
        exceptMetasBuilder.setMetasType(MetasType.bizException);
        exceptMetasBuilder.setMainCode(metaInfo.getIntValue("mainCode"));
        exceptMetasBuilder.setBosExceptionItems(metaItemsInfo);
        this.createMetaTitle(exceptMetasBuilder, metaInfo);
        try {
            exceptMetasBuilder.build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public void createResource(JSONObject metaInfo, JSONObject metaItemsInfo) {
        if (metaInfo == null || metaItemsInfo == null || metaItemsInfo.size() == 0) {
            return;
        }
        ResMetasBuilder builder = new ResMetasBuilder();
        builder.setMetasType(MetasType.i18nResource);
        builder.setBosResourceItems(metaItemsInfo);
        this.createMetaTitle(builder, metaInfo);
        try {
            builder.build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private void createMetaTitle(MetasBuilder metasBuilder, JSONObject metaInfo) {
        String name = metaInfo.getString("name");
        String alias = metaInfo.getString("alias");
        String descripe = metaInfo.getString("descripe");
        if (metasBuilder == null || StringUtils.isBlank((String)name)) {
            return;
        }
        metasBuilder.setPackageName(this.projectPosition.getString("packageName"));
        metasBuilder.setJavaPublishPath(this.projectPosition.getString("javaPublishPath"));
        metasBuilder.setMetasPublishPath(this.projectPosition.getString("MetasPublishPath"));
        metasBuilder.setName(name);
        metasBuilder.setAlias(alias);
        metasBuilder.setDescripe(descripe == null ? alias : descripe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void transJsFile(String path, Map<Integer, String> advices) {
        int index = path.indexOf("\\");
        String ProjectName = path.substring(0, index);
        if (path.substring(index + 1).startsWith("dev")) {
            path = path.substring(index + 1);
            index = path.indexOf("\\");
        }
        if (!this.projectPosition.containsKey((Object)ProjectName)) {
            return;
        }
        String[] proCodeArr = this.projectPosition.getString(ProjectName).split(",");
        String code = proCodeArr.length > 1 ? proCodeArr[1] : "UTF-8";
        path = proCodeArr[0].substring(0, proCodeArr[0].indexOf(ProjectName)) + path;
        if (advices == null || advices.isEmpty()) {
            return;
        }
        File sorceFile = new File(path);
        if (!sorceFile.exists()) {
            return;
        }
        File targetFile = new File(path + ".bak");
        Iterator findLineIt = new TreeSet(advices.keySet()).iterator();
        BufferedReader reader = null;
        FileWriterWithEncoding write = null;
        int curLine = 1;
        int findLine = (Integer)findLineIt.next();
        String advice = advices.get(findLine);
        try {
            String lineContent;
            write = new FileWriterWithEncoding(targetFile, code);
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sorceFile), code));
            while ((lineContent = reader.readLine()) != null) {
                if (curLine == findLine) {
                    write.write(lineContent.substring(0, lineContent.indexOf(lineContent.trim())) + advice);
                    if (findLineIt.hasNext()) {
                        findLine = (Integer)findLineIt.next();
                        advice = advices.get(findLine);
                    }
                } else {
                    write.write(lineContent);
                }
                write.write("\n");
                ++curLine;
            }
            this.closeIO((Closeable)write);
            this.closeIO(reader);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.closeIO((Closeable)write);
            this.closeIO(reader);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            this.closeIO((Closeable)write);
            this.closeIO(reader);
            {
                catch (Throwable throwable) {
                    this.closeIO((Closeable)write);
                    this.closeIO(reader);
                    throw throwable;
                }
            }
        }
        sorceFile.delete();
        targetFile.renameTo(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void transJavaFile(String path, Map<Integer, String> advices, Collection<String> importPackages) {
        int index = path.indexOf("\\");
        String ProjectName = path.substring(0, index);
        if (path.substring(index + 1).startsWith("dev")) {
            path = path.substring(index + 1);
            index = path.indexOf("\\");
        }
        if (!this.projectPosition.containsKey((Object)ProjectName)) {
            return;
        }
        String[] proCodeArr = this.projectPosition.getString(ProjectName).split(",");
        String code = proCodeArr.length > 1 ? proCodeArr[1] : "UTF-8";
        path = proCodeArr[0] + path.substring(path.indexOf("\\", index + 1));
        if (advices == null || advices.isEmpty()) {
            return;
        }
        File sorceFile = new File(path);
        if (!sorceFile.exists()) {
            return;
        }
        File targetFile = new File(path + ".bak");
        Iterator findLineIt = new TreeSet(advices.keySet()).iterator();
        BufferedReader reader = null;
        FileWriterWithEncoding write = null;
        int curLine = 1;
        int findLine = (Integer)findLineIt.next();
        String[] origiContent = advices.get(findLine).split("@#@%");
        ArrayList<String> packages = new ArrayList<String>();
        int importPackage = -1;
        try {
            String lineContent;
            write = new FileWriterWithEncoding(targetFile, code);
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sorceFile), code));
            while ((lineContent = reader.readLine()) != null) {
                if (importPackage == 0 && (lineContent.replaceAll("\\s+", "").startsWith("publicclass") || lineContent.replaceAll("\\s+", "").startsWith("/*"))) {
                    this.writeImportLabel((Writer)write, importPackages, packages, false);
                    importPackage = 1;
                }
                if (curLine >= findLine && curLine < findLine + 20 && (lineContent.replaceAll("\t|\\s+", "").startsWith(origiContent[1].replaceAll("\t|\\s+", "")) || lineContent.replaceAll("\t|\\s+", "").startsWith(origiContent[0].replaceAll("\t|\\s+", "")))) {
                    write.write(lineContent.substring(0, lineContent.indexOf(lineContent.trim())) + origiContent[0]);
                    if (findLineIt.hasNext()) {
                        findLine = (Integer)findLineIt.next();
                        origiContent = advices.get(findLine).split("@#@%");
                    }
                } else {
                    write.write(lineContent);
                }
                lineContent = lineContent.trim();
                if (importPackage == -1 && lineContent.startsWith("package ")) {
                    importPackage = 0;
                }
                if (importPackage == 0 && lineContent.startsWith("import ")) {
                    packages.add(lineContent);
                }
                write.write("\n");
                ++curLine;
            }
            this.closeIO((Closeable)write);
            this.closeIO(reader);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.closeIO((Closeable)write);
            this.closeIO(reader);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            this.closeIO((Closeable)write);
            this.closeIO(reader);
            {
                catch (Throwable throwable) {
                    this.closeIO((Closeable)write);
                    this.closeIO(reader);
                    throw throwable;
                }
            }
        }
        sorceFile.delete();
        targetFile.renameTo(new File(path));
    }

    private void writeImportLabel(Writer write, Collection<String> labels, List<String> importedPackages, boolean writeSqlUtile) throws IOException {
        String Mlutile = "import com.kingdee.eas.hr.ats.util.common.MLUtile;";
        if (writeSqlUtile && !importedPackages.contains(Mlutile)) {
            write.write("import com.kingdee.eas.hr.ats.util.common.MLUtile;\n\n");
            return;
        }
        if (labels == null || labels.isEmpty()) {
            return;
        }
        boolean hasChange = false;
        StringBuffer inContent = new StringBuffer();
        for (String label : labels) {
            if (label.toLowerCase(Locale.US).endsWith("resenum") && !importedPackages.contains(Mlutile)) {
                write.write(Mlutile);
                write.write("\n");
                hasChange = true;
                importedPackages.add(Mlutile);
            }
            inContent.append("import ").append(this.projectPosition.getString("packageName")).append(".").append(label).append(";");
            if (importedPackages.contains(inContent.toString())) continue;
            write.write(inContent.toString());
            hasChange = true;
            write.write("\n");
        }
        if (hasChange) {
            write.write("\n");
        }
    }

    private void closeIO(Closeable io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void transSOLFile(String path, Map<Integer, String> advices, Collection<String> importPackages) {
        int index = path.indexOf("\\");
        String ProjectName = path.substring(0, index);
        if (path.substring(index + 1).startsWith("dev")) {
            path = path.substring(index + 1);
            index = path.indexOf("\\");
        }
        if (!this.projectPosition.containsKey((Object)ProjectName)) {
            return;
        }
        String[] proCodeArr = this.projectPosition.getString(ProjectName).split(",");
        String code = proCodeArr.length > 1 ? proCodeArr[1] : "UTF-8";
        path = proCodeArr[0] + path.substring(path.indexOf("\\", index + 1));
        File sorceFile = new File(path);
        if (!sorceFile.exists()) {
            return;
        }
        File targetFile = new File(path + ".bak");
        Iterator findLineIt = new TreeSet(advices.keySet()).iterator();
        int findLine = (Integer)findLineIt.next();
        String[] origiContent = advices.get(findLine).split("@#@%");
        BufferedReader reader = null;
        FileWriterWithEncoding write = null;
        ArrayList<String> packages = new ArrayList<String>();
        int importPackage = -1;
        int curLine = 1;
        try {
            String lineContent;
            write = new FileWriterWithEncoding(targetFile, code);
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sorceFile), code));
            while ((lineContent = reader.readLine()) != null) {
                if (importPackage == 0 && (lineContent.replaceAll("\\s+", "").startsWith("publicclass") || lineContent.replaceAll("\\s+", "").startsWith("/*"))) {
                    this.writeImportLabel((Writer)write, null, packages, true);
                    importPackage = 1;
                }
                if (curLine >= findLine && curLine < findLine + 20 && (lineContent.replaceAll("\t", "").trim().equals(origiContent[1]) || lineContent.replaceAll("\t", "").trim().equals(origiContent[0]))) {
                    write.write(lineContent.substring(0, lineContent.indexOf(lineContent.trim())) + origiContent[0]);
                    if (findLineIt.hasNext()) {
                        findLine = (Integer)findLineIt.next();
                        origiContent = advices.get(findLine).split("@#@%");
                    }
                } else {
                    write.write(lineContent);
                }
                lineContent = lineContent.trim();
                if (importPackage == -1 && lineContent.startsWith("package ")) {
                    importPackage = 0;
                }
                if (importPackage == 0 && lineContent.startsWith("import ")) {
                    packages.add(lineContent);
                }
                write.write("\n");
                ++curLine;
            }
            write.flush();
            this.closeIO((Closeable)write);
            this.closeIO(reader);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.closeIO((Closeable)write);
            this.closeIO(reader);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            this.closeIO((Closeable)write);
            this.closeIO(reader);
            {
                catch (Throwable throwable) {
                    this.closeIO((Closeable)write);
                    this.closeIO(reader);
                    throw throwable;
                }
            }
        }
        sorceFile.delete();
        targetFile.renameTo(new File(path));
    }

    public JSONObject getProjectPosition() {
        return this.projectPosition;
    }

    public void setProjectPosition(JSONObject projectPosition) {
        this.projectPosition = projectPosition;
    }
}

