/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.result;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsNounCommonResEnum;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsTakeWorkingFactory;
import com.kingdee.eas.hr.ats.AtsTakeWorkingInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodCollection;
import com.kingdee.eas.hr.ats.AttendancePeriodFactory;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.BillSubmitTypeEnum;
import com.kingdee.eas.hr.ats.GetValueMtdAmtEnum;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayLimitStatus;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.IAtsOverTimeBill;
import com.kingdee.eas.hr.ats.IAtsOverTimeBillEntry;
import com.kingdee.eas.hr.ats.IAtsTakeWorking;
import com.kingdee.eas.hr.ats.IAttendancePeriod;
import com.kingdee.eas.hr.ats.IHolidayPolicy;
import com.kingdee.eas.hr.ats.OverTimeCompensFactory;
import com.kingdee.eas.hr.ats.OverTimeCompensInfo;
import com.kingdee.eas.hr.ats.OverTimeCreateTag;
import com.kingdee.eas.hr.ats.OverTimeTypeFactory;
import com.kingdee.eas.hr.ats.OverTimeTypeInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.TakeWoring;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.takeWorkLimit.util.TakeWorkLimitUtils;
import com.kingdee.eas.hr.ats.util.AtsAttendanceFileUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CalculateTakeWorking {
    private Logger logger = Logger.getLogger(CalculateTakeWorking.class);
    private IHolidayPolicy iPolicy;
    private IAtsTakeWorking iWorking;
    private IAtsOverTimeBillEntry iOverTimeBill;
    private IAtsOverTimeBill iOverTime;
    private IAttendancePeriod iAttendancePeriod;
    private Context ctx;

    public CalculateTakeWorking(Context ctx) {
        this.ctx = ctx;
        try {
            this.iPolicy = HolidayPolicyFactory.getLocalInstance(ctx);
            this.iWorking = AtsTakeWorkingFactory.getLocalInstance(ctx);
            this.iOverTimeBill = AtsOverTimeBillEntryFactory.getLocalInstance(ctx);
            this.iOverTime = AtsOverTimeBillFactory.getLocalInstance(ctx);
            this.iAttendancePeriod = AttendancePeriodFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            this.logger.error((Object)("CalculateTakeWorking.class init fail,reason\uff1a" + (Object)((Object)e)));
        }
    }

    public void generateAtsOverTimeBill(Map entryMap) throws BOSException, SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("=====generateAtsOverTimeBill param" + entryMap.toString()));
        }
        if (entryMap == null || entryMap.isEmpty()) {
            return;
        }
        if (entryMap.get("otDate") == null || entryMap.get("startTime") == null || entryMap.get("endTime") == null || entryMap.get("realStartTime") == null || entryMap.get("realEndTime") == null) {
            this.logger.error((Object)"date params include null!");
            return;
        }
        String personId = (String)entryMap.get("personId");
        if (this.isExistUserCreateBill(personId, AtsDateUtils.stringToShortDate((String)entryMap.get("startTime")))) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("there has exist ot bill commited by person \uff1a" + personId + ",startTime:" + (String)entryMap.get("startTime")));
            }
            return;
        }
        AtsOverTimeBillEntryInfo newEntryInfo = new AtsOverTimeBillEntryInfo();
        OverTimeTypeInfo typeInfo = null;
        OverTimeCompensInfo compensInfo = null;
        if (entryMap.get("realOTTime") == null || ((BigDecimal)entryMap.get("realOTTime")).doubleValue() < 0.0) {
            entryMap.put("realOTTime", new BigDecimal(0));
        }
        AtsOverTimeBillEntryInfo oldEntryInfo = this.getOldEntry(personId, AtsDateUtils.stringToShortDate((String)entryMap.get("startTime")));
        if (entryMap.get("applyOTTime") == null || ((BigDecimal)entryMap.get("applyOTTime")).doubleValue() < 0.0) {
            entryMap.put("applyOTTime", new BigDecimal(0));
        }
        if (entryMap.get("otCompens") == null) {
            entryMap.put("otCompens", "zkbt5bMLQ3ehUivmKbtBOqlrTmA=");
        } else if ("AERg0TIcSnaM40EKvJCdRKlrTmA=".equals(entryMap.get("otCompens"))) {
            newEntryInfo.setCalculateState(false);
        }
        try {
            compensInfo = OverTimeCompensFactory.getLocalInstance(this.ctx).getOverTimeCompensInfo((IObjectPK)new ObjectUuidPK((String)entryMap.get("otCompens")));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        if (oldEntryInfo != null) {
            this.updateEntryInfo(oldEntryInfo, entryMap, compensInfo);
            return;
        }
        if (oldEntryInfo == null && ((BigDecimal)entryMap.get("realOTTime")).doubleValue() <= 0.0) {
            return;
        }
        newEntryInfo.setOtDate(AtsDateUtils.stringToShortDate((String)entryMap.get("otDate")));
        newEntryInfo.setStartTime(AtsDateUtils.stringToTimestamp((String)entryMap.get("startTime")));
        newEntryInfo.setEndTime(AtsDateUtils.stringToTimestamp((String)entryMap.get("endTime")));
        newEntryInfo.setApplyOTTime((BigDecimal)entryMap.get("applyOTTime"));
        newEntryInfo.setRestTime(entryMap.get("restTime") == null ? null : Integer.valueOf(((BigDecimal)entryMap.get("restTime")).intValue()));
        newEntryInfo.setRealOTTime((BigDecimal)entryMap.get("realOTTime"));
        newEntryInfo.setRealStartTime(AtsDateUtils.stringToTimestamp((String)entryMap.get("realStartTime")));
        newEntryInfo.setRealEndTime(AtsDateUtils.stringToTimestamp((String)entryMap.get("realEndTime")));
        newEntryInfo.setDescription(MLUtile.getRes(AtsNounCommonResEnum.GenerateBackMission, this.ctx));
        newEntryInfo.setCreateTag(OverTimeCreateTag.backjobCreate);
        try {
            if (0 == (Integer)entryMap.get("otType")) {
                typeInfo = OverTimeTypeFactory.getLocalInstance(this.ctx).getOverTimeTypeInfo((IObjectPK)new ObjectUuidPK("rBy0u1YgQ9C1OxcM85mxyY6C/nU="));
            } else if (1 == (Integer)entryMap.get("otType")) {
                typeInfo = OverTimeTypeFactory.getLocalInstance(this.ctx).getOverTimeTypeInfo((IObjectPK)new ObjectUuidPK("zr+ur5D4RA+2bdVZ2VPqp46C/nU="));
            } else if (2 == (Integer)entryMap.get("otType")) {
                typeInfo = OverTimeTypeFactory.getLocalInstance(this.ctx).getOverTimeTypeInfo((IObjectPK)new ObjectUuidPK("sRWUOt7sRpOY0TCo6NMqGY6C/nU="));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (typeInfo == null) {
            this.logger.error((Object)("person:" + personId + " can  not find otType"));
            return;
        }
        newEntryInfo.setOtType(typeInfo);
        newEntryInfo.setOtReason(null);
        if (compensInfo == null) {
            this.logger.error((Object)("person:" + personId + " can't find otCompen type"));
            return;
        }
        newEntryInfo.setOtCompens(compensInfo);
        AttendanceFileInfo attendanceFileInfo = AtsAttendanceFileUtils.getAttendanceFile(this.ctx, personId);
        newEntryInfo.setPerson(attendanceFileInfo.getProposer());
        newEntryInfo.setAdminOrgUnit(attendanceFileInfo.getAdminOrgUnit());
        newEntryInfo.setPosition(attendanceFileInfo.getPosition());
        AtsOverTimeBillInfo billInfo = new AtsOverTimeBillInfo();
        PersonPositionInfo personPositonInfo = SHRBillServerUtil.getAdminOrgUnitAndHrOrgUnit(this.ctx, personId);
        billInfo.setProposer(personPositonInfo == null ? null : personPositonInfo.getPerson());
        billInfo.setApplyDate(new java.util.Date());
        billInfo.setHrOrgUnit(personPositonInfo == null ? null : personPositonInfo.getHrOrgUnit());
        billInfo.setAdminOrg(personPositonInfo == null ? null : personPositonInfo.getPersonDep());
        billInfo.setNumber("JBD_" + newEntryInfo.getPerson().getNumber() + "_" + newEntryInfo.getStartTime());
        billInfo.setBillSubmitType(BillSubmitTypeEnum.common);
        billInfo.setApproveType(ApproveTypeEnum.DIRECT);
        billInfo.setBillState(HRBillStateEnum.AUDITED);
        billInfo.setIsMultiEntry(false);
        billInfo.getEntries().add(newEntryInfo);
        try {
            this.iOverTime.addnew(billInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void generateTakeWorkingLimit(List<AtsOverTimeBillInfo> oldBillList, List<AtsOverTimeBillInfo> newBillList, Map<String, String> scheduleResultMap, Map<Object, Object> globalMap) throws EASBizException, BOSException {
        this.generateTakeWorkingLimit(oldBillList, newBillList, scheduleResultMap, BigDecimal.valueOf(8L), globalMap);
    }

    public void generateTakeWorkingLimit(List<AtsOverTimeBillInfo> oldBillList, List<AtsOverTimeBillInfo> newBillList, Map<String, String> scheduleResultMap, BigDecimal standardHour, Map<Object, Object> globalMap) throws EASBizException, BOSException {
        this.logger.info((Object)("transmit data=====generateTakeWorkingLimit params" + newBillList.toString()));
        String personIds = "";
        HashSet<String> allPersonSet = new HashSet<String>();
        if (newBillList == null || newBillList.isEmpty()) {
            return;
        }
        for (AtsOverTimeBillInfo temp : newBillList) {
            AtsOverTimeBillEntryInfo billEntryInfo = temp.getEntries().get(0);
            String personTemp = billEntryInfo.getPerson() == null ? null : billEntryInfo.getPerson().getId().toString();
            if (!StringUtils.isNotEmpty((String)personTemp)) continue;
            personIds = personIds + "'" + personTemp + "',";
            allPersonSet.add(personTemp);
        }
        if (StringUtils.isNotBlank((String)personIds)) {
            personIds = personIds.substring(0, personIds.length() - 1);
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("select distinct attfile.fproposerid proposerId, policy.fid policyId ,takeWorking.Fid workingId ").append("from T_HR_ATS_attendanceFile attFile ").append("inner join t_hr_ats_holidaypolicySet policySet  on attfile.fholidaypolicysetid = policySet.Fid ").append("inner join t_hr_ats_holidaypolicy policy on policySet.Fid = policy.fholidaypolicysetid ").append("inner join t_hr_ats_holidayType holidayType  on policy.fholidaytypeid = holidayType.Fid and holidayType.Fid = ? ").append("inner join t_hr_ats_takeWorking takeWorking on policy.ftakeworkingruleid = takeWorking.Fid ").append("where attfile.fproposerid in (" + personIds + ")");
            Object[] objects = new Object[]{"+ZM5jTmrS0KHCjDSYGcFLf0tUpg="};
            String policyId = "";
            String workingId = "";
            String proposerId = "";
            HashMap<String, HolidayPolicyInfo> existPolicyMap = new HashMap<String, HolidayPolicyInfo>();
            HashMap<String, AtsTakeWorkingInfo> existTakeWorkMap = new HashMap<String, AtsTakeWorkingInfo>();
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])objects);
                if (rowSet != null) {
                    while (rowSet.next()) {
                        policyId = rowSet.getString("policyId");
                        workingId = rowSet.getString("workingId");
                        proposerId = rowSet.getString("proposerId");
                        allPersonSet.remove(proposerId);
                        existTakeWorkMap.put(proposerId, this.iWorking.getAtsTakeWorkingInfo((IObjectPK)new ObjectUuidPK(workingId)));
                        existPolicyMap.put(proposerId, this.iPolicy.getHolidayPolicyInfo((IObjectPK)new ObjectUuidPK(policyId)));
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (!allPersonSet.isEmpty()) {
                this.logger.info((Object)("pesonID" + ((Object)allPersonSet).toString() + " has not holiday limit relate to takeWork"));
            }
            for (AtsOverTimeBillInfo billInfo : newBillList) {
                String otType;
                AtsOverTimeBillEntryInfo entryInfo = billInfo.getEntries().get(0);
                String personIdTemp = entryInfo.getPerson().getId().toString();
                HolidayPolicyInfo policyInfo = (HolidayPolicyInfo)existPolicyMap.get(personIdTemp);
                AtsTakeWorkingInfo workInfo = (AtsTakeWorkingInfo)existTakeWorkMap.get(personIdTemp);
                String string = otType = entryInfo != null && entryInfo.getOtType() != null && entryInfo.getOtType().getId() != null ? entryInfo.getOtType().getId().toString() : "";
                if (policyInfo != null && workInfo != null) {
                    BigDecimal workRate = this.getRate(otType, workInfo);
                    if (workRate.compareTo(BigDecimal.ZERO) == 0) continue;
                    this.handlerTakeWorking(policyInfo, workInfo, billInfo, oldBillList, standardHour, globalMap);
                    continue;
                }
                this.logger.info((Object)("personId\uff1a" + personIdTemp + " holiday policy or takeWork rule or leave bill number\uff1a" + billInfo.getNumber() + ",it's otCompens is not takeWork"));
            }
        }
    }

    private void handlerTakeWorking(HolidayPolicyInfo policyInfo, AtsTakeWorkingInfo workInfo, AtsOverTimeBillInfo billInfo, List<AtsOverTimeBillInfo> oldBillList, BigDecimal standardHour, Map<Object, Object> globalMap) {
        AtsOverTimeBillEntryInfo billEntryInfo = billInfo.getEntries().get(0);
        java.util.Date otDate = billEntryInfo.getOtDate();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cycleBeginDate", (Object)otDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("cycleEndDate", (Object)otDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("holidayPolicy.id", (Object)policyInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)billEntryInfo.getPerson().getId().toString(), CompareType.EQUALS));
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("standardLimit"));
        evi.getSelector().add(new SelectorItemInfo("realLimit"));
        evi.getSelector().add(new SelectorItemInfo("remainLimit"));
        SorterItemInfo sorterItem = new SorterItemInfo("createTime");
        sorterItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItem);
        HolidayLimitCollection limitList = null;
        try {
            limitList = HolidayLimitFactory.getLocalInstance(this.ctx).getHolidayLimitCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (limitList != null && !limitList.isEmpty()) {
            this.updateTakeWorkingLimit(policyInfo, limitList, billInfo, oldBillList, workInfo, standardHour, globalMap);
        } else if (billInfo.getEntries().get(0).getRealOTTime().doubleValue() > 0.0 && "AERg0TIcSnaM40EKvJCdRKlrTmA=".equals(billInfo.getEntries().get(0).getOtCompens().getId().toString())) {
            this.insertTakeWorkingLimit(policyInfo, workInfo, billInfo, standardHour, globalMap);
        }
    }

    private void updateTakeWorkingLimit(HolidayPolicyInfo policyInfo, HolidayLimitCollection limitList, AtsOverTimeBillInfo billInfo, List<AtsOverTimeBillInfo> oldBillList, AtsTakeWorkingInfo workInfo, BigDecimal standardHour, Map<Object, Object> globalMap) {
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        String personId = String.valueOf(globalMap.get("personId"));
        String date = String.valueOf(globalMap.get("attenceDate"));
        String key = personId + "_" + date;
        String endDate = (String)globalMap.get("endDate");
        AttendanceFileInfo fileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(key);
        Map fileInfoSizeMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile_Size");
        HashSet fileInfoSet = (HashSet)fileInfoSizeMap.get(personId);
        String hrOrgUnitId = null;
        if (fileInfo.getHrOrgUnit() != null && fileInfo.getHrOrgUnit().getId() != null) {
            hrOrgUnitId = fileInfo.getHrOrgUnit().getId().toString();
        }
        java.util.Date attenceDate = AtsDateUtils.stringToShortDate(date);
        java.util.Date leffDate = fileInfo.getLEFFDT();
        java.util.Date periodEndDate = AtsDateUtils.stringToShortDate(endDate);
        Map parameterMap = (Map)globalMap.get("parameterMap");
        AtsOverTimeBillEntryInfo newEntryInfo = billInfo.getEntries().get(0);
        BigDecimal oldRealLimit = new BigDecimal(0);
        HolidayLimitInfo limitInfo = null;
        BigDecimal newRealLimit = newEntryInfo.getRealOTTime();
        if (newEntryInfo.isCalculateState()) {
            String holidayLimitId;
            if (oldBillList != null) {
                for (AtsOverTimeBillInfo temp : oldBillList) {
                    if (!temp.getEntries().get(0).getId().toString().equals(newEntryInfo.getId().toString())) continue;
                    oldRealLimit = temp.getEntries().get(0).getRealOTTime();
                    break;
                }
            }
            String string = holidayLimitId = newEntryInfo.getHolidayLimit() == null ? null : newEntryInfo.getHolidayLimit().getId().toString();
            if (StringUtils.isNotEmpty((String)holidayLimitId)) {
                for (int i = 0; i < limitList.size(); ++i) {
                    HolidayLimitInfo temp = limitList.get(i);
                    if (!temp.getId().toString().equals(holidayLimitId)) continue;
                    limitInfo = temp;
                    break;
                }
            }
            if (limitInfo == null) {
                limitInfo = limitList.get(0);
            }
            if ("AERg0TIcSnaM40EKvJCdRKlrTmA=".equals(newEntryInfo.getOtCompens().getId().toString())) {
                newEntryInfo.setCalculateState(true);
                newEntryInfo.setHolidayLimit(limitInfo);
            } else {
                newEntryInfo.setCalculateState(false);
                newEntryInfo.setHolidayLimit(null);
                newRealLimit = new BigDecimal(0);
            }
        } else {
            limitInfo = limitList.get(0);
            if ("AERg0TIcSnaM40EKvJCdRKlrTmA=".equals(newEntryInfo.getOtCompens().getId().toString())) {
                newEntryInfo.setCalculateState(true);
                newEntryInfo.setHolidayLimit(limitInfo);
            } else {
                return;
            }
        }
        BigDecimal realLimit = newRealLimit.subtract(oldRealLimit);
        HolidayTypeUnitEnum unit = policyInfo.getUnit();
        if (policyInfo.isEnableMinAmt()) {
            BigDecimal minAmt = policyInfo.getMinAmt();
            GetValueMtdAmtEnum getMinAmtValueMtd = policyInfo.getMinAmtValueMtd();
            BigDecimal transNewRealLimit = this.getRateHolidayLimit(newEntryInfo.getOtType().getId().toString(), workInfo, newRealLimit);
            BigDecimal transOldRealLimit = this.getRateHolidayLimit(newEntryInfo.getOtType().getId().toString(), workInfo, oldRealLimit);
            if (unit.equals((Object)HolidayTypeUnitEnum.day)) {
                transNewRealLimit = this.transHourToDay(transNewRealLimit, standardHour);
                transOldRealLimit = this.transHourToDay(transOldRealLimit, standardHour);
            }
            transNewRealLimit = this.getMinAmtRealLimit(transNewRealLimit, minAmt, getMinAmtValueMtd);
            transOldRealLimit = this.getMinAmtRealLimit(transOldRealLimit, minAmt, getMinAmtValueMtd);
            realLimit = transNewRealLimit.compareTo(BigDecimal.ZERO) != 0 ? BigDecimal.ZERO.subtract(transOldRealLimit).add(transNewRealLimit) : BigDecimal.ZERO.subtract(transOldRealLimit);
        } else {
            realLimit = this.getRateHolidayLimit(newEntryInfo.getOtType().getId().toString(), workInfo, realLimit);
            if (unit.equals((Object)HolidayTypeUnitEnum.day)) {
                realLimit = this.transHourToDay(realLimit, standardHour);
            }
        }
        try {
            limitInfo.setStandardLimit(limitInfo.getStandardLimit().add(realLimit));
            limitInfo.setRealLimit(limitInfo.getRealLimit().add(realLimit));
            limitInfo.setRemainLimit(limitInfo.getRemainLimit().add(realLimit));
            if (attenceDate.getTime() > leffDate.getTime() && attenceDate.getTime() <= periodEndDate.getTime() && fileInfoSet.size() > 1) {
                limitInfo.setStandardLimit(limitInfo.getStandardLimit().subtract(realLimit));
                limitInfo.setRealLimit(limitInfo.getRealLimit().subtract(realLimit));
                limitInfo.setRemainLimit(limitInfo.getRemainLimit().subtract(realLimit));
                String innerKey = personId + "_" + date + "_" + hrOrgUnitId;
                java.util.Date sqlinnerDate = AtsDateUtils.stringToShortDate(date);
                Date sqlDate = new Date(sqlinnerDate.getTime());
                parameterMap.put(innerKey, new Object[]{personId, sqlDate, hrOrgUnitId});
            }
            HolidayLimitFactory.getLocalInstance(this.ctx).update((IObjectPK)new ObjectUuidPK(limitInfo.getId()), limitInfo);
            this.iOverTimeBill.update((IObjectPK)new ObjectUuidPK(newEntryInfo.getId()), newEntryInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void insertTakeWorkingLimit(HolidayPolicyInfo policyInfo, AtsTakeWorkingInfo workInfo, AtsOverTimeBillInfo billInfo, BigDecimal standardHour, Map<Object, Object> globalMap) {
        HolidayLimitInfo limitInfo = new HolidayLimitInfo();
        AtsOverTimeBillEntryInfo entryInfo = billInfo.getEntries().get(0);
        BigDecimal realLimit = this.getRateHolidayLimit(entryInfo.getOtType().getId().toString(), workInfo, entryInfo.getRealOTTime());
        HolidayTypeUnitEnum unit = policyInfo.getUnit();
        if (unit.equals((Object)HolidayTypeUnitEnum.day)) {
            realLimit = this.transHourToDay(realLimit, standardHour);
        }
        if (policyInfo.isEnableMinAmt()) {
            BigDecimal minAmt = policyInfo.getMinAmt();
            GetValueMtdAmtEnum getMinAmtValueMtd = policyInfo.getMinAmtValueMtd();
            realLimit = this.getMinAmtRealLimit(realLimit, minAmt, getMinAmtValueMtd);
        }
        if (realLimit.compareTo(BigDecimal.ZERO) != 0) {
            limitInfo.setStandardLimit(realLimit);
            limitInfo.setRealLimit(realLimit);
            limitInfo.setRemainLimit(realLimit);
            limitInfo.setAddOrSubLimit(BigDecimal.valueOf(0.0));
            limitInfo.setUsedLimit(BigDecimal.valueOf(0.0));
            limitInfo.setFreezeLimit(BigDecimal.valueOf(0.0));
            limitInfo.setPreOverdraftLimit(BigDecimal.valueOf(0.0));
            limitInfo.setStatus(HolidayLimitStatus.audited);
            TakeWoring takeWorkType = workInfo.getTaskWorkingType();
            PersonPositionInfo personPosition = SHRBillServerUtil.getAdminOrgUnitAndHrOrgUnit(this.ctx, entryInfo.getPerson().getId().toString());
            EmpLaborRelationInfo laborInfo = SHRBillUtil.getEmpLaborRelationInfo(entryInfo.getPerson().getId().toString(), this.ctx);
            if ("2".equals(takeWorkType.getValue())) {
                if (!this.setAttenceCycleDate(limitInfo, workInfo, entryInfo.getOtDate())) {
                    return;
                }
            } else if ("1".equals(takeWorkType.getValue())) {
                this.setSeasonAttenceCycleDate(limitInfo, workInfo, entryInfo.getOtDate(), personPosition, laborInfo);
            } else {
                this.setNoAttenceCycleDate(limitInfo, workInfo, entryInfo.getOtDate());
            }
            limitInfo.setEnableCycle(true);
            limitInfo.setHolidayUnit(policyInfo.getUnit());
            limitInfo.setHolidayPolicy(policyInfo);
            limitInfo.setDelayDate(this.getDelayDate(workInfo, limitInfo.getCycleEndDate()));
            limitInfo.setProposer(personPosition.getPerson());
            limitInfo.setPosition(personPosition.getPrimaryPosition());
            limitInfo.setAdminOrgUnit(personPosition.getPersonDep());
            limitInfo.setHrOrgUnit(personPosition.getHrOrgUnit());
            try {
                ObjectUuidPK uuidPK = (ObjectUuidPK)HolidayLimitFactory.getLocalInstance(this.ctx).addnew(limitInfo);
                limitInfo.setId(uuidPK.getKeyValue());
                entryInfo.setCalculateState(true);
                entryInfo.setHolidayLimit(limitInfo);
                this.iOverTimeBill.update((IObjectPK)new ObjectUuidPK(entryInfo.getId()), entryInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private BigDecimal getMinAmtRealLimit(BigDecimal realLimit, BigDecimal minAmt, GetValueMtdAmtEnum getMinAmtValueMtd) {
        int getMinAmtValueMtdInt = getMinAmtValueMtd.getValue();
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        switch (getMinAmtValueMtdInt) {
            case 1: {
                roundingMode = RoundingMode.FLOOR;
                break;
            }
            case 2: {
                roundingMode = RoundingMode.CEILING;
                break;
            }
            case 3: {
                roundingMode = RoundingMode.HALF_UP;
            }
        }
        BigDecimal rate = realLimit.divide(minAmt, 0, roundingMode);
        realLimit = minAmt.multiply(rate).setScale(2);
        return realLimit;
    }

    private BigDecimal transHourToDay(BigDecimal beforeTransLimit, BigDecimal standardHour) {
        return TakeWorkLimitUtils.transHourToDay(beforeTransLimit, standardHour);
    }

    private boolean setAttenceCycleDate(HolidayLimitInfo limitInfo, AtsTakeWorkingInfo workInfo, java.util.Date otDate) {
        Map<String, Object> resultMap = this.attenceCycleDate(workInfo, otDate);
        if (resultMap.isEmpty()) {
            return false;
        }
        limitInfo.setCycleDate((java.util.Date)resultMap.get("cycleDate"));
        limitInfo.setCycleBeginDate((java.util.Date)resultMap.get("cycleBeginDate"));
        limitInfo.setEffectDate((java.util.Date)resultMap.get("cycleBeginDate"));
        limitInfo.setCycleEndDate((java.util.Date)resultMap.get("cycleEndDate"));
        limitInfo.setYear((Integer)resultMap.get("year"));
        limitInfo.setDelayDate((java.util.Date)resultMap.get("delayDate"));
        return true;
    }

    private Map<String, Object> attenceCycleDate(AtsTakeWorkingInfo workInfo, java.util.Date otDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        AttendancePeriodCollection periodColls = null;
        try {
            String oql = "select startDate,endDate where group.id = '" + workInfo.getAttenceCycle().getId().toString() + "'";
            periodColls = this.iAttendancePeriod.getAttendancePeriodCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (periodColls != null && !periodColls.isEmpty()) {
            for (int i = 0; i < periodColls.size(); ++i) {
                AttendancePeriodInfo periodInfo = periodColls.get(i);
                java.util.Date startDate = periodInfo.getStartDate();
                java.util.Date endDate = periodInfo.getEndDate();
                if (startDate.getTime() > otDate.getTime() || endDate.getTime() < otDate.getTime()) continue;
                resultMap.put("cycleDate", startDate);
                resultMap.put("cycleBeginDate", startDate);
                resultMap.put("year", AtsDateUtils.getCurrentYear(startDate));
                resultMap.put("cycleEndDate", endDate);
                resultMap.put("delayDate", this.getDelayDate(workInfo, endDate));
                break;
            }
            if (resultMap.isEmpty()) {
                this.logger.error((Object)(workInfo.getAttenceCycle().getName() + "this attCycle not include time" + otDate));
            }
        } else {
            this.logger.error((Object)(workInfo.getAttenceCycle().getName() + "this attCycle not exist cycle info(not exist entry datatime)"));
        }
        return resultMap;
    }

    private void setSeasonAttenceCycleDate(HolidayLimitInfo limitInfo, AtsTakeWorkingInfo workInfo, java.util.Date otDate, PersonPositionInfo personPosition, EmpLaborRelationInfo laborInfo) {
        java.util.Date enterDate = null;
        if (laborInfo != null) {
            enterDate = laborInfo.getEnterDate();
        }
        int year = AtsDateUtils.getCurrentYear(otDate);
        Map<String, Object> dateMap = AtsDateUtils.generateSDateAndEDateBySeason(AtsDateUtils.getSeason(otDate), Integer.toString(year));
        java.util.Date cycleBeginDate = (java.util.Date)dateMap.get("startDate");
        java.util.Date cycleEndDate = (java.util.Date)dateMap.get("endDate");
        java.util.Date EffectDate = cycleBeginDate;
        if (enterDate != null && enterDate.getTime() >= cycleBeginDate.getTime() && enterDate.getTime() <= cycleEndDate.getTime()) {
            EffectDate = enterDate;
        }
        limitInfo.setCycleDate(cycleBeginDate);
        limitInfo.setYear(year);
        limitInfo.setCycleBeginDate(cycleBeginDate);
        limitInfo.setCycleEndDate(cycleEndDate);
        limitInfo.setEffectDate(EffectDate);
        limitInfo.setDelayDate(this.getDelayDate(workInfo, cycleEndDate));
    }

    private void setNoAttenceCycleDate(HolidayLimitInfo limitInfo, AtsTakeWorkingInfo workInfo, java.util.Date otDate) {
        Map<String, Object> resultMap = this.noAttenceCycleDate(workInfo, otDate);
        limitInfo.setCycleDate((java.util.Date)resultMap.get("cycleDate"));
        limitInfo.setYear((Integer)resultMap.get("year"));
        limitInfo.setCycleBeginDate((java.util.Date)resultMap.get("cycleBeginDate"));
        limitInfo.setCycleEndDate((java.util.Date)resultMap.get("cycleEndDate"));
        limitInfo.setEffectDate((java.util.Date)resultMap.get("cycleBeginDate"));
        limitInfo.setDelayDate((java.util.Date)resultMap.get("delayDate"));
    }

    private Map<String, Object> noAttenceCycleDate(AtsTakeWorkingInfo workInfo, java.util.Date otDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        java.util.Date cycleBeginDate = AtsDateUtils.getCurrentFirstDay(otDate);
        if ("3".equals(workInfo.getTaskWorkingType().getValue())) {
            cycleBeginDate = otDate;
        }
        if ("4".equals(workInfo.getTaskWorkingType().getValue())) {
            cycleBeginDate = AtsDateUtils.getCurrentYearFirst();
        }
        int year = AtsDateUtils.getCurrentYear(cycleBeginDate);
        resultMap.put("cycleDate", cycleBeginDate);
        resultMap.put("year", year);
        resultMap.put("cycleBeginDate", cycleBeginDate);
        java.util.Date cycleEndDate = this.getCycleEndDate(cycleBeginDate, workInfo.getTaskWorkingType().getValue());
        resultMap.put("cycleEndDate", cycleEndDate);
        resultMap.put("delayDate", this.getDelayDate(workInfo, cycleEndDate));
        return resultMap;
    }

    private java.util.Date getCycleEndDate(java.util.Date beginDate, String type) {
        int dateType = 2;
        int add = 0;
        if ("0".equals(type)) {
            dateType = 2;
            add = 1;
        } else if ("1".equals(type)) {
            dateType = 2;
            add = 3;
        } else if ("4".equals(type)) {
            dateType = 2;
            add = 12;
        } else if ("3".equals(type)) {
            return beginDate;
        }
        return AtsDateUtils.dateAdd(beginDate, dateType, add, true);
    }

    private boolean isExistUserCreateBill(String personId, java.util.Date oneDayBegin) {
        boolean flag = true;
        java.util.Date oneDayEnd = AtsDateUtils.dateAdd(oneDayBegin, 3, 1, false);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)oneDayBegin, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)oneDayEnd, CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("createTag", (Object)1, CompareType.EQUALS));
        try {
            flag = this.iOverTimeBill.exists(filter);
        }
        catch (BOSException e) {
            this.logger.error((Object)MLUtile.getRes((ResourceEnum)AtsCommonResEnum.ReasonFail, this.ctx, new Object[]{"\uff1a", e}));
        }
        catch (EASBizException e) {
            this.logger.error((Object)MLUtile.getRes((ResourceEnum)AtsCommonResEnum.ReasonFail, this.ctx, new Object[]{"\uff1a", e}));
        }
        return flag;
    }

    private AtsOverTimeBillEntryInfo getOldEntry(String personId, java.util.Date oneDayBegin) {
        java.util.Date oneDayEnd = AtsDateUtils.dateAdd(oneDayBegin, 3, 1, false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)oneDayBegin, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)oneDayEnd, CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("createTag", (Object)2, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("realOTTime"));
        evi.getSelector().add(new SelectorItemInfo("createTag"));
        AtsOverTimeBillEntryCollection entryCollection = null;
        try {
            entryCollection = this.iOverTimeBill.getAtsOverTimeBillEntryCollection(evi);
        }
        catch (BOSException e) {
            this.logger.error((Object)MLUtile.getRes((ResourceEnum)AtsCommonResEnum.ReasonFail, this.ctx, new Object[]{"\uff1a", e}));
        }
        if (entryCollection == null || entryCollection.isEmpty()) {
            return null;
        }
        return entryCollection.get(0);
    }

    private void updateEntryInfo(AtsOverTimeBillEntryInfo entryInfo, Map entryMap, OverTimeCompensInfo otCompens) {
        BigDecimal realOTTime = (BigDecimal)entryMap.get("realOTTime");
        BigDecimal applyOTTime = (BigDecimal)entryMap.get("applyOTTime");
        Object restTime = entryMap.get("restTime");
        entryInfo.setOtCompens(otCompens);
        entryInfo.setRealOTTime(realOTTime);
        entryInfo.setApplyOTTime(applyOTTime);
        entryInfo.setRestTime(restTime == null ? null : Integer.valueOf(((BigDecimal)restTime).intValue()));
        try {
            this.iOverTimeBill.update((IObjectPK)new ObjectUuidPK(entryInfo.getId()), entryInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private java.util.Date getDelayDate(AtsTakeWorkingInfo workInfo, java.util.Date endDate) {
        int delayLength = workInfo.getDelayLength().intValue();
        int type = workInfo.getDelayLengthUnit().getValue() + 1;
        java.util.Date delayDate = AtsDateUtils.dateAdd(endDate, type, delayLength);
        return delayDate;
    }

    public String getMainOrgByCu() {
        String orgId;
        OrgUnitInfo mainOrg = (OrgUnitInfo)this.ctx.get((Object)OrgType.HRO);
        String string = orgId = mainOrg == null ? "" : mainOrg.getString("id");
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return orgId;
    }

    private BigDecimal getRateHolidayLimit(String otType, AtsTakeWorkingInfo workInfo, BigDecimal beforeLimit) {
        BigDecimal afterLimit = null;
        afterLimit = "rBy0u1YgQ9C1OxcM85mxyY6C/nU=".equals(otType) ? beforeLimit.multiply(new BigDecimal(workInfo.getWorkDayRate())) : ("zr+ur5D4RA+2bdVZ2VPqp46C/nU=".equals(otType) ? beforeLimit.multiply(new BigDecimal(workInfo.getRestDayRate())) : ("sRWUOt7sRpOY0TCo6NMqGY6C/nU=".equals(otType) ? beforeLimit.multiply(new BigDecimal(workInfo.getLegalHolidayRate())) : beforeLimit.multiply(new BigDecimal(1))));
        return afterLimit;
    }

    private BigDecimal getRate(String otType, AtsTakeWorkingInfo workInfo) {
        if ("rBy0u1YgQ9C1OxcM85mxyY6C/nU=".equals(otType)) {
            return new BigDecimal(workInfo.getWorkDayRate());
        }
        if ("zr+ur5D4RA+2bdVZ2VPqp46C/nU=".equals(otType)) {
            return new BigDecimal(workInfo.getRestDayRate());
        }
        if ("sRWUOt7sRpOY0TCo6NMqGY6C/nU=".equals(otType)) {
            return new BigDecimal(workInfo.getLegalHolidayRate());
        }
        return new BigDecimal(0);
    }
}

