/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.statistics.shift.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.hr.ats.AtsShiftCountSetEntryCollection;
import com.kingdee.eas.hr.ats.AtsShiftCountSetEntryFactory;
import com.kingdee.eas.hr.ats.AtsShiftCountSetEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceShiftCountType;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.statistics.expression.AtsExpressionEvaluator;
import com.kingdee.eas.hr.ats.statistics.shift.ShiftStatisticsService;
import com.kingdee.eas.hr.ats.statistics.shift.StatisticsVO;
import com.kingdee.eas.hr.ats.statistics.shift.impl.DayTypeStatisticsServiceImpl;
import com.kingdee.eas.hr.ats.statistics.shift.impl.FixOTStatisticsServiceImpl;
import com.kingdee.eas.hr.ats.statistics.shift.impl.SupportStatisticsServiceImpl;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AtsShiftStatisticsUtil {
    public static final String sumHour = "sumHour";
    public static final String dayTypeCount = "dayTypeCount";
    public static final String dayType = "dayType";
    public static final String GRID_INDEX = "index";
    public static final String GRID_HIDDEN = "hidden";
    public static final String GRID_NAME = "name";
    public static final String GRID_LABEL = "label";

    public static Map<String, Map<String, Object>> getShiftStatisticsDataByDayType(Context ctx, List<String> personKeyList, String beginDate, String endDate) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        Object[] sqlParams = AtsShiftStatisticsUtil.getDayTypeSqlAndParams(personKeyList, beginDate, endDate);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlParams[0].toString(), (Object[])((Object[])sqlParams[1]));
            while (rs != null && rs.next()) {
                AtsShiftStatisticsUtil.putStatisticsData(rs, AtsShiftStatisticsUtil.getSatisticsMap(result, rs));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Map<String, Map<String, Object>> getShiftStatisticsDataBySupport(Context ctx, List<String> personKeyList, String beginDate, String endDate) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        Object[] sqlParams = AtsShiftStatisticsUtil.getSupportSqlAndParams(personKeyList, beginDate, endDate);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlParams[0].toString(), (Object[])((Object[])sqlParams[1]));
            while (rs != null && rs.next()) {
                AtsShiftStatisticsUtil.putSatisticsData(result, rs, AttendanceShiftCountType.supportHour.getName());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Map<String, Map<String, Object>> getShiftStatisticsDataByFixOT(Context ctx, List<String> personKeyList, String beginDate, String endDate) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        Object[] sqlParams = AtsShiftStatisticsUtil.getFixOTSqlAndParams(personKeyList, beginDate, endDate);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlParams[0].toString(), (Object[])((Object[])sqlParams[1]));
            while (rs != null && rs.next()) {
                AtsShiftStatisticsUtil.putSatisticsData(result, rs, AttendanceShiftCountType.fixOverTimeHour.getName());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getKeyIdValue(IRowSet rs) throws SQLException {
        String proposerid = rs.getString("FPROPOSERID");
        String adminorgunitid = rs.getString("FADMINORGUNITID");
        String attadminorgunitid = rs.getString("FATTADMINORGUNITID");
        String hrorgunitid = rs.getString("FHRORGUNITID");
        String keyId = new StringBuffer().append(proposerid).append("@_@").append(adminorgunitid).append("@_@").append(attadminorgunitid).append("@_@").append(hrorgunitid).toString();
        return keyId;
    }

    public static List<String> getPersonIdParam(List<String> personKeyList) {
        ArrayList<String> personIds = new ArrayList<String>();
        for (int i = 0; i < personKeyList.size(); ++i) {
            personIds.add(personKeyList.get(i).split("@_@")[0]);
        }
        return personIds;
    }

    public static Object[] getFixOTSqlAndParams(List<String> personKeyList, String beginDate, String endDate) {
        List<String> personIds = AtsShiftStatisticsUtil.getPersonIdParam(personKeyList);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FPROPOSERID,FHRORGUNITID,FATTADMINORGUNITID, FADMINORGUNITID,SUM(sumHour)/60 sumHour  FROM ( ").append(" SELECT a.FPROPOSERID,a.FHRORGUNITID,a.FADMINORGUNITID as FATTADMINORGUNITID, b.FADMINORGUNITID ,FNextDateTime,FPreDateTime,FSegmentInRest, ").append(" (DATEDIFF(minute,FPreDateTime,FNextDateTime)-ISNULL(FSegmentInRest,0)) AS sumHour ").append(" FROM T_HR_ATS_SCHEDULESHIFT a ").append(" INNER JOIN T_HR_ATS_SCHEDULESHIFTITEM m on a.fid = m.FGROUPID ").append(" INNER JOIN T_HR_ATS_ATTENDANCEFILEHIS b on a.fproposerid = b.FPROPOSERID ").append(" and b.fleffdt >= a.FATTENDDATE and b.FEFFDT <= a.FATTENDDATE ").append(" where a.FATTENDDATE >= ? and  a.FATTENDDATE <= ? ").append(" and m.FATTENDANCETYPE in (?,?)").append(" and A.FPROPOSERID IN ").append(AtsCollectionUtile.joinForSql(personIds.size())).append(" )T ").append(" GROUP BY FPROPOSERID,FHRORGUNITID,FATTADMINORGUNITID,FADMINORGUNITID ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(AtsDateUtils.stringShortToTimestamp(beginDate));
        params.add(AtsDateUtils.stringShortToTimestamp(endDate));
        params.add("2");
        params.add("4");
        params.addAll(personIds);
        return new Object[]{sql.toString(), params.toArray()};
    }

    public static Object[] getSupportSqlAndParams(List<String> personKeyList, String beginDate, String endDate) {
        List<String> personIds = AtsShiftStatisticsUtil.getPersonIdParam(personKeyList);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FPROPOSERID,FHRORGUNITID,FATTADMINORGUNITID, FADMINORGUNITID,SUM(sumHour)/60 sumHour  FROM ( ").append(" SELECT a.FPROPOSERID,a.FHRORGUNITID,a.FADMINORGUNITID as FATTADMINORGUNITID, b.FADMINORGUNITID ,FNextDateTime,FPreDateTime,FSegmentInRest, ").append(" (DATEDIFF(minute,FPreDateTime,FNextDateTime)-ISNULL(FSegmentInRest,0)) AS sumHour ").append(" FROM T_HR_ATS_SCHEDULESHIFT a ").append(" INNER JOIN T_HR_ATS_SCHEDULESHIFTITEM m on a.fid = m.FGROUPID ").append(" INNER JOIN T_HR_ATS_ATTENDANCEFILEHIS b on a.fproposerid = b.FPROPOSERID ").append(" and b.fleffdt >= a.FATTENDDATE and b.FEFFDT <= a.FATTENDDATE ").append(" where a.FATTENDDATE >= ? and  a.FATTENDDATE <= ? ").append(" and m.FitemSrcType = ? ").append(" and A.FPROPOSERID IN  ").append(AtsCollectionUtile.joinForSql(personIds.size())).append(" )T ").append(" GROUP BY FPROPOSERID,FHRORGUNITID,FATTADMINORGUNITID,FADMINORGUNITID ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(AtsDateUtils.stringShortToTimestamp(beginDate));
        params.add(AtsDateUtils.stringShortToTimestamp(endDate));
        params.add(1);
        params.addAll(personIds);
        return new Object[]{sql.toString(), params.toArray()};
    }

    public static Object[] getDayTypeSqlAndParams(List<String> personKeyList, String beginDate, String endDate) {
        List<String> personIds = AtsShiftStatisticsUtil.getPersonIdParam(personKeyList);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FPROPOSERID, FADMINORGUNITID,FATTADMINORGUNITID ,FHRORGUNITID,FDAYTYPE dayType,COUNT(1) dayTypeCount, ").append(" SUM(FSTANDARDHOUR) sumHour  FROM ( ").append(" SELECT a.FPROPOSERID,a.FHRORGUNITID,a.FADMINORGUNITID as FATTADMINORGUNITID, ").append(" b.FADMINORGUNITID ,a.FDAYTYPE,A.FSTANDARDHOUR ").append(" FROM T_HR_ATS_SCHEDULESHIFT a ").append(" INNER JOIN T_HR_ATS_ATTENDANCEFILEHIS b on a.fproposerid = b.FPROPOSERID ").append(" and b.fleffdt >= a.FATTENDDATE and b.FEFFDT <= a.FATTENDDATE ").append(" where a.FATTENDDATE >= ? and  a.FATTENDDATE <= ? ").append(" and A.FPROPOSERID IN ").append(AtsCollectionUtile.joinForSql(personIds.size())).append(" )T ").append(" GROUP BY FPROPOSERID,FHRORGUNITID,FATTADMINORGUNITID, FADMINORGUNITID ,FDAYTYPE ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(AtsDateUtils.stringShortToTimestamp(beginDate));
        params.add(AtsDateUtils.stringShortToTimestamp(endDate));
        params.addAll(personIds);
        return new Object[]{sql.toString(), params.toArray()};
    }

    public static void putSatisticsData(Map<String, Map<String, Object>> result, IRowSet rs, String hour) throws SQLException {
        Map<String, Object> statisticsData = AtsShiftStatisticsUtil.getSatisticsMap(result, rs);
        statisticsData.put(hour, rs.getBigDecimal(sumHour));
    }

    public static Map<String, Object> getSatisticsMap(Map<String, Map<String, Object>> result, IRowSet rs) throws SQLException {
        String keyId = AtsShiftStatisticsUtil.getKeyIdValue(rs);
        if (result.get(keyId) == null) {
            result.put(keyId, new HashMap());
        }
        return result.get(keyId);
    }

    public static void putStatisticsData(IRowSet rs, Map<String, Object> statisticsData) throws SQLException {
        BigDecimal count = BigDecimal.valueOf(rs.getInt(dayTypeCount));
        int dayTypeValue = rs.getInt(dayType);
        BigDecimal sumHourValue = rs.getBigDecimal(sumHour);
        if (dayTypeValue == 0) {
            statisticsData.put(AttendanceShiftCountType.workDay.getName(), count);
            statisticsData.put(AttendanceShiftCountType.workDayHour.getName(), sumHourValue);
        } else if (dayTypeValue == 1) {
            statisticsData.put(AttendanceShiftCountType.restDay.getName(), count);
        } else if (dayTypeValue == 2) {
            statisticsData.put(AttendanceShiftCountType.legalHoliday.getName(), count);
        }
    }

    public static void putStatisticsDataColor(Context ctx, Map<String, Map<String, Object>> statisticsData, Map<String, List<AtsShiftCountSetEntryInfo>> shiftCountSet) {
        Iterator<Map.Entry<String, Map<String, Object>>> iter = statisticsData.entrySet().iterator();
        int decimalPlace = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
        while (iter.hasNext()) {
            Map.Entry<String, Map<String, Object>> entry = iter.next();
            Map<String, Object> data = entry.getValue();
            block1: for (Map.Entry<String, List<AtsShiftCountSetEntryInfo>> countSetEntry : shiftCountSet.entrySet()) {
                BigDecimal dataValue = (BigDecimal)data.get(countSetEntry.getKey());
                if (null == dataValue) continue;
                dataValue = DecimalPlaceUtil.decimalPlaceCtrl(ctx, dataValue, decimalPlace);
                data.put(countSetEntry.getKey(), dataValue);
                List<AtsShiftCountSetEntryInfo> entryListInfo = countSetEntry.getValue();
                for (int j = 0; j < entryListInfo.size(); ++j) {
                    boolean flag = AtsExpressionEvaluator.evaluate(dataValue, entryListInfo.get(j).toExpressionString());
                    if (!flag) continue;
                    data.put(countSetEntry.getKey() + "_color", entryListInfo.get(j).getColor());
                    continue block1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, Object>> getStatisticsData(Context ctx, List<String> personKeyList, String beginDate, String endDate, Map<String, List<AtsShiftCountSetEntryInfo>> shiftCountSet) {
        String tempTableName = null;
        if (personKeyList != null && personKeyList.size() >= 50) {
            tempTableName = AtsShiftStatisticsUtil.createStatisticsTempTable(ctx, personKeyList);
        }
        if (!StringUtils.isEmpty(tempTableName)) {
            try {
                Map<String, Map<String, Object>> map = AtsShiftStatisticsUtil.getStatisticsDataByTmpTable(ctx, beginDate, endDate, shiftCountSet, tempTableName);
                return map;
            }
            finally {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
        }
        return AtsShiftStatisticsUtil.getStatisticsDataByList(ctx, beginDate, endDate, shiftCountSet, personKeyList);
    }

    public static void addStatisticsData(Map<String, Map<String, Object>> statisticsData, Map<String, Map<String, Object>> otherData) {
        for (Map.Entry<String, Map<String, Object>> entry : otherData.entrySet()) {
            if (statisticsData.get(entry.getKey()) != null) {
                statisticsData.get(entry.getKey()).putAll(entry.getValue());
                continue;
            }
            statisticsData.put(entry.getKey(), entry.getValue());
        }
    }

    public static void setShiftCountSetColModel(Context ctx, List<String> colNames, List<Map<String, Object>> colModel) throws BOSException {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        AtsShiftCountSetEntryCollection coll = AtsShiftCountSetEntryFactory.getLocalInstance(ctx).getAtsShiftCountSetEntryCollection(" where creator.id='" + userInfo.getId().toString() + "' and state ='" + 1 + "'");
        HashMap<Integer, Boolean> enableMap = new HashMap<Integer, Boolean>();
        for (int i = 0; i < coll.size(); ++i) {
            enableMap.put(coll.get(i).getShiftCountType().getValue(), true);
        }
        List countTypeList = AttendanceShiftCountType.getEnumList();
        for (int i = 0; i < countTypeList.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(GRID_INDEX, ((AttendanceShiftCountType)((Object)countTypeList.get(i))).getName());
            map.put(GRID_NAME, ((AttendanceShiftCountType)((Object)countTypeList.get(i))).getName());
            map.put(GRID_LABEL, ((AttendanceShiftCountType)((Object)countTypeList.get(i))).getName());
            if (null == enableMap.get(((AttendanceShiftCountType)((Object)countTypeList.get(i))).getValue())) {
                map.put(GRID_HIDDEN, true);
            }
            map.put("width", 80);
            colNames.add(((AttendanceShiftCountType)((Object)countTypeList.get(i))).getAlias());
            colModel.add(map);
        }
    }

    public static Map<String, List<AtsShiftCountSetEntryInfo>> getShiftCountSet(Context ctx) throws BOSException {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        AtsShiftCountSetEntryCollection coll = AtsShiftCountSetEntryFactory.getLocalInstance(ctx).getAtsShiftCountSetEntryCollection(" where creator.id='" + userInfo.getId().toString() + "' and state ='" + 1 + "' order by shiftCountType asc,sort asc");
        HashMap<String, List<AtsShiftCountSetEntryInfo>> resultMap = new HashMap<String, List<AtsShiftCountSetEntryInfo>>();
        for (int i = 0; i < coll.size(); ++i) {
            String shiftCountTypeKey = coll.get(i).getShiftCountType().getName();
            ArrayList<AtsShiftCountSetEntryInfo> entries = (ArrayList<AtsShiftCountSetEntryInfo>)resultMap.get(shiftCountTypeKey);
            if (entries == null) {
                entries = new ArrayList<AtsShiftCountSetEntryInfo>();
            }
            entries.add(coll.get(i));
            resultMap.put(shiftCountTypeKey, entries);
        }
        return resultMap;
    }

    public static void setInitStatisticDataValue(List<String> personKeyList, Map<String, Map<String, Object>> statisticsData, Map<String, List<AtsShiftCountSetEntryInfo>> shiftCountSet) {
        Iterator<Map.Entry<String, List<AtsShiftCountSetEntryInfo>>> countSetIter = shiftCountSet.entrySet().iterator();
        while (countSetIter.hasNext()) {
            String countSetKey = countSetIter.next().getKey();
            for (int i = 0; i < personKeyList.size(); ++i) {
                String keyId = personKeyList.get(i);
                if (statisticsData.get(keyId) == null) {
                    HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>();
                    data.put(countSetKey, BigDecimal.ZERO);
                    statisticsData.put(keyId, data);
                    continue;
                }
                if (statisticsData.get(keyId).get(countSetKey) != null) continue;
                statisticsData.get(keyId).put(countSetKey, BigDecimal.ZERO);
            }
        }
    }

    public static Object[] getDayTypeSqlAndParamsBatch(Context ctx, String tempTableName, String beginDate, String endDate) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FPROPOSERID, FADMINORGUNITID,FATTADMINORGUNITID ,FHRORGUNITID,FDAYTYPE dayType,COUNT(1) dayTypeCount, ").append(" SUM(FSTANDARDHOUR) sumHour  FROM ( ").append(" SELECT a.FPROPOSERID,a.FHRORGUNITID,a.FADMINORGUNITID as FATTADMINORGUNITID, ").append(" b.FADMINORGUNITID ,a.FDAYTYPE,A.FSTANDARDHOUR ").append(" FROM ").append(tempTableName).append(" tmp ").append(" INNER JOIN  T_HR_ATS_SCHEDULESHIFT a ON TMP.FID = A.FPROPOSERID ").append(" INNER JOIN T_HR_ATS_ATTENDANCEFILEHIS b on a.fproposerid = b.FPROPOSERID ").append(" and b.fleffdt >= a.FATTENDDATE and b.FEFFDT <= a.FATTENDDATE ").append(" where a.FATTENDDATE >= ? and  a.FATTENDDATE <= ? ").append(" )T ").append(" GROUP BY FPROPOSERID,FHRORGUNITID,FATTADMINORGUNITID, FADMINORGUNITID ,FDAYTYPE ");
        ArrayList<Timestamp> params = new ArrayList<Timestamp>();
        params.add(AtsDateUtils.stringShortToTimestamp(beginDate));
        params.add(AtsDateUtils.stringShortToTimestamp(endDate));
        return new Object[]{sql.toString(), params.toArray()};
    }

    public static Object[] getSupportSqlAndParamsBatch(Context ctx, String tempTableName, String beginDate, String endDate) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FPROPOSERID,FHRORGUNITID,FATTADMINORGUNITID, FADMINORGUNITID,SUM(sumHour)/60 sumHour  FROM ( ").append(" SELECT a.FPROPOSERID,a.FHRORGUNITID,a.FADMINORGUNITID as FATTADMINORGUNITID, b.FADMINORGUNITID ,FNextDateTime,FPreDateTime,FSegmentInRest, ").append(" (DATEDIFF(minute,FPreDateTime,FNextDateTime)-ISNULL(FSegmentInRest,0)) AS sumHour ").append(" FROM ").append(tempTableName).append(" tmp ").append(" INNER JOIN  T_HR_ATS_SCHEDULESHIFT a ON TMP.FID = A.FPROPOSERID ").append(" INNER JOIN T_HR_ATS_SCHEDULESHIFTITEM m on a.fid = m.FGROUPID ").append(" INNER JOIN T_HR_ATS_ATTENDANCEFILEHIS b on a.fproposerid = b.FPROPOSERID ").append(" and b.fleffdt >= a.FATTENDDATE and b.FEFFDT <= a.FATTENDDATE ").append(" where a.FATTENDDATE >= ? and  a.FATTENDDATE <= ? ").append(" and m.FitemSrcType = ? ").append(" )T ").append(" GROUP BY FPROPOSERID,FHRORGUNITID,FATTADMINORGUNITID,FADMINORGUNITID ");
        ArrayList<Comparable<Date>> params = new ArrayList<Comparable<Date>>();
        params.add(AtsDateUtils.stringShortToTimestamp(beginDate));
        params.add(AtsDateUtils.stringShortToTimestamp(endDate));
        params.add(Integer.valueOf(1));
        return new Object[]{sql.toString(), params.toArray()};
    }

    public static Object[] getFixOTSqlAndParamsBatch(Context ctx, String tempTableName, String beginDate, String endDate) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FPROPOSERID,FHRORGUNITID,FATTADMINORGUNITID, FADMINORGUNITID,SUM(sumHour)/60 sumHour  FROM ( ").append(" SELECT a.FPROPOSERID,a.FHRORGUNITID,a.FADMINORGUNITID as FATTADMINORGUNITID, b.FADMINORGUNITID ,FNextDateTime,FPreDateTime,FSegmentInRest, ").append(" (DATEDIFF(minute,FPreDateTime,FNextDateTime)-ISNULL(FSegmentInRest,0)) AS sumHour ").append(" FROM ").append(tempTableName).append(" tmp ").append(" INNER JOIN  T_HR_ATS_SCHEDULESHIFT a ON TMP.FID = A.FPROPOSERID ").append(" INNER JOIN T_HR_ATS_SCHEDULESHIFTITEM m on a.fid = m.FGROUPID ").append(" INNER JOIN T_HR_ATS_ATTENDANCEFILEHIS b on a.fproposerid = b.FPROPOSERID ").append(" and b.fleffdt >= a.FATTENDDATE and b.FEFFDT <= a.FATTENDDATE ").append(" where a.FATTENDDATE >= ? and  a.FATTENDDATE <= ? ").append(" and m.FATTENDANCETYPE in (?,?)").append(" )T ").append(" GROUP BY FPROPOSERID,FHRORGUNITID,FATTADMINORGUNITID,FADMINORGUNITID ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(AtsDateUtils.stringShortToTimestamp(beginDate));
        params.add(AtsDateUtils.stringShortToTimestamp(endDate));
        params.add("2");
        params.add("4");
        return new Object[]{sql.toString(), params.toArray()};
    }

    public static Map<String, Map<String, Object>> getShiftStatisticsDataByDayType(Context ctx, String personTableName, String beginDate, String endDate) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        Object[] sqlParams = AtsShiftStatisticsUtil.getDayTypeSqlAndParamsBatch(ctx, personTableName, beginDate, endDate);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlParams[0].toString(), (Object[])((Object[])sqlParams[1]));
            while (rs != null && rs.next()) {
                AtsShiftStatisticsUtil.putStatisticsData(rs, AtsShiftStatisticsUtil.getSatisticsMap(result, rs));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Map<String, Map<String, Object>> getShiftStatisticsDataBySupport(Context ctx, String personTableName, String beginDate, String endDate) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        Object[] sqlParams = null;
        try {
            sqlParams = AtsShiftStatisticsUtil.getSupportSqlAndParamsBatch(ctx, personTableName, beginDate, endDate);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlParams[0].toString(), (Object[])((Object[])sqlParams[1]));
            while (rs != null && rs.next()) {
                AtsShiftStatisticsUtil.putSatisticsData(result, rs, AttendanceShiftCountType.supportHour.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Map<String, Map<String, Object>> getShiftStatisticsDataByFixOT(Context ctx, String personTableName, String beginDate, String endDate) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        Object[] sqlParams = AtsShiftStatisticsUtil.getFixOTSqlAndParamsBatch(ctx, personTableName, beginDate, endDate);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlParams[0].toString(), (Object[])((Object[])sqlParams[1]));
            while (rs != null && rs.next()) {
                AtsShiftStatisticsUtil.putSatisticsData(result, rs, AttendanceShiftCountType.fixOverTimeHour.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String createStatisticsTempTable(Context ctx, List<String> personIds) {
        String tempTableName = null;
        try {
            String tmpIndexSql;
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (String person : personIds) {
                params.add(new Object[]{person.split("@_@")[0]});
            }
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(" CREATE TABLE T_HR_ATS_STATISTIC_TEMP(FID VARCHAR(44))");
            DbUtil.executeBatch((Context)ctx, (String)("insert into " + tempTableName + " values(?)"), params);
            String dbType = ContextUtil.getDbType((Context)ctx);
            if (!StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle"))) {
                tmpIndexSql = "CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (FID ASC) ;";
                DbUtil.execute((Context)ctx, (String)tmpIndexSql.toString());
            } else {
                tmpIndexSql = "CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (FID ASC) ;";
                DbUtil.execute((Context)ctx, (String)tmpIndexSql.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempTableName;
    }

    private static Map<String, Map<String, Object>> getStatisticsDataByList(Context ctx, String beginDate, String endDate, Map<String, List<AtsShiftCountSetEntryInfo>> shiftCountSet, List<String> personKeyList) {
        HashMap<String, Map<String, Object>> statisticsData = new HashMap<String, Map<String, Object>>();
        ShiftStatisticsService statisticsService = new DayTypeStatisticsServiceImpl();
        StatisticsVO statisticsVO = AtsShiftStatisticsUtil.getStatisticsVO(ctx, beginDate, endDate, personKeyList);
        if (shiftCountSet.containsKey(AttendanceShiftCountType.workDay.getName()) || shiftCountSet.containsKey(AttendanceShiftCountType.restDay.getName()) || shiftCountSet.containsKey(AttendanceShiftCountType.workDayHour.getName()) || shiftCountSet.containsKey(AttendanceShiftCountType.legalHoliday.getName())) {
            AtsShiftStatisticsUtil.addStatisticsData(statisticsData, statisticsService.statisticsData(statisticsVO));
        }
        if (shiftCountSet.containsKey(AttendanceShiftCountType.supportHour.getName())) {
            statisticsService = new SupportStatisticsServiceImpl();
            AtsShiftStatisticsUtil.addStatisticsData(statisticsData, statisticsService.statisticsData(statisticsVO));
        }
        if (shiftCountSet.containsKey(AttendanceShiftCountType.fixOverTimeHour.getName())) {
            statisticsService = new FixOTStatisticsServiceImpl();
            AtsShiftStatisticsUtil.addStatisticsData(statisticsData, statisticsService.statisticsData(statisticsVO));
        }
        return statisticsData;
    }

    private static Map<String, Map<String, Object>> getStatisticsDataByTmpTable(Context ctx, String beginDate, String endDate, Map<String, List<AtsShiftCountSetEntryInfo>> shiftCountSet, String tempTableName) {
        HashMap<String, Map<String, Object>> statisticsData = new HashMap<String, Map<String, Object>>();
        ShiftStatisticsService statisticsService = new DayTypeStatisticsServiceImpl();
        StatisticsVO statisticsVO = AtsShiftStatisticsUtil.getStatisticsVO(ctx, beginDate, endDate, tempTableName);
        if (shiftCountSet.containsKey(AttendanceShiftCountType.workDay.getName()) || shiftCountSet.containsKey(AttendanceShiftCountType.restDay.getName()) || shiftCountSet.containsKey(AttendanceShiftCountType.workDayHour.getName()) || shiftCountSet.containsKey(AttendanceShiftCountType.legalHoliday.getName())) {
            AtsShiftStatisticsUtil.addStatisticsData(statisticsData, statisticsService.statisticsData(statisticsVO));
        }
        if (shiftCountSet.containsKey(AttendanceShiftCountType.supportHour.getName())) {
            statisticsService = new SupportStatisticsServiceImpl();
            AtsShiftStatisticsUtil.addStatisticsData(statisticsData, statisticsService.statisticsData(statisticsVO));
        }
        if (shiftCountSet.containsKey(AttendanceShiftCountType.fixOverTimeHour.getName())) {
            statisticsService = new FixOTStatisticsServiceImpl();
            AtsShiftStatisticsUtil.addStatisticsData(statisticsData, statisticsService.statisticsData(statisticsVO));
        }
        return statisticsData;
    }

    private static StatisticsVO getStatisticsVO(Context ctx, String beginDate, String endDate, String tempTableName) {
        StatisticsVO statisticsVO = new StatisticsVO();
        statisticsVO.setCtx(ctx);
        statisticsVO.setPersonTableName(tempTableName);
        statisticsVO.setBeginDate(beginDate);
        statisticsVO.setEndDate(endDate);
        return statisticsVO;
    }

    private static StatisticsVO getStatisticsVO(Context ctx, String beginDate, String endDate, List<String> personKeyList) {
        StatisticsVO statisticsVO = new StatisticsVO();
        statisticsVO.setCtx(ctx);
        statisticsVO.setPersonKeyList(personKeyList);
        statisticsVO.setBeginDate(beginDate);
        statisticsVO.setEndDate(endDate);
        return statisticsVO;
    }
}

