/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.check;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.sum.check.SumSalaryDataCheckUtil;
import com.kingdee.eas.hr.ats.util.AtsDbUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SumSalaryDataCheck {
    private static Logger logger = Logger.getLogger(SumSalaryDataCheck.class);

    public int sumSalaryDataCheckCount(Context ctx, String attendPeriodId) {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSumNoSalaryCount(), (Object[])new Object[]{attendPeriodId});
            if (rs != null && rs.next()) {
                return rs.getInt("CNT");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public Object[] sumSalaryDataCheckAndFix(Context ctx, String attendPeriodId) {
        Object[] result = null;
        int sumType = SumSalaryDataCheckUtil.getSystemParamIntValue(ctx, "ATS_SumType");
        switch (sumType) {
            case 1: {
                result = this.checkAndFixSumNoSalaryDataByPerson(ctx, attendPeriodId);
                this.checkAndFixSalaryNoDetailDataByPerson(ctx, attendPeriodId);
                return result;
            }
            case 0: {
                result = this.checkAndFixSumNoSalaryData(ctx, attendPeriodId);
                this.checkAndFixSalaryNoDetailData(ctx, attendPeriodId);
                return result;
            }
            case 2: {
                result = this.checkAndFixSumNoSalaryDataByHRPerson(ctx, attendPeriodId);
                return result;
            }
            case 3: {
                result = this.checkAndFixSumNoSalaryDataByHRPersonAtt(ctx, attendPeriodId);
                return result;
            }
        }
        result = this.checkAndFixSumNoSalaryData(ctx, attendPeriodId);
        this.checkAndFixSalaryNoDetailData(ctx, attendPeriodId);
        return result;
    }

    private Object[] checkAndFixSumNoSalaryData(Context ctx, String attendPeriodId) {
        Object[] result = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSumNoSalaryCount(), (Object[])new Object[]{attendPeriodId});
            if (rs != null && rs.next()) {
                int count = rs.getInt("CNT");
                logger.error((Object)("===========start checkSumNoSalaryData total count: " + count + "=============="));
                if (count > 0) {
                    ArrayList<Object[]> salaryMDDetailParams = new ArrayList<Object[]>();
                    ArrayList<Object[]> salaryMDParams = new ArrayList<Object[]>();
                    rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSumNoSalarySQL(), (Object[])new Object[]{attendPeriodId});
                    while (rs.next()) {
                        String id = rs.getString("FID");
                        salaryMDDetailParams.add(new Object[]{id});
                        salaryMDParams.add(new Object[]{id});
                    }
                    Object[] paramsTemplateArr = new Object[]{salaryMDParams, salaryMDDetailParams};
                    result = AtsDbUtil.executeBatch(ctx, salaryMDParams.size(), AtsDbUtil.getBatchCount(), SumSalaryDataCheckUtil.getTranSalaryTemplateSQLArr(), paramsTemplateArr);
                    if (null != result && result.length == 2) {
                        logger.error((Object)("===========end checkSumNoSalaryData total count: " + count + ",success count: " + result[0] + ",errorMsg: " + result[1] + "=========="));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Object[] checkAndFixSalaryNoDetailData(Context ctx, String attendPeriodId) {
        Object[] result = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSalaryNoDetailCount(), (Object[])new Object[]{attendPeriodId});
            if (rs != null && rs.next()) {
                int count = rs.getInt("CNT");
                logger.error((Object)("===========start checkSalaryNoDetailData total count: " + count + "=============="));
                if (count > 0) {
                    ArrayList<Object[]> salaryMDDetailParams = new ArrayList<Object[]>();
                    rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSalaryNoDetailSQL(), (Object[])new Object[]{attendPeriodId});
                    while (rs.next()) {
                        String id = rs.getString("FID");
                        salaryMDDetailParams.add(new Object[]{id});
                    }
                    Object[] paramsTemplateArr = new Object[]{salaryMDDetailParams};
                    result = AtsDbUtil.executeBatch(ctx, salaryMDDetailParams.size(), AtsDbUtil.getBatchCount(), new String[]{SumSalaryDataCheckUtil.getTranSalaryDetailTemplateSQL()}, paramsTemplateArr);
                    if (null != result && result.length == 2) {
                        logger.error((Object)("===========end checkSalaryNoDetailData total count: " + count + ",success count: " + result[0] + ",errorMsg: " + result[1] + "=========="));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Object[] checkAndFixSumNoSalaryDataByPerson(Context ctx, String attendPeriodId) {
        Object[] result = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSumNoSalaryCount(), (Object[])new Object[]{attendPeriodId});
            if (rs != null && rs.next()) {
                int count = rs.getInt("CNT");
                logger.error((Object)("===========start checkSumNoSalaryDataByPerson total count: " + count + "=============="));
                if (count > 0) {
                    ArrayList<Object[]> salaryMDDetailParams = new ArrayList<Object[]>();
                    ArrayList<Object[]> salaryMDParams = new ArrayList<Object[]>();
                    rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSumNoSalarySQL(), (Object[])new Object[]{attendPeriodId});
                    while (rs.next()) {
                        String id = rs.getString("FID");
                        salaryMDDetailParams.add(new Object[]{id});
                        salaryMDParams.add(new Object[]{id});
                    }
                    Object[] paramsTemplateArr = new Object[]{salaryMDParams, salaryMDDetailParams};
                    result = AtsDbUtil.executeBatch(ctx, salaryMDParams.size(), AtsDbUtil.getBatchCount(), SumSalaryDataCheckUtil.getTranSalaryTemplateSQLArrByPerson(), paramsTemplateArr);
                    if (null != result && result.length == 2) {
                        logger.error((Object)("===========end checkSumNoSalaryDataByPerson total count: " + count + ",success count: " + result[0] + ",errorMsg: " + result[1] + "=========="));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Object[] checkAndFixSalaryNoDetailDataByPerson(Context ctx, String attendPeriodId) {
        Object[] result = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSalaryNoDetailCountByPerson(), (Object[])new Object[]{attendPeriodId});
            if (rs != null && rs.next()) {
                int count = rs.getInt("CNT");
                logger.error((Object)("===========start checkSalaryNoDetailDataByPerson total count: " + count + "=============="));
                if (count > 0) {
                    ArrayList<Object[]> salaryMDDetailParams = new ArrayList<Object[]>();
                    rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSalaryNoDetailSQLByPerson(), (Object[])new Object[]{attendPeriodId});
                    while (rs.next()) {
                        String id = rs.getString("FID");
                        salaryMDDetailParams.add(new Object[]{id});
                    }
                    Object[] paramsTemplateArr = new Object[]{salaryMDDetailParams};
                    result = AtsDbUtil.executeBatch(ctx, salaryMDDetailParams.size(), AtsDbUtil.getBatchCount(), new String[]{SumSalaryDataCheckUtil.getTranSalaryDetailTemplateSQLByPerson()}, paramsTemplateArr);
                    if (null != result && result.length == 2) {
                        logger.error((Object)("===========end checkSalaryNoDetailDataByPerson total count: " + count + ",success count: " + result[0] + ",errorMsg: " + result[1] + "=========="));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Object[] checkAndFixSumNoSalaryDataByHRPerson(Context ctx, String attendPeriodId) {
        Object[] result = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSumNoSalaryCount(), (Object[])new Object[]{attendPeriodId});
            if (rs != null && rs.next()) {
                int count = rs.getInt("CNT");
                logger.error((Object)("===========start checkSumNoSalaryDataByPerson total count: " + count + "=============="));
                if (count > 0) {
                    ArrayList<Object[]> salaryMDDetailParams = new ArrayList<Object[]>();
                    ArrayList<Object[]> salaryMDParams = new ArrayList<Object[]>();
                    rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSumNoSalarySQL(), (Object[])new Object[]{attendPeriodId});
                    while (rs.next()) {
                        String id = rs.getString("FID");
                        salaryMDDetailParams.add(new Object[]{id});
                        salaryMDParams.add(new Object[]{id});
                    }
                    Object[] paramsTemplateArr = new Object[]{salaryMDParams, salaryMDDetailParams};
                    result = AtsDbUtil.executeBatch(ctx, salaryMDParams.size(), AtsDbUtil.getBatchCount(), SumSalaryDataCheckUtil.getTranSalaryTemplateSQLArrByHRPerson(), paramsTemplateArr);
                    if (null != result && result.length == 2) {
                        logger.error((Object)("===========end checkSumNoSalaryDataByPerson total count: " + count + ",success count: " + result[0] + ",errorMsg: " + result[1] + "=========="));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Object[] checkAndFixSumNoSalaryDataByHRPersonAtt(Context ctx, String attendPeriodId) {
        Object[] result = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSumNoSalaryCount(), (Object[])new Object[]{attendPeriodId});
            if (rs != null && rs.next()) {
                int count = rs.getInt("CNT");
                logger.error((Object)("===========start checkSumNoSalaryDataByPerson total count: " + count + "=============="));
                if (count > 0) {
                    ArrayList<Object[]> salaryMDDetailParams = new ArrayList<Object[]>();
                    ArrayList<Object[]> salaryMDParams = new ArrayList<Object[]>();
                    rs = DbUtil.executeQuery((Context)ctx, (String)SumSalaryDataCheckUtil.getExistsSumNoSalarySQL(), (Object[])new Object[]{attendPeriodId});
                    while (rs.next()) {
                        String id = rs.getString("FID");
                        salaryMDDetailParams.add(new Object[]{id});
                        salaryMDParams.add(new Object[]{id});
                    }
                    Object[] paramsTemplateArr = new Object[]{salaryMDParams, salaryMDDetailParams};
                    result = AtsDbUtil.executeBatch(ctx, salaryMDParams.size(), AtsDbUtil.getBatchCount(), SumSalaryDataCheckUtil.getTranSalaryTemplateSQLArrByHRPersonAtt(), paramsTemplateArr);
                    if (null != result && result.length == 2) {
                        logger.error((Object)("===========end checkSumNoSalaryDataByPerson total count: " + count + ",success count: " + result[0] + ",errorMsg: " + result[1] + "=========="));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

