/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.save;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AtsResultToSumBatchSave {
    public Logger logger = Logger.getLogger(AtsResultToSumBatchSave.class);

    public Map<String, Object> submitAttendResultSumRecordData(Context ctx, List<LinkedHashMap<String, Object>> DataList, List<String> keyList, Map<String, Object> existedSumRecord, Map<String, Object> params) {
        Map filterItems = (Map)params.get("sumParams");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> successMap = new HashMap<String, Object>();
        HashMap<String, Object> hasSalaryMap = new HashMap<String, Object>();
        resultMap.put("SUCCESS_MAP", successMap);
        resultMap.put("HASSALARY_MAP", hasSalaryMap);
        Set<String> existedSumKeys = existedSumRecord.keySet();
        try {
            this.checkData(DataList, existedSumRecord, hasSalaryMap);
            for (int i = 0; i < DataList.size(); ++i) {
                LinkedHashMap<String, Object> linkMap = DataList.get(i);
                String personId = (String)linkMap.get("personId");
                String hrOrgUnitId = (String)linkMap.get("hrOrgUnitId");
                String adminOrgUnitId = (String)linkMap.get("adminOrgUnitId");
                String sumKey = hrOrgUnitId + personId + adminOrgUnitId;
                String sumKeyUnderLine = hrOrgUnitId + "_" + personId + "_" + adminOrgUnitId;
                String resultId = (String)linkMap.get("resultId");
                if (StringUtils.isEmpty((String)resultId)) {
                    successMap.put(sumKey, null);
                    continue;
                }
                String sum_key_Msg = (String)linkMap.get("hrOrgName") + "-" + (String)linkMap.get("orgName") + "-" + (String)linkMap.get("personName") + "(" + (String)linkMap.get("personNumber") + ")";
                try {
                    if (!StringUtils.isEmpty((String)((String)linkMap.get("salaryStatus"))) && ((String)linkMap.get("salaryStatus")).equals("1")) {
                        hasSalaryMap.put(sumKey, sum_key_Msg);
                        continue;
                    }
                    if (existedSumKeys.contains(sumKey)) {
                        this.doExistedSumRecord(ctx, resultMap, linkMap, keyList, filterItems, sumKeyUnderLine);
                        continue;
                    }
                    this.doNewSumRecord(ctx, resultMap, linkMap, keyList, filterItems, sumKeyUnderLine);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("PAGE: RESULTTOSUM sum or transalary single record failed,sum_key_Msg:" + sum_key_Msg + " sumKey:" + sumKey));
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("PAGE: RESULTTOSUM gather by page fail\uff01DataList size: " + DataList.size() + ",DataList:" + DataList.toString()));
            e.printStackTrace();
        }
        return resultMap;
    }

    public void checkData(List<LinkedHashMap<String, Object>> DataList, Map<String, Object> existedSumRecord, Map<String, Object> hasSalaryMap) {
    }

    public void doExistedSumRecord(Context ctx, Map resultMap, LinkedHashMap<String, Object> linkMap, List<String> keyList, Map<String, String> filterItems, String sumKeyUnderLine) {
        String[] sumKeyArr = sumKeyUnderLine.split("_");
        String hrOrgUnitId = sumKeyArr[0];
        String personId = sumKeyArr[1];
        String adminOrgUnitId = sumKeyArr[2];
        String sumKey = hrOrgUnitId + personId + adminOrgUnitId;
        ArrayList<Object[]> updateSumParams = new ArrayList<Object[]>();
        ArrayList<Object[]> updateSumSalaryParams = new ArrayList<Object[]>();
        ArrayList<Object[]> insertSalaryParams = new ArrayList<Object[]>();
        ArrayList<Object[]> insertSalaryDetailParams = new ArrayList<Object[]>();
        ArrayList<Object[]> insertItemToSalaryDetailParams = new ArrayList<Object[]>();
        HashSet<String> sumIdSet = new HashSet<String>();
        HashMap<String, Object> successMap = new HashMap<String, Object>();
        HashMap<String, Object> auditedMap = new HashMap<String, Object>();
        HashMap<String, Object> hasSalaryMap = new HashMap<String, Object>();
        String fid = (String)linkMap.get("fid");
        String salaryStatus = filterItems.get("salaryStatus");
        String salaryStatusDB = (String)linkMap.get("salaryStatus");
        try {
            if (!StringUtils.isEmpty((String)salaryStatus) && 1 == Integer.valueOf(salaryStatus)) {
                if (!StringUtils.isEmpty((String)salaryStatusDB) && !salaryStatusDB.equals("3")) {
                    updateSumParams.add(this.genUpdateSumParam(ctx, keyList, fid, linkMap, filterItems, 3));
                    sumIdSet.add(fid);
                }
                updateSumSalaryParams.add(this.genUpdateSumSalaryParam(ctx, linkMap, fid));
                insertSalaryParams.add(new Object[]{fid});
                insertSalaryDetailParams.add(this.genInsertSalaryDetailParam(hrOrgUnitId, personId, adminOrgUnitId, filterItems.get("beginDate"), filterItems.get("endDate")));
                insertItemToSalaryDetailParams.add(this.genInsertItemToSalaryDetailParam(hrOrgUnitId, personId, adminOrgUnitId, filterItems.get("beginDate"), filterItems.get("endDate")));
                successMap.put(sumKey, null);
            } else if (StringUtils.isEmpty((String)salaryStatusDB) || salaryStatusDB.equals("2")) {
                updateSumParams.add(this.genUpdateSumParam(ctx, keyList, fid, linkMap, filterItems, 2));
                sumIdSet.add(fid);
                successMap.put(sumKey, null);
            } else {
                String sum_key_Msg = (String)linkMap.get("hrOrgName") + "-" + (String)linkMap.get("orgName") + "-" + (String)linkMap.get("personName") + "(" + (String)linkMap.get("personNumber") + ")";
                auditedMap.put(sumKey, sum_key_Msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.assembleSumData(resultMap, null, updateSumParams, updateSumSalaryParams, insertSalaryParams, insertSalaryDetailParams, insertItemToSalaryDetailParams, sumIdSet, successMap, auditedMap, hasSalaryMap);
    }

    public void doNewSumRecord(Context ctx, Map resultMap, LinkedHashMap<String, Object> linkMap, List<String> keyList, Map<String, String> filterItems, String sumKeyUnderLine) {
        String[] sumKeyArr = sumKeyUnderLine.split("_");
        String hrOrgUnitId = sumKeyArr[0];
        String personId = sumKeyArr[1];
        String adminOrgUnitId = sumKeyArr[2];
        String sumKey = hrOrgUnitId + personId + adminOrgUnitId;
        ArrayList<Object[]> insertSumParams = new ArrayList<Object[]>();
        ArrayList<Object[]> updateSumSalaryParams = new ArrayList<Object[]>();
        ArrayList<Object[]> insertSalaryParams = new ArrayList<Object[]>();
        ArrayList<Object[]> insertSalaryDetailParams = new ArrayList<Object[]>();
        ArrayList<Object[]> insertItemToSalaryDetailParams = new ArrayList<Object[]>();
        HashSet<String> sumIdSet = new HashSet<String>();
        HashMap<String, Object> successMap = new HashMap<String, Object>();
        String bosType = filterItems.get("BOSTYPE");
        if (StringUtils.isEmpty((String)bosType)) {
            bosType = "49FE8646";
        }
        try {
            String fid = this.genSumNewID(ctx, bosType);
            if (!StringUtils.isEmpty((String)fid)) {
                insertSumParams.add(this.genInsertSumParam(ctx, keyList, linkMap, filterItems, fid));
                if (!StringUtils.isEmpty((String)filterItems.get("salaryStatus")) && 1 == Integer.valueOf(filterItems.get("salaryStatus"))) {
                    updateSumSalaryParams.add(this.genUpdateSumSalaryParam(ctx, linkMap, fid));
                    insertSalaryParams.add(new Object[]{fid});
                    insertSalaryDetailParams.add(this.genInsertSalaryDetailParam(hrOrgUnitId, personId, adminOrgUnitId, filterItems.get("beginDate"), filterItems.get("endDate")));
                    insertItemToSalaryDetailParams.add(this.genInsertItemToSalaryDetailParam(hrOrgUnitId, personId, adminOrgUnitId, filterItems.get("beginDate"), filterItems.get("endDate")));
                }
                sumIdSet.add(fid);
                successMap.put(sumKey, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.assembleSumData(resultMap, insertSumParams, null, updateSumSalaryParams, insertSalaryParams, insertSalaryDetailParams, insertItemToSalaryDetailParams, sumIdSet, successMap, null, null);
    }

    public Object[] genUpdateSumSalaryParam(Context ctx, LinkedHashMap<String, Object> linkMap, String fid) {
        Object[] sum_salary_updateParam = new Object[]{1, linkMap.get("attendPeriodName"), linkMap.get("attendPeriodId"), new Timestamp(System.currentTimeMillis()), HRFilterUtils.getCurrentUserId((Context)ctx), fid, 1};
        return sum_salary_updateParam;
    }

    public Object[] genInsertSumParam(Context ctx, List<String> keyList, LinkedHashMap<String, Object> linkMap, Map<String, String> filterItems, String fid) throws AtsCommonBizException {
        ArrayList<Object> valList = new ArrayList<Object>();
        for (int j = 0; j < keyList.size(); ++j) {
            valList.add(linkMap.get(keyList.get(j)));
        }
        if (keyList.size() != valList.size()) {
            throw new AtsCommonBizException(AtsCommonBizException.SAVEFAILWITHPARAM, new Object[]{"genateSumInsertParam", keyList.size() != valList.size()});
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String personNumber = (String)linkMap.get("personNumber");
        String positionName = (String)linkMap.get("PositionName");
        String positionId = (String)linkMap.get("fpositionID");
        String hrOrgUnitId = (String)linkMap.get("hrOrgUnitId");
        Integer sumType = Integer.valueOf(filterItems.get("sumType"));
        for (int i = 0; keyList.size() > i; ++i) {
            String key = keyList.get(i);
            if (key.equalsIgnoreCase("fid")) {
                paramList.add(fid);
                continue;
            }
            if (!key.startsWith("S")) continue;
            if ((key.equals("S1") || key.equals("S2") || key.equals("S3") || key.equals("S4") || key.equals("S5") || key.equals("S6")) && (valList.get(i) == null || StringUtils.isEmpty((String)((String)valList.get(i))))) {
                paramList.add(SQLType.DATETIME);
                continue;
            }
            String dataType = filterItems.get("ATSPROJECT_" + key);
            if (!StringUtils.isEmpty((String)dataType) && dataType.equals("5") && (null == valList.get(i) || StringUtils.isEmpty((String)((String)valList.get(i))))) {
                paramList.add(SQLType.DATETIME);
                continue;
            }
            paramList.add(null == valList.get(i) ? "" : valList.get(i));
        }
        paramList.add((String)linkMap.get("attendPeriodName"));
        paramList.add((String)linkMap.get("attendPeriodId"));
        paramList.add((String)linkMap.get("personId"));
        paramList.add((String)linkMap.get("adminOrgUnitId"));
        paramList.add((String)linkMap.get("attadminOrgUnitId"));
        paramList.add(2);
        paramList.add(null == personNumber ? "" : personNumber);
        paramList.add(null == positionName ? "" : positionName);
        paramList.add(null == positionId ? "" : positionId);
        paramList.add(null == hrOrgUnitId ? "" : hrOrgUnitId);
        paramList.add(new Timestamp(System.currentTimeMillis()));
        paramList.add(HRFilterUtils.getCurrentUserId((Context)ctx));
        paramList.add(sumType);
        return paramList.toArray();
    }

    public static String genInsertSumSqlTemplate(Context ctx, List<String> keyList, String tableName) {
        StringBuffer keySb = new StringBuffer();
        StringBuffer valSb = new StringBuffer();
        for (int i = 0; keyList.size() > i; ++i) {
            String key = keyList.get(i);
            if (!key.equalsIgnoreCase("fid") && !key.startsWith("S")) continue;
            keySb.append(keyList.get(i) + ",");
            valSb.append("?,");
        }
        keySb.append("FSALARYPERIOD, FATTENDANCEPERIODID, FPROPOSERID, FADMINORGUNITID, FATTADMINORGUNITID, FSALARYSTATUS,");
        keySb.append("FNUMBER, FNAME" + MLUtile.getMlFlag(ctx) + ", FPOSITIONID, FHRORGUNITID, FCREATETIME,FCREATORID,FSUMTYPE ");
        valSb.append(" ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ");
        String sql = "INSERT INTO " + tableName + "( " + keySb.toString() + " )  VALUES( " + valSb.toString() + " )";
        return sql;
    }

    public Object[] genUpdateSumParam(Context ctx, List<String> keyList, String fid, LinkedHashMap<String, Object> linkMap, Map<String, String> filterItems, int salaryStatus) throws Exception {
        ArrayList<Object> valList = new ArrayList<Object>();
        for (int j = 0; j < keyList.size(); ++j) {
            valList.add(linkMap.get(keyList.get(j)));
        }
        if (keyList.size() != valList.size()) {
            throw new Exception((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.SAVEFAILWITHPARAM, new Object[]{"genateUpdateCon", keyList.size() != valList.size()})));
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (int i = 0; keyList.size() > i; ++i) {
            String dataType;
            String key = keyList.get(i);
            if (!key.startsWith("S")) continue;
            if (null == valList.get(i)) {
                // empty if block
            }
            if ((key.equals("S1") || key.equals("S2") || key.equals("S3") || key.equals("S4") || key.equals("S5") || key.equals("S6")) && (valList.get(i) == null || StringUtils.isEmpty((String)((String)valList.get(i))))) {
                paramList.add(SQLType.DATETIME);
                continue;
            }
            if (null != filterItems && !StringUtils.isEmpty((String)(dataType = filterItems.get("ATSPROJECT_" + key))) && dataType.equals("5") && (null == valList.get(i) || StringUtils.isEmpty((String)((String)valList.get(i))))) {
                paramList.add(SQLType.DATETIME);
                continue;
            }
            paramList.add(null == valList.get(i) ? "" : valList.get(i));
        }
        paramList.add(linkMap.get("attendPeriodName"));
        paramList.add(linkMap.get("attendPeriodId"));
        paramList.add(new Timestamp(System.currentTimeMillis()));
        paramList.add(HRFilterUtils.getCurrentUserId((Context)ctx));
        paramList.add(salaryStatus);
        paramList.add(Integer.valueOf(filterItems.get("sumType")));
        paramList.add(fid);
        paramList.add(1);
        return paramList.toArray();
    }

    public static String genUpdateSumSqlTemplate(Context ctx, List<String> keyList, String tableName) {
        StringBuffer oqlSb = new StringBuffer();
        oqlSb.append(" UPDATE " + tableName + " SET ");
        for (int i = 0; keyList.size() > i; ++i) {
            String key = keyList.get(i);
            if (!key.startsWith("S")) continue;
            oqlSb.append(key + " = ?,");
        }
        oqlSb.append(" FSALARYPERIOD=?, FATTENDANCEPERIODID=?, FLASTUPDATETIME=?, FLASTUPDATEUSERID=?, FSALARYSTATUS=?,FSUMTYPE=? ");
        oqlSb.append(" WHERE FID=? AND FSALARYSTATUS <> ? ");
        return oqlSb.toString();
    }

    public Object[] genInsertSalaryDetailParam(String hrOrgUnitId, String personId, String adminOrgUnitId, String beginDate, String endDate) {
        Object[] sum_updateParam = new Object[]{hrOrgUnitId, personId, adminOrgUnitId, AtsDateUtils.stringShortToTimestamp(beginDate), AtsDateUtils.stringShortToTimestamp(endDate)};
        return sum_updateParam;
    }

    public Object[] genInsertItemToSalaryDetailParam(String hrOrgUnitId, String personId, String adminOrgUnitId, String beginDate, String endDate) {
        Object[] sum_updateParam = new Object[]{hrOrgUnitId, personId, adminOrgUnitId, AtsDateUtils.stringShortToTimestamp(beginDate), AtsDateUtils.stringShortToTimestamp(endDate)};
        return sum_updateParam;
    }

    public String genInsertSalaryDetailSqlTemplate(String resultTableName, String resultSalaryTableName) {
        StringBuffer insertDetailMdSql = new StringBuffer();
        insertDetailMdSql.append(" INSERT INTO " + resultSalaryTableName + "  SELECT * FROM " + resultTableName + " ");
        insertDetailMdSql.append(" WHERE FATTHRORGUNITID =? AND FPROPOSERID = ? AND FADMINORGUNITID = ? ");
        insertDetailMdSql.append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        return insertDetailMdSql.toString();
    }

    public String genUpdateSumSalarySqlTemplate(String tableName) {
        return "UPDATE " + tableName + " SET FSALARYSTATUS=?, FSALARYPERIOD=?,FATTENDANCEPERIODID=?, FLASTUPDATETIME=? ,FLASTUPDATEUSERID=? WHERE FID= ? AND FSALARYSTATUS <> ? ";
    }

    public String genInsertSalarySqlTemplate(String sumTableName, String salaryTableName) {
        return "INSERT INTO " + salaryTableName + "  SELECT * FROM " + sumTableName + "  WHERE  FID = ? ";
    }

    public void assembleSumData(Map resultMap, List<Object[]> insertSumParams, List<Object[]> updateSumParams, List<Object[]> updateSumSalaryParams, List<Object[]> insertSalaryParams, List<Object[]> insertSalaryDetailParams, List<Object[]> insertItemToSalaryDetailParams, Set<String> sumIdSet, Map<String, Object> successMap, Map<String, Object> auditedMap, Map<String, Object> hasSalaryMap) {
        this.putParamsToMap(resultMap, insertSumParams, "INSERT_SUM_PARAMS");
        this.putParamsToMap(resultMap, updateSumParams, "UPDATE_SUM_PARAMS");
        this.putParamsToMap(resultMap, updateSumSalaryParams, "SUM_SALARY_UPDATE_PARAMS");
        this.putParamsToMap(resultMap, insertSalaryParams, "SALARY_INSERT_PARAMS");
        this.putParamsToMap(resultMap, insertSalaryDetailParams, "SALARY_DETAIL_INSERT_PARAMS");
        this.putParamsToMap(resultMap, insertItemToSalaryDetailParams, "ITEM_TO_SALARY_DETAIL_INSERT_PARAMS");
        this.putParamsToMap(resultMap, sumIdSet, "SUMID_SET");
        this.putParamsToMap(resultMap, successMap, "SUCCESS_MAP");
        this.putParamsToMap(resultMap, auditedMap, "AUDITED_MAP");
        this.putParamsToMap(resultMap, hasSalaryMap, "HASSALARY_MAP");
    }

    public void putParamsToMap(Map resultMap, List<Object[]> params, String paramsName) {
        if (null != params && params.size() > 0 && !StringUtils.isEmpty((String)paramsName)) {
            if (null != resultMap.get(paramsName)) {
                ((List)resultMap.get(paramsName)).addAll(params);
            } else {
                resultMap.put(paramsName, params);
            }
        }
    }

    public void putParamsToMap(Map resultMap, Set<String> params, String paramsName) {
        if (null != params && params.size() > 0 && !StringUtils.isEmpty((String)paramsName)) {
            if (null != resultMap.get(paramsName)) {
                ((Set)resultMap.get(paramsName)).addAll(params);
            } else {
                resultMap.put(paramsName, params);
            }
        }
    }

    public void putParamsToMap(Map resultMap, Map<String, Object> params, String paramsName) {
        if (null != params && params.size() > 0 && !StringUtils.isEmpty((String)paramsName)) {
            if (null != resultMap.get(paramsName)) {
                ((Map)resultMap.get(paramsName)).putAll(params);
            } else {
                resultMap.put(paramsName, params);
            }
        }
    }

    public String genSumNewID(Context ctx, String bosType) throws BOSException, SQLException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("SELECT newbosid('" + bosType + "')"));
        if (rowSet != null && rowSet.size() > 0 && rowSet.next()) {
            return rowSet.getString(1);
        }
        return "";
    }
}

