/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.hr.ats.AtsFormulaResEnum;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.app.formula.calculate.ResultCal;
import com.kingdee.eas.hr.ats.common.AtsTempTableUtil;
import com.kingdee.eas.hr.ats.sum.factory.AtsSumFactory;
import com.kingdee.eas.hr.ats.sum.service.AtsSumCal;
import com.kingdee.eas.hr.ats.sum.service.AtsSumService;
import com.kingdee.eas.hr.ats.sum.service.formula.CalculateDynaCustomerResult;
import com.kingdee.eas.hr.ats.sum.util.AtsResultToSumHelper;
import com.kingdee.eas.hr.ats.sum.util.AtsSumSalaryUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsSumCalImpl
implements AtsSumCal {
    private AtsSumService atsSumService;
    private static Logger logger = Logger.getLogger(AtsSumCalImpl.class);
    Integer sumType;

    @Override
    public void setSumType(Integer sumType) {
        this.sumType = sumType;
    }

    @Override
    public int getSumType(Context ctx) {
        if (this.sumType == null) {
            return AtsSumSalaryUtil.getSystemParamIntValue(ctx, "3qBV2X0Zi0KK2Aaru9d9YaiB8+c=");
        }
        return this.sumType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> sumResult(Context ctx, Map<String, Object> sumParams) {
        int sumType = this.getSumType(ctx);
        this.initAtsSumService(sumType);
        String tempTableName = null;
        HashMap<String, Object> resultMap = new HashMap();
        try {
            Map filterItems = (Map)sumParams.get("sumParams");
            filterItems.put("sumType", sumType + "");
            tempTableName = this.atsSumService.prepareTempTable(ctx, sumParams);
            resultMap = this.batchSumResult(ctx, sumParams, tempTableName);
        }
        catch (Throwable throwable) {
            if (!StringUtils.isEmpty(tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
            throw throwable;
        }
        if (!StringUtils.isEmpty((String)tempTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
        return resultMap;
    }

    private Map<String, Object> batchSumResult(Context ctx, Map<String, Object> sumParams, String tempTableName) {
        int totalCount = AtsResultToSumHelper.getQueryTotalCount(ctx, tempTableName);
        logger.error((Object)("------RESULTTOSUM start totalCount: " + totalCount + "--------"));
        long startTime = System.currentTimeMillis();
        Map filterItems = (Map)sumParams.get("sumParams");
        filterItems.put("tempTableName", tempTableName);
        sumParams.put("tempTableName", tempTableName);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int rows = 100;
        int pages = 0;
        pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
        filterItems.put("rows", Integer.toString(rows));
        Map<String, String> columnMap = this.atsSumService.getColumnMap(ctx, this.atsSumService.getSelector(ctx, "summaryTitleView"));
        List<String> keyList = this.atsSumService.getKeyList(ctx, "T_HR_ATS_ATTENDANCERESULTSUM", columnMap);
        for (int page = 1; page <= pages; ++page) {
            try {
                filterItems.put("page", Integer.toString(page));
                String sqlt = AtsResultToSumHelper.setAttencePanelTempTableSql(ctx, totalCount, filterItems, " * ");
                IRowSet sumKeyRows = DbUtil.executeQuery((Context)ctx, (String)sqlt);
                List<LinkedHashMap<String, Object>> sumRowLinkedList = this.atsSumService.getUnLockPersonList(ctx, sumParams, sumKeyRows);
                Map<String, Object> batchMsgMap = this.doSumResult(ctx, sumParams, columnMap, keyList, sumRowLinkedList);
                this.atsSumService.assembleMsg(ctx, batchMsgMap, resultMap);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            logger.error((Object)("PAGE END:detail trans gather per page cost: " + (System.currentTimeMillis() - startTime)));
        }
        logger.error((Object)"------RESULTTOSUM end -------------");
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> doSumResult(Context ctx, Map<String, Object> sumParams, Map<String, String> columnMap, List<String> keyList, List<LinkedHashMap<String, Object>> sumRowLinkedList) {
        void var8_10;
        Map<String, Object> existSumRecordSet;
        block7: {
            String sumKeyTmpTable = null;
            existSumRecordSet = null;
            HashMap hashMap = new HashMap();
            try {
                if (null != sumRowLinkedList && sumRowLinkedList.size() > 0) {
                    sumKeyTmpTable = this.atsSumService.prepareSumKeyTmpTable(ctx, sumRowLinkedList);
                    existSumRecordSet = this.atsSumService.getExistedSumRecordSet(ctx, sumParams, sumRowLinkedList, sumKeyTmpTable);
                    this.atsSumService.setDetailToSumRecord(ctx, sumKeyTmpTable, sumParams, sumRowLinkedList, columnMap);
                    Map<String, Object> map = this.atsSumService.sum(ctx, sumRowLinkedList, keyList, existSumRecordSet, sumParams);
                    this.atsSumService.saveSumRecord(ctx, map, keyList);
                }
                var8_10.put("LOCK_MAP", sumParams.get("LOCK_MAP"));
                if (StringUtils.isEmpty((String)sumKeyTmpTable)) break block7;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                break block7;
            }
            AtsTempTableUtil.dropTable(ctx, sumKeyTmpTable);
            break block7;
            finally {
                if (!StringUtils.isEmpty(sumKeyTmpTable)) {
                    AtsTempTableUtil.dropTable(ctx, sumKeyTmpTable);
                }
            }
        }
        logger.error((Object)("PAGE END: RESULTTOSUM total records:" + (null == sumRowLinkedList ? 0 : sumRowLinkedList.size())));
        logger.error((Object)("PAGE END: RESULTTOSUM existAttendRecord size:" + (null == existSumRecordSet ? 0 : existSumRecordSet.size())));
        return var8_10;
    }

    @Override
    public Map<String, Object> sumSelectedResult(Context ctx, Map<String, Object> params) {
        int sumType = this.getSumType(ctx);
        this.initAtsSumService(sumType);
        Map filterItems = (Map)params.get("sumParams");
        filterItems.put("sumType", sumType + "");
        Map<String, String> columnMap = this.atsSumService.getColumnMap(ctx, this.atsSumService.getSelector(ctx, "summaryTitleView"));
        List<String> keyList = this.atsSumService.getKeyList(ctx, "T_HR_ATS_ATTENDANCERESULTSUM", columnMap);
        List<LinkedHashMap<String, Object>> sumRowLinkedList = this.atsSumService.getUnLockPersonList(ctx, params);
        Map<String, Object> resultMap = this.doSumResult(ctx, params, columnMap, keyList, sumRowLinkedList);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> sumResultForDynamic(Context ctx, Map<String, Object> sumParams) {
        int sumType = this.getSumType(ctx);
        this.initAtsSumService(sumType);
        String tempTableName = null;
        HashMap<String, Object> resultMap = new HashMap();
        try {
            Map filterItems = (Map)sumParams.get("sumParams");
            filterItems.put("sumType", sumType + "");
            tempTableName = AtsResultToSumHelper.getAttenceResultTempTable(ctx, filterItems, (String)filterItems.get("sumDynamicSql"));
            resultMap = this.batchSumResult(ctx, sumParams, tempTableName);
        }
        catch (Throwable throwable) {
            if (!StringUtils.isEmpty(tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
            throw throwable;
        }
        if (!StringUtils.isEmpty((String)tempTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> calCustomerSumResult(Context ctx, Map<String, Object> sumParams, Map<String, Object> resultMap) {
        try {
            if (null != resultMap && resultMap.size() > 0) {
                Map filterItems = (Map)sumParams.get("sumParams");
                String attencePolicyId = (String)filterItems.get("attendPolicyId");
                String dynamicSQL = (String)filterItems.get("sumDynamicSql");
                boolean calFormula = true;
                if (!StringUtils.isEmpty((String)attencePolicyId)) {
                    ResultCal cal = new ResultCal();
                    cal.setMainTableName("T_HR_ATS_AttendanceResultSum");
                    cal.setCtx(ctx);
                    IRowSet rowSet = cal.getSchemeFormulas(attencePolicyId);
                    if (rowSet == null || rowSet.size() == 0) {
                        calFormula = false;
                    }
                }
                if (calFormula) {
                    if (!StringUtils.isEmpty((String)dynamicSQL)) {
                        new CalculateDynaCustomerResult().calculateSumResult(ctx, filterItems, dynamicSQL, "ATS_RESULT");
                    } else {
                        Set sumIdSet = (Set)resultMap.get("SUMID_SET");
                        if (null != sumIdSet && sumIdSet.size() > 0) {
                            dynamicSQL = "SELECT ATS_RESULT.* FROM T_HR_ATS_ATTENDANCERESULTSUM ATS_RESULT WHERE FID IN (" + AtsUtil.convertSetToString(sumIdSet) + ") order by ATS_RESULT.FID desc";
                            new CalculateDynaCustomerResult().calculateSumResult(ctx, filterItems, dynamicSQL, "ATS_RESULT");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)(" result to sum calCustomerSumResult fail," + MLUtile.getRes(AtsFormulaResEnum.CallFail, ctx)));
            e.printStackTrace();
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> tranSalary(Context ctx, Map<String, Object> resultMap) {
        this.initAtsSumService(this.getSumType(ctx));
        this.atsSumService.tranSalary(ctx, resultMap);
        return resultMap;
    }

    public void initAtsSumService(int sumType) {
        AtsSumService atsSumService = AtsSumFactory.getInstance().createAtsSumService(sumType);
        this.setAtsSumService(atsSumService);
    }

    public AtsSumService getAtsSumService() {
        return this.atsSumService;
    }

    public void setAtsSumService(AtsSumService atsSumService) {
        this.atsSumService = atsSumService;
    }
}

