/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AttendancePeriodFactory;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.thread.ExecutorService.TaskPool;
import com.kingdee.eas.hr.ats.thread.executor.Callable;
import com.kingdee.eas.hr.ats.util.AtsDbUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AtsSumMulPozitionDeleteUtil {
    private static Logger logger = Logger.getLogger(AtsSumMulPozitionDeleteUtil.class);

    public static void dealSumMulPozitionErrorData(Context ctx, String attendPeriodId) {
        try {
            ThreadPoolExecutor pool = TaskPool.getFixedInstance("dealSumErrorData", 1, 100L);
            pool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String attendPeriodId = (String)this.getDependency();
                    AtsSumMulPozitionDeleteUtil.deleteOutDatedResSum(this.ctx, attendPeriodId);
                    return null;
                }
            }.setDependency(attendPeriodId).setCtx(ctx));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteOutDatedResSum(Context ctx, String attendPeriodId) {
        if (StringUtils.isEmpty((CharSequence)attendPeriodId)) {
            return false;
        }
        AtsSumMulPozitionDeleteUtil.deleteSumMulPozitionDataUnMatchByAtt(ctx, attendPeriodId, "T_HR_ATS_ATTRESULTITEMSUM");
        AtsSumMulPozitionDeleteUtil.deleteSumMulPozitionDataDuplicate(ctx, attendPeriodId, "T_HR_ATS_ATTRESULTITEMSUM", "T_HR_ATS_ATTRESULTITEMSUMMD");
        return true;
    }

    private static void deleteSumMulPozitionDataDuplicate(Context ctx, String attendPeriodId, String sumMulPozitionTableName, String sumMulPozitionSalaryTableName) {
        try {
            int sumRepeatCount;
            int salaryRepeatCount;
            StringBuilder mdStr = new StringBuilder();
            mdStr.append(" SELECT COUNT(*) CNT FROM " + sumMulPozitionSalaryTableName).append(" WHERE FATTENDANCEPERIODID = ? GROUP BY FPROPOSERID,FATTADMINORGUNITID ,FHRORGUNITID ,FATTENDANCEPERIODID ").append(" HAVING COUNT(*) > 1");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)mdStr.toString(), (Object[])new Object[]{attendPeriodId});
            if (rs.next() && (salaryRepeatCount = rs.getInt("CNT")) > 0) {
                StringBuilder mdDelStr = new StringBuilder();
                mdDelStr.append(" DELETE FROM " + sumMulPozitionSalaryTableName + " A WHERE A.FID < (SELECT MAX(B.FID) FROM " + sumMulPozitionSalaryTableName + " B ").append(" WHERE A.FPROPOSERID = B.FPROPOSERID ").append(" AND A.FATTADMINORGUNITID=B.FATTADMINORGUNITID ").append(" AND A.FHRORGUNITID =B.FHRORGUNITID ").append(" AND A.FATTENDANCEPERIODID = B.FATTENDANCEPERIODID ) ").append(" AND A.FATTENDANCEPERIODID = ? ");
                DbUtil.execute((Context)ctx, (String)mdDelStr.toString(), (Object[])new Object[]{attendPeriodId});
            }
            StringBuilder sumStr = new StringBuilder();
            sumStr.append(" SELECT COUNT(*) CNT FROM  " + sumMulPozitionTableName).append(" WHERE FATTENDANCEPERIODID = ? GROUP BY FPROPOSERID ,FATTADMINORGUNITID,FHRORGUNITID ,FATTENDANCEPERIODID ").append(" HAVING COUNT(*) > 1");
            rs = DbUtil.executeQuery((Context)ctx, (String)mdStr.toString(), (Object[])new Object[]{attendPeriodId});
            if (rs.next() && (sumRepeatCount = rs.getInt("CNT")) > 0) {
                StringBuilder sumDelStr = new StringBuilder();
                sumDelStr.append(" DELETE FROM " + sumMulPozitionTableName + " A WHERE A.FID < (SELECT MAX(B.FID) FROM " + sumMulPozitionTableName + " B ").append(" WHERE A.FPROPOSERID = B.FPROPOSERID ").append(" AND A.FATTADMINORGUNITID=B.FATTADMINORGUNITID ").append(" AND A.FHRORGUNITID =B.FHRORGUNITID ").append(" AND A.FATTENDANCEPERIODID = B.FATTENDANCEPERIODID ) ").append(" AND A.FATTENDANCEPERIODID = ? ");
                DbUtil.execute((Context)ctx, (String)sumDelStr.toString(), (Object[])new Object[]{attendPeriodId});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteSumMulPozitionDataUnMatchByAtt(Context ctx, String attendPeriodId, String tableName) {
        try {
            AttendancePeriodInfo atsPeriod = AttendancePeriodFactory.getLocalInstance(ctx).getAttendancePeriodInfo("select startDate,endDate,name where id='" + attendPeriodId + "'");
            StringBuilder queryStr = new StringBuilder();
            queryStr.append(" select resSum.fid,resSum.FHrOrgUnitID, resSum.FAdminOrgUnitId,resSum.FATTAdminOrgUnitId,resSum.fproposerid").append(" from " + tableName + " resSum  ").append(" where not exists (select 1 from T_HR_ATS_ATTRESULTITEM ATTITEM  WHERE ATTITEM.FPROPOSERID=resSum.FProposerID  ").append(" and ATTITEM.FatthrOrgUnitId = resSum.FhrOrgUnitId ").append(" and ATTITEM.FATTAdminOrgUnitId = resSum.FATTAdminOrgUnitId ").append(" and  ATTITEM.FATTENCEDATE >= ? and ATTITEM.FATTENCEDATE <= ? )").append(" and resSum.FAttendancePeriodID = ? ").append(" and resSum.FSalaryStatus = 2 ");
            IRowSet queryRs = DbUtil.executeQuery((Context)ctx, (String)queryStr.toString(), (Object[])new Object[]{new Timestamp(atsPeriod.getStartDate().getTime()), new Timestamp(atsPeriod.getEndDate().getTime()), attendPeriodId});
            AtsSumMulPozitionDeleteUtil.deleteDataAndRecordLog(ctx, attendPeriodId, queryRs, queryStr.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteDataAndRecordLog(Context ctx, String attendPeriodId, IRowSet queryRs, String querySql) throws SQLException, BOSException, EASBizException {
        StringBuilder logResult = new StringBuilder();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        String fid = null;
        while (queryRs.next()) {
            logResult.append(queryRs.getString("fid") + ":");
            logResult.append(queryRs.getString("FHrOrgUnitID") + ",");
            logResult.append(queryRs.getString("FATTAdminOrgUnitId") + ",");
            logResult.append(queryRs.getString("fproposerid") + ";");
            params.add(new Object[]{queryRs.getString("fid")});
            fid = queryRs.getString("fid");
        }
        if (params.size() > 0) {
            AttendancePeriodInfo atsPeriod = AttendancePeriodFactory.getLocalInstance(ctx).getAttendancePeriodInfo("select startDate,endDate,name where id='" + attendPeriodId + "'");
            String deleteStr = " delete from T_HR_ATS_ATTRESULTITEMSUM where fid = ? ";
            DbUtil.executeBatch((Context)ctx, (String)deleteStr.toString(), params);
            logResult.insert(0, "totalCount:\u3010" + params.size() + "\u3011");
            querySql = " delete from T_HR_ATS_ATTRESULTITEMSUM where fid in ( " + querySql + ")";
            DataLogUtil.saveSumDataLogBySalary(ctx, attendPeriodId, atsPeriod.getName(), querySql.toString(), logResult.toString(), fid, OperActionEnum.deleteInvalidData, OperTypeEnum.attResultItemSum);
        }
    }

    public static Object[] checkAndFixSumMulPozitionNoSalaryData(Context ctx, String attendPeriodId) {
        Object[] result = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)AtsSumMulPozitionDeleteUtil.getExistsSumMulPoztionNoSalaryCount(), (Object[])new Object[]{attendPeriodId});
            if (rs != null && rs.next()) {
                int count = rs.getInt("CNT");
                logger.error((Object)("===========start checkSumMulPozitionNoSalaryDataByPerson total count: " + count + "=============="));
                if (count > 0) {
                    ArrayList<Object[]> salaryMDParams = new ArrayList<Object[]>();
                    rs = DbUtil.executeQuery((Context)ctx, (String)AtsSumMulPozitionDeleteUtil.getExistsSumMulPoztionNoSalarySQL(), (Object[])new Object[]{attendPeriodId});
                    while (rs.next()) {
                        String id = rs.getString("FID");
                        salaryMDParams.add(new Object[]{id});
                    }
                    Object[] paramsTemplateArr = new Object[]{salaryMDParams};
                    result = AtsDbUtil.executeBatch(ctx, salaryMDParams.size(), AtsDbUtil.getBatchCount(), AtsSumMulPozitionDeleteUtil.getTranSalaryTemplateSQL(), paramsTemplateArr);
                    if (null != result && result.length == 2) {
                        logger.error((Object)("===========end checkSumMulPozitionNoSalaryDataByPerson total count: " + count + ",success count: " + result[0] + ",errorMsg: " + result[1] + "=========="));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getExistsSumMulPoztionNoSalaryCount() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT COUNT(A.FID) CNT FROM T_HR_ATS_ATTRESULTITEMSUM A ").append(" WHERE A.FSALARYSTATUS  = 1 AND NOT EXISTS (SELECT 1 FROM T_HR_ATS_ATTRESULTITEMSUMMD B WHERE A.FID = B.FID) ").append(" AND A.FATTENDANCEPERIODID = ? ");
        return sb.toString();
    }

    public static String getExistsSumMulPoztionNoSalarySQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT FID FROM T_HR_ATS_ATTRESULTITEMSUM A ").append(" WHERE A.FSALARYSTATUS  = 1 AND NOT EXISTS (SELECT 1 FROM T_HR_ATS_ATTRESULTITEMSUMMD B WHERE A.FID = B.FID) ").append(" AND A.FATTENDANCEPERIODID = ? ");
        return sb.toString();
    }

    public static String[] getTranSalaryTemplateSQL() {
        return new String[]{"INSERT INTO T_HR_ATS_ATTRESULTITEMSUMMD  SELECT * FROM T_HR_ATS_ATTRESULTITEMSUM  WHERE  FID = ? "};
    }
}

