/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.dingtalk;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.HttpSendUtil;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DDSyncURLUtil {
    public static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.trdsync.ddsync.util.DDSyncURLUtil");
    public static Map tokenMap = null;
    public static final String DEFAULT_MCLOUD = "https://oapi.dingtalk.com";
    public static final String DD_TOKEN = "/gettoken";
    public static final String DD_LIST_RECORD = "/attendance/listRecord";
    public static final long EXPIRES_IN = 0x6DDD00L;

    public static String getSyncUrl(Context ctx, String syncTypeUrl) throws BOSException {
        String secret;
        String eip;
        Map config = new DDSyncHelper(ctx).getConfig();
        String mCloud = config.get("mCloud") == null ? DEFAULT_MCLOUD : (String)config.get("mCloud");
        String token = DDSyncURLUtil.getToken(mCloud, eip = (String)config.get("eip"), secret = (String)config.get("secret"));
        if (StringUtils.isEmpty((String)token)) {
            throw new BOSException("token is empty");
        }
        String syncUrl = mCloud + syncTypeUrl + "?access_token=" + token;
        return syncUrl;
    }

    private static String getToken(String headUrl, String corpid, String corpsecret) {
        if (tokenMap == null) {
            tokenMap = new HashMap();
            DDSyncURLUtil.sendToken(headUrl, corpid, corpsecret);
        } else {
            long currentTimeMillis;
            long effectTime = (Long)tokenMap.get("effectime");
            if (effectTime <= (currentTimeMillis = System.currentTimeMillis())) {
                DDSyncURLUtil.sendToken(headUrl, corpid, corpsecret);
            }
        }
        return tokenMap.get("token").toString();
    }

    private static void sendToken(String headUrl, String corpid, String corpsecret) {
        HashMap<String, String> tokenParam = new HashMap<String, String>();
        tokenParam.put("corpid", corpid);
        tokenParam.put("corpsecret", corpsecret);
        try {
            JSONObject tokenResult = HttpSendUtil.startGet((String)(headUrl + DD_TOKEN), tokenParam);
            if (tokenResult.getInteger("errcode") != 0) {
                logger.info((Object)("fetch token fail:" + tokenResult.getString("errmsg")));
            } else {
                String token = tokenResult.getString("access_token");
                long effectime = System.currentTimeMillis() + 0x6DDD00L;
                tokenMap.put("token", token);
                tokenMap.put("effectime", effectime - 300000L);
            }
        }
        catch (Exception e) {
            logger.info((Object)("fetch token fail;" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void clearTokenCache() {
        if (tokenMap != null) {
            tokenMap.clear();
        }
    }

    public static long getTime() {
        return new Date().getTime();
    }
}

