/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.dingtalk;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DingTalkHelper {
    public static Map<String, String> GetPerson2OpenId(Context ctx, String personIds, boolean idIsPersonId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = " select T_PM_EASDTUSERMAP.FPersonId,T_PM_EASDTUSERMAP.FXTID  from T_PM_EASDTUSERMAP  where FIsDelete != 1 ";
        if (StringUtils.isNotBlank((String)personIds)) {
            sql = sql + " and " + (idIsPersonId ? "T_PM_EASDTUSERMAP.FPersonId" : "T_PM_EASDTUSERMAP.FXTID") + " in ('" + personIds.replaceAll(",", "','") + "')";
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("FPersonId");
                if (StringUtils.isEmpty((String)fid)) continue;
                map.put(fid, rowSet.getString("FXTID"));
            }
        }
        catch (Exception e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        return map;
    }

    public static Map<String, PersonInfo> GetAllOpenID2Person(Context ctx, Set<String> personIds) {
        HashMap<String, PersonInfo> map = new HashMap<String, PersonInfo>();
        String sql = " select T_PM_EASDTUSERMAP.FPersonId,T_PM_EASDTUSERMAP.FXTID,T_BD_Person.FNumber as fnumber,T_BD_Person.fname" + MLUtile.getMlFlag(ctx) + " as fname from T_PM_EASDTUSERMAP inner join T_BD_Person on T_PM_EASDTUSERMAP.FPersonId=T_BD_Person.fid ";
        if (!AtsCollectionUtile.isEmpty(personIds)) {
            sql = sql + "where T_PM_EASDTUSERMAP.FPersonId in " + AtsCollectionUtile.joinForSqlWithBrackets(personIds);
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("FPersonId");
                if (StringUtils.isEmpty((String)fid)) continue;
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)fid));
                personInfo.setName(rowSet.getString("fname"));
                personInfo.setNumber(rowSet.getString("fnumber"));
                map.put(rowSet.getString("FXTID"), personInfo);
            }
        }
        catch (Exception e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        return map;
    }

    public static Map<String, AttendanceFileInfo> GetAllOpenID2AttendanceFile(Context ctx, Set<String> personIds) {
        HashMap<String, AttendanceFileInfo> map = new HashMap<String, AttendanceFileInfo>();
        String sql = " select T_PM_EASDTUSERMAP.FPersonId,T_PM_EASDTUSERMAP.FXTID,T_HR_ATS_AttendanceFile.FAdminOrgUnitId AS FAdminOrgUnitId, T_HR_ATS_AttendanceFile.FAttAdminOrgUnitId AS FAttAdminOrgUnitId,T_HR_ATS_AttendanceFile.FHrOrgUnitId AS FHrOrgUnitId, T_HR_ATS_AttendanceFile.FAttendanceNum as FAttendanceNum  from T_PM_EASDTUSERMAP inner join T_HR_ATS_AttendanceFile on T_PM_EASDTUSERMAP.FPersonId=T_HR_ATS_AttendanceFile.fproposerid ";
        if (!AtsCollectionUtile.isEmpty(personIds)) {
            sql = sql + "where T_PM_EASDTUSERMAP.FPersonId in " + AtsCollectionUtile.joinForSqlWithBrackets(personIds);
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("FPersonId");
                if (StringUtils.isEmpty((String)fid)) continue;
                AttendanceFileInfo attendanceFileInfo = new AttendanceFileInfo();
                attendanceFileInfo.setAttendanceNum(rowSet.getString("FAttendanceNum"));
                if (!StringUtils.isEmpty((String)rowSet.getString("FAdminOrgUnitId"))) {
                    AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                    adminOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FAdminOrgUnitId")));
                    attendanceFileInfo.setAdminOrgUnit(adminOrgUnitInfo);
                }
                if (!StringUtils.isEmpty((String)rowSet.getString("FAttAdminOrgUnitId"))) {
                    AdminOrgUnitInfo attAdminOrgUnitInfo = new AdminOrgUnitInfo();
                    attAdminOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FAttAdminOrgUnitId")));
                    attendanceFileInfo.setAttAdminOrgUnit(attAdminOrgUnitInfo);
                }
                if (!StringUtils.isEmpty((String)rowSet.getString("FHrOrgUnitId"))) {
                    HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
                    hrOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FHrOrgUnitId")));
                    attendanceFileInfo.setHrOrgUnit(hrOrgUnitInfo);
                }
                map.put(rowSet.getString("FXTID"), attendanceFileInfo);
            }
        }
        catch (Exception e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        return map;
    }
}

