/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.dingtalk;

import com.alibaba.fastjson.JSON;
import com.kingdee.eas.hr.ats.AtsCludHubResEnum;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.SignRecordFactory;
import com.kingdee.eas.hr.ats.SignRecordInfo;
import com.kingdee.eas.hr.ats.syn.OpenApiUrlKeyEnum;
import com.kingdee.eas.hr.ats.syn.dingtalk.DDSyncURLUtil;
import com.kingdee.eas.hr.ats.syn.dingtalk.DingTalkHelper;
import com.kingdee.eas.hr.ats.syn.dingtalk.DingTalkParserHelper;
import com.kingdee.eas.hr.ats.syn.punchcard.AbstractPunchCardSynProcessor;
import com.kingdee.eas.hr.ats.syn.synch.ECloudInterface;
import com.kingdee.eas.hr.ats.syn.synch.PunchCardSynEnv;
import com.kingdee.eas.hr.ats.syn.synch.SynHelper;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class DingTalkPunchCardSynProcessor
extends AbstractPunchCardSynProcessor {
    private Logger logger = AtsLog.getPunchcardCloudLog();

    public DingTalkPunchCardSynProcessor() {
        this.setOpenapikey(OpenApiUrlKeyEnum.DINGTALK.getValue());
    }

    @Override
    protected PunchCardSynEnv createPunchCardSynEnv() {
        PunchCardSynEnv punchCardSynEnv = super.createPunchCardSynEnv();
        punchCardSynEnv.setCloudInterface(ECloudInterface.NEWLIST);
        return punchCardSynEnv;
    }

    @Override
    protected JSONArray getOutData(PunchCardSynEnv punchCardSynEnv, Timestamp curSynStartTimeStamp) {
        com.alibaba.fastjson.JSONObject param = new com.alibaba.fastjson.JSONObject();
        String syncUrl = "";
        try {
            syncUrl = DDSyncURLUtil.getSyncUrl(this.getCtx(), "/attendance/listRecord");
            param.put("userIds", Arrays.asList(punchCardSynEnv.getOpenIds().split(",")));
            if (this.isFetchDataDayByDay()) {
                param.put("checkDateFrom", (Object)AtsDateUtils.timestampToString(curSynStartTimeStamp));
                param.put("checkDateTo", (Object)AtsDateUtils.dateLongToString(new Date(curSynStartTimeStamp.getTime() + 86400000L)));
            } else {
                param.put("checkDateFrom", (Object)AtsDateUtils.timestampToString(punchCardSynEnv.getWorkDateFrom()));
                param.put("checkDateTo", (Object)AtsDateUtils.timestampToString(punchCardSynEnv.getWorkDateTo()));
            }
            param.put("isI18n", (Object)"false");
            com.alibaba.fastjson.JSONObject returnValue = DingTalkPunchCardSynProcessor.startPost(param.toString(), syncUrl);
            if (null != returnValue && null != returnValue.get((Object)"recordresult")) {
                AtsLog.getPunchcardCloudLog().error((Object)returnValue.getJSONArray("recordresult").toJSONString());
                return JSONArray.fromObject((Object)returnValue.getJSONArray("recordresult"));
            }
        }
        catch (Exception e) {
            this.setGlobalException(e);
            String s = syncUrl + param.toString();
            this.add(MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item11, this.ctx, e.getMessage(), s));
            this.logger.error((Object)("fetch cloud data error:" + e.getMessage() + s), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static com.alibaba.fastjson.JSONObject startPost(String jsonBody, String url) throws IOException {
        String returnValue = "this is default return value, means method invoke failed!";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        BasicResponseHandler responseHandler = new BasicResponseHandler(){

            public String handleEntity(HttpEntity entity) throws IOException {
                return EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            }
        };
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            StringEntity requestEntity = new StringEntity(jsonBody, "UTF-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity((HttpEntity)requestEntity);
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception var15) {
            var15.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException var14) {
                var14.printStackTrace();
            }
        }
        return com.alibaba.fastjson.JSONObject.parseObject((String)new String(returnValue.getBytes("UTF-8"), "UTF-8"));
    }

    @Override
    protected void updatePunchCardSynEnv(JSONArray recordsJsonArr, PunchCardSynEnv punchCardSynEnv, boolean initPersonData) {
        this.logger.info((Object)("dataSize=" + (recordsJsonArr == null ? 0 : recordsJsonArr.size())));
        if (recordsJsonArr == null || recordsJsonArr.size() == 0) {
            return;
        }
        punchCardSynEnv.addCloudTotalSize(recordsJsonArr.size());
        if (initPersonData) {
            try {
                com.alibaba.fastjson.JSONArray array = JSON.parseArray((String)recordsJsonArr.toString());
                String openidField = ((com.alibaba.fastjson.JSONObject)array.get(0)).containsKey((Object)"openId") ? "openId" : "userId";
                this.initPunchcardSynEnv(punchCardSynEnv, AtsCollectionUtile.conectProperty(array, openidField), !initPersonData);
            }
            catch (Exception e) {
                this.add(MLUtile.getRes((ResourceEnum)AtsCommonResEnum.InitFail, this.ctx, "punchCardSynEnv", ":" + e.getMessage()));
                this.logger.error((Object)("punchCardSynEnv init error:" + e.getMessage()), (Throwable)e);
                return;
            }
        }
        for (int i = 0; i < recordsJsonArr.size(); ++i) {
            JSONObject json = recordsJsonArr.getJSONObject(i);
            if (!DingTalkParserHelper.isValid(json, this.ctx)) continue;
            if ("Outside".equals(json.getString("locationResult"))) {
                SignRecordInfo signRecordInfo = DingTalkParserHelper.assembleSignRecordInfo(json, punchCardSynEnv);
                punchCardSynEnv.addSignRcd(signRecordInfo);
                continue;
            }
            PunchCardRecordInfo crdInfo = DingTalkParserHelper.assemblePunchCardRecordInfo(json, punchCardSynEnv);
            punchCardSynEnv.addPunchCard(crdInfo);
        }
    }

    @Override
    protected void initPunchcardSynEnv(PunchCardSynEnv punchCardSynEnv, String ids, boolean idIsPersonId) throws Exception {
        if (StringUtils.isEmpty((String)ids)) {
            return;
        }
        Map<String, String> allPerson2OpenIdMap = DingTalkHelper.GetPerson2OpenId(this.ctx, ids, idIsPersonId);
        StringBuffer openIdsb = this.removeAndGetOpenIds(allPerson2OpenIdMap);
        if (openIdsb.length() == 0) {
            punchCardSynEnv.setOpenIds("");
            return;
        }
        punchCardSynEnv.setOpenIds(openIdsb.substring(0, openIdsb.length() - 1));
        Set<String> personIdSet = allPerson2OpenIdMap.keySet();
        punchCardSynEnv.setpMap(SynHelper.GetAllPersonInfo(this.ctx, personIdSet));
        punchCardSynEnv.setPpMap(SynHelper.GetAllPersonPositionInfo(this.ctx, personIdSet));
        punchCardSynEnv.setAllOpenID2PersonMap(DingTalkHelper.GetAllOpenID2Person(this.ctx, personIdSet));
        punchCardSynEnv.setAllOpenID2AttFileMap(DingTalkHelper.GetAllOpenID2AttendanceFile(this.ctx, personIdSet));
        if (punchCardSynEnv.getPunchCardRecord() == null) {
            punchCardSynEnv.setPunchCardRecord(PunchCardRecordFactory.getLocalInstance(this.ctx));
        }
        if (punchCardSynEnv.getSignRecord() == null) {
            punchCardSynEnv.setSignRecord(SignRecordFactory.getLocalInstance(this.ctx));
        }
    }

    private StringBuffer removeAndGetOpenIds(Map<String, String> allPerson2OpenIdMap) {
        StringBuffer retValue = new StringBuffer();
        Iterator<Map.Entry<String, String>> it = allPerson2OpenIdMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (StringUtils.isNotEmpty((String)entry.getValue())) {
                retValue.append(entry.getValue()).append(",");
                continue;
            }
            it.remove();
        }
        return retValue;
    }
}

