/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.takeWorkLimit.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillResEnum;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AtsTakeWorkingInfo;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayLimitStatus;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.IOTtoTakeWorkDetail;
import com.kingdee.eas.hr.ats.OTType;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailFactory;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailInfo;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailStatus;
import com.kingdee.eas.hr.ats.TakeWorkSourceType;
import com.kingdee.eas.hr.ats.TakeWorkUnitConvertRule;
import com.kingdee.eas.hr.ats.takeWorkLimit.impl.CoreCalTakeWorkLimit;
import com.kingdee.eas.hr.ats.takeWorkLimit.util.TakeWorkLimitUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalOvertimeBill2TakeWorkLimit
extends CoreCalTakeWorkLimit {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.takeWorkLimit.impl.CalOvertimeBill2TakeWorkLimit");
    private IOTtoTakeWorkDetail ioTtoTakeWorkDetail;

    public CalOvertimeBill2TakeWorkLimit(Context ctx, Map map) {
        super(ctx, map);
        try {
            this.ioTtoTakeWorkDetail = OTtoTakeWorkDetailFactory.getLocalInstance(ctx);
            this.limitInfo = (HolidayLimitInfo)map.get("existedLimit");
        }
        catch (BOSException e) {
            logger.error((Object)("CalOvertimeBill2TakeWorkLimit.class init fail,reaseon\uff1a" + (Object)((Object)e)));
            e.printStackTrace();
        }
    }

    @Override
    public void generateTakeWorkLimit(Context ctx, Map param) {
        try {
            logger.error((Object)("Overtime takeWorkLimit cal person id: " + (String)param.get("proposerID")));
            this.prepareData(ctx, param);
            this.calTotalLimit(ctx, param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void beforeCal(Context ctx, Map param) {
        super.beforeCal(ctx, param);
        String proposerID = (String)param.get("proposerID");
        Set detailSet = (Set)param.get("existedDetail");
        ArrayList bills = (ArrayList)param.get("bill");
        HashMap<String, AtsOverTimeBillEntryInfo> entryMap = new HashMap<String, AtsOverTimeBillEntryInfo>();
        if (bills != null && bills.size() > 0) {
            for (int i = 0; i < bills.size(); ++i) {
                AtsOverTimeBillEntryInfo entry = ((AtsOverTimeBillInfo)bills.get(i)).getEntries().get(0);
                entryMap.put(entry.getId().toString(), entry);
            }
        }
        if (this.limitInfo != null && detailSet != null && detailSet.size() > 0) {
            ArrayList<ObjectUuidPK> detailList = new ArrayList<ObjectUuidPK>();
            for (OTtoTakeWorkDetailInfo detailInfo : detailSet) {
                AtsOverTimeBillEntryInfo entry = (AtsOverTimeBillEntryInfo)entryMap.get(detailInfo.getSourceBillId());
                BigDecimal formerConvOTValue = detailInfo.getLimitValue();
                if (entry != null) continue;
                detailInfo.setState(OTtoTakeWorkDetailStatus.invalid);
                detailList.add(new ObjectUuidPK(detailInfo.getId()));
                this.limitInfo.setStandardLimit(this.limitInfo.getStandardLimit().subtract(formerConvOTValue));
                this.limitInfo.setRealLimit(this.limitInfo.getRealLimit().subtract(formerConvOTValue));
                this.limitInfo.setRemainLimit(this.limitInfo.getRemainLimit().subtract(formerConvOTValue));
            }
            int detailSize = detailList.size();
            if (detailSize > 0) {
                try {
                    ObjectUuidPK[] detailIds = new ObjectUuidPK[detailSize];
                    for (int i = 0; i < detailSize; ++i) {
                        detailIds[i] = (IObjectPK)detailList.get(i);
                    }
                    OTtoTakeWorkDetailFactory.getLocalInstance(ctx).deleteBatchData((IObjectPK[])detailIds);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    protected void doCalTotalLimit(Context ctx, Map param) {
        Set existedDetail = (Set)param.get("existedDetail");
        HashMap<String, OTtoTakeWorkDetailInfo> existedDetailMap = new HashMap<String, OTtoTakeWorkDetailInfo>();
        if (existedDetail != null && existedDetail.size() > 0) {
            for (OTtoTakeWorkDetailInfo detail : existedDetail) {
                String sourceBillId = detail.getSourceBillId();
                existedDetailMap.put(sourceBillId, detail);
            }
        }
        HolidayPolicyInfo policyInfo = (HolidayPolicyInfo)param.get("policyInfo");
        PersonPositionInfo personPositionInfo = (PersonPositionInfo)param.get("personPosition");
        AtsTakeWorkingInfo twRule = (AtsTakeWorkingInfo)param.get("twRule");
        Map ruleBasedData = (Map)param.get("ruleBasedData");
        Map stdHourMap = (Map)param.get("stdHour");
        ArrayList bills = (ArrayList)param.get("bill");
        if (bills != null && bills.size() > 0) {
            for (int i = 0; i < bills.size(); ++i) {
                AtsOverTimeBillInfo bill = (AtsOverTimeBillInfo)bills.get(i);
                AtsOverTimeBillEntryInfo entry = bill.getEntries().get(0);
                BigDecimal stdHour = null;
                BigDecimal afterDealStdHour = null;
                boolean isHalfDay = AtsLeaveBillUtils.isHalfDay(ctx, entry.getPerson().getId().toString(), entry.getOtDate());
                HolidayTypeUnitEnum unit = policyInfo.getUnit();
                if (twRule.getUnitConvertRule().compareTo((Object)TakeWorkUnitConvertRule.fixedHour) == 0) {
                    stdHour = twRule.getFixedHour();
                } else {
                    stdHour = (BigDecimal)stdHourMap.get(entry.getPerson().getId() + "_" + AtsDateUtils.dateShortToString(entry.getOtDate()));
                    if (unit.equals((Object)HolidayTypeUnitEnum.day) && isHalfDay) {
                        stdHour = stdHour.multiply(new BigDecimal("2"));
                    }
                }
                afterDealStdHour = stdHour;
                if (afterDealStdHour != null && afterDealStdHour.compareTo(new BigDecimal(0)) > 0) {
                    this.calLimit(ctx, bill, existedDetailMap, this.limitInfo, policyInfo, twRule, afterDealStdHour, personPositionInfo, ruleBasedData, param);
                    continue;
                }
                System.out.println("--------calLimit:takeWork rule error or the standdard hour in schedule error");
                param.put("errorStr", MLUtile.getRes(AtsScheduleShiftResEnum.ScheduleShiftDateException, ctx));
                param.put("success", 0);
                if (twRule.getUnitConvertRule().compareTo((Object)TakeWorkUnitConvertRule.fixedHour) != 0) continue;
                param.put("errorStr", MLUtile.getRes(AtsOverTimeBillResEnum.RegenLimitForIllegalTransferRule, ctx));
            }
        } else {
            AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)param.get("atsHolidayFileHis");
            if (this.limitInfo != null) {
                if (null != atsHolidayFileHisInfo) {
                    this.limitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
                    this.limitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
                }
                this.limitInfo.setStandardLimit(BigDecimal.ZERO);
                this.limitInfo.setRealLimit(this.limitInfo.getAddOrSubLimit());
                this.limitInfo.setRemainLimit(this.limitInfo.getAddOrSubLimit().subtract(this.limitInfo.getUsedLimit()).subtract(this.limitInfo.getFreezeLimit()).subtract(this.limitInfo.getPreOverdraftLimit()));
                this.limitInfo.setStatus(HolidayLimitStatus.audited);
            } else {
                HolidayLimitInfo preLimit = (HolidayLimitInfo)param.get("preLimit");
                if (policyInfo.isIsOverAutoSub() && preLimit != null && preLimit.getRemainLimit().compareTo(BigDecimal.ZERO) < 0) {
                    Date delayDate;
                    this.limitInfo = new HolidayLimitInfo();
                    this.limitInfo.setStandardLimit(BigDecimal.ZERO);
                    this.limitInfo.setRealLimit(BigDecimal.ZERO);
                    this.limitInfo.setRemainLimit(BigDecimal.ZERO);
                    this.limitInfo.setAddOrSubLimit(BigDecimal.valueOf(0.0));
                    this.limitInfo.setUsedLimit(BigDecimal.valueOf(0.0));
                    this.limitInfo.setFreezeLimit(BigDecimal.valueOf(0.0));
                    this.limitInfo.setPreOverdraftLimit(preLimit.getRemainLimit().abs());
                    this.limitInfo.setRemainLimit(this.limitInfo.getPreOverdraftLimit().multiply(new BigDecimal(-1)));
                    this.limitInfo.setStatus(HolidayLimitStatus.audited);
                    TakeWorkLimitUtils.setRuleBasedData(this.limitInfo, ruleBasedData);
                    this.limitInfo.setEnableCycle(true);
                    this.limitInfo.setHolidayUnit(policyInfo.getUnit());
                    this.limitInfo.setHolidayPolicy(policyInfo);
                    this.limitInfo.setDelayDate(TakeWorkLimitUtils.getDelayDate(twRule, this.limitInfo.getCycleEndDate()));
                    if (null != ruleBasedData && null != (delayDate = (Date)ruleBasedData.get("delayDate")) && delayDate.compareTo(this.limitInfo.getDelayDate()) < 0) {
                        this.limitInfo.setDelayDate(delayDate);
                    }
                    this.limitInfo.setProposer(personPositionInfo.getPerson());
                    this.limitInfo.setPosition(personPositionInfo.getPrimaryPosition());
                    if (null != atsHolidayFileHisInfo) {
                        this.limitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
                        this.limitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
                    }
                    this.limitInfo.setCycleType(twRule.getTaskWorkingType());
                    try {
                        ObjectUuidPK uuidPK = (ObjectUuidPK)HolidayLimitFactory.getLocalInstance(ctx).addnew(this.limitInfo);
                        this.limitInfo.setId(uuidPK.getKeyValue());
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (this.limitInfo != null) {
            CoreBaseCollection allLimitColl = (CoreBaseCollection)param.get("allLimitColl");
            allLimitColl.add((CoreBaseInfo)this.limitInfo);
        }
        param.put("success", 1);
    }

    protected void calLimit(Context ctx, AtsOverTimeBillInfo billInfo, Map<String, OTtoTakeWorkDetailInfo> detailMap, HolidayLimitInfo limitInfo, HolidayPolicyInfo policyInfo, AtsTakeWorkingInfo twRule, BigDecimal stdHour, PersonPositionInfo personPositionInfo, Map<String, Object> ruleBasedData, Map param) {
        HolidayLimitInfo preLimit = (HolidayLimitInfo)param.get("preLimit");
        AtsOverTimeBillEntryInfo entry = billInfo.getEntries().get(0);
        String entryId = entry.getId().toString();
        Date otDate = entry.getOtDate();
        OTtoTakeWorkDetailInfo detail = detailMap.get(entry.getId().toString());
        if (limitInfo != null) {
            this.updateTakeWorkLimit(ctx, billInfo, entry, policyInfo, twRule, detail, personPositionInfo, stdHour, param);
        } else {
            this.insertTakeWorkLimit(ctx, billInfo, entry, policyInfo, personPositionInfo, ruleBasedData, twRule, stdHour, preLimit, param);
        }
    }

    protected void updateTakeWorkLimit(Context ctx, AtsOverTimeBillInfo bill, AtsOverTimeBillEntryInfo entry, HolidayPolicyInfo policyInfo, AtsTakeWorkingInfo twRule, OTtoTakeWorkDetailInfo detail, PersonPositionInfo personPositionInfo, BigDecimal stdHour, Map param) {
        AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)param.get("atsHolidayFileHis");
        this.limitInfo.setStatus(HolidayLimitStatus.audited);
        BigDecimal convLimit = BigDecimal.ZERO;
        BigDecimal realOTTime = entry.getRealOTTime();
        HolidayTypeUnitEnum unit = policyInfo.getUnit();
        convLimit = TakeWorkLimitUtils.getConvValue(entry.getOtType().getId().toString(), twRule, realOTTime);
        if (unit.equals((Object)HolidayTypeUnitEnum.day)) {
            if (!this.limitInfo.getHolidayUnit().equals((Object)HolidayTypeUnitEnum.day)) {
                this.limitInfo.setHolidayUnit(HolidayTypeUnitEnum.day);
            }
            convLimit = TakeWorkLimitUtils.transHourToDay(convLimit, stdHour);
        }
        convLimit = TakeWorkLimitUtils.getMinAmtRealLimit(ctx, convLimit, policyInfo);
        if (entry.isCalculateState()) {
            if (detail != null) {
                if (null != atsHolidayFileHisInfo) {
                    detail.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
                    this.limitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
                    if (this.limitInfo.getHrOrgUnit() == null) {
                        this.limitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
                    }
                }
                if (convLimit.compareTo(detail.getLimitValue()) == 0) {
                    return;
                }
                detail.setState(OTtoTakeWorkDetailStatus.invalid);
                this.limitInfo.setStandardLimit(this.limitInfo.getStandardLimit().subtract(detail.getLimitValue()));
                this.limitInfo.setRealLimit(this.limitInfo.getRealLimit().subtract(detail.getLimitValue()));
                this.limitInfo.setRemainLimit(this.limitInfo.getRemainLimit().subtract(detail.getLimitValue()));
                entry.setHolidayLimit(this.limitInfo);
            }
            if (!"AERg0TIcSnaM40EKvJCdRKlrTmA=".equals(entry.getOtCompens().getIdentity().toString())) {
                entry.setCalculateState(false);
                entry.setHolidayLimit(null);
            }
        } else if ("AERg0TIcSnaM40EKvJCdRKlrTmA=".equalsIgnoreCase(entry.getOtCompens().getId().toString())) {
            entry.setCalculateState(true);
            entry.setHolidayLimit(this.limitInfo);
        } else {
            entry.setCalculateState(false);
            if (entry.getHolidayLimit() != null) {
                entry.setHolidayLimit(null);
                try {
                    AtsOverTimeBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entry.getId()), entry);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            if (null != atsHolidayFileHisInfo) {
                this.limitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
                if (this.limitInfo.getHrOrgUnit() == null) {
                    this.limitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
                }
            }
            this.limitInfo.setStandardLimit(this.limitInfo.getStandardLimit().add(convLimit));
            this.limitInfo.setRealLimit(this.limitInfo.getRealLimit().add(convLimit));
            this.limitInfo.setRemainLimit(this.limitInfo.getRemainLimit().add(convLimit));
            this.limitInfo.setCycleType(twRule.getTaskWorkingType());
            entry.setHolidayLimit(this.limitInfo);
            AtsOverTimeBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entry.getId()), entry);
            if (detail != null) {
                if (detail.getState().getValue() == OTtoTakeWorkDetailStatus.invalid.getValue()) {
                    OTtoTakeWorkDetailFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(detail.getId()));
                } else {
                    detail.setHrOrgUnit(atsHolidayFileHisInfo != null ? atsHolidayFileHisInfo.getHrOrgUnit() : null);
                    OTtoTakeWorkDetailFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(detail.getId()), detail);
                }
            }
            this.insertDetailRecord(this.limitInfo, bill, entry, twRule, convLimit, policyInfo, personPositionInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void insertTakeWorkLimit(Context ctx, AtsOverTimeBillInfo bill, AtsOverTimeBillEntryInfo entry, HolidayPolicyInfo policyInfo, PersonPositionInfo personPositionInfo, Map ruleBasedData, AtsTakeWorkingInfo twRule, BigDecimal stdHour, HolidayLimitInfo preLimit, Map param) {
        if (this.limitInfo != null) {
            return;
        }
        this.limitInfo = new HolidayLimitInfo();
        this.limitInfo.setPreOverdraftLimit(new BigDecimal(0));
        if (policyInfo.isIsOverAutoSub() && preLimit != null && preLimit.getRemainLimit().compareTo(BigDecimal.ZERO) < 0) {
            this.limitInfo.setPreOverdraftLimit(preLimit.getRemainLimit().abs());
        }
        BigDecimal realOTTime = entry.getRealOTTime();
        BigDecimal convLimit = TakeWorkLimitUtils.getConvValue(entry.getOtType().getId().toString(), twRule, realOTTime);
        HolidayTypeUnitEnum unit = policyInfo.getUnit();
        if (unit.equals((Object)HolidayTypeUnitEnum.day)) {
            convLimit = TakeWorkLimitUtils.transHourToDay(convLimit, stdHour);
        }
        if ((convLimit = TakeWorkLimitUtils.getMinAmtRealLimit(ctx, convLimit, policyInfo)).compareTo(BigDecimal.ZERO) >= 0) {
            Date delayDate;
            this.limitInfo.setStandardLimit(convLimit);
            this.limitInfo.setRealLimit(convLimit);
            this.limitInfo.setRemainLimit(convLimit.subtract(this.limitInfo.getPreOverdraftLimit()));
            this.limitInfo.setAddOrSubLimit(BigDecimal.valueOf(0.0));
            this.limitInfo.setUsedLimit(BigDecimal.valueOf(0.0));
            this.limitInfo.setFreezeLimit(BigDecimal.valueOf(0.0));
            this.limitInfo.setStatus(HolidayLimitStatus.audited);
            TakeWorkLimitUtils.setRuleBasedData(this.limitInfo, ruleBasedData);
            this.limitInfo.setEnableCycle(true);
            this.limitInfo.setHolidayUnit(policyInfo.getUnit());
            this.limitInfo.setHolidayPolicy(policyInfo);
            this.limitInfo.setDelayDate(TakeWorkLimitUtils.getDelayDate(twRule, this.limitInfo.getCycleEndDate()));
            if (null != ruleBasedData && null != (delayDate = (Date)ruleBasedData.get("delayDate")) && delayDate.compareTo(this.limitInfo.getDelayDate()) < 0) {
                this.limitInfo.setDelayDate(delayDate);
            }
            this.limitInfo.setProposer(personPositionInfo.getPerson());
            this.limitInfo.setPosition(personPositionInfo.getPrimaryPosition());
            AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)param.get("atsHolidayFileHis");
            if (null != atsHolidayFileHisInfo) {
                this.limitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
                this.limitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
            }
            this.limitInfo.setCycleType(twRule.getTaskWorkingType());
            try {
                ObjectUuidPK uuidPK = (ObjectUuidPK)HolidayLimitFactory.getLocalInstance(ctx).addnew(this.limitInfo);
                this.limitInfo.setId(uuidPK.getKeyValue());
                entry.setCalculateState(true);
                entry.setHolidayLimit(this.limitInfo);
                AtsOverTimeBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entry.getId()), entry);
                this.insertDetailRecord(this.limitInfo, bill, entry, twRule, convLimit, policyInfo, personPositionInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    protected void insertDetailRecord(HolidayLimitInfo limitInfo, AtsOverTimeBillInfo bill, AtsOverTimeBillEntryInfo entry, AtsTakeWorkingInfo twRule, BigDecimal convLimit, HolidayPolicyInfo policyInfo, PersonPositionInfo personPositionInfo) throws EASBizException, BOSException {
        if (convLimit.compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        OTtoTakeWorkDetailInfo detail = new OTtoTakeWorkDetailInfo();
        detail.setSourceBillId(entry.getId().toString());
        detail.setSourceNum(bill.getNumber());
        detail.setConvertDate(new Date());
        detail.setPeriodStart(limitInfo.getCycleBeginDate());
        detail.setPeriodEnd(limitInfo.getCycleEndDate());
        detail.setPeriodDelay(limitInfo.getDelayDate());
        detail.setConvertRate(TakeWorkLimitUtils.getConvRate(entry.getOtType().getId().toString(), twRule));
        detail.setSource(TakeWorkSourceType.overtimeBill);
        detail.setSourceUnit(HolidayTypeUnitEnum.hour);
        detail.setSourceValue(entry.getRealOTTime());
        detail.setLimit(limitInfo.getId().toString());
        detail.setLimitUnit(policyInfo.getUnit());
        detail.setLimitValue(convLimit);
        detail.setAdminOrgUnit(limitInfo.getAdminOrgUnit());
        detail.setHrOrgUnit(limitInfo.getHrOrgUnit());
        detail.setProposer(personPositionInfo.getPerson());
        detail.setPosition(personPositionInfo.getPrimaryPosition());
        detail.setState(OTtoTakeWorkDetailStatus.effected);
        OTType otType = null;
        if (entry.getOtType().getId().toString().compareTo("rBy0u1YgQ9C1OxcM85mxyY6C/nU=") == 0) {
            otType = OTType.OT1;
        } else if (entry.getOtType().getId().toString().compareTo("zr+ur5D4RA+2bdVZ2VPqp46C/nU=") == 0) {
            otType = OTType.OT2;
        } else if (entry.getOtType().getId().toString().compareTo("sRWUOt7sRpOY0TCo6NMqGY6C/nU=") == 0) {
            otType = OTType.OT3;
        }
        detail.setOTType(otType);
        detail.setUnitConvertRule(twRule.getUnitConvertRule());
        detail.setFixedHour(twRule.getFixedHour());
        detail.setEnableMinAmt(policyInfo.isEnableMinAmt());
        detail.setMinAmt(policyInfo.getMinAmt());
        detail.setMinAmtValueMtd(policyInfo.getMinAmtValueMtd());
        detail.setOtDate(entry.getOtDate());
        detail.setAttAdminOrgUnit(detail.getAdminOrgUnit());
        this.ioTtoTakeWorkDetail.addnew(detail);
    }
}

