/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.takeWorkLimit.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsHolidayFileCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.GetValueMtdEnum;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.takeWorkLimit.impl.GenerateTakeWorkLimit;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecalculateHolidayLimit {
    private static Logger logger = Logger.getLogger(GenerateTakeWorkLimit.class);

    public void RecalculateWorkLimitBackGround(Context ctx, Map param) throws EASBizException, BOSException, SQLException {
        HashMap map = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.Fid as id from  ").append(" T_HR_ATS_LeaveBill bill left OUTER JOIN T_HR_ATS_LeaveBillEntry entry on  bill.fid=entry.FBillID where bill.FBillState IN ('3') ");
        IRowSet row = null;
        row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (row.next()) {
            String holidayTypeId;
            String tempErrorString;
            AtsLeaveBillEntryCollection leaveBillEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where id in ('" + row.getString("id") + "')");
            AtsLeaveBillEntryInfo info = leaveBillEntryColl.get(0);
            String personId = info.getPerson().getId().toString();
            Timestamp beginTime = info.getBeginTime();
            Timestamp endTime = info.getEndTime();
            String holidayPolicyId = info.getPolicy().getId().toString();
            HolidayPolicyInfo holidayPolicyInfo = AtsWebUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
            if (holidayPolicyInfo == null || !StringUtils.isEmpty((String)(tempErrorString = this.validateLeaveBill(ctx, personId, holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString())))) continue;
            HashMap<String, Object> paraMap = new HashMap<String, Object>();
            paraMap.put("personId", personId);
            paraMap.put("timeOffApplyType", holidayTypeId);
            paraMap.put("isElasticCalLen", info.isIsElasticCalLen());
            paraMap.put("timeOffStartDate", beginTime);
            paraMap.put("timeOffEndDate", endTime);
            Map res = (Map)OSFExecutor.executeOSF((Context)ctx, paraMap, (String)"getLeaveLength_new");
            double realLength = (Double)res.get("leaveLength");
            res.put("realLen", realLength);
            double initialValue = holidayPolicyInfo.getInitialValue() == null ? 0.0 : holidayPolicyInfo.getInitialValue().doubleValue();
            if (realLength < initialValue) continue;
            if (holidayPolicyInfo.getMinLeaveLengthVMtd() == GetValueMtdEnum.actualValue) {
                BigDecimal minLeaveLength = holidayPolicyInfo.getMinLeaveLength();
                BigDecimal bRealLength = BigDecimal.valueOf(realLength);
                if (bRealLength.remainder(minLeaveLength).compareTo(BigDecimal.ZERO) != 0) continue;
            }
            try {
                AtsLeaveBillFactory.getLocalInstance(ctx).calculateLeaveBillEntry(info, res);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    public String validateLeaveBill(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        String errorString = "";
        String personName = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId)).getName();
        AtsHolidayFileCollection holidayFileColl = new AtsHolidayFileCollection();
        holidayFileColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        if (holidayFileColl.size() == 0) {
            errorString = "error";
            return errorString;
        }
        if (holidayFileColl.get(0).getHolidayPolicySet() == null) {
            errorString = "error";
            return errorString;
        }
        HolidayPolicyInfo holidayPolicyInfo = null;
        try {
            holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo("  where holidayPolicySet = '" + holidayFileColl.get(0).getHolidayPolicySet().getId().toString() + "' and holidayType='" + holidayTypeId + "' ");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (holidayPolicyInfo == null) {
            errorString = "error";
            return errorString;
        }
        return errorString;
    }
}

