/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.thread.ExecutorService;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.atsTimer.AtsTimeTask;
import com.kingdee.eas.hr.ats.thread.ExecutorService.RejectedPolicy;
import com.kingdee.eas.hr.ats.thread.ExecutorService.ThreadFactory;
import com.kingdee.eas.hr.ats.thread.ExecutorService.ThreadPool;
import com.kingdee.eas.hr.ats.thread.executor.TaskExecutorBase;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;

public abstract class TaskPool {
    private static Timer poolTimer;
    private static Object lock;
    private static final String SMALL_POOL_NAME = "smallPool";
    private static int maxPoolCount;
    private static long purgeTaskListFrequency;
    private static long shutdownAfterIdel;
    private static Map<String, ThreadPool> executorPoolMap;

    private static synchronized void initPoolTimer() {
        poolTimer = new Timer();
        poolTimer.schedule((TimerTask)new AtsTimeTask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void process() throws Exception {
                Object object = lock;
                synchronized (object) {
                    Iterator it = executorPoolMap.values().iterator();
                    while (it.hasNext()) {
                        ThreadPool pool = (ThreadPool)it.next();
                        if (pool.getLastTaskEndTime() == null) continue;
                        if (pool.getActiveCount() == 0 && System.currentTimeMillis() - pool.getLastTaskEndTime().getTime() > shutdownAfterIdel) {
                            if (pool == PoolHolder.INST) continue;
                            it.remove();
                            pool.shutdown();
                            continue;
                        }
                        pool.purgeTakList(this.ctx);
                    }
                }
            }
        }, 1000L, purgeTaskListFrequency);
    }

    public static void execute(Runnable command) {
        PoolHolder.INST.execute(command);
    }

    public static Future<?> submit(Runnable task) {
        return PoolHolder.INST.submit(task);
    }

    public static <T> Future<T> submit(Runnable task, T result) {
        return PoolHolder.INST.submit(task, result);
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return PoolHolder.INST.submit(task);
    }

    public static <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return PoolHolder.INST.invokeAny(tasks);
    }

    public static <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return PoolHolder.INST.invokeAny(tasks, timeout, unit);
    }

    public static <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return PoolHolder.INST.invokeAll(tasks);
    }

    public static <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return PoolHolder.INST.invokeAll(tasks, timeout, unit);
    }

    public static List<Runnable> shutdownNow() {
        return PoolHolder.INST.shutdownNow();
    }

    public static void shutdown() {
        PoolHolder.INST.shutdown();
    }

    public boolean cancelTask(Context ctx, String id) {
        return PoolHolder.INST.cancelTask(ctx, this.getTask(id));
    }

    public TaskExecutorBase<?> getTask(String id) {
        return PoolHolder.INST.getTask(id);
    }

    public Object getTaskResult(String id) {
        TaskExecutorBase<?> result = PoolHolder.INST.getTask(id);
        try {
            return result.fetch();
        }
        catch (InterruptedException e) {
            AtsLog.getLog().error((Object)e);
        }
        catch (ExecutionException e) {
            AtsLog.getLog().error((Object)e);
        }
        return null;
    }

    public static Timer getPoolTimer() {
        return poolTimer;
    }

    public static void setPoolTimer(Timer poolTimer) {
        TaskPool.poolTimer = poolTimer;
    }

    public static int getMaxPoolCount() {
        return maxPoolCount;
    }

    public static void setMaxPoolCount(int maxPoolCount) {
        TaskPool.maxPoolCount = maxPoolCount;
    }

    public static long getPurgeTaskListFrequency() {
        return purgeTaskListFrequency;
    }

    public static void setPurgeTaskListFrequency(long purgeTaskListFrequency) {
        TaskPool.purgeTaskListFrequency = purgeTaskListFrequency;
    }

    public static long getShutdownAfterIdel() {
        return shutdownAfterIdel;
    }

    public static void setShutdownAfterIdel(long shutdownAfterIdel) {
        TaskPool.shutdownAfterIdel = shutdownAfterIdel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolExecutor getFixedInstance(String poolName, int threadSize, long keepAliveTime) {
        if (poolTimer == null) {
            TaskPool.initPoolTimer();
        }
        poolName = StringUtils.isBlank((String)poolName) ? SMALL_POOL_NAME : poolName;
        Object object = lock;
        synchronized (object) {
            if (executorPoolMap.get(poolName) != null) {
                return executorPoolMap.get(poolName);
            }
            if (executorPoolMap.size() > maxPoolCount) {
                throw new RuntimeException("taskPool reach the max pool count!");
            }
            ThreadPool pool = new ThreadPool(threadSize, threadSize, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ThreadFactory.getInstance(), new RejectedPolicy());
            executorPoolMap.put(poolName, pool);
            return pool;
        }
    }

    public static ThreadPoolExecutor getCacheInstance(String poolName, int MaxThreadSize, long keepAliveTime) {
        ThreadPoolExecutor executor = TaskPool.getFixedInstance(poolName, MaxThreadSize, keepAliveTime);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    static {
        lock = new Object();
        maxPoolCount = 10;
        purgeTaskListFrequency = 60000L;
        shutdownAfterIdel = 1800000L;
        executorPoolMap = new HashMap<String, ThreadPool>(maxPoolCount);
    }

    private static final class PoolHolder {
        public static ThreadPool INST = (ThreadPool)TaskPool.getCacheInstance(null, 5, 10000L);

        private PoolHolder() {
        }
    }
}

