/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.HolidayLimitBillTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitChangeType;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitDetailStatusEnum;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.app.HolidayLimitDetailControllerBean;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AtsLeaveBillLimitHelperServer {
    private IDecimalPlaceStrategy decimalPlacesSystem = new DecimalPlaceOperationSystem();

    public AtsLeaveBillLimitHelperServer() {
        if (null == this.decimalPlacesSystem) {
            this.decimalPlacesSystem = new DecimalPlaceOperationSystem();
        }
    }

    public int rollBackYearVacationLimit(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        AtsLeaveBillInfo billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
        AtsLeaveBillEntryCollection entryCollection = billInfo.getEntries();
        BigDecimal leavelengthSum = BigDecimal.valueOf(0L);
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal leavelength = entryCollection.get(i).getLeaveLength();
            leavelengthSum = leavelengthSum.add(leavelength);
        }
        String personId = billInfo.getEntries().get(0).getPerson().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoByPersonId(ctx, personId);
        Timestamp startTime = billInfo.getEntries().get(0).getBeginTime();
        Timestamp endTime = billInfo.getEntries().get(0).getEndTime();
        HolidayLimitCollection holidayLimitCollection = AtsServerUtils.getHolidayLimitCollectionByPersonIdAndStartEndTime(ctx, personId, "3T54RtSQRIqAL6cffMh60P0tUpg=", startTime, endTime);
        holidayLimitCollection.sort("delaydate");
        HolidayLimitInfo holidayLimitInfo = holidayLimitCollection.get(holidayLimitCollection.size() - 1);
        for (int i = 0; i < holidayLimitCollection.size(); ++i) {
            String holidayLimitId;
            HashMap<String, Object> mapBalance;
            BigDecimal leavelengthSumTemp;
            if (leavelengthSum.compareTo(holidayLimitCollection.get(i).getFreezeLimit()) == 1) {
                leavelengthSumTemp = holidayLimitCollection.get(i).getFreezeLimit();
                mapBalance = new HashMap();
                leavelengthSumTemp = this.decimalPlacesSystem.precisionConvert(ctx, leavelengthSumTemp, RoundingMode.HALF_UP);
                mapBalance.put("freezeLimit", leavelengthSumTemp);
                mapBalance.put("personId", personId);
                mapBalance.put("holidayPolicyId", holidayPolicyInfo.getId().toString());
                mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                holidayLimitId = "";
                if (holidayLimitInfo != null) {
                    holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                }
                mapBalance.put("holidayLimitId", holidayLimitId);
                try {
                    this.rollBackFreeze(ctx, mapBalance);
                    this.updateRemainLimit(ctx, mapBalance);
                    this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                leavelengthSum = leavelengthSum.subtract(leavelengthSumTemp);
                continue;
            }
            leavelengthSumTemp = leavelengthSum;
            mapBalance = new HashMap<String, Object>();
            leavelengthSumTemp = this.decimalPlacesSystem.precisionConvert(ctx, leavelengthSumTemp, RoundingMode.HALF_UP);
            mapBalance.put("freezeLimit", leavelengthSumTemp);
            mapBalance.put("personId", personId);
            mapBalance.put("holidayPolicyId", holidayPolicyInfo.getId().toString());
            mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
            holidayLimitId = "";
            if (holidayLimitInfo != null) {
                holidayLimitId = holidayLimitCollection.get(i).getId().toString();
            }
            mapBalance.put("holidayLimitId", holidayLimitId);
            try {
                this.rollBackFreeze(ctx, mapBalance);
                this.updateRemainLimit(ctx, mapBalance);
                this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo);
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    protected void rollBackFreeze(Context ctx, Map<String, Object> mapBalance) throws BOSException, EASBizException {
        try {
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            BigDecimal freezeLimitBD = (BigDecimal)mapBalance.get("freezeLimit");
            String sql_query = "select  holiday_limit.*  from t_hr_ats_holidaylimit holiday_limit  where fid='" + holidayLimitId + "' ";
            IRowSet row = null;
            row = DbUtil.executeQuery((Context)ctx, (String)sql_query);
            BigDecimal freezeLimit_His = BigDecimal.valueOf(0L);
            while (row.next()) {
                freezeLimit_His = row.getBigDecimal("FreezeLimit");
            }
            BigDecimal freezeLimit_res = freezeLimit_His.subtract(freezeLimitBD);
            freezeLimit_res = this.decimalPlacesSystem.precisionConvert(ctx, freezeLimit_res, RoundingMode.HALF_UP);
            float freezeLimit = freezeLimit_res.floatValue();
            String sql_update = "  update  t_hr_ats_holidaylimit set  FreezeLimit='" + freezeLimit + "'  where fid='" + holidayLimitId + "' ";
            DbUtil.execute((Context)ctx, (String)sql_update);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void updateRemainLimit(Context ctx, Map<String, Object> mapBalance) throws BOSException, EASBizException {
        try {
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            String sqlquery = "select holiday_limit.*  from t_hr_ats_holidaylimit holiday_limit  where fid='" + holidayLimitId + "' ";
            IRowSet row = null;
            row = DbUtil.executeQuery((Context)ctx, (String)sqlquery);
            BigDecimal realLimit = BigDecimal.valueOf(0L);
            BigDecimal usedLimit = BigDecimal.valueOf(0L);
            BigDecimal freezeLimit = BigDecimal.valueOf(0L);
            while (row.next()) {
                realLimit = row.getBigDecimal("FRealLimit");
                usedLimit = row.getBigDecimal("FUsedLimit");
                freezeLimit = row.getBigDecimal("FreezeLimit");
            }
            BigDecimal remainLimit_bg = realLimit.subtract(usedLimit).subtract(freezeLimit);
            remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, remainLimit_bg, RoundingMode.HALF_UP);
            float remainLimit = remainLimit_bg.floatValue();
            String sql = "  update  t_hr_ats_holidaylimit set FRemainLimit='" + remainLimit + "'  where   fid='" + holidayLimitId + "' ";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected int insertDataInfoToHolildayLimitDetail(Context ctx, Map<String, Object> mapBalance, AtsLeaveBillInfo billInfo) {
        int res = 0;
        HolidayLimitDetailControllerBean holidayLimitDetailControllerBean = new HolidayLimitDetailControllerBean();
        CoreBaseCollection colls = new CoreBaseCollection();
        HolidayLimitDetailInfo detailInfo = new HolidayLimitDetailInfo();
        String personId = (String)mapBalance.get("personId");
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx, personId);
        detailInfo.setProposer(personPositionInfo.getPerson());
        detailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
        detailInfo.setPosition(personPositionInfo.getPrimaryPosition());
        PersonPositionInfo position = SHRBillServerUtil.getAdminOrgUnitAndHrOrgUnit(ctx, personId);
        HROrgUnitInfo hrInfo = null;
        hrInfo = position.getHrOrgUnit();
        detailInfo.setHrOrgUnit(hrInfo);
        Calendar cal = Calendar.getInstance();
        detailInfo.setYear(cal.get(1));
        detailInfo.setChangeDate(this.dateToTimestamp(new Date()));
        detailInfo.setChangeType(HolidayLimitChangeType.deduction);
        detailInfo.setBillType(HolidayLimitBillTypeEnum.leaveBill);
        detailInfo.setLeaveBill(billInfo);
        detailInfo.setLeaveBillNumber(billInfo.getNumber());
        detailInfo.setChangeValue((BigDecimal)mapBalance.get("usedLimit"));
        detailInfo.setChangeUnit((HolidayTypeUnitEnum)((Object)mapBalance.get("holidayPolicyUnit")));
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        HolidayLimitInfo limitInfo = new HolidayLimitInfo();
        limitInfo.setId(BOSUuid.read((String)holidayLimitId));
        detailInfo.setHolidayLimit(limitInfo);
        detailInfo.setStatus(HolidayLimitDetailStatusEnum.valid);
        colls.add((CoreBaseInfo)detailInfo);
        try {
            holidayLimitDetailControllerBean.addnewBatchData(ctx, colls);
            res = 1;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return res;
    }

    private Timestamp dateToTimestamp(Date date) {
        Timestamp ts = new Timestamp(date.getTime());
        return ts;
    }
}

