/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.IsAttendanceEnum;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.RoundingMode;

public class AtsOverTimeUtils {
    private static final IDecimalPlaceStrategy sysStrategy = new DecimalPlaceOperationSystem();

    public static void setOverTimeToSysDecimalPlace(Context ctx, AtsOverTimeBillInfo billInfo) {
        AtsOverTimeBillEntryCollection entries = billInfo.getEntries();
        if (entries == null || entries.size() == 0) {
            return;
        }
        AtsOverTimeBillEntryInfo entryInfo = null;
        for (int index = 0; index < entries.size(); ++index) {
            entryInfo = entries.get(index);
            AtsOverTimeUtils.setOverTimeEntryInfoOTTimeToSysDecimalPlace(ctx, entryInfo);
        }
    }

    public static void setOverTimeEntryInfoOTTimeToSysDecimalPlace(Context ctx, AtsOverTimeBillEntryInfo entryInfo) {
        if (entryInfo.getApplyOTTime() != null) {
            entryInfo.setApplyOTTime(sysStrategy.precisionConvert(ctx, entryInfo.getApplyOTTime(), RoundingMode.HALF_UP));
        }
        if (entryInfo.getRealOTTime() != null) {
            entryInfo.setRealOTTime(sysStrategy.precisionConvert(ctx, entryInfo.getRealOTTime(), RoundingMode.HALF_UP));
        }
    }

    public static String getScheduleShiftLogSql() {
        return " select 1  from t_hr_ats_attendanceFileHis his  inner join T_HR_ATS_ScheduleShiftDataLog log on his.feffdt <= log.fAttendDate and his.fleffdt >= log.fAttendDate and his.fProposerId = log.fPersonId  where  log.fOperType = '" + OperTypeEnum.scheduleShift.getValue() + "'  and log.fOperAction = '" + OperActionEnum.delete.getValue() + "'  and his.fAttendFileState = '" + AttendFileStateEnum.enable.getValue() + "'  and his.fIsAttendance = '" + IsAttendanceEnum.no.getValue() + "'  and his.fProposerId = entry.FPersonID  and log.FLastUpdateTime > bill.FCreateTime  and dateAdd(day, -1, entry.fStartTime) <= log.fAttendDate  and entry.fEndTime >= log.fAttendDate";
    }

    public static String getScheduleShiftSql() {
        return "select 1  from t_hr_ats_scheduleshift C  where C.FProposerID = entry.FPersonID  and C.FLastUpdateTime > bill.FCreateTime and dateAdd(day,-1, entry.fStartTime) <= C.fAttendDate  and entry.fEndTime >= C.fAttendDate ";
    }

    public static boolean isNeedReCalBill(Context ctx, String entryId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.Fid as id ").append(" from T_HR_ATS_OverTimeBill bill ").append(" left OUTER JOIN T_HR_ATS_OverTimeBillEntry entry on bill.fid=entry.FBillID ").append(" where entry.Fid ='" + entryId + "'");
        sql.append(" and ( ").append(" exists (").append(AtsOverTimeUtils.getScheduleShiftSql()).append(") ").append(" or ").append(" exists (").append(AtsOverTimeUtils.getScheduleShiftLogSql()).append(")").append(")");
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (row != null && row.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

