/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.Precision;

import com.kingdee.eas.hr.ats.GetValueMtdAmtEnum;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.util.Precision.PrecisionHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DelimitPrecisionHelper
extends PrecisionHelper {
    private HolidayPolicyInfo holidayPolicyInfo;

    @Override
    protected void innerInitPrecision() {
        super.innerInitPrecision();
        this.initPrecisionByHPolicy();
    }

    private void initPrecisionByHPolicy() {
        if (this.holidayPolicyInfo == null || !this.holidayPolicyInfo.isEnableMinAmt()) {
            return;
        }
        GetValueMtdAmtEnum division = this.holidayPolicyInfo.getMinAmtValueMtd();
        if (division == GetValueMtdAmtEnum.floor) {
            this.setRoundingMode(RoundingMode.FLOOR);
        } else if (division == GetValueMtdAmtEnum.ceil) {
            this.setRoundingMode(RoundingMode.CEILING);
        }
        BigDecimal minLen = this.holidayPolicyInfo.getMinAmt();
        if (minLen != null) {
            this.setPrecision(this.holidayPolicyInfo.getMinLeaveLength().scale());
        }
    }

    protected boolean useSystemPrecision() {
        return this.holidayPolicyInfo == null || !this.holidayPolicyInfo.isEnableMinAmt() || this.holidayPolicyInfo.getMinAmt() == null || this.holidayPolicyInfo.getMinAmt().doubleValue() == 0.0;
    }

    @Override
    public BigDecimal precisionProcess(Object number, int precision, RoundingMode roundingMode) {
        if (this.useSystemPrecision()) {
            return super.precisionProcess(number, precision, roundingMode);
        }
        BigDecimal decimal = new BigDecimal(String.valueOf(number));
        BigDecimal minLen = this.holidayPolicyInfo.getMinLeaveLength();
        return decimal.divide(minLen, 0, this.getRoundingMode()).multiply(minLen);
    }

    public HolidayPolicyInfo getHolidayPolicyInfo() {
        return this.holidayPolicyInfo;
    }

    public DelimitPrecisionHelper setHolidayPolicyInfo(HolidayPolicyInfo holidayPolicyInfo) {
        this.holidayPolicyInfo = holidayPolicyInfo;
        return this;
    }
}

