/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.Precision;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.ParamUtile;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrecisionHelper {
    private Context ctx;
    private RoundingMode roundingMode = RoundingMode.HALF_UP;
    private int systemPrecision = Integer.MIN_VALUE;
    private int precision;
    private static int maxPrecision = 8;
    private Map<BOSObjectType, List<String>> bosTypeToPrecisionFields = new HashMap<BOSObjectType, List<String>>();

    public PrecisionHelper() {
    }

    public PrecisionHelper(Context ctx) {
        this.ctx = ctx;
    }

    public static int getSystemPrecision(Context ctx) {
        int precision = 2;
        try {
            String configPrecision = ParamUtile.getParamVal(ctx, "ATS_DecimalPlaceCtrl");
            precision = Integer.valueOf(configPrecision);
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)("get Pram val error:" + e.getMessage()));
        }
        catch (Exception e) {
            AtsLog.getLog().error((Object)("Pram val config error:" + e.getMessage()));
        }
        precision = precision < 0 ? 0 : (precision > maxPrecision ? maxPrecision : precision);
        return precision;
    }

    public void initPrecision() {
        if (this.systemPrecision == Integer.MIN_VALUE) {
            this.innerInitPrecision();
        }
    }

    protected void innerInitPrecision() {
        this.precision = this.systemPrecision = PrecisionHelper.getSystemPrecision(this.ctx);
    }

    protected void initPrecisionFields(CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo == null) {
            return;
        }
        PropertyCollection allPropertys = AtsEntityUtile.getAllPropertity(this.ctx, coreBaseInfo);
        ArrayList<String> propertiesName = new ArrayList<String>();
        for (int i = 0; i < allPropertys.size(); ++i) {
            OwnPropertyInfo property;
            DataType dataType;
            if (allPropertys.get(i) instanceof LinkPropertyInfo || (dataType = (property = (OwnPropertyInfo)allPropertys.get(i)).getDataType()) != DataType.FLOAT && dataType != DataType.DOUBLE && dataType != DataType.DECIMAL) continue;
            propertiesName.add(property.getName());
        }
        this.bosTypeToPrecisionFields.put(coreBaseInfo.getBOSType(), propertiesName);
    }

    public CoreBaseInfo precisionProcess(CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo == null) {
            return null;
        }
        List<String> fields = this.bosTypeToPrecisionFields.get(coreBaseInfo.getBOSType());
        if (fields == null) {
            this.initPrecisionFields(coreBaseInfo);
        }
        for (String field : fields) {
            this.precisionProcess(coreBaseInfo, field);
        }
        return coreBaseInfo;
    }

    public CoreBaseInfo precisionProcess(CoreBaseInfo coreBaseInfo, String field) {
        Object numberObj;
        Object object = numberObj = coreBaseInfo == null ? null : coreBaseInfo.get(field);
        if (numberObj != null && numberObj instanceof Number) {
            coreBaseInfo.put(field, (Object)this.precisionProcess(numberObj));
        }
        return coreBaseInfo;
    }

    public BigDecimal precisionProcess(Object number) {
        return this.precisionProcess(number, this.getPrecision());
    }

    public BigDecimal precisionProcess(Object number, int precision) {
        return this.precisionProcess(number, precision, this.roundingMode);
    }

    public BigDecimal precisionProcess(Object number, int precision, RoundingMode roundingMode) {
        if (number == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal decimal = new BigDecimal(String.valueOf(number));
        return decimal.setScale(precision, roundingMode);
    }

    public Context getCtx() {
        return this.ctx;
    }

    public PrecisionHelper setCtx(Context ctx) {
        this.ctx = ctx;
        return this;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public PrecisionHelper setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
        return this;
    }

    public int getSystemPrecision() {
        return this.systemPrecision;
    }

    public PrecisionHelper setSystemPrecision(int systemPrecision) {
        this.systemPrecision = systemPrecision;
        return this;
    }

    public int getPrecision() {
        this.initPrecision();
        return this.precision;
    }

    public PrecisionHelper setPrecision(int precision) {
        this.precision = precision;
        return this;
    }
}

