/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AbstractAttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.atsContrl.AtsOverTimeLimitRuleStatueEnum;
import com.kingdee.eas.hr.atsContrl.OtLimitCtrlEnableSettingCollection;
import com.kingdee.eas.hr.atsContrl.OtLimitCtrlEnableSettingFactory;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;

public class SHRBillServerUtil {
    private static Logger logger = Logger.getLogger(SHRBillServerUtil.class);

    public static PersonPositionInfo getAdminOrgUnit(Context ctx, String personID) {
        if (personID == null) {
            return null;
        }
        PersonPositionInfo personPositionInfo = null;
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("jobGrade.id,");
        oqlb.append("hrOrgUnit.id,");
        oqlb.append("tryoutMonth,");
        oqlb.append("jobGrade.name,");
        oqlb.append("jobLevel.id,");
        oqlb.append("jobLevel.name,");
        oqlb.append("person.name,");
        oqlb.append("person.employeeType.name,");
        oqlb.append("personDep.id,");
        oqlb.append("personDep.name,");
        oqlb.append("personDep.number,");
        oqlb.append("personDep.displayName,");
        oqlb.append("primaryPosition.id,");
        oqlb.append("primaryPosition.name,");
        oqlb.append("primaryPosition.number,");
        oqlb.append("primaryPosition.job.id,");
        oqlb.append("primaryPosition.job.name");
        oqlb.append(" where person.id='");
        oqlb.append(personID);
        oqlb.append("'");
        PersonPositionCollection c = null;
        try {
            c = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oqlb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"SHRBillUtil.getAdminOrgUnit err", (Throwable)e);
        }
        if (c != null && c.size() > 0) {
            personPositionInfo = c.get(0);
        }
        return personPositionInfo;
    }

    public static EmpPosOrgRelationInfo getAdminOrgUnitByAppointDate(Context ctx, String personId, Date appointDate) {
        if (personId == null) {
            return null;
        }
        EmpPosOrgRelationInfo empPositionInfo = null;
        EmpPosOrgRelationQueryHelper emppositionQuery = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection coll = null;
        try {
            coll = emppositionQuery.getAppointDatePersonPM(ctx, personId, appointDate);
        }
        catch (BOSException e) {
            logger.error((Object)"SHRBillUtil.getAdminOrgUnitByAppointDate error", (Throwable)e);
        }
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                EmpPosOrgRelationInfo info = coll.get(i);
                if (info.getAssignType() != AssignTypeEnum.MAIN) continue;
                empPositionInfo = info;
            }
        }
        return empPositionInfo;
    }

    public static Map<String, List<EmpPosOrgRelationInfo>> getEmpPosOrgRelationInfos(Context ctx, String personIds, String beginDate, String endDate) throws BOSException, SQLException {
        Pair<String, List<String>> pair = AtsCollectionUtile.inSqlMask(personIds);
        StringBuffer sql = new StringBuffer();
        sql.append(" select emp.FEFFDT,emp.FLEFFDT,emp.FIsInner,emp.FPersonID,emp.FAdminOrgID,emp.FPositionID,emp.FAssignType,emp.FID,emt.fisInCount fisInCount ");
        sql.append(" from T_HR_EmpOrgRelation emp ");
        sql.append(" left join T_HR_EmpLaborRelation eml on emp.FlaborRelationID = eml.FID ");
        sql.append(" left join T_HR_EmpLaborRelationHis emlHis on eml.FID = emlHis.FHistoryRelateID ");
        sql.append(" left join T_HR_BDEmployeeType emt on emlHis.FLaborRelationStateID = emt.FID ");
        sql.append(" where emp.FPersonID in (" + (String)pair.getLeft() + ")  ");
        sql.append(" and emp.FIsSystem = 1 ");
        sql.append(" and emp.Fislatestinaday=1 ");
        sql.append(" and ( ");
        sql.append(" emp.FEFFDT <= ? and emp.FLEFFDT >= ?  ");
        sql.append(" ) ");
        sql.append(" order by emp.FEFFDT,emp.FLEFFDT ");
        IRowSet row = null;
        row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])AtsCollectionUtile.object2Arr(pair.getRight(), AtsDateUtils.stringShortToTimestamp(endDate), AtsDateUtils.stringShortToTimestamp(beginDate)));
        HashMap<String, List<EmpPosOrgRelationInfo>> empInfoMap = new HashMap<String, List<EmpPosOrgRelationInfo>>();
        EmpPosOrgRelationInfo info = null;
        while (row.next()) {
            info = new EmpPosOrgRelationInfo();
            info.setId(BOSUuid.read((String)row.getString("FID")));
            info.setEFFDT((Date)row.getDate("FEFFDT"));
            info.setLEFFDT((Date)row.getDate("FLEFFDT"));
            if (row.getInt("FIsInner") == 1) {
                info.setIsInner(true);
            } else {
                info.setIsInner(false);
            }
            if (row.getInt("FAssignType") == 0) {
                info.setAssignType(AssignTypeEnum.PARTTIME);
            } else if (row.getInt("FAssignType") == 1) {
                info.setAssignType(AssignTypeEnum.MAIN);
            }
            if (row.getInt("fisInCount") == 1) {
                info.setIsIncount(true);
            } else {
                info.setIsIncount(false);
            }
            PersonInfo pinfo = new PersonInfo();
            pinfo.setId(BOSUuid.read((String)row.getString("FPersonID")));
            info.setPerson(pinfo);
            AdminOrgUnitInfo unitinfo = new AdminOrgUnitInfo();
            unitinfo.setId(BOSUuid.read((String)row.getString("FAdminOrgID")));
            info.setAdminOrg(unitinfo);
            PositionInfo poinfo = new PositionInfo();
            poinfo.setId(BOSUuid.read((String)row.getString("FPositionID")));
            info.setPosition(poinfo);
            String key = row.getString("FPersonID");
            ArrayList<EmpPosOrgRelationInfo> empposlList = new ArrayList<EmpPosOrgRelationInfo>();
            if (empInfoMap.containsKey(key)) {
                ((List)empInfoMap.get(key)).add(info);
            } else {
                empposlList.add(info);
                empInfoMap.put(key, empposlList);
            }
            info = null;
        }
        return empInfoMap;
    }

    public static EmpPosOrgRelationInfo getAdminOrgUnitByAppointDateV2(Context ctx, String personId, Date appointDate, Map<String, List<EmpPosOrgRelationInfo>> empPosInfoMap) {
        if (personId == null) {
            return null;
        }
        EmpPosOrgRelationInfo empPositionInfo = null;
        List<EmpPosOrgRelationInfo> empposList = empPosInfoMap.get(personId);
        ArrayList<EmpPosOrgRelationInfo> resList = new ArrayList<EmpPosOrgRelationInfo>();
        if (empposList != null) {
            for (EmpPosOrgRelationInfo info : empposList) {
                if (appointDate.getTime() < info.getEFFDT().getTime() || appointDate.getTime() > info.getLEFFDT().getTime()) continue;
                resList.add(info);
            }
        }
        if (resList != null && resList.size() > 0) {
            for (int i = 0; i < resList.size(); ++i) {
                EmpPosOrgRelationInfo info;
                info = (EmpPosOrgRelationInfo)resList.get(i);
                if (info.getAssignType() != AssignTypeEnum.MAIN) continue;
                empPositionInfo = info;
            }
        }
        return empPositionInfo;
    }

    public static PersonPositionInfo getAdminOrgUnitAndHrOrgUnit(Context ctx, String personID) {
        if (personID == null) {
            return null;
        }
        PersonPositionInfo personPositionInfo = null;
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("jobGrade.id,");
        oqlb.append("tryoutMonth,");
        oqlb.append("jobGrade.name,");
        oqlb.append("jobLevel.id,");
        oqlb.append("jobLevel.name,");
        oqlb.append("person.name,");
        oqlb.append("person.employeeType.name,");
        oqlb.append("hrOrgUnit.id,");
        oqlb.append("hrOrgUnit.name,");
        oqlb.append("hrOrgUnit.number,");
        oqlb.append("personDep.id,");
        oqlb.append("personDep.name,");
        oqlb.append("personDep.number,");
        oqlb.append("personDep.displayName,");
        oqlb.append("primaryPosition.id,");
        oqlb.append("primaryPosition.name,");
        oqlb.append("primaryPosition.number,");
        oqlb.append("primaryPosition.job.id,");
        oqlb.append("primaryPosition.job.name");
        oqlb.append(" where person.id='");
        oqlb.append(personID);
        oqlb.append("'");
        PersonPositionCollection c = null;
        try {
            c = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oqlb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"SHRBillUtil.getAdminOrgUnitAndHrOrgUnit err", (Throwable)e);
        }
        if (c != null && c.size() > 0) {
            personPositionInfo = c.get(0);
        }
        return personPositionInfo;
    }

    public static Map<String, EmpLaborRelationInfo> getEmpLaborRelationInfos(Context ctx, String personIds) {
        if (personIds == null) {
            return null;
        }
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("enterDate,");
        oqlb.append("person.id,");
        oqlb.append("person.name,");
        oqlb.append("person.number");
        oqlb.append(" where person.id in (");
        oqlb.append(personIds);
        oqlb.append(" )");
        EmpLaborRelationCollection coll = null;
        HashMap<String, EmpLaborRelationInfo> infoMap = new HashMap<String, EmpLaborRelationInfo>();
        try {
            coll = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationCollection(oqlb.toString());
            if (coll != null) {
                for (int i = 0; i < coll.size(); ++i) {
                    String key = coll.get(i).getPerson().getId().toString();
                    infoMap.put(key, coll.get(i));
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"SHRBillUtil.getEmpLaborRelationInfos err", (Throwable)e);
        }
        return infoMap;
    }

    public static Map<String, PersonPositionInfo> getAdminOrgUnitAndHrOrgUnitInfos(Context ctx, String personIds) {
        if (personIds == null) {
            return null;
        }
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("leftDate,");
        oqlb.append("jobGrade.id,");
        oqlb.append("tryoutMonth,");
        oqlb.append("jobGrade.name,");
        oqlb.append("jobLevel.id,");
        oqlb.append("jobLevel.name,");
        oqlb.append("person.name,");
        oqlb.append("person.number,");
        oqlb.append("person.employeeType.name,");
        oqlb.append("hrOrgUnit.id,");
        oqlb.append("hrOrgUnit.name,");
        oqlb.append("hrOrgUnit.number,");
        oqlb.append("personDep.id,");
        oqlb.append("personDep.name,");
        oqlb.append("personDep.number,");
        oqlb.append("personDep.displayName,");
        oqlb.append("primaryPosition.id,");
        oqlb.append("primaryPosition.name,");
        oqlb.append("primaryPosition.number,");
        oqlb.append("primaryPosition.job.id,");
        oqlb.append("primaryPosition.job.name");
        oqlb.append(" where person.id in (");
        oqlb.append(personIds);
        oqlb.append(" )");
        PersonPositionCollection coll = null;
        HashMap<String, PersonPositionInfo> infoMap = new HashMap<String, PersonPositionInfo>();
        try {
            coll = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oqlb.toString());
            if (coll != null) {
                for (int i = 0; i < coll.size(); ++i) {
                    String key = coll.get(i).getPerson().getId().toString();
                    infoMap.put(key, coll.get(i));
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"SHRBillUtil.getAdminOrgUnitAndHrOrgUnitInfos err", (Throwable)e);
        }
        return infoMap;
    }

    public static PersonInfo getPersonDetailInfo(Context ctx, String personID) {
        PersonInfo personInfo = null;
        if (personID == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("employeeType.id"));
        sic.add(new SelectorItemInfo("employeeType.name"));
        sic.add(new SelectorItemInfo("employeeType.number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        try {
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personID), sic);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return personInfo;
    }

    public static PersonInfo getPersonDetailInfo(String personID) {
        PersonInfo personInfo = null;
        if (personID == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("employeeType.id"));
        sic.add(new SelectorItemInfo("employeeType.name"));
        sic.add(new SelectorItemInfo("employeeType.number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        try {
            personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personID), sic);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return personInfo;
    }

    public static String convertOqlToSql(Context ctx, String oqlFilter) {
        if (StringUtils.isEmpty((CharSequence)oqlFilter)) {
            return "";
        }
        if (oqlFilter.indexOf("person.name") > -1) {
            oqlFilter = oqlFilter.replace("person.name", "person.fname" + MLUtile.getMlFlag(ctx));
        }
        if (oqlFilter.indexOf("name") > -1) {
            oqlFilter = oqlFilter.replace("name", "person.fname" + MLUtile.getMlFlag(ctx));
        }
        if (oqlFilter.indexOf("person.number") > -1) {
            oqlFilter = oqlFilter.replace("person.number", "person.fnumber");
        }
        if (oqlFilter.indexOf("number") > -1) {
            oqlFilter = oqlFilter.replace("number", "person.fnumber");
        }
        if (oqlFilter.indexOf("adminOrgUnit.displayName") > -1) {
            oqlFilter = oqlFilter.replace("adminOrgUnit.displayName", "adminOrgUnit.fDisplayName" + MLUtile.getMlFlag(ctx));
        }
        if (oqlFilter.indexOf("primaryPosition.name") > -1) {
            oqlFilter = oqlFilter.replace("primaryPosition.name", "primaryPosition.FName" + MLUtile.getMlFlag(ctx));
        }
        if (oqlFilter.indexOf("employeeType.name") > -1) {
            oqlFilter = oqlFilter.replace("employeeType.name", "employeeType.fName" + MLUtile.getMlFlag(ctx));
        }
        if (oqlFilter.indexOf("pp.joinGroupDate") > -1) {
            oqlFilter = oqlFilter.replace("pp.joinGroupDate", " pp.fJoinGroupDate");
        }
        return oqlFilter;
    }

    @Deprecated
    public static boolean overTimeControl(Context ctx) {
        boolean isControl = false;
        String sql = "select fisUsed from T_HR_ATS_AtsOtLimitControlPar";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowset.next()) {
                if (rowset.getInt("fisUsed") != 1) continue;
                isControl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isControl;
    }

    public static boolean overTimeControl(Context ctx, String hrOrgUnitId) throws EASBizException, BOSException {
        OtLimitCtrlEnableSettingCollection coll = OtLimitCtrlEnableSettingFactory.getLocalInstance((Context)ctx).getOtLimitCtrlEnableSettingCollection(" where hrOrgUnit.id = '" + hrOrgUnitId + "' ");
        if (coll.size() > 0) {
            return AtsOverTimeLimitRuleStatueEnum.enable.equals((Object)coll.get(0).getState());
        }
        return false;
    }

    public static boolean overTimeControl(String personId, Context ctx) {
        try {
            AttendanceFileCollection fileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection("select hrOrgUnit.id where proposer.id = '" + personId + "' ");
            String hrOrgUnitId = "";
            if (fileColl != null && fileColl.size() > 0) {
                hrOrgUnitId = fileColl.get(0).getHrOrgUnit().getId().toString();
            }
            return SHRBillServerUtil.overTimeControl(ctx, hrOrgUnitId);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean overTimeControl(String personId, String startDate, Context ctx) {
        try {
            AttendanceFileHISCollection fileColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection("select hrOrgUnit.id where proposer.id = '" + personId + "'  and effdt <= '" + AtsDateUtils.stringShortToTimestamp(startDate) + "' and leffdt >= '" + AtsDateUtils.stringShortToTimestamp(startDate) + "'");
            String hrOrgUnitId = "";
            if (fileColl != null && fileColl.size() > 0) {
                hrOrgUnitId = fileColl.get(0).getHrOrgUnit().getId().toString();
            }
            return SHRBillServerUtil.overTimeControl(ctx, hrOrgUnitId);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static PersonInfo getCurrPersonInfo(Context ctx) {
        String userName = ctx.getUserName();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        PersonInfo personInfo = null;
        personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        return personInfo;
    }

    public static Map<String, PersonOtherInfoInfo> getPersonOtherInfos(Context ctx, String personIds) {
        if (personIds == null) {
            return null;
        }
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("retireDate,");
        oqlb.append("jobStartDate");
        oqlb.append(" where person.id in (");
        oqlb.append(personIds);
        oqlb.append(" )");
        PersonOtherInfoCollection coll = null;
        HashMap<String, PersonOtherInfoInfo> infoMap = new HashMap<String, PersonOtherInfoInfo>();
        try {
            coll = PersonOtherInfoFactory.getLocalInstance((Context)ctx).getPersonOtherInfoCollection(oqlb.toString());
            if (coll != null) {
                for (int i = 0; i < coll.size(); ++i) {
                    String key = coll.get(i).getPerson().getId().toString();
                    infoMap.put(key, coll.get(i));
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"SHRBillUtil.getPersonOtherInfos err", (Throwable)e);
        }
        return infoMap;
    }

    public static Set<String> getHolidayLimitInfoByBillID(Context ctx, String BillID) {
        HashSet<String> holidayLimitIDSet = new HashSet<String>();
        String sql = " SELECT FHOLIDAYLIMITID FROM T_HR_ATS_HOLIDAYLIMITDETAIL  LEFT OUTER JOIN T_HR_ATS_HOLIDAYLIMIT ON T_HR_ATS_HOLIDAYLIMITDETAIL.FHOLIDAYLIMITID = T_HR_ATS_HOLIDAYLIMIT.FID  WHERE FHOLIDAYLIMITID is not null and Fleavebillid = '" + BillID + "'";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowset.next()) {
                holidayLimitIDSet.add(rowset.getString("FHOLIDAYLIMITID"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return holidayLimitIDSet;
    }

    public static boolean getIsElasticCalCtrl(Context ctx, String personId, String holidayPolicyId, String beginTime, String endTime) {
        boolean showIsElasticCalCtrl = false;
        if (StringUtils.isNotBlank((CharSequence)holidayPolicyId)) {
            HolidayPolicyInfo holidayPolicyInfo = null;
            try {
                holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo((IObjectPK)new ObjectUuidPK(holidayPolicyId));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (holidayPolicyInfo != null && holidayPolicyInfo.isIsHalfDayOff()) {
                return showIsElasticCalCtrl;
            }
        }
        Date date = HRTimeWebUtils.stringToShortDate(beginTime);
        String attDate = HRTimeWebUtils.dateShortToString(date);
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, attDate = AtsDateUtils.getDateFromLongString(attDate));
        if (scheduleShiftInfo != null) {
            showIsElasticCalCtrl = scheduleShiftInfo.isIsElastic() && scheduleShiftInfo.getElasticType().getValue() == 1;
            return showIsElasticCalCtrl;
        }
        Date endDate = HRTimeWebUtils.stringToShortDate(endTime);
        String attEndDate = HRTimeWebUtils.dateShortToString(endDate);
        ScheduleShiftInfo endscheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, attEndDate = AtsDateUtils.getDateFromLongString(attEndDate));
        if (endscheduleShiftInfo != null) {
            showIsElasticCalCtrl = endscheduleShiftInfo.isIsElastic() && endscheduleShiftInfo.getElasticType().getValue() == 1;
            return showIsElasticCalCtrl;
        }
        AbstractAttendanceFileHISInfo filehisInfo = null;
        String oql = "select id,atsShift.* where proposer.id = '" + personId + "' and effdt <= '" + attDate + "' and leffdt >= '" + attDate + "' ";
        try {
            AttendanceFileHISCollection filehisInfoColls = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(oql);
            if (AtsCollectionUtile.isEmpty((IObjectCollection)filehisInfoColls)) {
                filehisInfo = filehisInfoColls.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (filehisInfo != null && filehisInfo.getAtsShift() != null) {
            showIsElasticCalCtrl = filehisInfo.getAtsShift().isIsElastic() && filehisInfo.getAtsShift().getElasticType().getValue() == 1;
        }
        return showIsElasticCalCtrl;
    }
}

