/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.BizDataSynchAssistCollection;
import com.kingdee.eas.hr.ats.BizDataSynchAssistFactory;
import com.kingdee.eas.hr.ats.BizDataSynchAssistInfo;
import com.kingdee.eas.hr.ats.IBizDataSynchAssist;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.dataplatform.CompareSymbolEnum;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ScheduleShiftUtils {
    public static BizDataSynchAssistInfo generateBizDataSynchAssistInfo(Context ctx, Timestamp lastUpdateTime) throws BOSException, EASBizException {
        BizDataSynchAssistInfo bizDataSynchAssistInfo = new BizDataSynchAssistInfo();
        bizDataSynchAssistInfo.setSynchManager("com.kingdee.eas.hr.ats.app.ScheduleShiftControllerBean");
        bizDataSynchAssistInfo.setLastsynchtime(lastUpdateTime);
        IBizDataSynchAssist bizDataSynchAssist = BizDataSynchAssistFactory.getLocalInstance(ctx);
        IObjectPK pk = bizDataSynchAssist.save(bizDataSynchAssistInfo);
        bizDataSynchAssistInfo.setId(BOSUuid.read((String)pk.toString()));
        return bizDataSynchAssistInfo;
    }

    public static boolean canEditSchedule(ScheduleShiftInfo scheduleShiftInfo) {
        return scheduleShiftInfo == null || ScheduleShiftUtils.canEditSchedule(scheduleShiftInfo.getSrcType());
    }

    public static boolean canEditSchedule(SchlShiftSrcTypeEnum srcType) {
        return srcType == null || Integer.valueOf(srcType.getValue()) <= Integer.valueOf("2");
    }

    public static void checkCanEditSchedule(Context ctx, String personId, Object attendDate) throws BOSException, HRCommonException {
        Set<String> forbidEditScheduleDates = ScheduleShiftUtils.listForbidEditScheduleDates(ctx, personId, attendDate);
        if (!forbidEditScheduleDates.isEmpty()) {
            String msg = MessageFormat.format("{0}{1}{2}", forbidEditScheduleDates.iterator().next(), CompareSymbolEnum.in.getAlias(), SchlShiftSrcTypeEnum.storeSchShift.getAlias());
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
    }

    public static Set<String> listForbidEditScheduleDates(Context ctx, String personId, Object attendDate) throws BOSException {
        attendDate = Date.getDate(attendDate);
        if (!BOSUuid.isValid((String)personId, (boolean)true) || attendDate == null) {
            return Collections.emptySet();
        }
        String inSql = AtsCollectionUtile.joinForSqlWithBrackets(Arrays.asList("1", "2"));
        String existSql = "select FAttendDate from T_HR_ATS_ScheduleShift where FProposerID=? and FAttendDate=? and FSrcType not in " + inSql;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)existSql, (Object[])new Object[]{personId, attendDate});
        HashSet<String> resu = new HashSet<String>();
        try {
            while (rowSet.next()) {
                resu.add(Date.getDate(rowSet.getObject("FAttendDate")).toDateStr());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resu;
    }

    public static BizDataSynchAssistInfo getBizDataSynchAssistInfo(Context ctx) throws BOSException {
        IBizDataSynchAssist bizDataSynchAssist = BizDataSynchAssistFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("synchManager", (Object)"com.kingdee.eas.hr.ats.app.ScheduleShiftControllerBean", CompareType.EQUALS));
        view.setFilter(fi);
        BizDataSynchAssistCollection collection = bizDataSynchAssist.getBizDataSynchAssistCollection(view);
        if (collection != null) {
            return collection.get(0);
        }
        return null;
    }

    public static BizDataSynchAssistInfo updateBizDataSynchAssistLastTime(Context ctx, BizDataSynchAssistInfo bizDataSynchAssistInfo, Timestamp lastUpdateTime) throws EASBizException, BOSException {
        if (bizDataSynchAssistInfo != null) {
            bizDataSynchAssistInfo.setLastsynchtime(lastUpdateTime);
            BizDataSynchAssistFactory.getLocalInstance(ctx).save(bizDataSynchAssistInfo);
        } else {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long time = 0L;
            try {
                time = format.parse("1900-01-01 00:00:00").getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            bizDataSynchAssistInfo = ScheduleShiftUtils.generateBizDataSynchAssistInfo(ctx, new Timestamp(time));
        }
        return bizDataSynchAssistInfo;
    }

    public static Set<String> getScheduleshiftIds(Context ctx, String sql, Object[] sqlParam, Set<String> scheduleshiftIds) throws SQLException, BOSException {
        IRowSet rowSet = null;
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])sqlParam);
        String id = "";
        while (rowSet.next()) {
            id = rowSet.getString("fid");
            scheduleshiftIds.add(id);
        }
        return scheduleshiftIds;
    }
}

