/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AbstractHolidayPolicyInfo;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.biz.util.AtsServerBizUtil;
import com.kingdee.eas.hr.ats.util.CollectionUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ValidateLeaveBillLimitUtils {
    private Context ctx = null;
    private String billId = "";
    private Map<String, Map<String, String>> holidayLimitMap = new HashMap<String, Map<String, String>>();
    private AtsLeaveBillInfo atsLeaveBillInfo = null;
    private Map<String, Object> holidayFileHisMap = new HashMap<String, Object>();

    public ValidateLeaveBillLimitUtils(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo) {
        this.ctx = ctx;
        this.atsLeaveBillInfo = atsLeaveBillInfo;
        this.billId = atsLeaveBillInfo.getId() == null ? "" : atsLeaveBillInfo.getId().toString();
    }

    public String validate() throws EASBizException, BOSException {
        String errorMsg = "";
        if (this.atsLeaveBillInfo == null || this.ctx == null) {
            return errorMsg;
        }
        AtsLeaveBillEntryCollection entryColls = this.atsLeaveBillInfo.getEntries();
        for (int i = 0; i < this.atsLeaveBillInfo.getEntries().size(); ++i) {
            String personId = this.atsLeaveBillInfo.getEntries().get(i).getPerson().getId().toString();
            String holidayPoliceId = this.atsLeaveBillInfo.getEntries().get(i).getPolicy().getId().toString();
            Timestamp beginTime = this.atsLeaveBillInfo.getEntries().get(i).getBeginTime();
            Timestamp endTime = this.atsLeaveBillInfo.getEntries().get(i).getEndTime();
            BigDecimal length = this.atsLeaveBillInfo.getEntries().get(i).getLeaveLength();
            if (length == null) {
                length = this.atsLeaveBillInfo.getEntries().get(i).getRealLeaveLength();
            }
            if (StringUtils.isEmpty((String)(errorMsg = this.updateHolidayLimit(personId, beginTime, endTime, holidayPoliceId, length)))) continue;
            return errorMsg;
        }
        return errorMsg;
    }

    public String updateHolidayLimit(String personId, Timestamp beginTimeCount, Timestamp endTimeCount, String holidayPolicyId, BigDecimal length) throws BOSException, EASBizException {
        String errorMsg;
        String hrOrgUnitId = "";
        String holidayPolicySetId = "";
        AtsHolidayFileHisInfo holidayFileHisInfo = this.getHolidayFileHis(personId, beginTimeCount);
        hrOrgUnitId = holidayFileHisInfo.getHrOrgUnit().getId().toString();
        holidayPolicySetId = holidayFileHisInfo.getHolidayPolicySet().getId().toString();
        AbstractHolidayPolicyInfo holidayPolicyInfo = null;
        HolidayPolicyCollection holidayPolicyColls = HolidayPolicyFactory.getLocalInstance(this.ctx).getHolidayPolicyCollection(" select id,isNeedAttach,isNeedAttachOver,preHolidayTypes,isCtrlLimit,isOver,holidayType.id,holidayType.name,minLeaveLength where holidayPolicySet='" + holidayPolicySetId + "'");
        Iterator iterator = holidayPolicyColls.iterator();
        while (iterator.hasNext()) {
            HolidayPolicyInfo item = (HolidayPolicyInfo)iterator.next();
            if (!item.getId().toString().equals(holidayPolicyId)) continue;
            holidayPolicyInfo = item;
        }
        if (holidayPolicyInfo == null) {
            return AtsServerBizUtil.noHolidayPolicyInfo_msg.getMessage();
        }
        Boolean isIsNeedAttach = holidayPolicyInfo.isIsNeedAttach();
        if (isIsNeedAttach.booleanValue()) {
            if (StringUtils.isEmpty((String)this.billId)) {
                return MLUtile.getRes(AtsFileResEnum.UploadAttachment, this.ctx);
            }
            String errorString = this.validateIsNeedAttach(this.ctx, this.billId);
            if (!errorString.equals("")) {
                return errorString;
            }
        }
        if (!StringUtils.isEmpty((String)holidayPolicyInfo.getPreHolidayTypes())) {
            String[] preHolidayTypeArr;
            for (String preHolidayType : preHolidayTypeArr = holidayPolicyInfo.getPreHolidayTypes().split(",")) {
                Iterator iteratorPre = holidayPolicyColls.iterator();
                AbstractHolidayPolicyInfo preHolidayPolicyInfo = null;
                while (iteratorPre.hasNext()) {
                    HolidayPolicyInfo item = (HolidayPolicyInfo)iteratorPre.next();
                    if (!item.getHolidayType().getId().toString().equals(preHolidayType)) continue;
                    preHolidayPolicyInfo = item;
                }
                if (preHolidayPolicyInfo == null) continue;
                String preHolidayTypeName = "";
                if (preHolidayPolicyInfo.isIsCtrlLimit() && !preHolidayPolicyInfo.isIsOver()) {
                    boolean available = this.preHolidayLimitAvailable(personId, beginTimeCount, endTimeCount, (HolidayPolicyInfo)preHolidayPolicyInfo, length, hrOrgUnitId);
                    if (!available) continue;
                    preHolidayTypeName = preHolidayPolicyInfo.getHolidayType().getName();
                    return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.PreHolidayTypesFirst, this.ctx, preHolidayTypeName);
                }
                return MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.PreHolidayTypesFirst, this.ctx, preHolidayTypeName);
            }
        }
        if (holidayPolicyInfo.isIsCtrlLimit() && !holidayPolicyInfo.isIsOver()) {
            return this.calHolidayLimit(personId, beginTimeCount, endTimeCount, (HolidayPolicyInfo)holidayPolicyInfo, length, hrOrgUnitId);
        }
        if (holidayPolicyInfo.isIsCtrlLimit() && holidayPolicyInfo.isIsOver() && !StringUtils.isEmpty((String)(errorMsg = this.calHolidayLimit(personId, beginTimeCount, endTimeCount, (HolidayPolicyInfo)holidayPolicyInfo, length, hrOrgUnitId))) && holidayPolicyInfo.isIsNeedAttachOver()) {
            if (StringUtils.isEmpty((String)this.billId)) {
                return MLUtile.getRes(AtsHolidayResEnum.LeakRemainLimitToLeaveBill, this.ctx);
            }
            String errorString = this.validateIsNeedAttach(this.ctx, this.billId);
            if (!errorString.equals("")) {
                return MLUtile.getRes(AtsHolidayResEnum.LeakRemainLimitToLeaveBill, this.ctx);
            }
        }
        return "";
    }

    public boolean preHolidayLimitAvailable(String personId, Timestamp beginTimeCount, Timestamp endTimeCount, HolidayPolicyInfo holidayPolicyInfo, BigDecimal length, String hrOrgUnitId) throws EASBizException, BOSException {
        String holidayPolicyId = holidayPolicyInfo.getId().toString();
        String holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        BigDecimal minLeaveLength = holidayPolicyInfo.getMinLeaveLength();
        HolidayLimitCollection holidayLimitColls = this.getHolidayLimitData(personId, beginTimeCount, endTimeCount, holidayTypeId, hrOrgUnitId);
        if (!CollectionUtile.isEmpty((IObjectCollection)holidayLimitColls)) {
            Iterator iterator = holidayLimitColls.iterator();
            while (iterator.hasNext()) {
                BigDecimal remainLimit = BigDecimal.ZERO;
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)iterator.next();
                String holidayLimitId = holidayLimitInfo.getId().toString();
                if (this.holidayLimitMap.get(holidayLimitId) == null) {
                    remainLimit = remainLimit.add(holidayLimitInfo.getRemainLimit());
                } else {
                    Map<String, String> exsitsLimit = this.holidayLimitMap.get(holidayLimitId);
                    remainLimit = new BigDecimal(exsitsLimit.get("remainLimit"));
                }
                if (minLeaveLength != null && remainLimit.compareTo(minLeaveLength) < 0) {
                    return false;
                }
                if (remainLimit.compareTo(BigDecimal.ZERO) <= 0) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public String calHolidayLimit(String personId, Timestamp beginTimeCount, Timestamp endTimeCount, HolidayPolicyInfo holidayPolicyInfo, BigDecimal length, String hrOrgUnitId) throws EASBizException, BOSException {
        String holidayPolicyId = holidayPolicyInfo.getId().toString();
        String holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        HolidayLimitCollection holidayLimitColls = this.getHolidayLimitData(personId, beginTimeCount, endTimeCount, holidayTypeId, hrOrgUnitId);
        if (CollectionUtile.isEmpty((IObjectCollection)holidayLimitColls)) {
            return MLUtile.getRes(AtsHolidayResEnum.NotGeneratePerLimit, this.ctx);
        }
        Iterator iterator = holidayLimitColls.iterator();
        while (iterator.hasNext() && length.compareTo(BigDecimal.ZERO) > 0) {
            HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)iterator.next();
            String holidayLimitId = holidayLimitInfo.getId().toString();
            BigDecimal remainLimit = BigDecimal.ZERO;
            BigDecimal usedLimit = BigDecimal.ZERO;
            if (this.holidayLimitMap.get(holidayLimitId) == null) {
                remainLimit = holidayLimitInfo.getRemainLimit();
                usedLimit = holidayLimitInfo.getUsedLimit();
            } else {
                Map<String, String> exsitsLimit = this.holidayLimitMap.get(holidayLimitId);
                remainLimit = new BigDecimal(exsitsLimit.get("remainLimit"));
                usedLimit = new BigDecimal(exsitsLimit.get("usedLimit"));
            }
            if (remainLimit.compareTo(length) >= 0) {
                usedLimit = length;
                remainLimit = remainLimit.subtract(length);
                length = BigDecimal.ZERO;
            } else {
                usedLimit = remainLimit;
                length = length.subtract(remainLimit);
                remainLimit = BigDecimal.ZERO;
            }
            HashMap<String, String> limitInfoMap = new HashMap<String, String>();
            limitInfoMap.put("usedLimit", usedLimit.toString());
            limitInfoMap.put("remainLimit", remainLimit.toString());
            this.holidayLimitMap.put(holidayLimitId, limitInfoMap);
        }
        if (length.compareTo(BigDecimal.ZERO) > 0) {
            return MLUtile.getRes(AtsHolidayResEnum.LeakRemainLimit, this.ctx);
        }
        return "";
    }

    public HolidayLimitCollection getHolidayLimitData(String personId, Timestamp beginTimeCount, Timestamp endTimeCount, String holidayTypeId, String hrOrgUnitId) throws EASBizException, BOSException {
        HolidayLimitCollection holidayLimitColls = this.getHolidayLimitCollectionByPersonIdAndStartEndTime(this.ctx, personId, holidayTypeId, beginTimeCount, endTimeCount, hrOrgUnitId);
        if (!CollectionUtile.isEmpty((IObjectCollection)holidayLimitColls)) {
            Iterator iterator = holidayLimitColls.iterator();
            while (iterator.hasNext()) {
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)iterator.next();
                String holidayLimitId = holidayLimitInfo.getId().toString();
                HashMap paramsMap = new HashMap();
                BigDecimal usedLimit = holidayLimitInfo.getUsedLimit();
                BigDecimal remainLimit = holidayLimitInfo.getRemainLimit();
                if (this.holidayLimitMap.get(holidayLimitId) != null) continue;
                HashMap<String, String> limitInfoMap = new HashMap<String, String>();
                limitInfoMap.put("usedLimit", usedLimit.toString());
                limitInfoMap.put("remainLimit", remainLimit.toString());
                this.holidayLimitMap.put(holidayLimitId, limitInfoMap);
            }
        }
        return holidayLimitColls;
    }

    public Map<String, Object> getAllLeaveBillTimes(Context ctx, Map<String, Object> paramsMap) {
        StringBuffer sql = new StringBuffer();
        int times = 0;
        String proposerid = (String)paramsMap.get("proposerid");
        String beginTime = (String)paramsMap.get("beginTime");
        String endTime = (String)paramsMap.get("endTime");
        String policyId = (String)paramsMap.get("policyId");
        beginTime = beginTime.substring(0, 10) + " 00:00:00";
        endTime = endTime.substring(0, 10) + " 00:00:00";
        sql.append("select feffectDate,fdelayDate from T_HR_ATS_HolidayLimit  holiLimit ");
        sql.append(" inner join  T_HR_ATS_HolidayPolicy policy on policy.fid = holiLimit.fholidaypolicyid");
        sql.append(" where ");
        sql.append(" ({TS '" + beginTime + "'}<= feffectDate and feffectDate < {TS '" + endTime + "'}");
        sql.append(" or\t{TS '" + beginTime + "'}< fdelayDate and fdelayDate <= {TS '" + endTime + "'}");
        sql.append(" or\tfeffectDate<= {TS '" + beginTime + "'} and  {TS '" + endTime + "'}<= fdelayDate )");
        sql.append("and FProposerID = '" + proposerid + "' and policy.fholidayTypeid='" + policyId + "'");
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        ArrayList limitList = new ArrayList();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    HashMap<String, String> limitMap = new HashMap<String, String>();
                    String effectDate = rowSet.getString("feffectDate");
                    String delayDate = rowSet.getString("fdelayDate");
                    if (effectDate.length() > 19) {
                        effectDate = effectDate.substring(0, 19);
                    }
                    if (delayDate.length() > 19) {
                        delayDate = delayDate.substring(0, 10) + " 23:59:59";
                    }
                    limitMap.put("effectDate", effectDate);
                    limitMap.put("delayDate", delayDate);
                    limitList.add(limitMap);
                    ++times;
                }
                infoMap.put("limitDate", limitList);
            }
            infoMap.put("policyId", policyId);
            infoMap.put("proposerid", proposerid);
            infoMap.put("allTimes", times);
        }
        catch (BOSException e) {
            infoMap.put("allTimes", times);
            e.printStackTrace();
        }
        catch (SQLException s) {
            infoMap.put("allTimes", times);
            s.printStackTrace();
        }
        return infoMap;
    }

    public HolidayLimitCollection getHolidayLimitCollectionByPersonIdAndStartEndTime(Context ctx, String personId, String holidayType, Timestamp startTime, Timestamp endTime, String hrOrgUnitId) throws BOSException, EASBizException {
        long leaveBillStartTime = startTime.getTime();
        long leaveBillEndTime = endTime.getTime();
        boolean tempVal = false;
        long b1 = 0L;
        long e1 = 0L;
        long b2 = 0L;
        long e2 = 0L;
        HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayType + "' and hrOrgUnit.id='" + hrOrgUnitId + "'  order by cyclebegindate asc");
        HolidayLimitCollection holidayLimitCollectionReturn = new HolidayLimitCollection();
        HolidayLimitInfo holidayLimitInfo = new HolidayLimitInfo();
        for (int i = 0; i < holidayLimitCollection.size(); ++i) {
            b1 = leaveBillStartTime;
            e1 = leaveBillEndTime;
            b2 = holidayLimitCollection.get(i).getEffectDate().getTime();
            e2 = holidayLimitCollection.get(i).getDelayDate().getTime() + 86399000L;
            if (b1 > e2 || e1 < b2) continue;
            holidayLimitInfo = holidayLimitCollection.get(i);
            holidayLimitCollectionReturn.add(holidayLimitInfo);
            tempVal = true;
        }
        if (!tempVal) {
            return null;
        }
        return holidayLimitCollectionReturn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AtsHolidayFileHisInfo getHolidayFileHis(String personId, Timestamp beginTimeCount) {
        AtsHolidayFileHisInfo atsHolidayFileHisInfo = null;
        AtsHolidayFileHisCollection atsHolidayFileHisCollection = null;
        if (this.holidayFileHisMap.get(personId) != null) {
            atsHolidayFileHisCollection = (AtsHolidayFileHisCollection)((Object)this.holidayFileHisMap.get(personId));
            boolean exsitHolidayFile = false;
            Iterator iterator = atsHolidayFileHisCollection.iterator();
            while (iterator.hasNext()) {
                AtsHolidayFileHisInfo item = (AtsHolidayFileHisInfo)iterator.next();
                if (item.getEFFDT().getTime() > beginTimeCount.getTime() || item.getLEFFDT().getTime() < beginTimeCount.getTime()) continue;
                exsitHolidayFile = true;
                atsHolidayFileHisInfo = item;
                break;
            }
            if (exsitHolidayFile) return atsHolidayFileHisInfo;
        }
        try {
            atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(this.ctx).getAtsHolidayFileHisCollection("where proposer.id='" + personId + "'  order by effdt asc");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (CollectionUtile.isEmpty((IObjectCollection)atsHolidayFileHisCollection)) return atsHolidayFileHisInfo;
        this.holidayFileHisMap.put(personId, (Object)atsHolidayFileHisCollection);
        boolean exsitHolidayFile = false;
        Iterator iterator = atsHolidayFileHisCollection.iterator();
        while (iterator.hasNext()) {
            AtsHolidayFileHisInfo item = (AtsHolidayFileHisInfo)iterator.next();
            if (item.getEFFDT().getTime() > beginTimeCount.getTime() || item.getLEFFDT().getTime() < beginTimeCount.getTime()) continue;
            exsitHolidayFile = true;
            atsHolidayFileHisInfo = item;
            break;
        }
        if (exsitHolidayFile) return atsHolidayFileHisInfo;
        return atsHolidayFileHisInfo;
    }

    public String validateIsNeedAttach(Context ctx, String billId) throws BOSException {
        String res = "";
        StringBuffer attachSql = new StringBuffer();
        if (!org.apache.axis.utils.StringUtils.isEmpty((String)billId)) {
            attachSql.append("select count(1) from T_hr_shrattachmentext where fboid = '" + billId + "' ");
            int appTimes = 0;
            IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)attachSql.toString());
            if (rowSet1.size() > 0) {
                try {
                    while (rowSet1.next()) {
                        appTimes = rowSet1.getInt(1);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (appTimes == 0) {
                    attachSql = new StringBuffer();
                    attachSql.append("select count(1) from T_BAS_BoAttchAsso where FBoID ='" + billId + "'");
                    rowSet1 = DbUtil.executeQuery((Context)ctx, (String)attachSql.toString());
                    if (rowSet1.size() > 0) {
                        try {
                            while (rowSet1.next()) {
                                appTimes = rowSet1.getInt(1);
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (appTimes == 0) {
                        res = MLUtile.getRes(AtsFileResEnum.UploadAttachment, ctx);
                    }
                }
            }
        }
        return res;
    }
}

