/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsSupportBillInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.FillSignCardEntryCollection;
import com.kingdee.eas.hr.ats.FillSignCardEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.FillSignCardType;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SegmentEnum;
import com.kingdee.eas.hr.ats.SegmentUnitEnum;
import com.kingdee.eas.hr.ats.app.ItemSourceType;
import com.kingdee.eas.hr.ats.common.AttendanceConstants;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.helper.ScheduleShiftItemHelper;
import com.kingdee.eas.hr.ats.result.AttDynamicItemResInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AtsCalCommonUtils {
    public static AttDynamicItemResInfo getInstanceOfItemResInfo(Timestamp preDateTime, Timestamp nextDateTime, AdminOrgUnitInfo adminOrgUnitInfo) {
        AttDynamicItemResInfo attDynamicItemResInfo = new AttDynamicItemResInfo();
        attDynamicItemResInfo.setItemStartDate(preDateTime);
        attDynamicItemResInfo.setItemEndDate(nextDateTime);
        attDynamicItemResInfo.setItemSourceType(ItemSourceType.sourceShiftItem);
        attDynamicItemResInfo.setAttadminOrgUnit(adminOrgUnitInfo);
        return attDynamicItemResInfo;
    }

    public static AttDynamicItemResInfo geItemResInfoByBill() {
        return new AttDynamicItemResInfo();
    }

    public static String getPersonAndDate(String personId, String dateStr) {
        return MessageFormat.format("{0}{1}{2}", personId, "_", dateStr);
    }

    public static String combineString(String str1, String str2) {
        return MessageFormat.format("{0}{1}{2}", str1, "_", str2);
    }

    public static void buildItemResultBySchedule(Map<Object, Object> globalMap, Map<String, List<ScheduleShiftInfo>> scheduleShiftItemMap, Map<String, List<AttDynamicItemResInfo>> atsItemResultDetailMap, String personAndDate) {
        if (AtsCollectionUtile.isEmpty(globalMap) || AtsCollectionUtile.isEmpty(scheduleShiftItemMap) || null == atsItemResultDetailMap) {
            return;
        }
        List<ScheduleShiftInfo> scheduleShiftList = scheduleShiftItemMap.get(personAndDate);
        if (AtsCollectionUtile.isEmpty(scheduleShiftList)) {
            AtsCalCommonUtils.buildItemDetailByshiftInfo(globalMap, atsItemResultDetailMap, personAndDate);
            return;
        }
        ScheduleShiftInfo sheduleshiftinfo = scheduleShiftList.get(0);
        ArrayList<AttDynamicItemResInfo> itemResultDetail = new ArrayList<AttDynamicItemResInfo>();
        ScheduleShiftItemCollection scheduleShiftItems = sheduleshiftinfo.getItems();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftItems)) {
            AtsCalCommonUtils.buildItemDetailByshiftInfo(globalMap, atsItemResultDetailMap, personAndDate);
        } else {
            for (int index = 0; index < scheduleShiftItems.size(); ++index) {
                ScheduleShiftItemInfo scheduleShiftItemInfo = scheduleShiftItems.get(index);
                scheduleShiftItemInfo.getAttendanceType();
                Timestamp preDateTime = scheduleShiftItemInfo.getPreDateTime();
                Timestamp nextDateTime = scheduleShiftItemInfo.getNextDateTime();
                AdminOrgUnitInfo adminOrgUnitInfo = scheduleShiftItemInfo.getAttAdminOrgUnit();
                AttDynamicItemResInfo attDynamicItemResInfo = AtsCalCommonUtils.getInstanceOfItemResInfo(preDateTime, nextDateTime, adminOrgUnitInfo);
                Timestamp restPreDateTime = scheduleShiftItemInfo.getRestPreDateTime();
                Timestamp restNextDateTime = scheduleShiftItemInfo.getRestNextDateTime();
                BigDecimal restTime = null == scheduleShiftItemInfo.getSegmentInRest() ? BigDecimal.ZERO : scheduleShiftItemInfo.getSegmentInRest();
                attDynamicItemResInfo.setPreIsPunchCard(scheduleShiftItemInfo.getPreIsPunchCard());
                attDynamicItemResInfo.setNextIsPunchCard(scheduleShiftItemInfo.getNextIsPunchCard());
                attDynamicItemResInfo.setItemRestStartDate(restPreDateTime);
                attDynamicItemResInfo.setItemRestEndDate(restNextDateTime);
                attDynamicItemResInfo.setRestTime(restTime);
                attDynamicItemResInfo.setAttendanceType(scheduleShiftItemInfo.getAttendanceType());
                attDynamicItemResInfo.setSegment(null == scheduleShiftItemInfo.getSegment() ? SegmentEnum.firtSegment : scheduleShiftItemInfo.getSegment());
                attDynamicItemResInfo.setItemSrcType(scheduleShiftItemInfo.getItemSrcType());
                attDynamicItemResInfo.setPreFloatAdjusted(scheduleShiftItemInfo.getPreFloatAdjusted());
                attDynamicItemResInfo.setNextFloatAdjusted(scheduleShiftItemInfo.getNextFloatAdjusted());
                itemResultDetail.add(attDynamicItemResInfo);
            }
            atsItemResultDetailMap.put(personAndDate, itemResultDetail);
        }
    }

    public static void buildItemDetailByshiftInfo(Map<Object, Object> globalMap, Map<String, List<AttDynamicItemResInfo>> atsItemResultDetailMap, String personAndDate) {
        if (AtsCollectionUtile.isEmpty(globalMap) || null == atsItemResultDetailMap) {
            return;
        }
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map atsShiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
        if (null == attendanceFileInfoMap) {
            return;
        }
        AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(personAndDate);
        if (null == attendanceFileInfo) {
            return;
        }
        AtsShiftInfo atsShiftInfo = attendanceFileInfo.getAtsShift();
        if (null == atsShiftInfo) {
            return;
        }
        String shiftId = atsShiftInfo.getId().toString();
        AtsShiftInfo shiftInfo = (AtsShiftInfo)atsShiftInfoMap.get(shiftId);
        if (null == shiftInfo) {
            return;
        }
        AtsShiftItemCollection shiftItem = shiftInfo.getItems();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)shiftItem)) {
            return;
        }
        ArrayList<AttDynamicItemResInfo> itemResultDetail = new ArrayList<AttDynamicItemResInfo>();
        AdminOrgUnitInfo adminOrgUnitInfo = attendanceFileInfo.getAttAdminOrgUnit();
        String dateString = AtsCalCommonUtils.getPersonOrDateStrByType(personAndDate, 1);
        for (int index = 0; index < shiftItem.size(); ++index) {
            AtsShiftItemInfo shiftItemInfo = shiftItem.get(index);
            Timestamp[] shiftTime = AtsCalCommonUtils.getTimeByShiftItem(shiftItemInfo, dateString);
            if (null == shiftTime || shiftTime.length < 4) continue;
            AttDynamicItemResInfo attDynamicItemResInfo = AtsCalCommonUtils.getInstanceOfItemResInfo(shiftTime[0], shiftTime[1], adminOrgUnitInfo);
            attDynamicItemResInfo.setItemRestStartDate(shiftTime[2]);
            attDynamicItemResInfo.setItemRestEndDate(shiftTime[3]);
            attDynamicItemResInfo.setPreIsPunchCard(shiftItemInfo.getPreIsPunchCard());
            attDynamicItemResInfo.setNextIsPunchCard(shiftItemInfo.getNextIsPunchCard());
            attDynamicItemResInfo.setRestTime(null == shiftItemInfo.getSegmentInRest() ? BigDecimal.ZERO : shiftItemInfo.getSegmentInRest());
            attDynamicItemResInfo.setAttendanceType(shiftItemInfo.getAttendanceType());
            attDynamicItemResInfo.setSegment(null == shiftItemInfo.getSegment() ? SegmentEnum.firtSegment : shiftItemInfo.getSegment());
            attDynamicItemResInfo.setPreFloatAdjusted(shiftItemInfo.getPreFloatAdjusted());
            attDynamicItemResInfo.setNextFloatAdjusted(shiftItemInfo.getNextFloatAdjusted());
            itemResultDetail.add(attDynamicItemResInfo);
        }
        atsItemResultDetailMap.put(personAndDate, itemResultDetail);
    }

    public static Timestamp[] getTimeByShiftItem(AtsShiftItemInfo atsShiftItemInfo, String dateString) {
        if (null == atsShiftItemInfo) {
            return null;
        }
        Timestamp preDateTime = AtsCalCommonUtils.getTimeByDayType(dateString, atsShiftItemInfo.getPreTime(), atsShiftItemInfo.getPreTimeDayType());
        Timestamp preRestDateTime = null;
        Timestamp nextRestDateTime = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)atsShiftItemInfo.getRestPreTime()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)atsShiftItemInfo.getRestNextTime())) {
            String atdtPreDayStr = AtsDateUtils.getPreDay(dateString, 1);
            String atdtNextDayStr = AtsDateUtils.getNextDay(dateString, 1);
            preRestDateTime = AtsDateUtils.stringToTimestamp(ScheduleShiftItemHelper.getRealRestTime(atsShiftItemInfo.getPreTime(), atsShiftItemInfo.getPreTimeDayType().getValue(), atsShiftItemInfo.getRestPreTime(), atsShiftItemInfo.getRestNextTime(), dateString, atdtPreDayStr, atdtNextDayStr, "restPreTime"));
            nextRestDateTime = AtsDateUtils.stringToTimestamp(ScheduleShiftItemHelper.getRealRestTime(atsShiftItemInfo.getPreTime(), atsShiftItemInfo.getPreTimeDayType().getValue(), atsShiftItemInfo.getRestPreTime(), atsShiftItemInfo.getRestNextTime(), dateString, atdtPreDayStr, atdtNextDayStr, "restNextTime"));
        }
        Timestamp nextDateTime = AtsCalCommonUtils.getTimeByDayType(dateString, atsShiftItemInfo.getNextTime(), atsShiftItemInfo.getNextTimeDayType());
        return new Timestamp[]{preDateTime, nextDateTime, preRestDateTime, nextRestDateTime};
    }

    public static Timestamp getTimeByDayType(String dateStr, String time, SegmentUnitEnum segmentUnitEnum) {
        String timeStr = AtsDateUtils.getFullTime(time);
        String dayType = String.valueOf(segmentUnitEnum.getValue());
        String shiftTime = AtsCalCommonUtils.timeToDateByDayType(timeStr, dayType, dateStr);
        Timestamp dateTime = new Timestamp(AtsDateUtils.stringToLongDate(shiftTime).getTime());
        return dateTime;
    }

    public static String timeToDateByDayType(String time, String dayType, String attDate) {
        String date = "";
        long dayMs = 86400000L;
        Date tempDate = AtsDateUtils.stringToShortDate(attDate);
        if (dayType.equals("0")) {
            date = AtsDateUtils.dateShortToString(new Date(tempDate.getTime() - dayMs)) + " " + time;
        } else if (dayType.equals("1")) {
            date = attDate + " " + time;
        } else if (dayType.equals("2")) {
            date = AtsDateUtils.dateShortToString(new Date(tempDate.getTime() + dayMs)) + " " + time;
        }
        return date;
    }

    public static String getPersonOrDateStrByType(String personAndDate, int type) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)personAndDate)) {
            return null;
        }
        String[] personAndDateArr = personAndDate.split("_");
        if (null == personAndDateArr || personAndDateArr.length < 2) {
            return null;
        }
        switch (type) {
            case 0: {
                return personAndDateArr[0];
            }
        }
        return personAndDateArr[1];
    }

    public static long getTimeDifferVal(Timestamp startTime, Timestamp endTime) {
        if (null == startTime || null == endTime) {
            return 0L;
        }
        long startTimeLong = startTime.getTime();
        long endTimeLong = endTime.getTime();
        return endTimeLong - startTimeLong > 0L ? endTimeLong - startTimeLong : 0L;
    }

    public static BigDecimal getDifferVal(long subtrahend, long minuend, int unitType, int decimalPlace) {
        BigDecimal minuendDec;
        BigDecimal subtrahendDec = BigDecimal.valueOf(subtrahend);
        BigDecimal differValDec = subtrahendDec.subtract(minuendDec = BigDecimal.valueOf(minuend));
        if (differValDec.longValue() <= 0L) {
            return BigDecimal.ZERO;
        }
        return differValDec.divide(AtsCalCommonUtils.getUnitVal(unitType), decimalPlace, RoundingMode.HALF_UP);
    }

    public static BigDecimal getUnitVal(int unitType) {
        switch (unitType) {
            case 0: {
                return BigDecimal.valueOf(86400000L);
            }
            case 1: {
                return BigDecimal.valueOf(3600000L);
            }
            case 2: {
                return BigDecimal.valueOf(60000L);
            }
        }
        return BigDecimal.valueOf(1000L);
    }

    public static BigDecimal getAttendanceDays(BigDecimal standardDays, BigDecimal standardHours, BigDecimal realHours, int decimalPlace) {
        if (null == standardDays || standardDays.equals(BigDecimal.ZERO) || null == standardHours || standardHours.equals(BigDecimal.ZERO) || null == realHours || realHours.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        return standardDays.multiply(realHours.divide(standardHours, decimalPlace, RoundingMode.HALF_UP)).setScale(decimalPlace, RoundingMode.HALF_UP);
    }

    public static void setFillSignCardTimesByCache(List<FillSignCardInfo> fillSignCardList, List<AttDynamicItemResInfo> itemResInfoList) {
        if (AtsCollectionUtile.isEmpty(fillSignCardList) || AtsCollectionUtile.isEmpty(itemResInfoList)) {
            return;
        }
        int size = itemResInfoList.size();
        if (size == 1) {
            AtsCalCommonUtils.setFillSignCardTime(fillSignCardList, itemResInfoList.get(0), null, null);
            return;
        }
        Timestamp flagTime = null;
        boolean fillSignCardIndex = false;
        for (int index = 0; index < size; ++index) {
            AttDynamicItemResInfo itemResInfo = itemResInfoList.get(index);
            String onTimeStr = itemResInfo.getOnTime();
            String OffTimeStr = itemResInfo.getOffTime();
            Timestamp itemOnTime = itemResInfo.getItemStartDate();
            Timestamp itemOffTime = itemResInfo.getItemEndDate();
            if (null == itemOnTime || null == itemOffTime) {
                return;
            }
            if (index == 0) {
                flagTime = AtsCalCommonUtils.requireFlagTime(onTimeStr, OffTimeStr, itemOnTime, itemOffTime);
                Timestamp startTime = new Timestamp(AtsDateUtils.stringToTimestamp(itemResInfo.getOnTime()).getTime() - 1L);
                AtsCalCommonUtils.setFillSignCardTime(fillSignCardList, itemResInfo, startTime, flagTime);
                continue;
            }
            if (index == size - 1) {
                AtsCalCommonUtils.setFillSignCardTime(fillSignCardList, itemResInfo, flagTime, null);
                continue;
            }
            Timestamp flagTimeTemp = AtsCalCommonUtils.requireFlagTime(onTimeStr, OffTimeStr, itemOnTime, itemOffTime);
            if (flagTimeTemp.compareTo(flagTime) <= 0) {
                itemResInfo.setFillTimes(BigDecimal.ZERO);
                continue;
            }
            AtsCalCommonUtils.setFillSignCardTime(fillSignCardList, itemResInfo, flagTime, flagTimeTemp);
            flagTime = flagTimeTemp;
        }
    }

    public static Timestamp requireFlagTime(String onTimeStr, String OffTimeStr, Timestamp itemOnTime, Timestamp itemOffTime) {
        Timestamp flagTime = null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)OffTimeStr)) {
            flagTime = AtsServerUtils.stringToTimestamp(OffTimeStr);
            return flagTime;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)onTimeStr)) {
            flagTime = AtsServerUtils.stringToTimestamp(onTimeStr);
            if (flagTime.compareTo(itemOffTime) < 0) {
                flagTime = itemOffTime;
            }
            return flagTime;
        }
        return itemOffTime;
    }

    public static void setFillSignCardTime(List<FillSignCardInfo> fillSignCardList, AttDynamicItemResInfo itemResInfo, Timestamp startTime, Timestamp endTime) {
        if (AtsCollectionUtile.isEmpty(fillSignCardList) || null == itemResInfo) {
            return;
        }
        BigDecimal filltimes = BigDecimal.ZERO;
        int size = fillSignCardList.size();
        for (int index = 0; index < size; ++index) {
            FillSignCardInfo info = fillSignCardList.get(index);
            FillSignCardEntryCollection coll = info.getEntries();
            int collSize = coll.size();
            for (int j = 0; j < collSize; ++j) {
                FillSignCardEntryInfo entryInfo = coll.get(j);
                if (entryInfo.getType() != FillSignCardType.fillCard) continue;
                if (null == startTime && null == endTime) {
                    filltimes = filltimes.add(BigDecimal.ONE);
                    continue;
                }
                if (null == startTime && entryInfo.getFillCardTime().compareTo(endTime) <= 0) {
                    filltimes = filltimes.add(BigDecimal.ONE);
                    continue;
                }
                if (null == endTime && entryInfo.getFillCardTime().compareTo(startTime) > 0) {
                    filltimes = filltimes.add(BigDecimal.ONE);
                    continue;
                }
                if (null == startTime || null == endTime || entryInfo.getFillCardTime().compareTo(startTime) <= 0 || entryInfo.getFillCardTime().compareTo(endTime) > 0) continue;
                filltimes = filltimes.add(BigDecimal.ONE);
            }
        }
        itemResInfo.setFillTimes(filltimes);
    }

    public static List<AttDynamicItemResInfo> requireItemResInfoList(Map param) {
        String personId = String.valueOf(param.get("personId"));
        String date = String.valueOf(param.get("attenceDate"));
        String personAndDate = AtsCalCommonUtils.getPersonAndDate(personId, date);
        return AtsCalCommonUtils.requireItemListByPersonAndDate(param, personAndDate);
    }

    public static List<AttDynamicItemResInfo> requireItemListByPersonAndDate(Map param, String personAndDate) {
        return AtsCalCommonUtils.requireItemListByPersonAndDate(param, personAndDate, "atsItemResultDetailMap");
    }

    public static List<AttDynamicItemResInfo> requireItemResInfoByBillList(Map param) {
        String personId = String.valueOf(param.get("personId"));
        String date = String.valueOf(param.get("attenceDate"));
        String personAndDate = AtsCalCommonUtils.getPersonAndDate(personId, date);
        return AtsCalCommonUtils.requireItemListByPersonAndDate(param, personAndDate, "atsItemInfoByBillMap");
    }

    public static Map<String, Object> requireResultListByPersonAndDate(Map param, String personAndDate) {
        Map globalMap = (Map)param.get("globalMap");
        if (null == globalMap) {
            return null;
        }
        Map resultResInfoMap = (Map)globalMap.get("calResultInfoMap");
        if (null == resultResInfoMap) {
            return null;
        }
        return (Map)resultResInfoMap.get(personAndDate);
    }

    public static List<AttDynamicItemResInfo> requireItemListByPersonAndDate(Map param, String personAndDate, String attendanceKey) {
        Map globalMap = (Map)param.get("globalMap");
        if (null == globalMap) {
            return null;
        }
        Map itemResInfoMap = (Map)globalMap.get(attendanceKey);
        if (null == itemResInfoMap) {
            return null;
        }
        return (List)itemResInfoMap.get(personAndDate);
    }

    public static AttDynamicItemResInfo buildItemInfoByBill(AtsSupportBillInfo supportBillInfo, Map param) {
        if (null == supportBillInfo || AtsCollectionUtile.isEmpty(param)) {
            return null;
        }
        String personId = String.valueOf(param.get("personId"));
        String date = String.valueOf(param.get("attenceDate"));
        Map globalMap = (Map)param.get("globalMap");
        if (AtsCollectionUtile.isEmpty(globalMap)) {
            return null;
        }
        HashMap<String, ArrayList<AttDynamicItemResInfo>> itemResultDetailByBillMap = (HashMap<String, ArrayList<AttDynamicItemResInfo>>)globalMap.get("atsItemInfoByBillMap");
        if (null == itemResultDetailByBillMap) {
            itemResultDetailByBillMap = new HashMap<String, ArrayList<AttDynamicItemResInfo>>();
            globalMap.put("atsItemInfoByBillMap", itemResultDetailByBillMap);
        }
        AttDynamicItemResInfo itemResInfo = new AttDynamicItemResInfo();
        AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
        adminOrgUnitInfo.setId(BOSUuid.read((String)supportBillInfo.getAttAdminOrg()));
        itemResInfo.setAttadminOrgUnit(adminOrgUnitInfo);
        itemResInfo.setItemSourceType(supportBillInfo.getItemSourceType());
        itemResInfo.setSupportTime(supportBillInfo.getRealSupportTime());
        itemResInfo.setSupportHours(supportBillInfo.getRealSupportHours());
        itemResInfo.setSupportDays(supportBillInfo.getRealSupportDays());
        String personAndDate = AtsCalCommonUtils.getPersonAndDate(personId, date);
        ArrayList<AttDynamicItemResInfo> itemResInfoList = (ArrayList<AttDynamicItemResInfo>)itemResultDetailByBillMap.get(personAndDate);
        if (null == itemResInfoList) {
            itemResInfoList = new ArrayList<AttDynamicItemResInfo>();
            itemResultDetailByBillMap.put(personAndDate, itemResInfoList);
        }
        itemResInfoList.add(itemResInfo);
        return itemResInfo;
    }

    public static CardRuleInfo requireCardRule(Map param, boolean hasScheduleShift) {
        if (AtsCollectionUtile.isEmpty(param)) {
            return null;
        }
        String personAndDate = AtsCalCommonUtils.getPersonAndDateByParam(param);
        Map globalMap = (Map)param.get("globalMap");
        if (hasScheduleShift) {
            return AtsCalCommonUtils.requireCardRuleBySchedule(globalMap, personAndDate);
        }
        return AtsCalCommonUtils.requireCardRuleByShift(globalMap, personAndDate);
    }

    public static CardRuleInfo requireCardRuleByShift(Map<Object, Object> globalMap, String personAndDate) {
        String cardRuleId;
        String shiftInfoId;
        if (AtsCollectionUtile.isEmpty(globalMap)) {
            return null;
        }
        Map cardRuleSingleInfoMap = (Map)globalMap.get("T_HR_ATS_CardRule");
        Map fileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map atsShiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
        if (AtsCollectionUtile.isEmpty(cardRuleSingleInfoMap) || AtsCollectionUtile.isEmpty(fileInfoMap) || AtsCollectionUtile.isEmpty(atsShiftInfoMap)) {
            return null;
        }
        AttendanceFileInfo fileInfo = (AttendanceFileInfo)fileInfoMap.get(personAndDate);
        String string = null == fileInfo ? null : (null == fileInfo.getAtsShift() ? null : (shiftInfoId = null == fileInfo.getAtsShift().getId() ? null : fileInfo.getAtsShift().getId().toString()));
        if (org.apache.commons.lang3.StringUtils.isEmpty(shiftInfoId)) {
            return null;
        }
        AtsShiftInfo shiftInfo = (AtsShiftInfo)atsShiftInfoMap.get(shiftInfoId);
        String string2 = null == shiftInfo ? null : (null == shiftInfo.getCardRule() ? null : (cardRuleId = null == shiftInfo.getCardRule().getId() ? null : shiftInfo.getCardRule().getId().toString()));
        if (org.apache.commons.lang3.StringUtils.isEmpty(cardRuleId)) {
            return null;
        }
        return (CardRuleInfo)cardRuleSingleInfoMap.get(cardRuleId);
    }

    public static CardRuleInfo requireCardRuleBySchedule(Map<Object, Object> globalMap, String personAndDate) {
        String cardRuleId;
        if (AtsCollectionUtile.isEmpty(globalMap)) {
            return null;
        }
        Map cardRuleSingleInfoMap = (Map)globalMap.get("T_HR_ATS_CardRule");
        Map scheduleShiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        if (AtsCollectionUtile.isEmpty(cardRuleSingleInfoMap) || AtsCollectionUtile.isEmpty(scheduleShiftItemMap)) {
            return null;
        }
        List scheduleShiftInfoList = (List)scheduleShiftItemMap.get(personAndDate);
        if (AtsCollectionUtile.isEmpty(scheduleShiftInfoList)) {
            return null;
        }
        String string = null == ((ScheduleShiftInfo)scheduleShiftInfoList.get(0)).getCardRule() ? null : (cardRuleId = null == ((ScheduleShiftInfo)scheduleShiftInfoList.get(0)).getCardRule().getId() ? null : ((ScheduleShiftInfo)scheduleShiftInfoList.get(0)).getCardRule().getId().toString());
        if (org.apache.commons.lang3.StringUtils.isEmpty(cardRuleId)) {
            return null;
        }
        return (CardRuleInfo)cardRuleSingleInfoMap.get(cardRuleId);
    }

    public static String getPersonAndDateByParam(Map param) {
        if (AtsCollectionUtile.isEmpty(param)) {
            return "";
        }
        String personId = String.valueOf(param.get("personId"));
        String date = String.valueOf(param.get("attenceDate"));
        return AtsCalCommonUtils.getPersonAndDate(personId, date);
    }

    public static Timestamp getMaxTwoTime(Timestamp time1, Timestamp time2) {
        return time1.compareTo(time2) > 0 ? time1 : time2;
    }

    public static Timestamp getMinTwoTime(Timestamp time1, Timestamp time2) {
        return time1.compareTo(time2) < 0 ? time1 : time2;
    }

    public static Timestamp hourExtend(Timestamp time, BigDecimal num) {
        long hourMs = 3600000L;
        long timeLong = time.getTime() + num.multiply(new BigDecimal(hourMs)).longValue();
        return new Timestamp(timeLong);
    }

    public static List<Timestamp> getEffectiveListByTimeInterval(List<Timestamp> segIntervalList, String timeInterval) {
        if (AtsCollectionUtile.isEmpty(segIntervalList)) {
            return null;
        }
        long timeIntervalMillisecond = 0L;
        ArrayList<Timestamp> resList = new ArrayList<Timestamp>();
        Timestamp minDate = segIntervalList.get(0);
        resList.add(minDate);
        for (int index = 1; index < segIntervalList.size(); ++index) {
            Timestamp purchardTime = segIntervalList.get(index);
            timeIntervalMillisecond = new BigDecimal(timeInterval).longValue() * 60L * 1000L;
            if (purchardTime.getTime() - minDate.getTime() < timeIntervalMillisecond) continue;
            resList.add(purchardTime);
        }
        return resList;
    }

    public static Timestamp getPreDateOffWorkTimeByResult(Map param) {
        String date;
        Date attdate;
        String personId = String.valueOf(param.get("personId"));
        String prePersonAndDate = AtsCalCommonUtils.getPersonAndDate(personId, AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attdate = AtsDateUtils.stringToShortDate(date = String.valueOf(param.get("attenceDate"))), 1)));
        Map<String, Object> preResultInfo = AtsCalCommonUtils.requireResultListByPersonAndDate(param, prePersonAndDate);
        if (AtsCollectionUtile.isEmpty(preResultInfo)) {
            return null;
        }
        Timestamp preDateOffWorkTime = null;
        for (int index = 6; index >= 1; --index) {
            preDateOffWorkTime = AtsCalCommonUtils.getTimeByResultInfo(index, preResultInfo);
            if (null == preDateOffWorkTime) continue;
            return preDateOffWorkTime;
        }
        return preDateOffWorkTime;
    }

    private static Timestamp getTimeByResultInfo(int index, Map<String, Object> preResultInfo) {
        if (AtsCollectionUtile.isEmpty(preResultInfo)) {
            return null;
        }
        return (Timestamp)preResultInfo.get(MessageFormat.format("{0}{1}", AttendanceConstants.COLUMNNO_MARK, index));
    }

    public static Timestamp getPreDateOffWorkTime(Map param) {
        String date;
        Date attdate;
        String personId = String.valueOf(param.get("personId"));
        String prePersonAndDate = AtsCalCommonUtils.getPersonAndDate(personId, AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attdate = AtsDateUtils.stringToShortDate(date = String.valueOf(param.get("attenceDate"))), 1)));
        List<AttDynamicItemResInfo> preItemInfoList = AtsCalCommonUtils.requireItemListByPersonAndDate(param, prePersonAndDate);
        if (AtsCollectionUtile.isEmpty(preItemInfoList)) {
            return null;
        }
        String preDateOffWorkTime = null;
        for (int index = 0; index < preItemInfoList.size(); ++index) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)preItemInfoList.get(index).getOnTime())) {
                preDateOffWorkTime = preItemInfoList.get(index).getOnTime();
            }
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)preItemInfoList.get(index).getOffTime())) continue;
            preDateOffWorkTime = preItemInfoList.get(index).getOffTime();
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(preDateOffWorkTime)) {
            return AtsDateUtils.stringToTimestamp(preDateOffWorkTime);
        }
        return null;
    }

    public static int setDecimalPlaceSystem(Context ctx, Map param) {
        int decimalPlaceSystem = DecimalPlaceUtil.getDefaultDecimalPlaces();
        if (AtsCollectionUtile.isEmpty(param)) {
            return decimalPlaceSystem;
        }
        Map globalMap = (Map)param.get("globalMap");
        return AtsCollectionUtile.isEmpty(globalMap) ? decimalPlaceSystem : DecimalPlaceUtil.getDecimalPlaces(ctx, globalMap);
    }

    public static String setCalServer(String serverPro) {
        boolean userNewCalServerFlag;
        String isUserNewCalServer = AtsServerCalUtils.getClzPathName("isUserNewCalServer");
        boolean bl = userNewCalServerFlag = StringUtils.isEmpty((String)isUserNewCalServer) || "true".equalsIgnoreCase(isUserNewCalServer);
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)serverPro) ? "" : MessageFormat.format(serverPro, userNewCalServerFlag ? "mulLocationImpl" : "implement");
    }
}

