/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsXmlUtile;
import com.kingdee.eas.hr.ats.util.common.StreamUtile;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class AtsEnvUtile {
    public static JSONObject getServerParam() {
        JSONObject serverParam = new JSONObject();
        serverParam.put("server", (Object)System.getProperty("EAS_INSTANCE_NAME"));
        serverParam.put("serverCount", (Object)AtsEnvUtile.getServerList(false).size());
        return serverParam;
    }

    public static List<String> getServerList(boolean initDevServerList) {
        String easHome = System.getProperty("EAS_HOME") + "/server/profiles";
        File files = new File(SHRCheck.checkFilePath((String)easHome));
        ArrayList<String> serverList = new ArrayList<String>();
        if (!files.isDirectory()) {
            return serverList;
        }
        for (File file : files.listFiles()) {
            if (!file.isDirectory() || file.getName() == null || !new File(SHRCheck.checkFilePath((String)(file.getAbsolutePath() + "/config/vm.properties"))).exists()) continue;
            serverList.add(file.getName());
        }
        if (initDevServerList) {
            AtsEnvUtile.initDevServerList(serverList);
        }
        return serverList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void initDevServerList(List<String> serverList) {
        block14: {
            File f1;
            File devJsFile = new File(SHRCheck.checkFilePath((String)(System.getProperty("EAS_HOME") + "/server/deploy/easweb.ear/shr_web.war/addon/attendmanage/web/js/shr/ats/util/dev.js")));
            if (!devJsFile.exists()) {
                return;
            }
            String logFileName = "apusic.log.{0}";
            String logPath = SHRSyssettingUtil.getLogsPath((String)"server1") + File.separator + "apusic.log.0";
            File f = new File(SHRCheck.checkFilePath((String)logPath));
            if (!f.exists() && (f1 = new File(SHRCheck.checkFilePath((String)(logPath = SHRSyssettingUtil.getLogsPath((String)"server1") + File.separator + "apusic0.log")))).exists()) {
                logFileName = "apusic{0}.log";
            }
            BufferedReader bufferedReader = null;
            FileOutputStream os = null;
            StringBuffer content = new StringBuffer();
            try {
                String line;
                bufferedReader = new BufferedReader(new FileReader(devJsFile));
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.contains("var apusicServerList")) {
                        content.append(line.substring(0, line.indexOf("var apusicServerList")));
                        content.append("var apusicServerList = ").append(JSON.toJSONString(serverList)).append(";\r\n");
                    } else if (line.contains("var logFileName")) {
                        content.append(line.substring(0, line.indexOf("var logFileName")));
                        content.append("var logFileName = '").append(logFileName).append("';");
                    } else {
                        content.append(line);
                    }
                    content.append("\r\n");
                }
                os = new FileOutputStream(devJsFile);
                os.write(content.toString().getBytes());
                StreamUtile.close(bufferedReader);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                break block14;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block14;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtile.close(bufferedReader);
                StreamUtile.close(os);
            }
            StreamUtile.close(os);
        }
    }

    public static List<String> findFilePath(List<String> fileNames, List<String> packagePaths, List<String> findedPath) {
        if (AtsCollectionUtile.isEmpty(fileNames) || AtsCollectionUtile.isEmpty(packagePaths)) {
            return null;
        }
        if (findedPath == null) {
            findedPath = new ArrayList<String>();
        }
        for (String path : packagePaths) {
            File packageFile = new File(SHRCheck.checkFilePath((String)(AtsConstants.PATH_EAS_HOME + "/" + path)));
            if (!packageFile.exists()) continue;
            if (packageFile.isFile()) {
                for (String file : fileNames) {
                    String filePath;
                    if (!packageFile.getName().contains(file) || findedPath.contains(filePath = packageFile.getAbsolutePath().substring(AtsConstants.PATH_EAS_HOME.length() + 1))) continue;
                    findedPath.add(filePath);
                }
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (String file : packageFile.list()) {
                list.add(path + "/" + file);
            }
            AtsEnvUtile.findFilePath(fileNames, list, findedPath);
        }
        return findedPath;
    }

    public static void downLoadJar(ZipOutputStream out, List<String> jarNames, List<String> packagePaths) {
        if (jarNames == null || jarNames.size() == 0) {
            return;
        }
        if (packagePaths == null) {
            packagePaths = new ArrayList<String>(2);
        }
        if (packagePaths.size() == 0) {
            packagePaths.add("server/lib");
            packagePaths.add("server/metas");
        }
        List<String> paths = AtsEnvUtile.findFilePath(jarNames, packagePaths, null);
        AtsEnvUtile.downLoad(out, paths);
    }

    public static void downLoad(ZipOutputStream out, List<String> filePaths) {
        if (filePaths == null) {
            return;
        }
        String easHome = System.getProperty("EAS_HOME");
        for (String path : filePaths) {
            File file = new File(SHRCheck.checkFilePath((String)(easHome + "/" + path)));
            if (!file.exists()) continue;
            AtsEnvUtile.createZipSource(out, file, path);
        }
    }

    public static void print(String msg) {
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZipSource(ZipOutputStream out, File file, String dir) {
        block18: {
            block17: {
                if (file == null || !file.exists()) {
                    return;
                }
                if (!file.isDirectory()) break block17;
                File[] files = file.listFiles();
                try {
                    out.putNextEntry(new ZipEntry(dir + "/"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                dir = dir.length() == 0 ? "" : dir + "/";
                for (int i = 0; i < files.length; ++i) {
                    AtsEnvUtile.createZipSource(out, files[i], dir + files[i].getName());
                }
                break block18;
            }
            if (file.getAbsolutePath().endsWith(".lck")) break block18;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(dir));
                int j = 0;
                byte[] buffer = new byte[1024];
                while ((j = fis.read(buffer)) > 0) {
                    out.write(buffer, 0, j);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static HashMap<String, String> getInstance(String serverName, String port) throws FileNotFoundException, DocumentException {
        List members;
        HashMap<String, String> domains = new HashMap<String, String>();
        Element rootElement = AtsXmlUtile.getRootElement(AtsConstants.PATH_EAS_HOME + "/admin/config/domain.xml");
        Element memberParent = AtsXmlUtile.find(rootElement, AtsXmlUtile.createEleNameAnchor("domain/clustermanager/eascluster/members"));
        List list = members = memberParent == null ? null : memberParent.elements();
        if (members != null && members.size() > 0) {
            for (Element member : members) {
                String node = member.attribute("node").getValue();
                if (node == null || "".equals(node)) continue;
                String ip = node.substring(0, node.indexOf(":"));
                String appServerHttpPort = member.attribute("appServerHttpPort").getValue();
                String instance = member.attribute("instance").getValue();
                domains.put(ip + ":" + appServerHttpPort, instance + "[" + ip + ":" + appServerHttpPort + "]");
            }
            return domains;
        }
        memberParent = AtsXmlUtile.find(rootElement, AtsXmlUtile.createEleNameAnchor("domain/clustermanager/easstatus"));
        List list2 = members = memberParent == null ? null : memberParent.elements();
        if (members == null || members.size() == 0) {
            domains.put(serverName + ":" + port, serverName + ":" + port);
            return domains;
        }
        for (Element member : members) {
            Attribute att = member.attribute("tcpurl");
            if (att == null) continue;
            String tcpurl = att.getValue();
            String instance = tcpurl.substring("tcp://".length());
            instance = instance.substring(0, instance.indexOf(":"));
            domains.put(instance + ":" + port, instance + ":" + port);
        }
        return domains;
    }
}

